/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaTimer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\u0019!a\u0006\u0001\u00030\u0011\u0015A2\u0001\"\u0001<\u0011\u001dq4\u00011A\u0005\n}BqaQ\u0002A\u0002\u0013%A\t\u0003\u0004H\u0007\u0001\u0006K\u0001\u0011\u0005\u0006\u0011\u000e!\t%\u0013\u0005\u0006\u0015\u000e!\t%\u0013\u0005\u0006\u0017\u000e!\t\u0001\u0014\u0002\u000f\u0017\u000647.\u0019+j[\u0016\u0014H+Z:u\u0015\tia\"A\u0004nKR\u0014\u0018nY:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0007\u0002\u001dQ,7\u000f^&bM.\fG+[7feR\ta\u0004\u0005\u0002\u0014?%\u0011\u0001\u0005\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003EA\u00111\u0005L\u0007\u0002I)\u0011QEJ\u0001\u0004CBL'BA\u0014)\u0003\u001dQW\u000f]5uKJT!!\u000b\u0016\u0002\u000b),h.\u001b;\u000b\u0003-\n1a\u001c:h\u0013\tiCE\u0001\u0003UKN$(aC'b]V\fGn\u00117pG.\u001c\"a\u0001\u0019\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014\u0001B2pe\u0016T!!D\u001b\u000b\u0005Y:\u0014AB=b[6,'OC\u00019\u0003\r\u0019w.\\\u0005\u0003uI\u0012Qa\u00117pG.$\u0012\u0001\u0010\t\u0003{\ri\u0011\u0001A\u0001\ri&\u001c7n]%o\u001d\u0006twn]\u000b\u0002\u0001B\u00111#Q\u0005\u0003\u0005R\u0011A\u0001T8oO\u0006\u0001B/[2lg&sg*\u00198pg~#S-\u001d\u000b\u0003=\u0015CqA\u0012\u0004\u0002\u0002\u0003\u0007\u0001)A\u0002yIE\nQ\u0002^5dWNLeNT1o_N\u0004\u0013\u0001\u0002;jG.$\u0012\u0001Q\u0001\u0005i&lW-A\u0005bI\u0012l\u0015\u000e\u001c7jgR\u0011a$\u0014\u0005\u0006\u001d*\u0001\r\u0001Q\u0001\u0007[&dG.[:")
public class KafkaTimerTest {
    @Test
    public void testKafkaTimer() {
        ManualClock clock = new ManualClock();
        Timer metric = new MetricsRegistry((Clock)clock).newTimer(this.getClass(), "TestTimer");
        double Epsilon = Double.longBitsToDouble(4368491638549381120L);
        new KafkaTimer(metric).time((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> clock.addMillis(1000L));
        Assertions.assertEquals((long)1L, (long)metric.count());
        Assertions.assertTrue((RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(metric.max() - (double)1000)) <= Epsilon ? 1 : 0) != 0);
        Assertions.assertTrue((RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(metric.min() - (double)1000)) <= Epsilon ? 1 : 0) != 0);
    }

    private class ManualClock
    extends Clock {
        private long ticksInNanos;

        private long ticksInNanos() {
            return this.ticksInNanos;
        }

        private void ticksInNanos_$eq(long x$1) {
            this.ticksInNanos = x$1;
        }

        public long tick() {
            return this.ticksInNanos();
        }

        public long time() {
            return TimeUnit.NANOSECONDS.toMillis(this.ticksInNanos());
        }

        public void addMillis(long millis) {
            this.ticksInNanos_$eq(this.ticksInNanos() + TimeUnit.MILLISECONDS.toNanos(millis));
        }

        public /* synthetic */ KafkaTimerTest kafka$metrics$KafkaTimerTest$ManualClock$$$outer() {
            return KafkaTimerTest.this;
        }

        public ManualClock() {
            if (KafkaTimerTest.this == null) {
                throw null;
            }
            this.ticksInNanos = 0L;
        }
    }
}

