/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.errors;

import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ErrorHandlingMetrics {
    private final Time time = new SystemTime();
    private final ConnectMetrics.MetricGroup metricGroup;
    private final Sensor recordProcessingFailures;
    private final Sensor recordProcessingErrors;
    private final Sensor recordsSkipped;
    private final Sensor retries;
    private final Sensor errorsLogged;
    private final Sensor dlqProduceRequests;
    private final Sensor dlqProduceFailures;
    private long lastErrorTime = 0L;

    public ErrorHandlingMetrics(ConnectorTaskId id, ConnectMetrics connectMetrics) {
        ConnectMetricsRegistry registry = connectMetrics.registry();
        this.metricGroup = connectMetrics.group(registry.taskErrorHandlingGroupName(), registry.connectorTagName(), id.connector(), registry.taskTagName(), Integer.toString(id.task()));
        this.metricGroup.close();
        this.recordProcessingFailures = this.metricGroup.sensor("total-record-failures");
        this.recordProcessingFailures.add(this.metricGroup.metricName(registry.recordProcessingFailures), (MeasurableStat)new CumulativeSum());
        this.recordProcessingErrors = this.metricGroup.sensor("total-record-errors");
        this.recordProcessingErrors.add(this.metricGroup.metricName(registry.recordProcessingErrors), (MeasurableStat)new CumulativeSum());
        this.recordsSkipped = this.metricGroup.sensor("total-records-skipped");
        this.recordsSkipped.add(this.metricGroup.metricName(registry.recordsSkipped), (MeasurableStat)new CumulativeSum());
        this.retries = this.metricGroup.sensor("total-retries");
        this.retries.add(this.metricGroup.metricName(registry.retries), (MeasurableStat)new CumulativeSum());
        this.errorsLogged = this.metricGroup.sensor("total-errors-logged");
        this.errorsLogged.add(this.metricGroup.metricName(registry.errorsLogged), (MeasurableStat)new CumulativeSum());
        this.dlqProduceRequests = this.metricGroup.sensor("deadletterqueue-produce-requests");
        this.dlqProduceRequests.add(this.metricGroup.metricName(registry.dlqProduceRequests), (MeasurableStat)new CumulativeSum());
        this.dlqProduceFailures = this.metricGroup.sensor("deadletterqueue-produce-failures");
        this.dlqProduceFailures.add(this.metricGroup.metricName(registry.dlqProduceFailures), (MeasurableStat)new CumulativeSum());
        this.metricGroup.addValueMetric(registry.lastErrorTimestamp, now -> this.lastErrorTime);
    }

    public void recordFailure() {
        this.recordProcessingFailures.record();
    }

    public void recordError() {
        this.recordProcessingErrors.record();
    }

    public void recordSkipped() {
        this.recordsSkipped.record();
    }

    public void recordRetry() {
        this.retries.record();
    }

    public void recordErrorLogged() {
        this.errorsLogged.record();
    }

    public void recordDeadLetterQueueProduceRequest() {
        this.dlqProduceRequests.record();
    }

    public void recordDeadLetterQueueProduceFailed() {
        this.dlqProduceFailures.record();
    }

    public void recordErrorTimestamp() {
        this.lastErrorTime = this.time.milliseconds();
    }

    public ConnectMetrics.MetricGroup metricGroup() {
        return this.metricGroup;
    }
}

