/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManagerImpl;
import kafka.server.BrokerToControllerChannelManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u00191\u0005\u0001)A\u0005\u007f!9q\t\u0001b\u0001\n\u0003A\u0005BB+\u0001A\u0003%\u0011\nC\u0004W\u0001\t\u0007I\u0011A,\t\rm\u0003\u0001\u0015!\u0003Y\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005d\u0001\u0001\u0007\t\u0019!C\u0001I\"I!\u000e\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\t\b\u0001)A\u0005[\"9!\u000f\u0001b\u0001\n\u0003a\u0007BB:\u0001A\u0003%Q\u000eC\u0004u\u0001\t\u0007I\u0011\u00017\t\rU\u0004\u0001\u0015!\u0003n\u0011\u00151\b\u0001\"\u0001x\u0011\u0015y\b\u0001\"\u0001x\u0011\u0019\tI\u0001\u0001C\u0001o\"1\u0011Q\u0002\u0001\u0005\u0002]Da!!\u0005\u0001\t\u00039\bBBA\u000b\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u001a\u0001!\ta\u001e\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u0019\tI\u0006\u0001C\u0001o\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003BBA4\u0001\u0011\u0005q\u000f\u0003\u0004\u0002l\u0001!\ta\u001e\u0002\u0014\u00032$XM]%te6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003C\t\naa]3sm\u0016\u0014(BA\u0012%\u0003\u0015Y\u0017MZ6b\u0015\u0005)\u0013\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t1\fgn\u001a\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\tQLW.Z\u000b\u0002\u007fA\u0011\u0001\tR\u0007\u0002\u0003*\u0011!iQ\u0001\u0006kRLGn\u001d\u0006\u0002G%\u0011Q)\u0011\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A%\u0011\u0005)\u001bV\"A&\u000b\u0005\u001dc%BA'O\u0003\u0019\u0019w.\\7p]*\u00111e\u0014\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0017\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u0017\t\u0003SeK!A\u0017\u0016\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005\u0011\"M]8lKJ$vnQ8oiJ|G\u000e\\3s+\u0005q\u0006CA0b\u001b\u0005\u0001'BA\u0011D\u0013\t\u0011\u0007M\u0001\u0011Ce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u00062s_.,'\u000fV8D_:$(o\u001c7mKJ|F%Z9\u0015\u0005\u0015D\u0007CA\u0015g\u0013\t9'F\u0001\u0003V]&$\bbB5\f\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013a\u0001;qaU\tQ\u000e\u0005\u0002o_6\tA*\u0003\u0002q\u0019\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qa\u0001\n1\u0001\u001e92\u0003\u0011!\b/\r\u0011\u0002\u0007Q\u0004('\u0001\u0003uaJ\u0002\u0013!B:fiV\u0004H#A3)\u0005MI\bC\u0001>~\u001b\u0005Y(B\u0001?R\u0003\u0015QWO\\5u\u0013\tq8P\u0001\u0004CK\u001a|'/Z\u0001\ni\u0016\u001cHOQ1tS\u000eD3\u0001FA\u0002!\rQ\u0018QA\u0005\u0004\u0003\u000fY(\u0001\u0002+fgR\f\u0001\u0004^3ti>3XM]<sSR,w+\u001b;iS:\u0014\u0015\r^2iQ\r)\u00121A\u0001\u0010i\u0016\u001cHoU5oO2,')\u0019;dQ\"\u001aa#a\u0001\u0002/Q,7\u000f^!vi\"|'/\u001b>bi&|gNR1jY\u0016$\u0007fA\f\u0002\u0004\u0005!B/Z:u'R\fG.\u001a\"s_.,'/\u00129pG\"D3\u0001GA\u0002\u0003=!Xm\u001d;Pi\",'/\u0012:s_J\u001c\bfA\r\u0002\u0004\u0005\tB/Z:u)>\u0004H*\u001a<fY\u0016\u0013(o\u001c:\u0015\r\u0005\u0005\u0012qEA%!\ry\u00161E\u0005\u0004\u0003K\u0001'aD!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\t\u000f\u0005%\"\u00041\u0001\u0002,\u0005!\u0011n\u001d:t!\u0019\ti#!\u0010\u0002D9!\u0011qFA\u001d\u001d\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bM\u00051AH]8pizJ\u0011aK\u0005\u0004\u0003wQ\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\t\tEA\u0002TKFT1!a\u000f+!\ry\u0016QI\u0005\u0004\u0003\u000f\u0002'\u0001D!mi\u0016\u0014\u0018j\u001d:Ji\u0016l\u0007bBA&5\u0001\u0007\u0011QJ\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b'\u0002\u0011A\u0014x\u000e^8d_2LA!a\u0016\u0002R\t1QI\u001d:peN\f1\u0003^3tiB\u000b'\u000f^5uS>tWI\u001d:peND3aGA\u0002\u0003I!Xm\u001d;QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:\u0015\r\u0005\u0005\u0012\u0011MA3\u0011\u0019\t\u0019\u0007\ba\u0001[\u0006\u0011A\u000f\u001d\u0005\b\u0003\u0017b\u0002\u0019AA'\u0003=!Xm\u001d;P]\u0016LeN\u00127jO\"$\bfA\u000f\u0002\u0004\u0005qB/Z:u!\u0006\u0014H/\u001b;j_:l\u0015n]:j]\u001eLeNU3ta>t7/\u001a\u0015\u0004=\u0005\r\u0001")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Before
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)EasyMock.createMock(BrokerToControllerChannelManager.class));
    }

    @Test
    public void testBasic() {
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.enqueue(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$2 -> {
            AlterIsrManagerTest.$anonfun$testBasic$2(x$2);
            return BoxedUnit.UNIT;
        }));
        this.time().sleep(50L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testOverwriteWithinBatch() {
        Capture capture = EasyMock.newCapture();
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (RequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        Assert.assertTrue((boolean)alterIsrManager.enqueue(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$3 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$2(x$3);
            return BoxedUnit.UNIT;
        })));
        Assert.assertFalse((boolean)alterIsrManager.enqueue(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), 10), (Function1 & Serializable)x$4 -> {
            AlterIsrManagerTest.$anonfun$testOverwriteWithinBatch$3(x$4);
            return BoxedUnit.UNIT;
        })));
        this.time().sleep(50L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assert.assertEquals((long)request.data().topics().size(), (long)1L);
        Assert.assertEquals((long)((AlterIsrRequestData.PartitionData)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (long)3L);
    }

    @Test
    public void testSingleBatch() {
        Capture capture = EasyMock.newCapture();
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.capture((Capture)capture), (RequestCompletionHandler)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        int n = 0;
        int to$extension_end = 9;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AlterIsrManagerTest.$anonfun$testSingleBatch$2(this, alterIsrManager, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var6_6 = null;
        this.time().sleep(50L);
        scheduler.tick();
        alterIsrManager.enqueue(new AlterIsrItem(new TopicPartition(this.topic(), 10), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$6 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$4(x$6);
            return BoxedUnit.UNIT;
        }));
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrRequest request = (AlterIsrRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assert.assertEquals((long)request.data().topics().size(), (long)1L);
        Assert.assertEquals((long)((AlterIsrRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (long)10L);
    }

    @Test
    public void testAuthorizationFailed() {
        .colon.colon isrs = new .colon.colon((Object)new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$7 -> {
            AlterIsrManagerTest.$anonfun$testAuthorizationFailed$1(x$7);
            return BoxedUnit.UNIT;
        }), (List)Nil$.MODULE$);
        Assert.assertFalse((boolean)this.testTopLevelError((Seq<AlterIsrItem>)isrs, Errors.CLUSTER_AUTHORIZATION_FAILED).enqueue(new AlterIsrItem(this.tp0(), null, (Function1 & Serializable)x$8 -> {
            AlterIsrManagerTest.$anonfun$testAuthorizationFailed$2(x$8);
            return BoxedUnit.UNIT;
        })));
    }

    @Test
    public void testStaleBrokerEpoch() {
        .colon.colon isrs = new .colon.colon((Object)new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$9 -> {
            AlterIsrManagerTest.$anonfun$testStaleBrokerEpoch$1(x$9);
            return BoxedUnit.UNIT;
        }), (List)Nil$.MODULE$);
        Assert.assertFalse((boolean)this.testTopLevelError((Seq<AlterIsrItem>)isrs, Errors.STALE_BROKER_EPOCH).enqueue(new AlterIsrItem(this.tp0(), null, (Function1 & Serializable)x$10 -> {
            AlterIsrManagerTest.$anonfun$testStaleBrokerEpoch$2(x$10);
            return BoxedUnit.UNIT;
        })));
    }

    @Test
    public void testOtherErrors() {
        .colon.colon isrs = new .colon.colon((Object)new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$11 -> {
            AlterIsrManagerTest.$anonfun$testOtherErrors$1(x$11);
            return BoxedUnit.UNIT;
        }), (List)Nil$.MODULE$);
        Assert.assertFalse((boolean)this.testTopLevelError((Seq<AlterIsrItem>)isrs, Errors.UNKNOWN_SERVER_ERROR).enqueue(new AlterIsrItem(this.tp0(), null, (Function1 & Serializable)x$12 -> {
            AlterIsrManagerTest.$anonfun$testOtherErrors$2(x$12);
            return BoxedUnit.UNIT;
        })));
    }

    public AlterIsrManager testTopLevelError(Seq<AlterIsrItem> isrs, Errors error) {
        Capture callbackCapture = EasyMock.newCapture();
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        isrs.foreach((Function1 & Serializable)alterIsrItem -> BoxesRunTime.boxToBoolean((boolean)alterIsrManager.enqueue(alterIsrItem)));
        this.time().sleep(100L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData().setErrorCode(error.code()));
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        return alterIsrManager;
    }

    @Test
    public void testPartitionErrors() {
        new .colon.colon((Object)Errors.INVALID_UPDATE_VERSION, (List)new .colon.colon((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (List)new .colon.colon((Object)Errors.NOT_LEADER_OR_FOLLOWER, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)error -> {
            AlterIsrManagerTest.$anonfun$testPartitionErrors$1(this, error);
            return BoxedUnit.UNIT;
        });
    }

    public AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        None$ create_e = None$.MODULE$;
        Object var10_6 = null;
        ObjectRef capturedError = new ObjectRef((Object)create_e);
        Function1 & Serializable callback = (Function1 & Serializable)result -> {
            AlterIsrManagerTest.$anonfun$testPartitionError$2(capturedError, result);
            return BoxedUnit.UNIT;
        };
        alterIsrManager.enqueue(new AlterIsrItem(tp, new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback));
        this.time().sleep(100L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData().setTopics(Collections.singletonList(new AlterIsrResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterIsrResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(error.code()))))));
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assert.assertTrue((boolean)((Option)capturedError.elem).isDefined());
        Assert.assertEquals((Object)((Option)capturedError.elem).get(), (Object)error);
        return alterIsrManager;
    }

    @Test
    public void testOneInFlight() {
        Capture callbackCapture = EasyMock.newCapture();
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterIsrManager.start();
        alterIsrManager.enqueue(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$14 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$2(x$14);
            return BoxedUnit.UNIT;
        }));
        this.time().sleep(100L);
        scheduler.tick();
        alterIsrManager.enqueue(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$15 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$3(x$15);
            return BoxedUnit.UNIT;
        }));
        alterIsrManager.enqueue(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$16 -> {
            AlterIsrManagerTest.$anonfun$testOneInFlight$4(x$16);
            return BoxedUnit.UNIT;
        }));
        this.time().sleep(100L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
        AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        EasyMock.reset((Object[])new Object[]{this.brokerToController()});
        this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        EasyMock.verify((Object[])new Object[]{this.brokerToController()});
    }

    @Test
    public void testPartitionMissingInResponse() {
        Object object = new Object();
        try {
            Capture callbackCapture = EasyMock.newCapture();
            EasyMock.reset((Object[])new Object[]{this.brokerToController()});
            this.brokerToController().sendRequest((AbstractRequest.Builder)EasyMock.anyObject(), (RequestCompletionHandler)EasyMock.capture((Capture)callbackCapture));
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
            EasyMock.replay((Object[])new Object[]{this.brokerToController()});
            MockScheduler scheduler = new MockScheduler((Time)this.time());
            AlterIsrManagerImpl alterIsrManager = new AlterIsrManagerImpl(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
            alterIsrManager.start();
            AtomicInteger count = new AtomicInteger(0);
            Function1 & Serializable callback = (Function1 & Serializable)result -> {
                count.incrementAndGet();
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            };
            alterIsrManager.enqueue(new AlterIsrItem(this.tp0(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback));
            alterIsrManager.enqueue(new AlterIsrItem(this.tp1(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback));
            alterIsrManager.enqueue(new AlterIsrItem(this.tp2(), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1)callback));
            this.time().sleep(100L);
            scheduler.tick();
            EasyMock.verify((Object[])new Object[]{this.brokerToController()});
            AlterIsrResponse alterIsrResp = new AlterIsrResponse(new AlterIsrResponseData().setTopics(Collections.singletonList(new AlterIsrResponseData.TopicData().setName(this.tp0().topic()).setPartitions(Collections.singletonList(new AlterIsrResponseData.PartitionData().setPartitionIndex(this.tp0().partition()).setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()))))));
            ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
            ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
            Assert.assertEquals((String)"Expected all callbacks to run", (long)count.get(), (long)3L);
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBasic$2(Either x$2) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$2(Either x$3) {
    }

    public static final /* synthetic */ void $anonfun$testOverwriteWithinBatch$3(Either x$4) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$3(Either x$5) {
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$2(AlterIsrManagerTest $this, AlterIsrManagerImpl alterIsrManager$1, int i) {
        alterIsrManager$1.enqueue(new AlterIsrItem(new TopicPartition($this.topic(), i), new LeaderAndIsr(1, 1, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), 10), (Function1 & Serializable)x$5 -> {
            AlterIsrManagerTest.$anonfun$testSingleBatch$3(x$5);
            return BoxedUnit.UNIT;
        }));
        $this.time().sleep(1L);
    }

    public static final /* synthetic */ void $anonfun$testSingleBatch$4(Either x$6) {
    }

    public static final /* synthetic */ void $anonfun$testAuthorizationFailed$1(Either x$7) {
    }

    public static final /* synthetic */ void $anonfun$testAuthorizationFailed$2(Either x$8) {
    }

    public static final /* synthetic */ void $anonfun$testStaleBrokerEpoch$1(Either x$9) {
    }

    public static final /* synthetic */ void $anonfun$testStaleBrokerEpoch$2(Either x$10) {
    }

    public static final /* synthetic */ void $anonfun$testOtherErrors$1(Either x$11) {
    }

    public static final /* synthetic */ void $anonfun$testOtherErrors$2(Either x$12) {
    }

    public static final /* synthetic */ void $anonfun$testPartitionErrors$2(Either x$13) {
    }

    public static final /* synthetic */ void $anonfun$testPartitionErrors$1(AlterIsrManagerTest $this, Errors error) {
        Assert.assertTrue((boolean)$this.testPartitionError($this.tp0(), error).enqueue(new AlterIsrItem($this.tp0(), null, (Function1 & Serializable)x$13 -> {
            AlterIsrManagerTest.$anonfun$testPartitionErrors$2(x$13);
            return BoxedUnit.UNIT;
        })));
    }

    public static final /* synthetic */ void $anonfun$testPartitionError$2(ObjectRef capturedError$1, Either result) {
        Errors error;
        if (result instanceof Left && (error = (Errors)((Left)result).value()) != null) {
            capturedError$1.elem = new Some((Object)error);
            return;
        }
        if (result instanceof Right) {
            Assert.fail((String)"Should have seen error");
            return;
        }
        throw new MatchError((Object)result);
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$2(Either x$14) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$3(Either x$15) {
    }

    public static final /* synthetic */ void $anonfun$testOneInFlight$4(Either x$16) {
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

