/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0015\u0001A\u0003%A\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\rE\u0002\u0001\u0015!\u0003,\u0011\u001d\u0011\u0004A1A\u0005\nMBa\u0001\u0011\u0001!\u0002\u0013!\u0004bB!\u0001\u0005\u0004%IA\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\"\t\u000f-\u0003!\u0019!C\u0005\u0019\"1\u0011\u000b\u0001Q\u0001\n5CQA\u0015\u0001\u0005\u0002MCQA\u0018\u0001\u0005\u0002MCQ\u0001\u0019\u0001\u0005\u0002M\u0013\u0011d\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eV3ti*\u0011\u0011CE\u0001\u0006KB|7\r\u001b\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0001\u0012AB2p]\u001aLw-F\u0001%!\t)c%D\u0001\u0013\u0013\t9#CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-F\u0001,!\tas&D\u0001.\u0015\tqC#A\u0003vi&d7/\u0003\u00021[\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003Q\u0002\"!\u000e \u000e\u0003YR!AM\u001c\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u0016u)\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tydGA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nq\"\u00197uKJL5O]'b]\u0006<WM]\u000b\u0002\u0007B\u0011Ai\u0012\b\u0003Y\u0015K!AR\u0017\u0002\u0013Q+7\u000f^+uS2\u001c\u0018B\u0001%J\u0005MiunY6BYR,'/S:s\u001b\u0006t\u0017mZ3s\u0015\t1U&\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005\u0011A\u000f]\u000b\u0002\u001bB\u0011ajT\u0007\u0002o%\u0011\u0001k\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001\u001bg\"|W\u000f\u001c3HKR,\u0005o\\2ig\u001a\u0013x.\u001c*fa2L7-\u0019\u000b\u0002)B\u0011\u0011$V\u0005\u0003-j\u0011A!\u00168ji\"\u0012A\u0002\u0017\t\u00033rk\u0011A\u0017\u0006\u00037r\nQA[;oSRL!!\u0018.\u0003\tQ+7\u000f^\u0001)g\"|W\u000f\u001c3SKR,(O\u001c(p\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|g.\u00134UQJ|wO\u001c\u0015\u0003\u001ba\u000b1f\u001d5pk2$'+\u001a;ve:,fn\u001b8po:$v\u000e]5d\u001fJ\u0004\u0016M\u001d;ji&|g.\u00134UQJ|wO\u001c\u0015\u0003\u001da\u0003")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TestUtils.MockAlterIsrManager alterIsrManager = new TestUtils.MockAlterIsrManager();
    private final TopicPartition tp = new TopicPartition("topic", 1);

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldGetEpochsFromReplica() {
        void apply_elems;
        void $minus$greater$extension_y;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var8_4 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Log mockLog = (Log)EasyMock.createNiceMock(Log.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)mockLog.endOffsetForEpoch(n)).andReturn((Object)new Some((Object)offsetAndEpoch));
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLog, logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (AlterIsrManager)this.alterIsrManager(), (Option)None$.MODULE$);
        Partition partition = replicaManager.createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)this.config().brokerId()));
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NONE, offsetAndEpoch.leaderEpoch(), offsetAndEpoch.offset()), (Object)response.apply((Object)this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        void apply_elems;
        void $minus$greater$extension_y;
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (AlterIsrManager)this.alterIsrManager(), (Option)None$.MODULE$);
        replicaManager.createPartition(this.tp());
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var5_5 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L), (Object)response.apply((Object)this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        void apply_elems;
        void $minus$greater$extension_y;
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (AlterIsrManager)this.alterIsrManager(), (Option)None$.MODULE$);
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var5_5 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L), (Object)response.apply((Object)this.tp()));
    }
}

