/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetRequestData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}A\u0001\"\t\u0001\t\u0006\u0004%IA\t\u0005\u0006S\u0001!\tE\u000b\u0005\u0006c\u0001!\tF\r\u0005\u0006k\u0001!\tF\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006/\u0002!\t!\u0012\u0005\u00065\u0002!\t!\u0012\u0005\u00069\u0002!\t!\u0012\u0005\u0006=\u0002!\t!\u0012\u0005\u0006G\u0002!\t!\u0012\u0005\u0006M\u0002!\t!\u0012\u0005\u0006Q\u0002!\t!\u0012\u0005\u0006+\u0001!IA\u001b\u0005\u0006]\u0002!Ia\u001c\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\u001f\u0001\t\u0013\tiHA\u0007M_\u001e|eMZ:fiR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011\u0001F\u0005\u0003;Q\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\tQLW.Z\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011aEF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012\u0001\"T8dWRKW.Z\u0001\fEJ|7.\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\u000bEJ|7.\u001a:US6,GCA\u00124\u0011\u0015!D\u00011\u0001,\u0003!\u0011'o\\6fe&#\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t9$\b\u0005\u0002-q%\u0011\u0011(\f\u0002\u0005+:LG\u000fC\u0003<\u000b\u0001\u0007A(A\u0003qe>\u00048\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\u0015A\u0013x\u000e]3si&,7/A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5d)\u00059\u0004F\u0001\u0004H!\tAU*D\u0001J\u0015\tQ5*A\u0003kk:LGOC\u0001M\u0003\ry'oZ\u0005\u0003\u001d&\u0013A\u0001V3ti\"\"a\u0001U*V!\ta\u0013+\u0003\u0002S[\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003Q\u000bQ\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u00022\u0006'I\u0001W\u0003\u0001\t\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u0012qa\u0012\u0015\u0005\u000fA\u001bV+\u0001\u0010uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a'bi\u0016\u001cH\u000fV5nK\"\u0012\u0001bR\u0001\u0018i\u0016\u001cH/R7qifdunZ:HKR|eMZ:fiND#!C$\u0002/Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u001d><\bF\u0001\u0006HQ\u0011Q\u0001+Y+\"\u0003\t\f\u0001\u0004\\3hC\u000eLh)\u001a;dQ>3gm]3ug\n+gm\u001c:f\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK\u0016\u000b'\u000f\\5fgR$\u0016.\\3)\u0005-9\u0005\u0006B\u0006QCV\u000bQ\u0006^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:CK\u001a|'/Z,ji\"\u001c\u0005.\u00198hS:<7+Z4nK:$8+\u001b>fQ\taq)\u0001\u0016uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^:)\u000559U#A6\u0011\u0005ma\u0017BA7\u0015\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002-M,g\u000e\u001a'jgR|eMZ:fiN\u0014V-];fgR$\"\u0001]>\u0011\u0005ELX\"\u0001:\u000b\u0005M$\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005U4\u0018AB2p[6|gN\u0003\u0002\u0018o*\u0011\u0001pS\u0001\u0007CB\f7\r[3\n\u0005i\u0014(A\u0005'jgR|eMZ:fiJ+7\u000f]8og\u0016DQ\u0001`\bA\u0002u\fqA]3rk\u0016\u001cH\u000f\u0005\u0002r}&\u0011qP\u001d\u0002\u0012\u0019&\u001cHo\u00144gg\u0016$(+Z9vKN$\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0011\t)!a\u0006\u0011\u000bE\f9!a\u0003\n\u0007\u0005%!OA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003;\u0002\rI,7m\u001c:e\u0013\u0011\t)\"a\u0004\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0019a\b\u00031\u0001\u0002\u001aA\u0019\u0011/a\u0007\n\u0007\u0005u!O\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\tck&dG\rV1sO\u0016$H+[7fgRA\u00111EA1\u0003[\n9\b\u0005\u0004\u0002&\u0005U\u00121\b\b\u0005\u0003O\t\tD\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003G\u0001\u0007yI|w\u000e\u001e \n\u00039J1!a\r.\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\t!A*[:u\u0015\r\t\u0019$\f\t\u0005\u0003{\tYF\u0004\u0003\u0002@\u0005Uc\u0002BA!\u0003#rA!a\u0011\u0002P9!\u0011QIA'\u001d\u0011\t9%a\u0013\u000f\t\u0005%\u0012\u0011J\u0005\u0002\u0019&\u0011\u0001pS\u0005\u0003/]L!!\u001e<\n\u0007\u0005MC/A\u0004nKN\u001c\u0018mZ3\n\t\u0005]\u0013\u0011L\u0001\u0016\u0019&\u001cHo\u00144gg\u0016$(+Z9vKN$H)\u0019;b\u0015\r\t\u0019\u0006^\u0005\u0005\u0003;\nyFA\bMSN$xJ\u001a4tKR$v\u000e]5d\u0015\u0011\t9&!\u0017\t\u000f\u0005\r\u0014\u00031\u0001\u0002f\u0005\u0011A\u000f\u001d\t\u0005\u0003O\nI'D\u0001u\u0013\r\tY\u0007\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ty'\u0005a\u0001\u0003c\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u00071\n\u0019(C\u0002\u0002v5\u0012A\u0001T8oO\"1\u0011\u0011P\tA\u0002-\nQ\"\\1y\u001dVlwJ\u001a4tKR\u001c\u0018!\u00044j]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002\u0000\u00055\u0015q\u0015\t\u0005\u0003\u0003\u000b9I\u0004\u0003\u0002@\u0005\r\u0015\u0002BAC\u00033\na\u0003T5ti>3gm]3u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003\u0013\u000bYIA\u000eMSN$xJ\u001a4tKR\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003\u000b\u000bI\u0006C\u0004\u0002\u0010J\u0001\r!!%\u0002\rQ|\u0007/[2t!\u0019\t\u0019*!(\u0002\"6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0004nkR\f'\r\\3\u000b\u0007\u0005mU&\u0001\u0006d_2dWm\u0019;j_:LA!a(\u0002\u0016\n1!)\u001e4gKJ\u0004B!!!\u0002$&!\u0011QUAF\u0005]a\u0015n\u001d;PM\u001a\u001cX\r\u001e+pa&\u001c'+Z:q_:\u001cX\rC\u0004\u0002dI\u0001\r!!\u001a")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)300000).toString());
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetResponse response = this.sendListOffsetsRequest(request);
        Assert.assertEquals((long)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (long)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)response.topics()).asScala(), topicPartition).errorCode());
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Log for partition [topic,0] should be created", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var11_10 = null;
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        void apply_elems;
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$2(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var14_10 = null;
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        FetchRequest.PartitionData $minus$greater$extension_y = new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)((Long)consumerOffsets.head())), -1L, 307200, Optional.empty());
        Object var10_18 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava()).build();
        Assert.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)this.sendFetchRequest(fetchRequest).responseData().get(topicPartition)).records()).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        boolean bl = false;
        int n = 1;
        int to$extension_end = 14;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TopicPartition $anonfun$testEmptyLogsGetOffsets$1_topicPartition = new TopicPartition(topic, 0);
                ListOffsetRequest $anonfun$testEmptyLogsGetOffsets$1_request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes($anonfun$testEmptyLogsGetOffsets$1_topicPartition, -2L, 1)).asJava()).build();
                if (BoxesRunTime.equals((Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.sendListOffsetsRequest($anonfun$testEmptyLogsGetOffsets$1_request).topics()).asScala(), $anonfun$testEmptyLogsGetOffsets$1_topicPartition).oldStyleOffsets()).asScala().head(), (Object)1)) {
                    bl = true;
                }
                Object var9_10 = null;
                Object var10_11 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var6_8 = null;
        Assert.assertFalse((boolean)bl);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, (Function0 & Serializable)() -> logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var12_8 = null;
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, (Function0 & Serializable)() -> logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var10_8 = null;
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)logSegment.size()).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public final Iterable<LogSegment> toIterable() {
                        return Iterable.toIterable$((Iterable)this);
                    }

                    public final Iterable<LogSegment> coll() {
                        return Iterable.coll$((Iterable)this);
                    }

                    public IterableFactory<Iterable> iterableFactory() {
                        return Iterable.iterableFactory$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public String className() {
                        return Iterable.className$((Iterable)this);
                    }

                    public final String collectionClassName() {
                        return Iterable.collectionClassName$((Iterable)this);
                    }

                    public String stringPrefix() {
                        return Iterable.stringPrefix$((Iterable)this);
                    }

                    public String toString() {
                        return Iterable.toString$((Iterable)this);
                    }

                    public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                        return Iterable.lazyZip$((Iterable)this, that);
                    }

                    public IterableOps fromSpecific(IterableOnce coll) {
                        return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                        return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
                    }

                    public IterableOps empty() {
                        return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
                    }

                    public final Iterable<LogSegment> toTraversable() {
                        return IterableOps.toTraversable$((IterableOps)this);
                    }

                    public boolean isTraversableAgain() {
                        return IterableOps.isTraversableAgain$((IterableOps)this);
                    }

                    public final Object repr() {
                        return IterableOps.repr$((IterableOps)this);
                    }

                    public IterableFactory<Iterable> companion() {
                        return IterableOps.companion$((IterableOps)this);
                    }

                    public Object head() {
                        return IterableOps.head$((IterableOps)this);
                    }

                    public Option<LogSegment> headOption() {
                        return IterableOps.headOption$((IterableOps)this);
                    }

                    public Object last() {
                        return IterableOps.last$((IterableOps)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return IterableOps.lastOption$((IterableOps)this);
                    }

                    public View<LogSegment> view() {
                        return IterableOps.view$((IterableOps)this);
                    }

                    public int sizeCompare(int otherSize) {
                        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
                    }

                    public final IterableOps sizeIs() {
                        return IterableOps.sizeIs$((IterableOps)this);
                    }

                    public int sizeCompare(Iterable<?> that) {
                        return IterableOps.sizeCompare$((IterableOps)this, that);
                    }

                    public View<LogSegment> view(int from, int until) {
                        return IterableOps.view$((IterableOps)this, (int)from, (int)until);
                    }

                    public Object transpose(Function1 asIterable) {
                        return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object filter(Function1 pred) {
                        return IterableOps.filter$((IterableOps)this, (Function1)pred);
                    }

                    public Object filterNot(Function1 pred) {
                        return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
                    }

                    public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                        return IterableOps.withFilter$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return IterableOps.partition$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return IterableOps.splitAt$((IterableOps)this, (int)n);
                    }

                    public Object take(int n) {
                        return IterableOps.take$((IterableOps)this, (int)n);
                    }

                    public Object takeRight(int n) {
                        return IterableOps.takeRight$((IterableOps)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return IterableOps.span$((IterableOps)this, p);
                    }

                    public Object drop(int n) {
                        return IterableOps.drop$((IterableOps)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableOps.dropRight$((IterableOps)this, (int)n);
                    }

                    public Object dropWhile(Function1 p) {
                        return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableOps.grouped$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableOps.sliding$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
                    }

                    public Object tail() {
                        return IterableOps.tail$((IterableOps)this);
                    }

                    public Object init() {
                        return IterableOps.init$((IterableOps)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return IterableOps.groupBy$((IterableOps)this, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                        return IterableOps.groupMap$((IterableOps)this, key, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                        return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
                    }

                    public Object scan(Object z, Function2 op) {
                        return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanLeft(Object z, Function2 op) {
                        return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanRight(Object z, Function2 op) {
                        return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object map(Function1 f) {
                        return IterableOps.map$((IterableOps)this, (Function1)f);
                    }

                    public Object flatMap(Function1 f) {
                        return IterableOps.flatMap$((IterableOps)this, (Function1)f);
                    }

                    public Object flatten(Function1 asIterable) {
                        return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object collect(PartialFunction pf) {
                        return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                        return IterableOps.partitionMap$((IterableOps)this, f);
                    }

                    public Object concat(IterableOnce suffix) {
                        return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public final Object $plus$plus(IterableOnce suffix) {
                        return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public Object zip(IterableOnce that) {
                        return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
                    }

                    public Object zipWithIndex() {
                        return IterableOps.zipWithIndex$((IterableOps)this);
                    }

                    public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                        return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return IterableOps.unzip$((IterableOps)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return IterableOps.unzip3$((IterableOps)this, asTriple);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return IterableOps.tails$((IterableOps)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return IterableOps.inits$((IterableOps)this);
                    }

                    public Object tapEach(Function1 f) {
                        return IterableOps.tapEach$((IterableOps)this, (Function1)f);
                    }

                    public Object $plus$plus$colon(IterableOnce that) {
                        return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
                    }

                    public boolean hasDefiniteSize() {
                        return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableOnceOps.foreach$((IterableOnceOps)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.forall$((IterableOnceOps)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.exists$((IterableOnceOps)this, p);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.count$((IterableOnceOps)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.find$((IterableOnceOps)this, p);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                    }

                    public <B> B reduce(Function2<B, B, B> op) {
                        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                    }

                    public boolean isEmpty() {
                        return IterableOnceOps.isEmpty$((IterableOnceOps)this);
                    }

                    public boolean nonEmpty() {
                        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                    }

                    public final <B> void copyToBuffer(Buffer<B> dest) {
                        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                    }

                    public <B> int copyToArray(Object xs) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                    }

                    public <B> int copyToArray(Object xs, int start) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                    }

                    public <B> int copyToArray(Object xs, int start, int len) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                    }

                    public Object min(Ordering ord) {
                        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                    }

                    public Object max(Ordering ord) {
                        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                    }

                    public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                    }

                    public final String mkString(String start, String sep, String end) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                    }

                    public final String mkString(String sep) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                    }

                    public final String mkString() {
                        return IterableOnceOps.mkString$((IterableOnceOps)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public final StringBuilder addString(StringBuilder b, String sep) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                    }

                    public final StringBuilder addString(StringBuilder b) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                    }

                    public <C1> C1 to(Factory<LogSegment, C1> factory) {
                        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                    }

                    public final Iterator<LogSegment> toIterator() {
                        return IterableOnceOps.toIterator$((IterableOnceOps)this);
                    }

                    public List<LogSegment> toList() {
                        return IterableOnceOps.toList$((IterableOnceOps)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return IterableOnceOps.toVector$((IterableOnceOps)this);
                    }

                    public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                    }

                    public <B> Set<B> toSet() {
                        return IterableOnceOps.toSet$((IterableOnceOps)this);
                    }

                    public scala.collection.immutable.Seq<LogSegment> toSeq() {
                        return IterableOnceOps.toSeq$((IterableOnceOps)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                    }

                    public final Stream<LogSegment> toStream() {
                        return IterableOnceOps.toStream$((IterableOnceOps)this);
                    }

                    public final <B> Buffer<B> toBuffer() {
                        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$2) {
                        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                    }

                    public Iterable<LogSegment> reversed() {
                        return IterableOnceOps.reversed$((IterableOnceOps)this);
                    }

                    public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                    }

                    public int knownSize() {
                        return IterableOnce.knownSize$((IterableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return StrictOptimizedLinearSeqOps.iterator$((StrictOptimizedLinearSeqOps)new .colon.colon((Object)this.$outer.logSegment$1, (List)Nil$.MODULE$));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetResponse sendListOffsetsRequest(ListOffsetRequest request) {
        return (ListOffsetResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetRequestData.ListOffsetTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetRequestData.ListOffsetTopic().setName(tp.topic()).setPartitions(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetResponseData.ListOffsetPartitionResponse findPartition(Buffer<ListOffsetResponseData.ListOffsetTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetResponseData.ListOffsetPartitionResponse)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((ListOffsetResponseData.ListOffsetTopicResponse)topics.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$6))).get()).partitions()).asScala().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$7))).get();
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsAfterDeleteRecords$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        return logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsBeforeLatestTime$1(LogManager logManager$2, TopicPartition topicPartition$2) {
        return logManager$2.getLog(topicPartition$2, logManager$2.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$2(TopicPartition topicPartition$2) {
        return new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition$2).append(" should be created").toString();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ void $anonfun$testEmptyLogsGetOffsets$1(LogOffsetTest $this, String topic$3, BooleanRef offsetChanged$1, int x$3) {
        TopicPartition topicPartition = new TopicPartition(topic$3, 0);
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, $this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
        if (BoxesRunTime.equals((Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)$this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)$this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)1)) {
            offsetChanged$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetResponseData.ListOffsetTopicResponse x$6) {
        String string = x$6.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetResponseData.ListOffsetPartitionResponse x$7) {
        return x$7.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsAfterDeleteRecords$3$adapted(Log log$1, Object x$1) {
        return log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeLatestTime$3$adapted(Log log$2, Object x$2) {
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeNow$2$adapted(Log log$3, Object x$4) {
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeEarliestTime$2$adapted(Log log$4, Object x$5) {
        return log$4.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }
}

