/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u001a4\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001A\u0002\u0013%A\tC\u0004I\u0001\u0001\u0007I\u0011B%\t\r=\u0003\u0001\u0015)\u0003F\u0011\u001d\u0001\u0006\u00011A\u0005\nECq\u0001\u0017\u0001A\u0002\u0013%\u0011\f\u0003\u0004\\\u0001\u0001\u0006KA\u0015\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0011\u001d\t\u0007\u00011A\u0005\n\tDa\u0001\u001a\u0001!B\u0013q\u0006bB3\u0001\u0001\u0004%IA\u001a\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u0011\u0019i\u0007\u0001)Q\u0005O\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\t\u0007I\u0011B;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u001di\bA1A\u0005\n=DaA \u0001!\u0002\u0013\u0001\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?Aq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u00024!9\u0011\u0011\f\u0001\u0005\u0002\u0005M\u0002bBA/\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003C\u0002A\u0011AA\u001a\u0011\u001d\t)\u0007\u0001C\u0001\u0003gAq!!\u001b\u0001\t\u0003\t\u0019\u0004C\u0004\u0002n\u0001!\t!a\r\t\u000f\u0005E\u0004\u0001\"\u0001\u00024!9\u0011Q\u000f\u0001\u0005\u0002\u0005M\u0002bBA=\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003{\u0002A\u0011AA\u001a\u0011\u001d\t\t\t\u0001C\u0001\u0003gAq!!\"\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\n\u0002!\t!a\r\t\u000f\u00055\u0005\u0001\"\u0001\u00024!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0002bBAK\u0001\u0011\u0005\u00111\u0007\u0005\b\u00033\u0003A\u0011AA\u001a\u0011\u001d\ti\n\u0001C\u0001\u0003gAq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002>\u0002!\t!a\r\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u00024!9\u0011Q\u0019\u0001\u0005\u0002\u0005M\u0002bBAe\u0001\u0011%\u00111\u001a\u0002\u001a!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u00025k\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0011\u0005\t\u0003Q\"A\u001a\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001F!\t\u0011e)\u0003\u0002Hg\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002+\r|g\u000e\u001e:pY2,'oQ8oi\u0016DHo\u0018\u0013fcR\u0011!*\u0014\t\u0003u-K!\u0001T\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u000e\t\t\u00111\u0001F\u0003\rAH%M\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b%\u0001\u0007n_\u000e\\'l[\"mS\u0016tG/F\u0001S!\t\u0019f+D\u0001U\u0015\t)V'\u0001\u0002{W&\u0011q\u000b\u0016\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!5|7m\u001b.l\u00072LWM\u001c;`I\u0015\fHC\u0001&[\u0011\u001dqe!!AA\u0002I\u000bQ\"\\8dWj[7\t\\5f]R\u0004\u0013\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012A\u0018\t\u0003\u0005~K!\u0001Y\u001a\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0006!Sn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002KG\"9a*CA\u0001\u0002\u0004q\u0016!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002OB\u0011!\t[\u0005\u0003SN\u0012Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-A\rqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3`I\u0015\fHC\u0001&m\u0011\u001dqE\"!AA\u0002\u001d\fa\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rI\u0001\tEJ|7.\u001a:JIV\t\u0001\u000f\u0005\u0002;c&\u0011!o\u000f\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zk\u000511/\u001a:wKJL!a\u001f=\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0017\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002\u0004A!\u0011QAA\u000b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB2p[6|gNC\u00027\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r]1dQ\u0016T!!a\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0018\u0005\u001d!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039beRLG/[8ogV\u0011\u0011q\u0004\t\u0007\u0003C\tY#a\u0001\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005%2(\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002$\t\u00191+Z9\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0015\"\u001a\u0001$a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQA!!\u0010\u0002\u0012\u0005)!.\u001e8ji&!\u0011\u0011IA\u001e\u0005\u0019\u0011UMZ8sK\u0006q\u0001/\u0019:uSRLwN\\*uCR,G\u0003BA$\u0003\u001b\u00022AQA%\u0013\r\tYe\r\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0019y\u0018\u00041\u0001\u0002\u0004\u0005\u0001D/Z:u\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8U_:+w\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3AGA*!\u0011\tI$!\u0016\n\t\u0005]\u00131\b\u0002\u0005)\u0016\u001cH/\u0001\u001euKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1$a\u0015\u0002wQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eV8PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002\u001d\u0003'\n1\u0006^3ti:+w\u000fU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004;\u0005M\u0013a\u0015;fgRtUm\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u\u000bb\u001cW\r\u001d;j_:4%o\\7De\u0016\fG/Z*uCR,7\u000fK\u0002\u001f\u0003'\nA\t^3ti:+w\u000fU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\\#se>\u00148i\u001c3f\rJ|Wn\u0011:fCR,7\u000b^1uKND3aHA*\u00031\"Xm\u001d;OK^\u0004\u0016M\u001d;ji&|g\u000eV8PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002!\u0003'\nq\u0007^3ti&sg/\u00197jI:+w\u000fU1si&$\u0018n\u001c8U_:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)J\fgn]5uS>t\u0007fA\u0011\u0002T\u0005)C/Z:u\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016$&/\u00198tSRLwN\u001c\u0015\u0004E\u0005M\u0013A\u000f;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\r\u0016:b]NLG/[8o\r>\u00148i\u001c8ue>dG.\u001a3TQV$Hm\\<oQ\r\u0019\u00131K\u0001'i\u0016\u001cHo\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f)J\fgn]5uS>t\u0007f\u0001\u0013\u0002T\u0005QD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R{gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004K\u0005M\u0013A\r;fgRLeN^1mS\u0012|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0019\n\u0019&A\u0018uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002(\u0003'\na\u0007^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\+oG2,\u0017M\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3\u0001KA*\u0003Y#Xm\u001d;PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o5>|7*Z3qKJ\u001cE.[3oi\u0016C8-\u001a9uS>tgI]8n'R\fG/\u001a'p_.,\b\u000fK\u0002*\u0003'\nq\t^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:,%O]8s\u0007>$WM\u0012:p[N#\u0018\r^3M_>\\W\u000f\u001d\u0015\u0004U\u0005M\u0013\u0001\u000e;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1&a\u0015\u0002gQ,7\u000f^%om\u0006d\u0017\u000eZ(gM2Lg.\u001a)beRLG/[8o)>tUm\u001e)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0017\u0002T\u0005)\u0003O]3qCJ,Wj\\2l)>,E.Z2u\u0019\u0016\fG-\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004\u0015\u0006\u0015\u0006bBA\u000e[\u0001\u0007\u0011q\u0015\t\u0007\u0003S\u000bI,a\u0001\u000f\t\u0005-\u0016Q\u0017\b\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011W\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014bAA\\w\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003wS1!a.<\u0003\t\"Xm\u001d;Va\u0012\fG/\u001b8h\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001c8i\\;oi\"\u001aa&a\u0015\u0002eQ,7\u000f\u001e(p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001c8\t[1oO\u00164uN\u001d+pa&\u001c7OQ3j]\u001e$U\r\\3uK\u0012D3aLA*\u0003U\"Xm\u001d;Va\u0012\fG/\u001b8h\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001c8i\\;oi\u0012+(/\u001b8h)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007A\n\u0019&A\tsKBd\u0017nY1BgNLwM\\7f]R$B!!4\u0002TB\u0019!)a4\n\u0007\u0005E7GA\tSKBd\u0017nY1BgNLwM\\7f]RDq!!62\u0001\u0004\t9.\u0001\u0005sKBd\u0017nY1t!\u0015\tI+!/q\u0001")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final scala.collection.immutable.Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        void apply_elems;
        TopicPartition topicPartition;
        void apply_elems2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var2_4 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderIsrAndControllerEpoch);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems), this.controllerContext().epochZkVersion())).andReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        void apply_elems;
        TopicPartition topicPartition;
        void apply_elems2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var2_4 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderIsrAndControllerEpoch);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems), this.controllerContext().epochZkVersion())).andThrow((Throwable)new ZooKeeperClientException("test"));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        void apply_elems;
        TopicPartition topicPartition;
        void apply_elems2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var2_4 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderIsrAndControllerEpoch);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems), this.controllerContext().epochZkVersion())).andReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOnlinePartitionToOnlineTransition() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        Right right;
        TopicPartition topicPartition;
        void apply_elems3;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var6_8 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderAndIsrAfterElection);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right2 = right = new Right((Object)updatedLeaderAndIsr);
        right = null;
        Right right3 = right2;
        TopicPartition $minus$greater$extension_$this2 = this.partition();
        Object var7_12 = null;
        right3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems), (Seq)Seq$.MODULE$.empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        Right right;
        TopicPartition topicPartition;
        void apply_elems3;
        int otherBrokerId = this.brokerId() + 1;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        objectArray[1] = TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3));
        this.controllerContext().shuttingDownBrokerIds().add((Object)this.brokerId());
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var7_9 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderAndIsrAfterElection);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right2 = right = new Right((Object)updatedLeaderAndIsr);
        right = null;
        Right right3 = right2;
        TopicPartition $minus$greater$extension_$this2 = this.partition();
        Object var8_13 = null;
        right3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems), (Seq)Seq$.MODULE$.empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        Right right;
        TopicPartition topicPartition;
        void apply_elems3;
        void $minus$greater$extension_y2;
        void apply_elems4;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems4));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        LogConfig logConfig = LogConfig$.MODULE$.apply();
        String $minus$greater$extension_$this = this.partition().topic();
        Object var6_6 = null;
        logConfig = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs((scala.collection.immutable.Set)Set.EmptySet$.MODULE$, this.config().originals())).andReturn((Object)new Tuple2(MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems3), (Object)Map.EmptyMap$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this2 = topicPartition2;
        Object var8_11 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)leaderAndIsrAfterElection);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right2 = right = new Right((Object)updatedLeaderAndIsr);
        right = null;
        Right right3 = right2;
        TopicPartition $minus$greater$extension_$this3 = this.partition();
        Object var9_15 = null;
        right3 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems2), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems), (Seq)Seq$.MODULE$.empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOfflinePartitionToUncleanOnlinePartitionTransition() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        Right right;
        TopicPartition topicPartition;
        void apply_elems3;
        int leaderBrokerId = this.brokerId() + 1;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        TopicPartition topicPartition2 = topicPartition = this.partition();
        topicPartition = null;
        TopicPartition $minus$greater$extension_$this = topicPartition2;
        Object var6_8 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)leaderAndIsrAfterElection);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right2 = right = new Right((Object)updatedLeaderAndIsr);
        right = null;
        Right right3 = right2;
        TopicPartition $minus$greater$extension_$this2 = this.partition();
        Object var7_12 = null;
        right3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems), (Seq)Seq$.MODULE$.empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        void apply_elems;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andThrow((Throwable)new ZooKeeperClientException(""));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        void apply_elems;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdatingOfflinePartitionsCount() {
        void apply_elems;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.controllerContext().setLiveBrokers((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$1)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((scala.collection.immutable.Seq<TopicPartition>)partitions);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient()});
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.length()).append(" offline partition(s)").toString(), (long)partitions.length(), (long)this.controllerContext().offlinePartitionCount());
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.controllerContext().offlinePartitionCount());
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$2)));
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.controllerContext().offlinePartitionCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        void apply_elems;
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(37).append("There should be ").append(partitions.length()).append(" offline partition(s)").toString(), (long)partitions.length(), (long)this.controllerContext().offlinePartitionCount());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        topicDeletionManager.enqueueTopicsForDeletion((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertEquals((String)"There should be no offline partition(s)", (long)0L, (long)this.controllerContext().offlinePartitionCount());
    }

    private ReplicaAssignment replicaAssignment(scala.collection.immutable.Seq<Object> replicas) {
        Nil$ apply_removingReplicas = Nil$.MODULE$;
        Nil$ apply_addingReplicas = Nil$.MODULE$;
        return new ReplicaAssignment(replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, scala.collection.immutable.Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        scala.collection.immutable.Seq getDataResponses = (scala.collection.immutable.Seq)partitions$1.map((Function1 & Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)));
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw((Seq)partitions$1)).andReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs((scala.collection.immutable.Set)Set.EmptySet$.MODULE$, this.config().originals())).andReturn((Object)new Tuple2((Object)Map.EmptyMap$.MODULE$, (Object)Map.EmptyMap$.MODULE$));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(scala.collection.immutable.Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((IterableOnceOps)partitions$1.map((Function1 & Serializable)partition -> {
            LeaderAndIsr $minus$greater$extension_y = leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
            return new Tuple2(partition, (Object)$minus$greater$extension_y);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Right right;
            LeaderAndIsr v;
            TopicPartition k;
            if (x0$1 != null) {
                k = (TopicPartition)x0$1._1();
                v = (LeaderAndIsr)x0$1._2();
                if (package$.MODULE$.Right() == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Right right2 = right = new Right((Object)v);
            right = null;
            Right $minus$greater$extension_y = right2;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }), (Seq)Seq$.MODULE$.empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$2) {
        return new TopicPartition(topic$2, x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

