/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import kafka.admin.BrokerApiVersionsCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersion;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Y2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)Q\u0005\u0001C\u0001M\ta\"I]8lKJ\f\u0005/\u001b,feNLwN\\:D_6l\u0017M\u001c3UKN$(B\u0001\u0004\b\u0003\u0015\tG-\\5o\u0015\u0005A\u0011!B6bM.\f7\u0001A\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q!AD\u0004\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003!5\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\u0015\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002/A\u0019\u0001$H\u0010\u000e\u0003eQ!AG\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq\u0012DA\u0002TKF\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\u0004\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AI2iK\u000e\\'I]8lKJ\f\u0005/\u001b,feNLwN\\\"p[6\fg\u000eZ(viB,H\u000fF\u0001(!\tA\u0013&D\u0001\u001c\u0013\tQ3D\u0001\u0003V]&$\b\u0006B\u0002-iU\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000b),h.\u001b;\u000b\u0003E\n1a\u001c:h\u0013\t\u0019dF\u0001\u0003UKN$\u0018a\u0002;j[\u0016|W\u000f\u001e\u0010\u0004\u0003Q\u0007\r")
public class BrokerApiVersionsCommandTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test(timeout=120000L)
    public void checkBrokerApiVersionCommandOutput() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, StandardCharsets.UTF_8.name());
        BrokerApiVersionsCommand$.MODULE$.execute(new String[]{"--bootstrap-server", this.brokerList()}, printStream);
        String content = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator lineIter = ArrayOps$.MODULE$.iterator$extension((Object)content.split("\n"));
        Assert.assertTrue((boolean)lineIter.hasNext());
        Assert.assertEquals((Object)new StringBuilder(24).append(this.brokerList()).append(" (id: 0 rack: null) -> (").toString(), (Object)lineIter.next());
        NodeApiVersions nodeApiVersions = NodeApiVersions.create();
        Buffer enabledApis = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)ApiKeys.enabledApis()).asScala();
        enabledApis.foreach((Function1 & Serializable)apiKey -> {
            BrokerApiVersionsCommandTest.$anonfun$checkBrokerApiVersionCommandOutput$1(nodeApiVersions, enabledApis, lineIter, apiKey);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)lineIter.hasNext());
        Assert.assertEquals((Object)")", (Object)lineIter.next());
        Assert.assertFalse((boolean)lineIter.hasNext());
    }

    public static final /* synthetic */ void $anonfun$checkBrokerApiVersionCommandOutput$1(NodeApiVersions nodeApiVersions$1, Buffer enabledApis$1, Iterator lineIter$1, ApiKeys apiKey) {
        ApiVersion apiVersion = nodeApiVersions$1.apiVersion(apiKey);
        Assert.assertNotNull((Object)apiVersion);
        String versionRangeStr = apiVersion.minVersion == apiVersion.maxVersion ? ((Object)apiVersion.minVersion).toString() : new StringBuilder(4).append(apiVersion.minVersion).append(" to ").append(apiVersion.maxVersion).toString();
        ApiKeys apiKeys = apiKey;
        Object object = enabledApis$1.last();
        String terminator = !(apiKeys != null ? !apiKeys.equals(object) : object != null) ? "" : ",";
        short usableVersion = nodeApiVersions$1.latestUsableVersion(apiKey);
        String line = new StringBuilder(16).append("\t").append(apiKey.name).append("(").append(apiKey.id).append("): ").append(versionRangeStr).append(" [usable: ").append(usableVersion).append("]").append(terminator).toString();
        Assert.assertTrue((boolean)lineIter$1.hasNext());
        Assert.assertEquals((Object)line, (Object)lineIter$1.next());
    }
}

