/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.mirror.MirrorClientConfig;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.runtime.isolation.Plugins;

public class MirrorMakerConfig
extends AbstractConfig {
    public static final String CLUSTERS_CONFIG = "clusters";
    private static final String CLUSTERS_DOC = "List of cluster aliases.";
    public static final String CONFIG_PROVIDERS_CONFIG = "config.providers";
    private static final String CONFIG_PROVIDERS_DOC = "Names of ConfigProviders to use.";
    private static final String NAME = "name";
    private static final String CONNECTOR_CLASS = "connector.class";
    private static final String SOURCE_CLUSTER_ALIAS = "source.cluster.alias";
    private static final String TARGET_CLUSTER_ALIAS = "target.cluster.alias";
    private static final String GROUP_ID_CONFIG = "group.id";
    private static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    private static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    private static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    private static final String BYTE_ARRAY_CONVERTER_CLASS = "org.apache.kafka.connect.converters.ByteArrayConverter";
    static final String SOURCE_CLUSTER_PREFIX = "source.cluster.";
    static final String TARGET_CLUSTER_PREFIX = "target.cluster.";
    private final Plugins plugins = new Plugins(this.originalsStrings());
    protected static final ConfigDef CONFIG_DEF = new ConfigDef().define("clusters", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "List of cluster aliases.").define("config.providers", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "Names of ConfigProviders to use.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();

    public MirrorMakerConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props, true);
    }

    public Set<String> clusters() {
        return new HashSet<String>(this.getList(CLUSTERS_CONFIG));
    }

    public List<SourceAndTarget> clusterPairs() {
        ArrayList<SourceAndTarget> pairs = new ArrayList<SourceAndTarget>();
        Set<String> clusters = this.clusters();
        Map originalStrings = this.originalsStrings();
        boolean globalHeartbeatsEnabled = true;
        if (originalStrings.containsKey("emit.heartbeats.enabled")) {
            globalHeartbeatsEnabled = Boolean.valueOf((String)originalStrings.get("emit.heartbeats.enabled"));
        }
        for (String source : clusters) {
            for (String target : clusters) {
                if (source.equals(target)) continue;
                String clusterPairConfigPrefix = source + "->" + target + ".";
                boolean clusterPairEnabled = Boolean.valueOf(originalStrings.getOrDefault(clusterPairConfigPrefix + "enabled", "false"));
                boolean clusterPairHeartbeatsEnabled = globalHeartbeatsEnabled;
                if (originalStrings.containsKey(clusterPairConfigPrefix + "emit.heartbeats.enabled")) {
                    clusterPairHeartbeatsEnabled = Boolean.valueOf((String)originalStrings.get(clusterPairConfigPrefix + "emit.heartbeats.enabled"));
                }
                if (!clusterPairEnabled && !clusterPairHeartbeatsEnabled) continue;
                pairs.add(new SourceAndTarget(source, target));
            }
        }
        return pairs;
    }

    public MirrorClientConfig clientConfig(String cluster) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.originalsStrings());
        props.putAll(this.clusterProps(cluster));
        return new MirrorClientConfig(this.transform(props));
    }

    Map<String, String> clusterProps(String cluster) {
        String v;
        HashMap<String, String> props = new HashMap<String, String>();
        Map strings = this.originalsStrings();
        props.putAll(this.stringsWithPrefixStripped(cluster + "."));
        for (String k : MirrorClientConfig.CLIENT_CONFIG_DEF.names()) {
            v = (String)props.get(k);
            if (v == null) continue;
            props.putIfAbsent("producer." + k, v);
            props.putIfAbsent("consumer." + k, v);
            props.putIfAbsent("admin." + k, v);
        }
        for (String k : MirrorClientConfig.CLIENT_CONFIG_DEF.names()) {
            v = (String)strings.get(k);
            if (v == null) continue;
            props.putIfAbsent("producer." + k, v);
            props.putIfAbsent("consumer." + k, v);
            props.putIfAbsent("admin." + k, v);
            props.putIfAbsent(k, v);
        }
        return props;
    }

    Map<String, String> workerConfig(SourceAndTarget sourceAndTarget) {
        Map<String, String> props = new HashMap<String, String>();
        props.putAll(this.clusterProps(sourceAndTarget.target()));
        props.putAll(this.stringsWithPrefix("offset.storage"));
        props.putAll(this.stringsWithPrefix("config.storage"));
        props.putAll(this.stringsWithPrefix("status.storage"));
        props.putAll(this.stringsWithPrefix(KEY_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix(VALUE_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix(HEADER_CONVERTER_CLASS_CONFIG));
        props.putAll(this.stringsWithPrefix("task"));
        props.putAll(this.stringsWithPrefix("worker"));
        props = this.transform(props);
        props.putAll(this.stringsWithPrefix(CONFIG_PROVIDERS_CONFIG));
        props.putIfAbsent(GROUP_ID_CONFIG, sourceAndTarget.source() + "-mm2");
        props.putIfAbsent("offset.storage.topic", "mm2-offsets." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent("status.storage.topic", "mm2-status." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent("config.storage.topic", "mm2-configs." + sourceAndTarget.source() + ".internal");
        props.putIfAbsent(KEY_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        props.putIfAbsent(VALUE_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        props.putIfAbsent(HEADER_CONVERTER_CLASS_CONFIG, BYTE_ARRAY_CONVERTER_CLASS);
        return props;
    }

    Map<String, String> connectorBaseConfig(SourceAndTarget sourceAndTarget, Class<?> connectorClass) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(this.originalsStrings());
        props.keySet().retainAll(MirrorConnectorConfig.CONNECTOR_CONFIG_DEF.names());
        props.putAll(this.stringsWithPrefix(CONFIG_PROVIDERS_CONFIG));
        props.putAll(MirrorMakerConfig.withPrefix(SOURCE_CLUSTER_PREFIX, this.clusterProps(sourceAndTarget.source())));
        props.putAll(MirrorMakerConfig.withPrefix(TARGET_CLUSTER_PREFIX, this.clusterProps(sourceAndTarget.target())));
        props.putIfAbsent(NAME, connectorClass.getSimpleName());
        props.putIfAbsent(CONNECTOR_CLASS, connectorClass.getName());
        props.putIfAbsent(SOURCE_CLUSTER_ALIAS, sourceAndTarget.source());
        props.putIfAbsent(TARGET_CLUSTER_ALIAS, sourceAndTarget.target());
        props.putAll(this.stringsWithPrefixStripped(sourceAndTarget.source() + "->" + sourceAndTarget.target() + "."));
        props.putIfAbsent("enabled", "false");
        return props;
    }

    List<String> configProviders() {
        return this.getList(CONFIG_PROVIDERS_CONFIG);
    }

    Map<String, String> transform(Map<String, String> props) {
        List<String> providerNames = this.configProviders();
        HashMap<String, ConfigProvider> providers = new HashMap<String, ConfigProvider>();
        for (String name : providerNames) {
            ConfigProvider configProvider = this.plugins.newConfigProvider((AbstractConfig)this, "config.providers." + name, Plugins.ClassLoaderUsage.PLUGINS);
            providers.put(name, configProvider);
        }
        ConfigTransformer transformer = new ConfigTransformer(providers);
        Map transformed = transformer.transform(props).data();
        providers.values().forEach(x -> Utils.closeQuietly((AutoCloseable)x, (String)"config provider"));
        return transformed;
    }

    private Map<String, String> stringsWithPrefixStripped(String prefix) {
        return this.originalsStrings().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(prefix)).collect(Collectors.toMap(x -> ((String)x.getKey()).substring(prefix.length()), x -> (String)x.getValue()));
    }

    private Map<String, String> stringsWithPrefix(String prefix) {
        Map strings = this.originalsStrings();
        strings.keySet().removeIf(x -> !x.startsWith(prefix));
        return strings;
    }

    static Map<String, String> withPrefix(String prefix, Map<String, String> props) {
        return props.entrySet().stream().collect(Collectors.toMap(x -> prefix + (String)x.getKey(), x -> (String)x.getValue()));
    }
}

