/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\rd\u0001B$I\u00015C\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"Aa\u000f\u0001B\u0001B\u0003%q\u000fC\u0003}\u0001\u0011\u0005Q\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n!I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111\u0003\u0005\t\u0003?\u0001\u0001\u0015)\u0003\u0002\f!I\u0011\u0011\u0006\u0001A\u0002\u0013%\u00111\u0006\u0005\n\u0003\u000b\u0002\u0001\u0019!C\u0005\u0003\u000fB\u0001\"a\u0013\u0001A\u0003&\u0011Q\u0006\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0005\u0003#B\u0011\"!\u0017\u0001\u0001\u0004%I!a\u0017\t\u0011\u0005}\u0003\u0001)Q\u0005\u0003'B\u0011\"a\u0019\u0001\u0005\u0004%I!!\u001a\t\u0011\u0005E\u0004\u0001)A\u0005\u0003OB\u0011\"a\u001d\u0001\u0005\u0004%I!!\u001e\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003oB!\"!\"\u0001\u0005\u0004%\t\u0001SAD\u0011!\u0011Y\u0006\u0001Q\u0001\n\u0005%\u0005\"\u0003B/\u0001\u0001\u0007I\u0011BA\u0005\u0011%\u0011y\u0006\u0001a\u0001\n\u0013\u0011\t\u0007\u0003\u0005\u0003f\u0001\u0001\u000b\u0015BA\u0006\u0011%\u0011I\u0007\u0001b\u0001\n\u0013\t9\f\u0003\u0005\u0003l\u0001\u0001\u000b\u0011BA]\u0011%\u0011i\u0007\u0001b\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003x\u0001\u0001\u000b\u0011\u0002B9\u0011\u001d\u0011I\b\u0001C\u0001\u0005wB\u0001B!(\u0001\t\u0003A%q\u0014\u0005\t\u0005K\u0003A\u0011\u0001%\u0003(\"A!q\u0016\u0001\u0005\u0002!\u0013\t\f\u0003\u0005\u00036\u0002!\t\u0001\u0013B\\\u0011!\u0011i\f\u0001C\u0001\u0011\n}\u0006\u0002\u0003Bc\u0001\u0011\u0005\u0001Ja2\t\u000f\t5\u0007\u0001\"\u0001\u0003P\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqA!>\u0001\t\u0013\u00119\u0010C\u0004\u0003|\u0002!IA!@\t\u000f\r\u0005\u0001\u0001\"\u0003\u0004\u0004!911\u0002\u0001\u0005\n\r5\u0001bBB\u000b\u0001\u0011%1q\u0003\u0005\n\u0007O\u0001\u0011\u0013!C\u0005\u0007SAqaa\u0010\u0001\t\u0013\u0019\t\u0005C\u0005\u0004H\u0001\t\n\u0011\"\u0003\u0004*!91\u0011\n\u0001\u0005\n\r-\u0003bBB,\u0001\u0011%1\u0011\f\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\r\u0019\ty\t\u0001\u0001\u0002\u0012\"Q\u0011q\u0014\u001a\u0003\u0002\u0003\u0006I!a%\t\u0015\u0005\u0005&G!A!\u0002\u0013\tI\b\u0003\u0004}e\u0011\u0005\u00111\u0015\u0005\n\u0003S\u0013\u0004\u0019!C\u0005\u0003\u0013A\u0011\"a+3\u0001\u0004%I!!,\t\u0011\u0005E&\u0007)Q\u0005\u0003\u0017A!\"!.3\u0005\u0004%\t\u0001SA\\\u0011!\tyL\rQ\u0001\n\u0005e\u0006BCAae\t\u0007I\u0011\u0001%\u00028\"A\u00111\u0019\u001a!\u0002\u0013\tI\fC\u0004\u0002FJ\"\t!!\u0003\t\u000f\u0005\u001d'\u0007\"\u0011\u0002J\"9\u00111\u001a\u001a\u0005B\u00055\u0007b\u0002B\u0006e\u0011\u0005#Q\u0002\u0005\b\u0005+\u0011D\u0011\tB\f\u0011\u001d\u0011)C\rC!\u0005OAqA!\u000e3\t\u0003\u00119\u0004C\u0004\u0002FJ\"IA!\u000f\t\u000f\t\u001d#\u0007\"\u0003\u0003J!9!q\u000b\u001a\u0005\n\te#\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0015\tI%*A\u0004oKR<xN]6\u000b\u0003-\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u001dRS\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&AB!osJ+g\r\u0005\u0002V16\taK\u0003\u0002X\u0015\u0006)Q\u000f^5mg&\u0011\u0011L\u0016\u0002\b\u0019><w-\u001b8h!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003mC:<'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013Q\"Q;u_\u000ecwn]3bE2,\u0017AB2p]\u001aLw\r\u0005\u0002eO6\tQM\u0003\u0002g\u0015\u000611/\u001a:wKJL!\u0001[3\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002li6\tAN\u0003\u0002X[*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u0005-\u0003(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!\u001e7\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\tA(0D\u0001z\u0015\t1X.\u0003\u0002|s\n9Q*\u001a;sS\u000e\u001c\u0018A\u0002\u001fj]&$h\bF\u0004\u007f\u0003\u0003\t\u0019!!\u0002\u0011\u0005}\u0004Q\"\u0001%\t\u000b\t$\u0001\u0019A2\t\u000b%$\u0001\u0019\u00016\t\u000bY$\u0001\u0019A<\u00025\u0011,g-Y;mi6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139\u0016\u0005\u0005-\u0001cA(\u0002\u000e%\u0019\u0011q\u0002)\u0003\u0007%sG/\u0001\u0010eK\u001a\fW\u000f\u001c;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005o\u0018\u0013fcR!\u0011QCA\u000e!\ry\u0015qC\u0005\u0004\u00033\u0001&\u0001B+oSRD\u0011\"!\b\u0007\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\u000eeK\u001a\fW\u000f\u001c;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005\u000f\t\u0015\u0004\u000f\u0005\r\u0002cA(\u0002&%\u0019\u0011q\u0005)\u0003\u0011Y|G.\u0019;jY\u0016\fA$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7/\u0006\u0002\u0002.AA\u0011qFA\u001b\u0003s\tY!\u0004\u0002\u00022)\u0019\u00111\u0007)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u0005E\"aA'baB!\u00111HA!\u001b\t\tiDC\u0002\u0002@y\u000b1A\\3u\u0013\u0011\t\u0019%!\u0010\u0003\u0017%sW\r^!eIJ,7o]\u0001![\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n](wKJ\u0014\u0018\u000eZ3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005%\u0003\"CA\u000f\u0013\u0005\u0005\t\u0019AA\u0017\u0003ui\u0017\r_\"p]:,7\r^5p]N\u0004VM]%q\u001fZ,'O]5eKN\u0004\u0003f\u0001\u0006\u0002$\u0005!\"M]8lKJl\u0015\r_\"p]:,7\r^5p]N,\"!a\u0015\u0011\u0007m\u000b)&C\u0002\u0002Xq\u0013q!\u00138uK\u001e,'/\u0001\rce>\\WM]'bq\u000e{gN\\3di&|gn]0%KF$B!!\u0006\u0002^!I\u0011Q\u0004\u0007\u0002\u0002\u0003\u0007\u00111K\u0001\u0016EJ|7.\u001a:NCb\u001cuN\u001c8fGRLwN\\:!Q\ri\u00111E\u0001\u0007G>,h\u000e^:\u0016\u0005\u0005\u001d\u0004\u0003CA5\u0003_\nI$a\u0003\u000e\u0005\u0005-$\u0002BA7\u0003c\tq!\\;uC\ndW-\u0003\u0003\u00028\u0005-\u0014aB2pk:$8\u000fI\u0001\u000fY&\u001cH/\u001a8fe\u000e{WO\u001c;t+\t\t9\b\u0005\u0005\u0002j\u0005=\u0014\u0011PA\u0006!\u0011\tY(a \u000e\u0005\u0005u$BA%n\u0013\u0011\t\t)! \u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u001f1L7\u000f^3oKJ\u001cu.\u001e8ug\u0002\n\u0011$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0019&\u001cH/\u001a8feV\u0011\u0011\u0011\u0012\t\t\u0003S\ny'!\u001f\u0002\fB\u0019\u0011Q\u0012\u001a\u000e\u0003\u0001\u0011q\u0003T5ti\u0016tWM]\"p]:,7\r^5p]F+x\u000e^1\u0014\rI\n\u0019*!'[!\rY\u0016QS\u0005\u0004\u0003/c&AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002|\u0005m\u0015\u0002BAO\u0003{\u0012a\u0003T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0005Y>\u001c7.\u0001\u0005mSN$XM\\3s)\u0019\tY)!*\u0002(\"9\u0011qT\u001bA\u0002\u0005M\u0005bBAQk\u0001\u0007\u0011\u0011P\u0001\u0010?6\f\u0007pQ8o]\u0016\u001cG/[8og\u0006\u0019r,\\1y\u0007>tg.Z2uS>t7o\u0018\u0013fcR!\u0011QCAX\u0011%\tibNA\u0001\u0002\u0004\tY!\u0001\t`[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8tA!\u001a\u0001(a\t\u0002)\r|gN\\3di&|gNU1uKN+gn]8s+\t\tI\fE\u0002y\u0003wK1!!0z\u0005\u0019\u0019VM\\:pe\u0006)2m\u001c8oK\u000e$\u0018n\u001c8SCR,7+\u001a8t_J\u0004\u0013\u0001H2p]:,7\r^5p]J\u000bG/\u001a+ie>$H\u000f\\3TK:\u001cxN]\u0001\u001eG>tg.Z2uS>t'+\u0019;f)\"\u0014x\u000e\u001e;mKN+gn]8sA\u0005qQ.\u0019=D_:tWm\u0019;j_:\u001c\u0018\u0001\u00047jgR,g.\u001a:OC6,GCAA=\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u0003\u0002\u0016\u0005=\u0007bBAi\u007f\u0001\u0007\u00111[\u0001\bG>tg-[4ta\u0011\t).!?\u0011\u0011\u0005]\u0017Q\\Ap\u0003kl!!!7\u000b\u0007\u0005mg,\u0001\u0003vi&d\u0017\u0002BA\u001c\u00033\u0004B!!9\u0002p:!\u00111]Av!\r\t)\u000fU\u0007\u0003\u0003OT1!!;M\u0003\u0019a$o\\8u}%\u0019\u0011Q\u001e)\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t0a=\u0003\rM#(/\u001b8h\u0015\r\ti\u000f\u0015\t\u0005\u0003o\fI\u0010\u0004\u0001\u0005\u0019\u0005m\u0018qZA\u0001\u0002\u0003\u0015\t!!@\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0000\n\u0015\u0001cA(\u0003\u0002%\u0019!1\u0001)\u0003\u000f9{G\u000f[5oOB\u0019qJa\u0002\n\u0007\t%\u0001KA\u0002B]f\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0006\u0002\u0003\u0010A1\u0011q\u001bB\t\u0003?LAAa\u0005\u0002Z\n\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BA\u000b\u00053Aq!!5B\u0001\u0004\u0011Y\u0002\r\u0003\u0003\u001e\t\u0005\u0002\u0003CAl\u0003;\fyNa\b\u0011\t\u0005](\u0011\u0005\u0003\r\u0005G\u0011I\"!A\u0001\u0002\u000b\u0005\u0011Q \u0002\u0004?\u0012\u0012\u0014a\u0003:fG>tg-[4ve\u0016$B!!\u0006\u0003*!9\u0011\u0011\u001b\"A\u0002\t-\u0002\u0007\u0002B\u0017\u0005c\u0001\u0002\"a6\u0002^\u0006}'q\u0006\t\u0005\u0003o\u0014\t\u0004\u0002\u0007\u00034\t%\u0012\u0011!A\u0001\u0006\u0003\tiPA\u0002`IM\nQa\u00197pg\u0016$\"!!\u0006\u0015\t\u0005-!1\b\u0005\b\u0003#$\u0005\u0019\u0001B\u001fa\u0011\u0011yDa\u0011\u0011\u0011\u0005]\u0017Q\\Ap\u0005\u0003\u0002B!a>\u0003D\u0011a!Q\tB\u001e\u0003\u0003\u0005\tQ!\u0001\u0002~\n\u0019q\f\n\u001b\u000235\f\u0007pQ8o]\u0016\u001cG/[8o\u0007J,\u0017\r^5p]J\u000bG/\u001a\u000b\u0005\u0003\u0017\u0011Y\u0005C\u0004\u0002R\u0016\u0003\rA!\u00141\t\t=#1\u000b\t\t\u0003/\fi.a8\u0003RA!\u0011q\u001fB*\t1\u0011)Fa\u0013\u0002\u0002\u0003\u0005)\u0011AA\u007f\u0005\ryF%N\u0001#GJ,\u0017\r^3D_:tWm\u0019;j_:\u0014\u0016\r^3UQJ|G\u000f\u001e7f'\u0016t7o\u001c:\u0015\u0005\u0005e\u0016AG7bq\u000e{gN\\3di&|gn\u001d)fe2K7\u000f^3oKJ\u0004\u0013A\u0003;pi\u0006d7i\\;oi\u0006qAo\u001c;bY\u000e{WO\u001c;`I\u0015\fH\u0003BA\u000b\u0005GB\u0011\"!\b\u0016\u0003\u0003\u0005\r!a\u0003\u0002\u0017Q|G/\u00197D_VtG\u000f\t\u0015\u0004-\u0005\r\u0012A\u00072s_.,'oQ8o]\u0016\u001cG/[8o%\u0006$XmU3og>\u0014\u0018a\u00072s_.,'oQ8o]\u0016\u001cG/[8o%\u0006$XmU3og>\u0014\b%A\tnCb$\u0006N]8ui2,G+[7f\u001bN,\"A!\u001d\u0011\u0007=\u0013\u0019(C\u0002\u0003vA\u0013A\u0001T8oO\u0006\u0011R.\u0019=UQJ|G\u000f\u001e7f)&lW-T:!\u0003\rIgn\u0019\u000b\t\u0003+\u0011iHa \u0003\u0004\"9\u0011qY\u000eA\u0002\u0005e\u0004b\u0002BA7\u0001\u0007\u0011\u0011H\u0001\bC\u0012$'/Z:t\u0011\u001d\u0011)i\u0007a\u0001\u0005\u000f\u000b1$Y2dKB$xN\u001d\"m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014\b\u0003\u0002BE\u00053k!Aa#\u000b\t\t5%qR\u0001\u0005G>\u0014XMC\u0002w\u0005#SAAa%\u0003\u0016\u00061\u00110Y7nKJT!Aa&\u0002\u0007\r|W.\u0003\u0003\u0003\u001c\n-%!B'fi\u0016\u0014\u0018!G;qI\u0006$X-T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B$B!!\u0006\u0003\"\"9!1\u0015\u000fA\u0002\u0005-\u0011aE7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\u0018!I;qI\u0006$X-T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,G\u0003BA\u000b\u0005SCqAa+\u001e\u0001\u0004\u0011i+\u0001\bpm\u0016\u0014(/\u001b3f#V|G/Y:\u0011\u0011\u0005=\u0012QGAp\u0003\u0017\t!$\u001e9eCR,'I]8lKJl\u0015\r_\"p]:,7\r^5p]N$B!!\u0006\u00034\"9\u0011Q\u0019\u0010A\u0002\u0005-\u0011!H;qI\u0006$XM\u0011:pW\u0016\u0014X*\u0019=D_:tWm\u0019;j_:\u0014\u0016\r^3\u0015\t\u0005U!\u0011\u0018\u0005\b\u0005w{\u0002\u0019AA\u0006\u0003Ei\u0017\r_\"p]:,7\r^5p]J\u000bG/Z\u0001\fC\u0012$G*[:uK:,'\u000f\u0006\u0004\u0002\u0016\t\u0005'1\u0019\u0005\u0006E\u0002\u0002\ra\u0019\u0005\b\u0003\u000f\u0004\u0003\u0019AA=\u00039\u0011X-\\8wK2K7\u000f^3oKJ$b!!\u0006\u0003J\n-\u0007\"\u00022\"\u0001\u0004\u0019\u0007bBAdC\u0001\u0007\u0011\u0011P\u0001\u0004I\u0016\u001cGCBA\u000b\u0005#\u0014\u0019\u000eC\u0004\u0002H\n\u0002\r!!\u001f\t\u000f\t\u0005%\u00051\u0001\u0002:\u0005\u0019q-\u001a;\u0015\t\u0005-!\u0011\u001c\u0005\b\u0005\u0003\u001b\u0003\u0019AA\u001d\u0003U9\u0018-\u001b;G_J\u001cuN\u001c8fGRLwN\\*m_R$b!!\u0006\u0003`\n\u0005\bbBAdI\u0001\u0007\u0011\u0011\u0010\u0005\b\u0005\u000b#\u0003\u0019\u0001BD\u0003Yi\u0017\r_\"p]:,7\r^5p]N,\u0005pY3fI\u0016$G\u0003\u0002Bt\u0005[\u00042a\u0014Bu\u0013\r\u0011Y\u000f\u0015\u0002\b\u0005>|G.Z1o\u0011\u001d\t9-\na\u0001\u0003s\nqcY8o]\u0016\u001cG/[8o'2|G/\u0011<bS2\f'\r\\3\u0015\t\t\u001d(1\u001f\u0005\b\u0003\u000f4\u0003\u0019AA=\u0003E\u0001(o\u001c;fGR,G\rT5ti\u0016tWM\u001d\u000b\u0005\u0005O\u0014I\u0010C\u0004\u0002H\u001e\u0002\r!!\u001f\u0002-5\f\u0007\u0010T5ti\u0016tWM]\"p]:,7\r^5p]N$B!a\u0003\u0003\u0000\"9\u0011q\u0019\u0015A\u0002\u0005e\u0014\u0001\n:fG>\u0014HmQ8o]\u0016\u001cG/[8o\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\r\tE4QAB\u0004\u0011\u001d\t9-\u000ba\u0001\u0003sBqa!\u0003*\u0001\u0004\u0011\t(\u0001\u0004uS6,Wj]\u0001\u001be\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0007\u0003\u0017\u0019yaa\u0005\t\u000f\rE!\u00061\u0001\u0002:\u000611/\u001a8t_JDqa!\u0003+\u0001\u0004\u0011\t(A\u0010de\u0016\fG/Z\"p]:,7\r^5p]J\u000bG/Z)v_R\f7+\u001a8t_J$b!!/\u0004\u001a\ru\u0001bBB\u000eW\u0001\u0007\u00111B\u0001\u000bcV|G/\u0019'j[&$\b\"CB\u0010WA\u0005\t\u0019AB\u0011\u0003-a\u0017n\u001d;f]\u0016\u0014x\n\u001d;\u0011\u000b=\u001b\u0019#a8\n\u0007\r\u0015\u0002K\u0001\u0004PaRLwN\\\u0001*GJ,\u0017\r^3D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018mU3og>\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r-\"\u0006BB\u0011\u0007[Y#aa\f\u0011\t\rE21H\u0007\u0003\u0007gQAa!\u000e\u00048\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007s\u0001\u0016AC1o]>$\u0018\r^5p]&!1QHB\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001akB$\u0017\r^3D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018\r\u0006\u0004\u0002\u0016\r\r3Q\t\u0005\b\u00077i\u0003\u0019AA\u0006\u0011%\u0019y\"\fI\u0001\u0002\u0004\u0019\t#A\u0012va\u0012\fG/Z\"p]:,7\r^5p]J\u000bG/Z)v_R\fG\u0005Z3gCVdG\u000f\n\u001a\u00021\r|gN\\3di&|gNU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0004N\rU\u0003\u0003BB(\u0007#j\u0011!\\\u0005\u0004\u0007'j'AC'fiJL7MT1nK\"91qD\u0018A\u0002\r\u0005\u0012!\u0006:bi\u0016\fVo\u001c;b\u001b\u0016$(/[2D_:4\u0017n\u001a\u000b\u0005\u00077\u001a\t\u0007E\u0002y\u0007;J1aa\u0018z\u00051iU\r\u001e:jG\u000e{gNZ5h\u0011\u001d\u0019Y\u0002\ra\u0001\u0003\u0017\u0001")
public class ConnectionQuotas
implements Logging,
AutoCloseable {
    private final KafkaConfig config;
    private final Time time;
    public final Metrics kafka$network$ConnectionQuotas$$metrics;
    private volatile int defaultMaxConnectionsPerIp;
    private volatile Map<InetAddress, Object> maxConnectionsPerIpOverrides;
    private volatile Integer brokerMaxConnections;
    private final scala.collection.mutable.Map<InetAddress, Object> counts;
    private final scala.collection.mutable.Map<ListenerName, Object> listenerCounts;
    private final scala.collection.mutable.Map<ListenerName, ListenerConnectionQuota> maxConnectionsPerListener;
    private volatile int totalCount;
    private final Sensor brokerConnectionRateSensor;
    private final long maxThrottleTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int defaultMaxConnectionsPerIp() {
        return this.defaultMaxConnectionsPerIp;
    }

    private void defaultMaxConnectionsPerIp_$eq(int x$1) {
        this.defaultMaxConnectionsPerIp = x$1;
    }

    private Map<InetAddress, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private void maxConnectionsPerIpOverrides_$eq(Map<InetAddress, Object> x$1) {
        this.maxConnectionsPerIpOverrides = x$1;
    }

    private Integer brokerMaxConnections() {
        return this.brokerMaxConnections;
    }

    private void brokerMaxConnections_$eq(Integer x$1) {
        this.brokerMaxConnections = x$1;
    }

    private scala.collection.mutable.Map<InetAddress, Object> counts() {
        return this.counts;
    }

    private scala.collection.mutable.Map<ListenerName, Object> listenerCounts() {
        return this.listenerCounts;
    }

    public scala.collection.mutable.Map<ListenerName, ListenerConnectionQuota> maxConnectionsPerListener() {
        return this.maxConnectionsPerListener;
    }

    private int totalCount() {
        return this.totalCount;
    }

    private void totalCount_$eq(int x$1) {
        this.totalCount = x$1;
    }

    private Sensor brokerConnectionRateSensor() {
        return this.brokerConnectionRateSensor;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public void inc(ListenerName listenerName, InetAddress address, Meter acceptorBlockedPercentMeter) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int max;
            this.waitForConnectionSlot(listenerName, acceptorBlockedPercentMeter);
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElseUpdate((Object)address, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            this.counts().put((Object)address, (Object)(count + 1));
            this.totalCount_$eq(this.totalCount() + 1);
            if (this.listenerCounts().contains((Object)listenerName)) {
                this.listenerCounts().put((Object)listenerName, (Object)(BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName)) + 1));
            }
            if (count >= (max = BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerIpOverrides().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & Serializable)() -> this.defaultMaxConnectionsPerIp())))) {
                throw new TooManyConnectionsException(address, max);
            }
            return;
        }
    }

    public void updateMaxConnectionsPerIp(int maxConnectionsPerIp) {
        this.defaultMaxConnectionsPerIp_$eq(maxConnectionsPerIp);
    }

    public void updateMaxConnectionsPerIpOverride(Map<String, Object> overrideQuotas) {
        this.maxConnectionsPerIpOverrides_$eq((Map<InetAddress, Object>)((Map)overrideQuotas.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String host = (String)x0$1._1();
            int count = x0$1._2$mcI$sp();
            Tuple2 tuple2 = new Tuple2((Object)InetAddress.getByName(host), (Object)count);
            return tuple2;
        })));
    }

    public void updateBrokerMaxConnections(int maxConnections) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            this.brokerMaxConnections_$eq(maxConnections);
            this.counts().notifyAll();
            return;
        }
    }

    public void updateBrokerMaxConnectionRate(int maxConnectionRate) {
        this.kafka$network$ConnectionQuotas$$updateConnectionRateQuota(maxConnectionRate, (Option<String>)None$.MODULE$);
    }

    public void addListener(KafkaConfig config, ListenerName listenerName) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            if (!this.maxConnectionsPerListener().contains((Object)listenerName)) {
                ListenerConnectionQuota newListenerQuota = new ListenerConnectionQuota(this, this.counts(), listenerName);
                this.maxConnectionsPerListener().put((Object)listenerName, (Object)newListenerQuota);
                this.listenerCounts().put((Object)listenerName, (Object)0);
                config.addReconfigurable((Reconfigurable)newListenerQuota);
                newListenerQuota.configure(config.valuesWithPrefixOverride(listenerName.configPrefix()));
            }
            this.counts().notifyAll();
            return;
        }
    }

    public void removeListener(KafkaConfig config, ListenerName listenerName) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            Option option = this.maxConnectionsPerListener().remove((Object)listenerName);
            if (option == null) {
                throw null;
            }
            Option foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ListenerConnectionQuota listenerConnectionQuota = (ListenerConnectionQuota)foreach_this.get();
                ConnectionQuotas.$anonfun$removeListener$1(this, listenerName, config, listenerConnectionQuota);
            }
            return;
        }
    }

    public void dec(ListenerName listenerName, InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int count = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(81).append("Attempted to decrease connection count for address with no connections, address: ").append(address).toString());
            }));
            if (count == 1) {
                this.counts().remove((Object)address);
            } else {
                this.counts().put((Object)address, (Object)(count - 1));
            }
            if (this.totalCount() <= 0) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Attempted to decrease total connection count for broker with no connections");
            }
            this.totalCount_$eq(this.totalCount() - 1);
            if (this.maxConnectionsPerListener().contains((Object)listenerName)) {
                int listenerCount = BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName));
                if (listenerCount == 0) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Attempted to decrease connection count for listener ").append(listenerName).append(" with no connections").toString());
                } else {
                    this.listenerCounts().put((Object)listenerName, (Object)(listenerCount - 1));
                }
            }
            this.counts().notifyAll();
            return;
        }
    }

    public int get(InetAddress address) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            int n = BoxesRunTime.unboxToInt((Object)this.counts().getOrElse((Object)address, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            return n;
        }
    }

    private void waitForConnectionSlot(ListenerName listenerName, Meter acceptorBlockedPercentMeter) {
        scala.collection.mutable.Map<InetAddress, Object> map = this.counts();
        synchronized (map) {
            long startThrottleTimeMs = this.time.milliseconds();
            long l = Math.max(this.recordConnectionAndGetThrottleTimeMs(listenerName, startThrottleTimeMs), 0L);
            if (l > 0L || !this.connectionSlotAvailable(listenerName)) {
                long startNs = this.time.nanoseconds();
                long endThrottleTimeMs = startThrottleTimeMs + l;
                long remainingThrottleTimeMs = l;
                do {
                    this.counts().wait(remainingThrottleTimeMs);
                } while ((remainingThrottleTimeMs = Math.max(endThrottleTimeMs - this.time.milliseconds(), 0L)) > 0L || !this.connectionSlotAvailable(listenerName));
                acceptorBlockedPercentMeter.mark(this.time.nanoseconds() - startNs);
            }
            return;
        }
    }

    public boolean maxConnectionsExceeded(ListenerName listenerName) {
        return this.totalCount() > BoxesRunTime.unboxToInt((Object)this.brokerMaxConnections()) && !this.protectedListener(listenerName);
    }

    private boolean connectionSlotAvailable(ListenerName listenerName) {
        if (BoxesRunTime.unboxToInt((Object)this.listenerCounts().apply((Object)listenerName)) >= this.maxListenerConnections(listenerName)) {
            return false;
        }
        if (this.protectedListener(listenerName)) {
            return true;
        }
        return this.totalCount() < BoxesRunTime.unboxToInt((Object)this.brokerMaxConnections());
    }

    private boolean protectedListener(ListenerName listenerName) {
        ListenerName listenerName2 = this.config.interBrokerListenerName();
        if (!(listenerName2 != null ? !listenerName2.equals(listenerName) : listenerName != null)) {
            Seq<EndPoint> seq = this.config.listeners();
            if (seq == null) {
                throw null;
            }
            if (seq.length() > 1) {
                return true;
            }
        }
        return false;
    }

    private int maxListenerConnections(ListenerName listenerName) {
        Object object;
        Option option = this.maxConnectionsPerListener().get((Object)listenerName);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((ListenerConnectionQuota)map_this.get()).maxConnections());
        None$ none$ = object2;
        Object var2_2 = null;
        object2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            Integer n;
            Integer n2 = n = Integer.valueOf(Integer.MAX_VALUE);
            n = null;
            object = n2;
        } else {
            object = getOrElse_this.get();
        }
        Object object3 = object;
        Object var4_4 = null;
        object = null;
        return BoxesRunTime.unboxToInt((Object)object3);
    }

    private long recordConnectionAndGetThrottleTimeMs(ListenerName listenerName, long timeMs) {
        if (this.protectedListener(listenerName)) {
            return this.recordAndGetListenerThrottleTime$1(0, listenerName, timeMs);
        }
        int brokerThrottleTimeMs = this.recordAndGetThrottleTimeMs(this.brokerConnectionRateSensor(), timeMs);
        return this.recordAndGetListenerThrottleTime$1(brokerThrottleTimeMs, listenerName, timeMs);
    }

    private int recordAndGetThrottleTimeMs(Sensor sensor, long timeMs) {
        try {
            sensor.record(1.0, timeMs);
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Quota violated for sensor (").append(sensor.name()).append("). Delay time: ").append(throttleTimeMs).append(" ms").toString());
            return throttleTimeMs;
        }
    }

    public Sensor kafka$network$ConnectionQuotas$$createConnectionRateQuotaSensor(int quotaLimit, Option<String> listenerOpt) {
        Object object;
        if (listenerOpt == null) {
            throw null;
        }
        Object object2 = listenerOpt.isEmpty() ? None$.MODULE$ : new Some((Object)ConnectionQuotas.$anonfun$createConnectionRateQuotaSensor$1((String)listenerOpt.get()));
        None$ none$ = object2;
        object2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            String string;
            String string2 = string = "ConnectionAcceptRate";
            string = null;
            object = string2;
        } else {
            object = getOrElse_this.get();
        }
        Object object3 = object;
        Object var6_4 = null;
        object = null;
        String sensorName = (String)object3;
        Sensor sensor = this.kafka$network$ConnectionQuotas$$metrics.sensor(sensorName, this.rateQuotaMetricConfig(quotaLimit), new Sensor[0]);
        sensor.add(this.connectionRateMetricName(listenerOpt), (MeasurableStat)new Rate(), null);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Created ").append(sensorName).append(" sensor, quotaLimit=").append(quotaLimit).toString());
        return sensor;
    }

    private Option<String> createConnectionRateQuotaSensor$default$2() {
        return None$.MODULE$;
    }

    public void kafka$network$ConnectionQuotas$$updateConnectionRateQuota(int quotaLimit, Option<String> listenerOpt) {
        this.kafka$network$ConnectionQuotas$$metrics.metric(this.connectionRateMetricName(listenerOpt)).config(this.rateQuotaMetricConfig(quotaLimit));
        this.info((Function0<String>)(Function0 & Serializable)() -> {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(41).append("Updated ");
            if (listenerOpt.isEmpty()) {
                String string;
                String string2 = string = "broker-wide";
                string = null;
                object = string2;
            } else {
                object = listenerOpt.get();
            }
            Object object2 = object;
            object = null;
            return stringBuilder.append(object2).append(" max connection creation rate to ").append(quotaLimit).toString();
        });
    }

    private Option<String> updateConnectionRateQuota$default$2() {
        return None$.MODULE$;
    }

    private MetricName connectionRateMetricName(Option<String> listenerOpt) {
        Object object;
        None$ none$;
        Object object2;
        if (listenerOpt == null) {
            throw null;
        }
        Object object3 = listenerOpt.isEmpty() ? None$.MODULE$ : new Some((Object)ConnectionQuotas.$anonfun$connectionRateMetricName$1((String)listenerOpt.get()));
        None$ none$2 = object3;
        object3 = null;
        None$ getOrElse_this = none$2;
        if (getOrElse_this.isEmpty()) {
            Map map;
            Map map2 = map = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            map = null;
            object2 = map2;
        } else {
            object2 = getOrElse_this.get();
        }
        Object object4 = object2;
        Object var5_3 = null;
        object2 = null;
        Map tags = (Map)object4;
        if (listenerOpt.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String cfr_ignored_0 = (String)listenerOpt.get();
            none$ = new Some((Object)"");
        }
        None$ none$3 = none$;
        none$ = null;
        None$ getOrElse_this2 = none$3;
        if (getOrElse_this2.isEmpty()) {
            String string;
            String string2 = string = "broker-";
            string = null;
            object = string2;
        } else {
            object = getOrElse_this2.get();
        }
        Object object5 = object;
        Object var8_8 = null;
        object = null;
        String namePrefix = (String)object5;
        return this.kafka$network$ConnectionQuotas$$metrics.metricName(new StringBuilder(22).append(namePrefix).append("connection-accept-rate").toString(), SocketServer$.MODULE$.MetricsGroup(), "Tracking rate of accepting new connections (per second)", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)tags).asJava());
    }

    private MetricConfig rateQuotaMetricConfig(int quotaLimit) {
        return new MetricConfig().timeWindow((long)BoxesRunTime.unboxToInt((Object)this.config.quotaWindowSizeSeconds()), TimeUnit.SECONDS).samples(BoxesRunTime.unboxToInt((Object)this.config.numQuotaSamples())).quota(new Quota((double)quotaLimit, true));
    }

    @Override
    public void close() {
        this.kafka$network$ConnectionQuotas$$metrics.removeSensor("ConnectionAcceptRate");
        this.maxConnectionsPerListener().values().foreach((Function1 & Serializable)x$22 -> {
            x$22.close();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeListener$1(ConnectionQuotas $this, ListenerName listenerName$3, KafkaConfig config$1, ListenerConnectionQuota listenerQuota) {
        $this.listenerCounts().remove((Object)listenerName$3);
        listenerQuota.close();
        $this.counts().notifyAll();
        config$1.removeReconfigurable((Reconfigurable)listenerQuota);
    }

    public static final /* synthetic */ int $anonfun$maxListenerConnections$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ int $anonfun$recordConnectionAndGetThrottleTimeMs$1(ConnectionQuotas $this, long timeMs$1, int minThrottleTimeMs$1, ListenerConnectionQuota listenerQuota) {
        int listenerThrottleTimeMs = $this.recordAndGetThrottleTimeMs(listenerQuota.connectionRateSensor(), timeMs$1);
        int n = Math.max(minThrottleTimeMs$1, listenerThrottleTimeMs);
        if (n > 0) {
            listenerQuota.connectionRateThrottleSensor().record((double)n, timeMs$1);
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$recordConnectionAndGetThrottleTimeMs$2() {
        return 0;
    }

    private final int recordAndGetListenerThrottleTime$1(int minThrottleTimeMs, ListenerName listenerName$5, long timeMs$1) {
        Object object;
        None$ none$;
        Option option = this.maxConnectionsPerListener().get((Object)listenerName$5);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ListenerConnectionQuota listenerConnectionQuota = (ListenerConnectionQuota)map_this.get();
            none$ = new Some((Object)ConnectionQuotas.$anonfun$recordConnectionAndGetThrottleTimeMs$1(this, timeMs$1, minThrottleTimeMs, listenerConnectionQuota));
        }
        None$ none$2 = none$;
        Object var5_4 = null;
        none$ = null;
        None$ getOrElse_this = none$2;
        if (getOrElse_this.isEmpty()) {
            Integer n;
            Integer n2 = n = Integer.valueOf(0);
            n = null;
            object = n2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var7_7 = null;
        object = null;
        return BoxesRunTime.unboxToInt((Object)object2);
    }

    public static final /* synthetic */ String $anonfun$createConnectionRateQuotaSensor$1(String listener) {
        return new StringBuilder(21).append("ConnectionAcceptRate-").append(listener).toString();
    }

    public static final /* synthetic */ String $anonfun$createConnectionRateQuotaSensor$2() {
        return "ConnectionAcceptRate";
    }

    public static final /* synthetic */ String $anonfun$updateConnectionRateQuota$2() {
        return "broker-wide";
    }

    public static final /* synthetic */ Map $anonfun$connectionRateMetricName$1(String listener) {
        String string;
        Object[] objectArray = new Tuple2[1];
        String string2 = string = "listener";
        string = null;
        String $minus$greater$extension_$this = string2;
        Object var1_2 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)listener);
        return (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static final /* synthetic */ Map $anonfun$connectionRateMetricName$2() {
        return (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$connectionRateMetricName$3(String x$21) {
        return "";
    }

    public static final /* synthetic */ String $anonfun$connectionRateMetricName$4() {
        return "broker-";
    }

    public ConnectionQuotas(KafkaConfig config, Time time, Metrics metrics) {
        this.config = config;
        this.time = time;
        this.kafka$network$ConnectionQuotas$$metrics = metrics;
        this.defaultMaxConnectionsPerIp = BoxesRunTime.unboxToInt((Object)config.maxConnectionsPerIp());
        this.maxConnectionsPerIpOverrides = (Map)config.maxConnectionsPerIpOverrides().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String host = (String)x0$1._1();
            int count = x0$1._2$mcI$sp();
            Tuple2 tuple2 = new Tuple2((Object)InetAddress.getByName(host), (Object)count);
            return tuple2;
        });
        this.brokerMaxConnections = config.maxConnections();
        this.counts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.listenerCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.maxConnectionsPerListener = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.totalCount = 0;
        this.brokerConnectionRateSensor = this.kafka$network$ConnectionQuotas$$createConnectionRateQuotaSensor(BoxesRunTime.unboxToInt((Object)config.maxConnectionCreationRate()), (Option<String>)None$.MODULE$);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(BoxesRunTime.unboxToInt((Object)config.quotaWindowSizeSeconds()));
    }

    public static final /* synthetic */ Object $anonfun$removeListener$1$adapted(ConnectionQuotas $this, ListenerName listenerName$3, KafkaConfig config$1, ListenerConnectionQuota listenerQuota) {
        ConnectionQuotas.$anonfun$removeListener$1($this, listenerName$3, config$1, listenerQuota);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maxListenerConnections$1$adapted(ListenerConnectionQuota x$20) {
        return BoxesRunTime.boxToInteger((int)x$20.maxConnections());
    }

    public static final /* synthetic */ Object $anonfun$recordConnectionAndGetThrottleTimeMs$1$adapted(ConnectionQuotas $this, long timeMs$1, int minThrottleTimeMs$1, ListenerConnectionQuota listenerQuota) {
        return BoxesRunTime.boxToInteger((int)ConnectionQuotas.$anonfun$recordConnectionAndGetThrottleTimeMs$1($this, timeMs$1, minThrottleTimeMs$1, listenerQuota));
    }

    public class ListenerConnectionQuota
    implements ListenerReconfigurable,
    AutoCloseable {
        private final Object lock;
        private final ListenerName listener;
        private volatile int _maxConnections;
        private final Sensor connectionRateSensor;
        private final Sensor connectionRateThrottleSensor;
        public final /* synthetic */ ConnectionQuotas $outer;

        private int _maxConnections() {
            return this._maxConnections;
        }

        private void _maxConnections_$eq(int x$1) {
            this._maxConnections = x$1;
        }

        public Sensor connectionRateSensor() {
            return this.connectionRateSensor;
        }

        public Sensor connectionRateThrottleSensor() {
            return this.connectionRateThrottleSensor;
        }

        public int maxConnections() {
            return this._maxConnections();
        }

        public ListenerName listenerName() {
            return this.listener;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this._maxConnections_$eq(this.maxConnections(configs));
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$updateConnectionRateQuota(this.maxConnectionCreationRate(configs), (Option<String>)new Some((Object)this.listener.value()));
        }

        public Set<String> reconfigurableConfigs() {
            return AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, SocketServer$.MODULE$.ListenerReconfigurableConfigs()).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
            int value = this.maxConnections(configs);
            if (value <= 0) {
                throw new ConfigException(new StringBuilder(9).append("Invalid ").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).append(" ").append(value).toString());
            }
            int rate = this.maxConnectionCreationRate(configs);
            if (rate <= 0) {
                throw new ConfigException(new StringBuilder(9).append("Invalid ").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).append(" ").append(rate).toString());
            }
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            Object object = this.lock;
            synchronized (object) {
                this._maxConnections_$eq(this.maxConnections(configs));
                this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$updateConnectionRateQuota(this.maxConnectionCreationRate(configs), (Option<String>)new Some((Object)this.listener.value()));
                this.lock.notifyAll();
                return;
            }
        }

        @Override
        public void close() {
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.removeSensor(this.connectionRateSensor().name());
            this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.removeSensor(this.connectionRateThrottleSensor().name());
        }

        private int maxConnections(java.util.Map<String, ?> configs) {
            Object object;
            Option option = Option$.MODULE$.apply(configs.get(KafkaConfig$.MODULE$.MaxConnectionsProp()));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ListenerConnectionQuota.$anonfun$maxConnections$1(map_this.get()));
            None$ none$ = object2;
            Object var2_2 = null;
            object2 = null;
            None$ getOrElse_this = none$;
            if (getOrElse_this.isEmpty()) {
                Integer n;
                Integer n2 = n = Integer.valueOf(Integer.MAX_VALUE);
                n = null;
                object = n2;
            } else {
                object = getOrElse_this.get();
            }
            Object object3 = object;
            Object var4_4 = null;
            object = null;
            return BoxesRunTime.unboxToInt((Object)object3);
        }

        private int maxConnectionCreationRate(java.util.Map<String, ?> configs) {
            Object object;
            Option option = Option$.MODULE$.apply(configs.get(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ListenerConnectionQuota.$anonfun$maxConnectionCreationRate$1(map_this.get()));
            None$ none$ = object2;
            Object var2_2 = null;
            object2 = null;
            None$ getOrElse_this = none$;
            if (getOrElse_this.isEmpty()) {
                Integer n;
                Integer n2 = n = Integer.valueOf(Integer.MAX_VALUE);
                n = null;
                object = n2;
            } else {
                object = getOrElse_this.get();
            }
            Object object3 = object;
            Object var4_4 = null;
            object = null;
            return BoxesRunTime.unboxToInt((Object)object3);
        }

        /*
         * WARNING - void declaration
         */
        private Sensor createConnectionRateThrottleSensor() {
            void var1_1;
            void add_stat;
            void $minus$greater$extension_y;
            Sensor sensor = this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.sensor(new StringBuilder(27).append("ConnectionRateThrottleTime-").append(this.listener.value()).toString());
            Object[] objectArray = new Tuple2[1];
            String string = this.listener.value();
            String $minus$greater$extension_$this = Processor$.MODULE$.ListenerMetricTag();
            Object var3_3 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            MetricName metricName = this.kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer().kafka$network$ConnectionQuotas$$metrics.metricName("connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), "Tracking average throttle-time, out of non-zero throttle times, per listener", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava());
            Avg avg = new Avg();
            if (sensor == null) {
                throw null;
            }
            sensor.add(metricName, (MeasurableStat)add_stat, null);
            return var1_1;
        }

        public /* synthetic */ ConnectionQuotas kafka$network$ConnectionQuotas$ListenerConnectionQuota$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ int $anonfun$maxConnections$1(Object x$23) {
            return Integer.parseInt(x$23.toString());
        }

        public static final /* synthetic */ int $anonfun$maxConnections$2() {
            return Integer.MAX_VALUE;
        }

        public static final /* synthetic */ int $anonfun$maxConnectionCreationRate$1(Object x$24) {
            return Integer.parseInt(x$24.toString());
        }

        public static final /* synthetic */ int $anonfun$maxConnectionCreationRate$2() {
            return Integer.MAX_VALUE;
        }

        public ListenerConnectionQuota(ConnectionQuotas $outer, Object lock, ListenerName listener) {
            this.lock = lock;
            this.listener = listener;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this._maxConnections = Integer.MAX_VALUE;
            this.connectionRateSensor = $outer.kafka$network$ConnectionQuotas$$createConnectionRateQuotaSensor(Integer.MAX_VALUE, (Option<String>)new Some((Object)listener.value()));
            this.connectionRateThrottleSensor = this.createConnectionRateThrottleSensor();
        }

        public static final /* synthetic */ Object $anonfun$maxConnections$1$adapted(Object x$23) {
            return BoxesRunTime.boxToInteger((int)ListenerConnectionQuota.$anonfun$maxConnections$1(x$23));
        }

        public static final /* synthetic */ Object $anonfun$maxConnectionCreationRate$1$adapted(Object x$24) {
            return BoxesRunTime.boxToInteger((int)ListenerConnectionQuota.$anonfun$maxConnectionCreationRate$1(x$24));
        }
    }
}

