/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.server.StrictControllerMutationQuota;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t2Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\t\t3\u000b\u001e:jGR\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rV3ti*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0011\u0005M\u0001Q\"\u0001\u0003\u0002IQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b-&|G.\u0019;j_:$\u0012A\u0006\t\u0003\u0017]I!\u0001\u0007\u0007\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b")
public class StrictControllerMutationQuotaTest {
    @Test
    public void testControllerMutationQuotaViolation() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor", new MetricConfig().quota(Quota.upperBound((double)10.0)).timeWindow(1L, TimeUnit.SECONDS).samples(10), new Sensor[0]);
        MetricName metricName = metrics.metricName("rate", "test-group");
        Assert.assertTrue((boolean)sensor.add(metricName, (MeasurableStat)new TokenBucket()));
        StrictControllerMutationQuota quota = new StrictControllerMutationQuota((Time)time, sensor);
        Assert.assertFalse((boolean)quota.isExceeded());
        quota.record(90.0);
        Assert.assertFalse((boolean)quota.isExceeded());
        Assert.assertEquals((long)0L, (long)quota.throttleTime());
        quota.record(90.0);
        Assert.assertFalse((boolean)quota.isExceeded());
        Assert.assertEquals((long)0L, (long)quota.throttleTime());
        Assert.assertThrows(ThrottlingQuotaExceededException.class, () -> quota.record(90.0));
        Assert.assertTrue((boolean)quota.isExceeded());
        Assert.assertEquals((long)8000L, (long)quota.throttleTime());
        time.sleep(5000L);
        Assert.assertEquals((long)3000L, (long)quota.throttleTime());
        metrics.close();
    }
}

