/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.server.PermissiveControllerMutationQuota;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t2Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\t)\u0003+\u001a:nSN\u001c\u0018N^3D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCR+7\u000f\u001e\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\n\u0001\u001b\u0005!\u0011\u0001\n;fgR\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018MV5pY\u0006$\u0018n\u001c8\u0015\u0003Y\u0001\"aC\f\n\u0005aa!\u0001B+oSRD#A\u0001\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t!A+Z:u\u0001")
public class PermissiveControllerMutationQuotaTest {
    @Test
    public void testControllerMutationQuotaViolation() {
        MockTime time = new MockTime(0L, System.currentTimeMillis(), 0L);
        Metrics metrics = new Metrics((Time)time);
        Sensor sensor = metrics.sensor("sensor", new MetricConfig().quota(Quota.upperBound((double)10.0)).timeWindow(1L, TimeUnit.SECONDS).samples(10), new Sensor[0]);
        MetricName metricName = metrics.metricName("rate", "test-group");
        Assert.assertTrue((boolean)sensor.add(metricName, (MeasurableStat)new TokenBucket()));
        PermissiveControllerMutationQuota quota = new PermissiveControllerMutationQuota((Time)time, sensor);
        Assert.assertFalse((boolean)quota.isExceeded());
        quota.record(90.0);
        Assert.assertFalse((boolean)quota.isExceeded());
        Assert.assertEquals((long)0L, (long)quota.throttleTime());
        quota.record(90.0);
        Assert.assertFalse((boolean)quota.isExceeded());
        Assert.assertEquals((long)8000L, (long)quota.throttleTime());
        quota.record(90.0);
        Assert.assertFalse((boolean)quota.isExceeded());
        Assert.assertEquals((long)17000L, (long)quota.throttleTime());
        time.sleep(5000L);
        Assert.assertEquals((long)12000L, (long)quota.throttleTime());
        metrics.close();
    }
}

