/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.cluster.EndPoint;
import kafka.coordinator.group.OffsetConfig$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUw!B\u001f?\u0011\u0003\u0019e!B#?\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005bB(\u0002\u0005\u0004%\t\u0001\u0015\u0005\u00073\u0006\u0001\u000b\u0011B)\t\u000fi\u000b!\u0019!C\u0001!\"11,\u0001Q\u0001\nECq\u0001X\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004^\u0003\u0001\u0006I!\u0015\u0005\b=\u0006\u0011\r\u0011\"\u0001Q\u0011\u0019y\u0016\u0001)A\u0005#\"9\u0001-\u0001b\u0001\n\u0003\u0001\u0006BB1\u0002A\u0003%\u0011\u000bC\u0004c\u0003\t\u0007I\u0011\u0001)\t\r\r\f\u0001\u0015!\u0003R\r\u0015)e(!\u0001e\u0011\u0015iu\u0002\"\u0001r\u0011\u001d\u0019xB1A\u0005\nQDaa_\b!\u0002\u0013)\bb\u0002?\u0010\u0005\u0004%I! \u0005\b\u0003'y\u0001\u0015!\u0003\u007f\u0011%\t)b\u0004b\u0001\n\u0013\t9\u0002\u0003\u0005\u0003\u0002=\u0001\u000b\u0011BA\r\u0011%\u0011\u0019a\u0004b\u0001\n\u0013\u0011)\u0001\u0003\u0005\u0003\u0016=\u0001\u000b\u0011\u0002B\u0004\u0011!\u00119b\u0004b\u0001\n#\u0001\u0006b\u0002B\r\u001f\u0001\u0006I!\u0015\u0005\n\u00057y!\u0019!C\t\u0005;A\u0001Ba\f\u0010A\u0003%!q\u0004\u0005\b\u0005cya\u0011\u0003B\u001a\u0011\u001d\u0011\tf\u0004D\t\u0005'BqA!\u0019\u0010\t\u0003\u0012\u0019\u0007C\u0004\u0003z=!\tEa\u0019\t\u000f\t\ru\u0002\"\u0001\u0003d!9!QR\b\u0005\u0012\t=eABA\u0012\u001f\u0001\u000b)\u0003\u0003\u0006\u00024\r\u0012)\u001a!C\u0001\u0003kA!\"!\u0015$\u0005#\u0005\u000b\u0011BA\u001c\u0011)\t\u0019f\tBK\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u0003W\u001a#\u0011#Q\u0001\n\u0005]\u0003BCA7G\tU\r\u0011\"\u0001\u0002V!Q\u0011qN\u0012\u0003\u0012\u0003\u0006I!a\u0016\t\r5\u001bC\u0011AA9\u0011\u001d\tIh\tC!\u0003wBq!a!$\t\u0003\n)\tC\u0004\u0002\u0018\u000e\"\t%!'\t\u0013\u0005m5%!A\u0005\u0002\u0005u\u0005\"CASGE\u0005I\u0011AAT\u0011%\tilII\u0001\n\u0003\ty\fC\u0005\u0002D\u000e\n\n\u0011\"\u0001\u0002@\"A\u0011QY\u0012\u0002\u0002\u0013\u0005\u0003\u000bC\u0005\u0002H\u000e\n\t\u0011\"\u0001\u0002J\"I\u00111Z\u0012\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003'\u001c\u0013\u0011!C!\u0003+D\u0011\"a8$\u0003\u0003%\t!!9\b\u0013\t\u0005v\"!A\t\u0002\t\rf!CA\u0012\u001f\u0005\u0005\t\u0012\u0001BS\u0011\u0019i\u0005\b\"\u0001\u00034\"I\u0011q\u0013\u001d\u0002\u0002\u0013\u0015#Q\u0017\u0005\n\u0005oC\u0014\u0011!CA\u0005sC\u0011B!19\u0003\u0003%\tIa1\u0002c5+H\u000e^5qY\u0016d\u0015n\u001d;f]\u0016\u00148oV5uQN\u000bW.Z*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0005\u0006\u001cX\rV3ti*\u0011q\bQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002E\u00035\taHA\u0019Nk2$\u0018\u000e\u001d7f\u0019&\u001cH/\u001a8feN<\u0016\u000e\u001e5TC6,7+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\"bg\u0016$Vm\u001d;\u0014\u0005\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007\u0006q1+Z2ve\u0016Le\u000e^3s]\u0006dW#A)\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001\u00027b]\u001eT\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n11\u000b\u001e:j]\u001e\fqbU3dkJ,\u0017J\u001c;fe:\fG\u000eI\u0001\u000f'\u0016\u001cWO]3FqR,'O\\1m\u0003=\u0019VmY;sK\u0016CH/\u001a:oC2\u0004\u0013\u0001C%oi\u0016\u0014h.\u00197\u0002\u0013%sG/\u001a:oC2\u0004\u0013\u0001C#yi\u0016\u0014h.\u00197\u0002\u0013\u0015CH/\u001a:oC2\u0004\u0013AB$tg\u0006\u0003\u0018.A\u0004HgN\f\u0005/\u001b\u0011\u0002\u000bAc\u0017-\u001b8\u0002\rAc\u0017-\u001b8!'\ryQm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0002\u000b!A_6\n\u0005)<'\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002m_6\tQN\u0003\u0002o\u0001\u0006\u0019\u0011\r]5\n\u0005Al'!C*bg2\u001cV\r^;q)\u0005\u0011\bC\u0001#\u0010\u00039!(/^:u'R|'/\u001a$jY\u0016,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003qV\u000b!![8\n\u0005i<(\u0001\u0002$jY\u0016\fq\u0002\u001e:vgR\u001cFo\u001c:f\r&dW\rI\u0001\bg\u0016\u0014h/\u001a:t+\u0005q\b#B@\u0002\n\u00055QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u000f5,H/\u00192mK*\u0019\u0011qA%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0005\u0005!aC!se\u0006L()\u001e4gKJ\u00042\u0001RA\b\u0013\r\t\tB\u0010\u0002\f\u0017\u000647.Y*feZ,'/\u0001\u0005tKJ4XM]:!\u0003%\u0001(o\u001c3vG\u0016\u00148/\u0006\u0002\u0002\u001aA9q0a\u0007\u0002 \u0005\u0015\u0018\u0002BA\u000f\u0003\u0003\u00111!T1q!\r\t\tcI\u0007\u0002\u001f\tq1\t\\5f]RlU\r^1eCR\f7CB\u0012H\u0003O\ti\u0003E\u0002I\u0003SI1!a\u000bJ\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001SA\u0018\u0013\r\t\t$\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003o\u0001B!!\u000f\u0002N5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0004oKR<xN]6\u000b\t\u0005\u0005\u00131I\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005\u000b)E\u0003\u0003\u0002H\u0005%\u0013AB1qC\u000eDWM\u0003\u0002\u0002L\u0005\u0019qN]4\n\t\u0005=\u00131\b\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\u001bM\f7\u000f\\'fG\"\fg.[:n+\t\t9\u0006\u0005\u0003\u0002Z\u0005\u001dd\u0002BA.\u0003G\u00022!!\u0018J\u001b\t\tyFC\u0002\u0002b\t\u000ba\u0001\u0010:p_Rt\u0014bAA3\u0013\u00061\u0001K]3eK\u001aL1\u0001WA5\u0015\r\t)'S\u0001\u000fg\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dAQA\u0011qDA:\u0003k\n9\bC\u0004\u00024)\u0002\r!a\u000e\t\u000f\u0005M#\u00061\u0001\u0002X!9\u0011Q\u000e\u0016A\u0002\u0005]\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0004c\u0001%\u0002\u0000%\u0019\u0011\u0011Q%\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000bi\tE\u0002I\u0003\u0013K1!a#J\u0005\u001d\u0011un\u001c7fC:Dq!a$-\u0001\u0004\t\t*A\u0002pE*\u00042\u0001SAJ\u0013\r\t)*\u0013\u0002\u0004\u0003:L\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0013\u0001B2paf$\u0002\"a\b\u0002 \u0006\u0005\u00161\u0015\u0005\n\u0003gq\u0003\u0013!a\u0001\u0003oA\u0011\"a\u0015/!\u0003\u0005\r!a\u0016\t\u0013\u00055d\u0006%AA\u0002\u0005]\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SSC!a\u000e\u0002,.\u0012\u0011Q\u0016\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003%)hn\u00195fG.,GMC\u0002\u00028&\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY,!-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005'\u0006BA,\u0003W\u000babY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0012\u0006=\u0007\"CAii\u0005\u0005\t\u0019AA?\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001b\t\u0007\u00033\fY.!%\u000e\u0005\u0005\u0015\u0011\u0002BAo\u0003\u000b\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qQAr\u0011%\t\tNNA\u0001\u0002\u0004\t\t\n\u0005\u0005\u0002h\u0006E\u0018Q_A{\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018\u0001\u00039s_\u0012,8-\u001a:\u000b\t\u0005=\u00181I\u0001\bG2LWM\u001c;t\u0013\u0011\t\u00190!;\u0003\u001b-\u000bgm[1Qe>$WoY3s!\u0015A\u0015q_A~\u0013\r\tI0\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0011\u0006u\u0018bAA\u0000\u0013\n!!)\u001f;f\u0003)\u0001(o\u001c3vG\u0016\u00148\u000fI\u0001\nG>t7/^7feN,\"Aa\u0002\u0011\u000f}\fY\"a\b\u0003\nAA!1\u0002B\t\u0003k\f)0\u0004\u0002\u0003\u000e)!!qBAw\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002\u0002B\n\u0005\u001b\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018AC2p]N,X.\u001a:tA\u0005A2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000eI\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/\u0006\u0002\u0003 A9!\u0011\u0005B\u0014#\n%RB\u0001B\u0012\u0015\u0011\u0011)#!\u0002\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA\u000f\u0005G\u0001R!!7\u0003,EKAA!\f\u0002\u0006\t\u00191+Z9\u00025-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn\u001d\u0011\u0002%M$\u0018\r^5d\u0015\u0006\f7oU3di&|gn]\u000b\u0003\u0005k\u0001b!!7\u0003,\t]\u0002\u0003\u0002B\u001d\u0005\u0017rAAa\u000f\u0003F9!!Q\bB!\u001d\u0011\tiFa\u0010\n\u0003\u0005K1Aa\u0011A\u0003\u0015)H/\u001b7t\u0013\u0011\u00119E!\u0013\u0002\u001b)\u000b\u0017m\u001d+fgR,F/\u001b7t\u0015\r\u0011\u0019\u0005Q\u0005\u0005\u0005\u001b\u0012yEA\u0006KC\u0006\u001c8+Z2uS>t'\u0002\u0002B$\u0005\u0013\n1\u0003Z=oC6L7MS1bgN+7\r^5p]N,\"A!\u0016\u0011\t\t]#QL\u0007\u0003\u00053R1Aa\u0017V\u0003\u0011)H/\u001b7\n\t\t}#\u0011\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!B:fiV\u0003HC\u0001B3!\rA%qM\u0005\u0004\u0005SJ%\u0001B+oSRD3a\bB7!\u0011\u0011yG!\u001e\u000e\u0005\tE$\u0002\u0002B:\u0003\u0013\nQA[;oSRLAAa\u001e\u0003r\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004A\tu\u0004\u0003\u0002B8\u0005\u007fJAA!!\u0003r\t)\u0011I\u001a;fe\u0006\u0011B/Z:u!J|G-^2f\u0007>t7/^7fQ\r\t#q\u0011\t\u0005\u0005_\u0012I)\u0003\u0003\u0003\f\nE$\u0001\u0002+fgR\fQ#\u00193e\tft\u0017-\\5d\u0015\u0006\f7oU3di&|g\u000e\u0006\u0006\u0003f\tE%Q\u0013BM\u0005;CqAa%#\u0001\u0004\u0011)&A\u0003qe>\u00048\u000fC\u0004\u0003\u0018\n\u0002\r!a\u0016\u0002\u00111L7\u000f^3oKJDqAa'#\u0001\u0004\t9&A\u0005nK\u000eD\u0017M\\5t[\"9!q\u0014\u0012A\u0002\t]\u0012a\u00036bCN\u001cVm\u0019;j_:\fab\u00117jK:$X*\u001a;bI\u0006$\u0018\rE\u0002\u0002\"a\u001aR\u0001\u000fBT\u0003[\u0001BB!+\u00030\u0006]\u0012qKA,\u0003?i!Aa+\u000b\u0007\t5\u0016*A\u0004sk:$\u0018.\\3\n\t\tE&1\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001BR)\u0005\t\u0016!B1qa2LH\u0003CA\u0010\u0005w\u0013iLa0\t\u000f\u0005M2\b1\u0001\u00028!9\u00111K\u001eA\u0002\u0005]\u0003bBA7w\u0001\u0007\u0011qK\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)M!5\u0011\u000b!\u00139Ma3\n\u0007\t%\u0017J\u0001\u0004PaRLwN\u001c\t\n\u0011\n5\u0017qGA,\u0003/J1Aa4J\u0005\u0019!V\u000f\u001d7fg!I!1\u001b\u001f\u0002\u0002\u0003\u0007\u0011qD\u0001\u0004q\u0012\u0002\u0004")
public abstract class MultipleListenersWithSameSecurityProtocolBaseTest
extends ZooKeeperTestHarness
implements SaslSetup {
    private volatile MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata$module;
    private final File trustStoreFile;
    private final ArrayBuffer<KafkaServer> servers;
    private final Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers;
    private final Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers;
    private final String kafkaClientSaslMechanism;
    private final scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    public static String Plain() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
    }

    public static String GssApi() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi();
    }

    public static String External() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External();
    }

    public static String Internal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal();
    }

    public static String SecureExternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal();
    }

    public static String SecureInternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal();
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata() {
        if (this.ClientMetadata$module == null) {
            this.ClientMetadata$lzycompute$1();
        }
        return this.ClientMetadata$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private File trustStoreFile() {
        return this.trustStoreFile;
    }

    private ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    private Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private Map<ClientMetadata, KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public abstract Seq<JaasTestUtils.JaasSection> staticJaasSections();

    public abstract Properties dynamicJaasSections();

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.staticJaasSections());
        super.setUp();
        int numServers = 2;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numServers);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$1(this, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        ((ResizableArray)this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.config(), ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)config -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$4(config);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), "__consumer_offsets", OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions(), 2, (Seq<KafkaServer>)this.servers(), ((KafkaServer)this.servers().head()).groupCoordinator().offsetsTopicConfigs());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramUser(), JaasTestUtils$.MODULE$.KafkaScramPassword());
        ((KafkaServer)this.servers().head()).config().listeners().foreach((Function1 & Serializable & scala.Serializable)endPoint -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$5(this, endPoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @After
    public void tearDown() {
        this.producers().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.consumers().values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsume() {
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void map_bf;
            void map_f;
            Range.Inclusive inclusive;
            KafkaProducer producer;
            ClientMetadata clientMetadata;
            if (x0$1 != null) {
                clientMetadata = (ClientMetadata)x0$1._1();
                producer = (KafkaProducer)x0$1._2();
                int n = 1;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                inclusive = RichInt$.MODULE$.to$extension0(n, 10);
                CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$testProduceConsume$2(clientMetadata, BoxesRunTime.unboxToInt((Object)i));
                if (inclusive == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            IndexedSeq producerRecords = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
            ((TraversableLike)producerRecords.map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
            KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply((Object)clientMetadata);
            consumer.subscribe(Collections.singleton(clientMetadata.topic()));
            Seq seq = TestUtils$.MODULE$.consumeRecords(consumer, producerRecords.size(), TestUtils$.MODULE$.consumeRecords$default$3());
            return seq;
        });
    }

    public void addDynamicJaasSection(Properties props, String listener, String mechanism, JaasTestUtils.JaasSection jaasSection) {
        String prefix = new ListenerName(listener).saslMechanismConfigPrefix(mechanism);
        String jaasConfig = ((JaasTestUtils.JaasModule)jaasSection.modules().head()).toString();
        props.put(new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.SaslJaasConfigProp()).toString(), jaasConfig);
    }

    private final void ClientMetadata$lzycompute$1() {
        synchronized (this) {
            if (this.ClientMetadata$module == null) {
                this.ClientMetadata$module = new MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$1(MultipleListenersWithSameSecurityProtocolBaseTest $this, int brokerId) {
        String x$2 = $this.zkConnect();
        Some x$3 = new Some((Object)$this.trustStoreFile());
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, x$6, x$7, (Option<File>)x$3, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(62).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append("://localhost:0, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append("://localhost:0").toString());
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(43).append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).append(":SASL_SSL,").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External()).append(":PLAINTEXT, ").append(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).append(":SASL_SSL").toString());
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal());
        props.put(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        props.put(KafkaConfig$.MODULE$.SaslMechanismInterBrokerProtocolProp(), $this.kafkaClientSaslMechanism());
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal())).mkString(","));
        props.put(new StringBuilder(0).append(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).configPrefix()).append(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp()).toString(), ((TraversableOnce)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal())).mkString(","));
        props.put(KafkaConfig$.MODULE$.SaslKerberosServiceNameProp(), "kafka");
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq($this.dynamicJaasSections());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(TestUtils$.MODULE$.sslConfigs(Mode.SERVER, false, (Option<File>)new Some((Object)$this.trustStoreFile()), new StringBuilder(6).append("server").append(brokerId).toString(), TestUtils$.MODULE$.sslConfigs$default$5(), TestUtils$.MODULE$.sslConfigs$default$6()));
        new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal(), (List)new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)listenerName -> props.put(new StringBuilder(21).append(new ListenerName(listenerName).configPrefix()).append("ssl.keystore.location").toString(), props.get("ssl.keystore.location")));
        props.put("ssl.keystore.location", "invalid/file/path");
        return $this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    public static final /* synthetic */ void $anonfun$setUp$4(KafkaConfig config) {
        Assert.assertEquals((String)new StringBuilder(37).append("Unexpected listener count for broker ").append(config.brokerId()).toString(), (long)4L, (long)config.listeners().size());
        Assert.assertEquals((String)new StringBuilder(23).append("Unexpected ").append(KafkaConfig$.MODULE$.InterBrokerListenerNameProp()).append(" for broker ").append(config.brokerId()).toString(), (Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal(), (Object)config.interBrokerListenerName().value());
    }

    private final void addProducerConsumer$1(ListenerName listenerName, String mechanism, Option saslProps, String bootstrapServers$1, EndPoint endPoint$1, Option trustStoreFile$1) {
        String topic = new StringBuilder(0).append(listenerName.value()).append(this.producers().size()).toString();
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ClientMetadata clientMetadata = new ClientMetadata(this, listenerName, mechanism, topic);
        int x$2 = -1;
        SecurityProtocol x$3 = endPoint$1.securityProtocol();
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$7();
        int x$11 = TestUtils$.MODULE$.createProducer$default$8();
        String x$12 = TestUtils$.MODULE$.createProducer$default$9();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producers().update((Object)clientMetadata, TestUtils$.MODULE$.createProducer(bootstrapServers$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$3, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProps, x$14, x$15, x$16));
        String x$18 = clientMetadata.toString();
        SecurityProtocol x$19 = endPoint$1.securityProtocol();
        String x$22 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$23 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$24 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$25 = TestUtils$.MODULE$.createConsumer$default$6();
        ByteArrayDeserializer x$26 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$27 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumers().update((Object)clientMetadata, TestUtils$.MODULE$.createConsumer(bootstrapServers$1, x$18, x$22, x$23, x$24, x$25, x$19, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProps, x$26, x$27));
    }

    public static final /* synthetic */ void $anonfun$setUp$5(MultipleListenersWithSameSecurityProtocolBaseTest $this, EndPoint endPoint) {
        ListenerName listenerName = endPoint.listenerName();
        None$ trustStoreFile = TestUtils$.MODULE$.usesSslTransportLayer(endPoint.securityProtocol()) ? new Some((Object)$this.trustStoreFile()) : None$.MODULE$;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)$this.servers(), listenerName);
        if (TestUtils$.MODULE$.usesSaslAuthentication(endPoint.securityProtocol())) {
            ((IterableLike)$this.kafkaServerSaslMechanisms().apply((Object)endPoint.listenerName().value())).foreach(arg_0 -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$6$adapted($this, listenerName, bootstrapServers, endPoint, (Option)trustStoreFile, arg_0));
            return;
        }
        $this.addProducerConsumer$1(listenerName, "", (Option)None$.MODULE$, bootstrapServers, endPoint, (Option)trustStoreFile);
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testProduceConsume$2(ClientMetadata clientMetadata$1, int i) {
        return new ProducerRecord(clientMetadata$1.topic(), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public MultipleListenersWithSameSecurityProtocolBaseTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        SaslSetup.$init$(this);
        this.trustStoreFile = File.createTempFile("truststore", ".jks");
        this.servers = new ArrayBuffer();
        this.producers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafkaClientSaslMechanism = MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
        Tuple2[] tuple2Array = new Tuple2[2];
        .colon.colon colon2 = new .colon.colon((Object)"SCRAM-SHA-256", (List)new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi(), (List)Nil$.MODULE$));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        .colon.colon colon3 = new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain(), (List)new .colon.colon((Object)"SCRAM-SHA-512", (List)Nil$.MODULE$));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.kafkaServerSaslMechanisms = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$1$adapted(MultipleListenersWithSameSecurityProtocolBaseTest $this, Object brokerId) {
        return MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$1($this, BoxesRunTime.unboxToInt((Object)brokerId));
    }

    public static final /* synthetic */ Object $anonfun$setUp$6$adapted(MultipleListenersWithSameSecurityProtocolBaseTest $this, ListenerName listenerName$1, String bootstrapServers$1, EndPoint endPoint$1, Option trustStoreFile$1, String mechanism) {
        $this.addProducerConsumer$1(listenerName$1, mechanism, (Option)new Some((Object)$this.kafkaClientSaslProperties(mechanism, true)), bootstrapServers$1, endPoint$1, trustStoreFile$1);
        return BoxedUnit.UNIT;
    }

    public class ClientMetadata
    implements Product,
    scala.Serializable {
        private final ListenerName listenerName;
        private final String saslMechanism;
        private final String topic;
        public final /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest $outer;

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public String saslMechanism() {
            return this.saslMechanism;
        }

        public String topic() {
            return this.topic;
        }

        public int hashCode() {
            return Objects.hash(this.listenerName(), this.saslMechanism());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ClientMetadata)) return false;
            if (((ClientMetadata)obj).kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() != this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer()) return false;
            ClientMetadata clientMetadata = (ClientMetadata)obj;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = clientMetadata.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            String string = this.saslMechanism();
            String string2 = clientMetadata.saslMechanism();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.topic();
            String string4 = clientMetadata.topic();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return new StringBuilder(2).append(this.listenerName().value()).append(":").append(this.saslMechanism()).append(":").append(this.topic()).toString();
        }

        public ClientMetadata copy(ListenerName listenerName, String saslMechanism, String topic) {
            return new ClientMetadata(this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer(), listenerName, saslMechanism, topic);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public String copy$default$2() {
            return this.saslMechanism();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public String productPrefix() {
            return "ClientMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.saslMechanism();
                }
                case 2: {
                    return this.topic();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClientMetadata;
        }

        public /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() {
            return this.$outer;
        }

        public ClientMetadata(MultipleListenersWithSameSecurityProtocolBaseTest $outer, ListenerName listenerName, String saslMechanism, String topic) {
            this.listenerName = listenerName;
            this.saslMechanism = saslMechanism;
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

