/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.NotRunning$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQ!\u000e\u0001\u0005BYBQ\u0001\u0011\u0001\u0005\u0002YBQ!\u0012\u0001\u0005\u0002YBQa\u0012\u0001\u0005\u0002YBQ!\u0013\u0001\u0005\u0002YBQa\u0013\u0001\u0005\u0002YBQ!\u0014\u0001\u0005\u0002YBQa\u0014\u0001\u0005\u0002YBQ!\u0015\u0001\u0005\u0002YBQa\u0015\u0001\u0005\u0002YBQ!\u0016\u0001\u0005\u0002YBQa\u0016\u0001\u0005\u0002YBQ!\u0017\u0001\u0005\u0002iCa!a\u0001\u0001\t\u00031\u0004BBA\u0004\u0001\u0011\u0005a\u0007\u0003\u0004\u0002\f\u0001!\tA\u000e\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011%\ty\u0004AI\u0001\n\u0013\t\tEA\nNKR\fG-\u0019;b%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u00181\u000511/\u001a:wKJT\u0011!G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001e=5\ta#\u0003\u0002 -\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u0011Q\u0004A\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\t\u0001\r!L\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!B:fiV\u0003H#A\u0013)\u0005\rA\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0015QWO\\5u\u0015\u0005i\u0014aA8sO&\u0011qH\u000f\u0002\u0007\u0005\u00164wN]3\u0002AQ,7\u000f^\"mkN$XM]%e/&$\bNU3rk\u0016\u001cHOV3sg&|g.\r\u0015\u0003\t\t\u0003\"!O\"\n\u0005\u0011S$\u0001\u0002+fgR\fA\u0003^3ti\u000ecWo\u001d;fe&#\u0017j\u001d,bY&$\u0007FA\u0003C\u0003A!Xm\u001d;D_:$(o\u001c7mKJLE\r\u000b\u0002\u0007\u0005\u0006AA/Z:u%\u0006\u001c7\u000e\u000b\u0002\b\u0005\u0006qA/Z:u\u0013NLe\u000e^3s]\u0006d\u0007F\u0001\u0005C\u0003M!Xm\u001d;O_R{\u0007/[2t%\u0016\fX/Z:uQ\tI!)A\u000buKN$\u0018)\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u0005)\u0011\u0015a\f;fgR\fU\u000f^8De\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014\bFA\u0006C\u0003}!Xm\u001d;BkR|7I]3bi\u0016|emQ8mY&$\u0017N\\4U_BL7m\u001d\u0015\u0003\u0019\t\u000bA\u0003^3ti\u0006cG\u000eV8qS\u000e\u001c(+Z9vKN$\bFA\u0007C\u0003Q!Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\"\u0012aBQ\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\rF\u0002\\Mr\u0004\"\u0001\u00183\u000e\u0003uS!AX0\u0002\u000f5,7o]1hK*\u0011\u0001-Y\u0001\u0007G>lWn\u001c8\u000b\u0005e\u0011'BA2=\u0003\u0019\t\u0007/Y2iK&\u0011Q-\u0018\u0002\u0014\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\u0006O>\u0001\r\u0001[\u0001\u0007i>\u0004\u0018nY:\u0011\u0007%\fHO\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011QNG\u0001\u0007yI|w\u000e\u001e \n\u0003!J!\u0001]\u0014\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002qOA\u0011Q/\u001f\b\u0003m^\u0004\"a[\u0014\n\u0005a<\u0013A\u0002)sK\u0012,g-\u0003\u0002{w\n11\u000b\u001e:j]\u001eT!\u0001_\u0014\t\u000bu|\u0001\u0019\u0001@\u0002-\u0005dGn\\<BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:\u0004\"AJ@\n\u0007\u0005\u0005qEA\u0004C_>dW-\u00198\u0002/Q,7\u000f\u001e*fa2L7-\u0019#po:\u0014Vm\u001d9p]N,\u0007F\u0001\tC\u0003\u0019\"Xm\u001d;JgJ\fe\r^3s\u0005J|7.\u001a:TQV$Hi\\<o\u0003:$'j\\5og\n\u000b7m\u001b\u0015\u0003#\t\u000bA\u0004^3ti\u0006c\u0017N^3Ce>\\WM]:XSRDgj\u001c+pa&\u001c7\u000f\u000b\u0002\u0013\u0005\u0006\u00192/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR1\u00111CA\u0010\u0003S\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033y\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005u\u0011q\u0003\u0002\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016Dq!!\t\u0014\u0001\u0004\t\u0019#A\u0004sKF,Xm\u001d;\u0011\t\u0005U\u0011QE\u0005\u0005\u0003O\t9BA\bNKR\fG-\u0019;b%\u0016\fX/Z:u\u0011%\tYc\u0005I\u0001\u0002\u0004\ti#A\u0006eKN$\u0018N\\1uS>t\u0007#\u0002\u0014\u00020\u0005M\u0012bAA\u0019O\t1q\n\u001d;j_:\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0012a\u00028fi^|'o[\u0005\u0005\u0003{\t9D\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u000ftK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019E\u000b\u0003\u0002.\u0005\u00153FAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Es%\u0001\u0006b]:|G/\u0019;j_:LA!!\u0016\u0002L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class MetadataRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @Before
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        String v1ClusterId = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId();
        Assert.assertNull((String)"v1 clusterId should be null", (Object)v1ClusterId);
    }

    @Test
    public void testClusterIdIsValid() {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2()).clusterId());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertEquals((String)"Controller id should match the active controller", (long)controllerId, (long)metadataResponse.controller().id());
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assert.assertNotEquals((String)"Controller id should switch to a new broker", (long)controllerId, (long)controllerId2);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testControllerId$3(this, controllerServer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(MetadataRequestTest.$anonfun$testControllerId$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRack() {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assert.assertEquals((String)"Rack information should match config", (Object)new StringBuilder(5).append("rack/").append(broker.id()).toString(), (Object)broker.rack()));
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Iterable topicMetadata = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assert.assertTrue((String)"internalTopic should show isInternal", (boolean)internalTopicMetadata.isInternal());
        Assert.assertFalse((String)"notInternalTopic topic not should show isInternal", (boolean)notInternalTopicMetadata.isInternal());
        Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)1).build(), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Assert.assertTrue((String)"Response should have no topics", (boolean)metadataResponse.topicMetadata().isEmpty());
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assert.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic$1(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic3, response2);
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("MetadataRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assert.assertEquals((long)0L, (long)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate_Topic";
        String topic2 = "testAutoCreate.Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)2L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        MetadataResponse.TopicMetadata topicMetadata2 = (MetadataResponse.TopicMetadata)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).toSeq().apply(1);
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata1.topic());
        Assert.assertEquals((Object)Errors.INVALID_TOPIC_EXCEPTION, (Object)topicMetadata2.error());
        Assert.assertEquals((Object)topic2, (Object)topicMetadata2.topic());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic1, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic1, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.error, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)1L, (long)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((long)2L, (long)partitionMetadata.replicaIds.size());
        Assert.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assert.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V0 Response should have no errors", (boolean)metadataResponseV0.errors().isEmpty());
        Assert.assertEquals((String)"V0 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV0.topicMetadata().size());
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V1 Response should have no errors", (boolean)metadataResponseV1.errors().isEmpty());
        Assert.assertEquals((String)"V1 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV1.topicMetadata().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplica() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.createTopic("t1", (Map<Object, Seq<Object>>)replicaAssignment);
        new .colon.colon((Object)this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer())), (List)new .colon.colon((Object)this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer())), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$1(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public MetadataRequestData requestData(List<String> topics, boolean allowAutoTopicCreation) {
        void var3_3;
        MetadataRequestData data = new MetadataRequestData();
        if (topics == null) {
            data.setTopics(null);
        } else {
            List foreach_these = topics;
            while (!foreach_these.isEmpty()) {
                String string = (String)foreach_these.head();
                MetadataRequestTest.$anonfun$requestData$1(data, string);
                foreach_these = (List)foreach_these.tail();
            }
        }
        data.setAllowAutoTopicCreation(allowAutoTopicCreation);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, server))).get();
        downNode.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(MetadataRequestTest.$anonfun$testReplicaDownResponse$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$), true), (short)0), this.sendMetadataRequest$default$2());
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v0MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)"The downed broker should not be in the brokers list", (boolean)v0BrokerIds.contains((Object)downNode));
        Assert.assertTrue((String)"Response should have one topic", (v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0);
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assert.assertTrue((String)"PartitionMetadata should have an error", (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(30).append("Response should have ").append(replicaCount - 1).append(" replicas").toString(), (v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0);
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v1MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)"The downed broker should not be in the brokers list", (boolean)v1BrokerIds.contains((Object)downNode));
        Assert.assertEquals((String)"Response should have one topic", (long)1L, (long)v1MetadataResponse.topicMetadata().size());
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assert.assertEquals((String)"PartitionMetadata should have no errors", (Object)Errors.NONE, (Object)v1PartitionMetadata.error);
        Assert.assertEquals((String)new StringBuilder(30).append("Response should have ").append(replicaCount).append(" replicas").toString(), (long)replicaCount, (long)v1PartitionMetadata.replicaIds.size());
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4());
        ((KafkaServer)this.servers().last()).shutdown();
        ((KafkaServer)this.servers().last()).awaitShutdown();
        ((KafkaServer)this.servers().last()).startup();
        this.checkIsr$1((Seq)this.servers(), topic);
    }

    @Test
    public void testAliveBrokersWithNoTopics() {
        KafkaServer serverToShutdown = (KafkaServer)((TraversableLike)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$11(x$20)))).last();
        serverToShutdown.shutdown();
        serverToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size() - 1);
        serverToShutdown.startup();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        if (destination == null) {
            throw null;
        }
        Object object = destination.isEmpty() ? this.anySocketServer() : destination.get();
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)object, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$3(MetadataRequestTest $this, KafkaServer controllerServer2$1) {
        MetadataResponse metadataResponse2 = $this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), $this.sendMetadataRequest$default$2());
        return metadataResponse2.controller() != null && controllerServer2$1.dataPlaneRequestProcessor().brokerId() == metadataResponse2.controller().id();
    }

    public static final /* synthetic */ String $anonfun$testControllerId$4() {
        return "Controller id should match the active controller after failover";
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    private final void checkAutoCreatedTopic$1(String autoCreatedTopic, MetadataResponse response) {
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assert.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions()));
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), autoCreatedTopic, foreach_i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$1(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assert.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.partition()), Buffer$.MODULE$.canBuildFrom())).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assert.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaIds).asScala());
            Assert.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.inSyncReplicaIds).asScala());
            Assert.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$requestData$1(MetadataRequestData data$1, String topic) {
        return data$1.topics().add(new MetadataRequestData.MetadataRequestTopic().setName(topic));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaServer server) {
        int serverId = server.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaServer downNode$1, Node x$9) {
        return x$9.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaServer downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replicaDownTopic$1, (List)Nil$.MODULE$)).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaServer x$12) {
        return x$12.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ Option $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$5(MetadataResponse.TopicMetadata x$14) {
        return ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$14.partitionMetadata()).asScala()).headOption();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$6(MetadataResponse.PartitionMetadata partitionMetadata) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.inSyncReplicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$8() {
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaServer broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option option = ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).headOption();
        if (option == null) {
            throw null;
        }
        Option flatMap_this = option;
        Object object = flatMap_this.isEmpty() ? None$.MODULE$ : MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$5((MetadataResponse.TopicMetadata)flatMap_this.get());
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$6((MetadataResponse.PartitionMetadata)object.get()));
        if (object2 == null) {
            throw null;
        }
        Object object3 = object2.isEmpty() ? MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$8() : object2.get();
        actualIsr$1.elem = object3;
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaServer broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return new StringBuilder(77).append("Topic metadata not updated correctly in broker ").append(broker$1).append("\n").append("Expected ISR: ").append(expectedIsr$1).append(" \n").append("Actual ISR : ").append((scala.collection.immutable.Set)actualIsr$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaServer broker) {
        ObjectRef actualIsr = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4($this, topic$1, broker, actualIsr, expectedIsr$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(broker, expectedIsr$1, actualIsr), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private final void checkIsr$1(Seq servers, String topic) {
        Seq activeBrokers = (Seq)servers.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$12)));
        scala.collection.immutable.Set expectedIsr = ((TraversableOnce)activeBrokers.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$13)), Seq$.MODULE$.canBuildFrom())).toSet();
        activeBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef controllerMetadataResponse$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.controllerSocketServer()));
        controllerMetadataResponse$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef controllerMetadataResponse$1) {
        return new StringBuilder(61).append("Expected ").append(expectedBrokersCount$1).append(" brokers, but there are ").append(((MetadataResponse)((Option)controllerMetadataResponse$1.elem).get()).brokers().size()).append(" ").append("according to the Controller").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaServer x$16) {
        return x$16.brokerState().currentState() != NotRunning$.MODULE$.state();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaServer broker$2, Seq brokersInController$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        Seq brokers = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), (Ordering)Ordering.Int$.MODULE$);
        Seq topicMetadata = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$18 -> x$18.topic(), (Ordering)Ordering.String$.MODULE$);
        Seq seq = brokersInController$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$19 -> x$19.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, Seq brokersInController$1, KafkaServer broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersInController$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$10(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMetadata$1(Seq servers, int expectedBrokersCount) {
        ObjectRef controllerMetadataResponse = ObjectRef.create((Object)None$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$1(this, controllerMetadataResponse, expectedBrokersCount)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$2(expectedBrokersCount, controllerMetadataResponse), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Seq brokersInController = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)((Option)controllerMetadataResponse.elem).get()).brokers()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$16)))).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersInController, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$11(KafkaServer x$20) {
        return x$20.kafkaController().isActive();
    }

    public static final /* synthetic */ Object $anonfun$requestData$1$adapted(MetadataRequestData data$1, String topic) {
        return BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$requestData$1(data$1, topic));
    }
}

