/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetRequestData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}A\u0001\"\t\u0001\t\u0006\u0004%IA\t\u0005\u0006S\u0001!\tE\u000b\u0005\u0006c\u0001!\tF\r\u0005\u0006k\u0001!\tF\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006/\u0002!\t!\u0012\u0005\u00065\u0002!\t!\u0012\u0005\u00069\u0002!\t!\u0012\u0005\u0006=\u0002!\t!\u0012\u0005\u0006G\u0002!\t!\u0012\u0005\u0006M\u0002!\t!\u0012\u0005\u0006Q\u0002!\t!\u0012\u0005\u0006+\u0001!IA\u001b\u0005\u0006]\u0002!Ia\u001c\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\u001f\u0001\t\u0013\tiHA\u0007M_\u001e|eMZ:fiR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011\u0001F\u0005\u0003;Q\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\tQLW.Z\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011aEF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012\u0001\"T8dWRKW.Z\u0001\fEJ|7.\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\u000bEJ|7.\u001a:US6,GCA\u00124\u0011\u0015!D\u00011\u0001,\u0003!\u0011'o\\6fe&#\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t9$\b\u0005\u0002-q%\u0011\u0011(\f\u0002\u0005+:LG\u000fC\u0003<\u000b\u0001\u0007A(A\u0003qe>\u00048\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\u0015A\u0013x\u000e]3si&,7/A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5d)\u00059\u0004F\u0001\u0004H!\tAU*D\u0001J\u0015\tQ5*A\u0003kk:LGOC\u0001M\u0003\ry'oZ\u0005\u0003\u001d&\u0013A\u0001V3ti\"\"a\u0001U*V!\ta\u0013+\u0003\u0002S[\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0003Q\u000bQ\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u00022\u0006'I\u0001W\u0003\u0001\t\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u0012qa\u0012\u0015\u0005\u000fA\u001bV+\u0001\u0010uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a'bi\u0016\u001cH\u000fV5nK\"\u0012\u0001bR\u0001\u0018i\u0016\u001cH/R7qifdunZ:HKR|eMZ:fiND#!C$\u0002/Q,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u001d><\bF\u0001\u0006HQ\u0011Q\u0001+Y+\"\u0003\t\f\u0001\u0004\\3hC\u000eLh)\u001a;dQ>3gm]3ug\n+gm\u001c:f\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK\u0016\u000b'\u000f\\5fgR$\u0016.\\3)\u0005-9\u0005\u0006B\u0006QCV\u000bQ\u0006^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:CK\u001a|'/Z,ji\"\u001c\u0005.\u00198hS:<7+Z4nK:$8+\u001b>fQ\taq)\u0001\u0016uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^:)\u000559U#A6\u0011\u0005ma\u0017BA7\u0015\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002-M,g\u000e\u001a'jgR|eMZ:fiN\u0014V-];fgR$\"\u0001]>\u0011\u0005ELX\"\u0001:\u000b\u0005M$\u0018\u0001\u0003:fcV,7\u000f^:\u000b\u0005U4\u0018AB2p[6|gN\u0003\u0002\u0018o*\u0011\u0001pS\u0001\u0007CB\f7\r[3\n\u0005i\u0014(A\u0005'jgR|eMZ:fiJ+7\u000f]8og\u0016DQ\u0001`\bA\u0002u\fqA]3rk\u0016\u001cH\u000f\u0005\u0002r}&\u0011qP\u001d\u0002\u0012\u0019&\u001cHo\u00144gg\u0016$(+Z9vKN$\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0011\t)!a\u0006\u0011\u000bE\f9!a\u0003\n\u0007\u0005%!OA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003;\u0002\rI,7m\u001c:e\u0013\u0011\t)\"a\u0004\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0019a\b\u00031\u0001\u0002\u001aA\u0019\u0011/a\u0007\n\u0007\u0005u!O\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\tck&dG\rV1sO\u0016$H+[7fgRA\u00111EA1\u0003[\n9\b\u0005\u0004\u0002&\u0005U\u00121\b\b\u0005\u0003O\t\tD\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003G\u0001\u0007yI|w\u000e\u001e \n\u00039J1!a\r.\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\t!A*[:u\u0015\r\t\u0019$\f\t\u0005\u0003{\tYF\u0004\u0003\u0002@\u0005Uc\u0002BA!\u0003#rA!a\u0011\u0002P9!\u0011QIA'\u001d\u0011\t9%a\u0013\u000f\t\u0005%\u0012\u0011J\u0005\u0002\u0019&\u0011\u0001pS\u0005\u0003/]L!!\u001e<\n\u0007\u0005MC/A\u0004nKN\u001c\u0018mZ3\n\t\u0005]\u0013\u0011L\u0001\u0016\u0019&\u001cHo\u00144gg\u0016$(+Z9vKN$H)\u0019;b\u0015\r\t\u0019\u0006^\u0005\u0005\u0003;\nyFA\bMSN$xJ\u001a4tKR$v\u000e]5d\u0015\u0011\t9&!\u0017\t\u000f\u0005\r\u0014\u00031\u0001\u0002f\u0005\u0011A\u000f\u001d\t\u0005\u0003O\nI'D\u0001u\u0013\r\tY\u0007\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ty'\u0005a\u0001\u0003c\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u00071\n\u0019(C\u0002\u0002v5\u0012A\u0001T8oO\"1\u0011\u0011P\tA\u0002-\nQ\"\\1y\u001dVlwJ\u001a4tKR\u001c\u0018!\u00044j]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002\u0000\u00055\u0015q\u0015\t\u0005\u0003\u0003\u000b9I\u0004\u0003\u0002@\u0005\r\u0015\u0002BAC\u00033\na\u0003T5ti>3gm]3u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003\u0013\u000bYIA\u000eMSN$xJ\u001a4tKR\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003\u000b\u000bI\u0006C\u0004\u0002\u0010J\u0001\r!!%\u0002\rQ|\u0007/[2t!\u0019\t\u0019*!(\u0002\"6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0004nkR\f'\r\\3\u000b\u0007\u0005mU&\u0001\u0006d_2dWm\u0019;j_:LA!a(\u0002\u0016\n1!)\u001e4gKJ\u0004B!!!\u0002$&!\u0011QUAF\u0005]a\u0015n\u001d;PM\u001a\u001cX\r\u001e+pa&\u001c'+Z:q_:\u001cX\rC\u0004\u0002dI\u0001\r!!\u001a")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetResponse response = this.sendListOffsetsRequest(request);
        Assert.assertEquals((long)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (long)this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 20);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$2(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 20);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        Tuple2[] tuple2Array = new Tuple2[1];
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava())).build();
        Assert.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)this.sendFetchRequest(fetchRequest).responseData().get(topicPartition)).records()).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 14);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogOffsetTest.$anonfun$testEmptyLogsGetOffsets$1(this, topic, offsetChanged, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, (Function0 & Serializable & scala.Serializable)() -> logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 20);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeNow$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, (Function0 & Serializable & scala.Serializable)() -> logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 20);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeEarliestTime$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.companion$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.thisCollection$((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.foreach$((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.forall$((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.exists$((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.find$((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.isEmpty$((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.reduceRight$((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.toIterable$((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.toIterator$((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.head$((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.take$((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.drop$((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableLike.grouped$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableLike.sliding$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.takeRight$((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.dropRight$((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zip$((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.sameElements$((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.toStream$((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.canEqual$((IterableLike)this, (Object)that);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view() {
                        return IterableLike.view$((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.repr$((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.isTraversableAgain$((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.parCombiner$((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                    }

                    public Object filterImpl(Function1 p, boolean isFlipped) {
                        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.partition$((TraversableLike)this, p);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.groupBy$((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.headOption$((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.tail$((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.last$((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.lastOption$((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.init$((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.span$((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.tails$((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.inits$((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.toTraversable$((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.toString$((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.stringPrefix$((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.withFilter$((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.par$((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return new .colon.colon((Object)this.$outer.logSegment$1, (List)Nil$.MODULE$).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Parallelizable.$init$((Parallelizable)this);
                        TraversableLike.$init$((TraversableLike)this);
                        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                        GenTraversable.$init$((GenTraversable)this);
                        Traversable.$init$((Traversable)this);
                        GenIterable.$init$((GenIterable)this);
                        IterableLike.$init$((IterableLike)this);
                        Iterable.$init$((Iterable)this);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$groupBy$1(scala.collection.TraversableLike scala.Function1 scala.collection.mutable.Map java.lang.Object ), $anonfun$groupBy$3$adapted(scala.Tuple2 ), $anonfun$groupBy$4(scala.collection.mutable.Builder scala.Tuple2 )}, serializedLambda);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetResponse sendListOffsetsRequest(ListOffsetRequest request) {
        return (ListOffsetResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private List<ListOffsetRequestData.ListOffsetTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetRequestData.ListOffsetTopic().setName(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetResponseData.ListOffsetPartitionResponse findPartition(Buffer<ListOffsetResponseData.ListOffsetTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetResponseData.ListOffsetPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponseData.ListOffsetTopicResponse)topics.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$1))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$2))).get();
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsAfterDeleteRecords$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        return logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsBeforeLatestTime$1(LogManager logManager$2, TopicPartition topicPartition$2) {
        return logManager$2.getLog(topicPartition$2, logManager$2.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$2(TopicPartition topicPartition$2) {
        return new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition$2).append(" should be created").toString();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ void $anonfun$testEmptyLogsGetOffsets$1(LogOffsetTest $this, String topic$3, BooleanRef offsetChanged$1, int _) {
        TopicPartition topicPartition = new TopicPartition(topic$3, 0);
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter($this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
        if (BoxesRunTime.equals((Object)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter($this.findPartition((Buffer<ListOffsetResponseData.ListOffsetTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter($this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala()).head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
            offsetChanged$1.elem = true;
        }
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetResponseData.ListOffsetTopicResponse x$1) {
        String string = x$1.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetResponseData.ListOffsetPartitionResponse x$2) {
        return x$2.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsAfterDeleteRecords$3$adapted(Log log$1, Object _) {
        return log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeLatestTime$3$adapted(Log log$2, Object _) {
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeNow$2$adapted(Log log$3, Object _) {
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeEarliestTime$2$adapted(Log log$4, Object _) {
        return log$4.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }
}

