/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.zookeeper.common.ZKConfig;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!3Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)\u0011\u0006\u0001C\u00013!)1\u0006\u0001C\u00013!)Q\u0006\u0001C\u00013!)q\u0006\u0001C\u0001a\ty1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\n\u0015\u000511/\u001a:wKJT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\u0015\u0005\u0011!p[\u0005\u0003'A\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\t\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRD#AA\u0011\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013!\u00026v]&$(\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)G\t!A+Z:u\u0003!\"Xm\u001d;De\u0016\fG/Z:Qe>\u0004XM\u001d.l)2\u001c8i\u001c8gS\u001e<\u0006.\u001a8ESN\f'\r\\3eQ\t\u0019\u0011%\u0001\u0016uKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XSRDGK];f-\u0006dW/Z:)\u0005\u0011\t\u0013A\r;fgR\u001c%/Z1uKN\u0004&o\u001c9fej[G\u000b\\:D_:4\u0017nZ,ji\"4\u0015\r\\:f\u0003:$G*[:u-\u0006dW/Z:)\u0005\u0015\t\u0013\u0001D2sK\u0006$XmU3sm\u0016\u0014H\u0003B\u00195s\u0019\u0003\"a\u0006\u001a\n\u0005MB!aC&bM.\f7+\u001a:wKJDQ!\u000e\u0004A\u0002Y\naA\\8eK&#\u0007CA\u000e8\u0013\tADDA\u0002J]RDQA\u000f\u0004A\u0002m\n\u0001\u0002[8ti:\u000bW.\u001a\t\u0003y\rs!!P!\u0011\u0005ybR\"A \u000b\u0005\u0001c\u0011A\u0002\u001fs_>$h(\u0003\u0002C9\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011E\u0004C\u0003H\r\u0001\u0007a'\u0001\u0003q_J$\b")
public class KafkaServerTest
extends ZooKeeperTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort(server1, TestUtils$.MODULE$.boundPort$default$2())), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        Assert.assertEquals((Object)None$.MODULE$, (Object)KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2()));
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        Option zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        Option zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer createServer(int nodeId, String hostName, int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "true" : someValue$1;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(Option zkClientConfig$1, String someValue$1, String kafkaProp) {
        Assert.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)((ZKConfig)zkClientConfig$1.get()).getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(Option zkClientConfig$2, String someValue$2, String kafkaProp) {
        Assert.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)((ZKConfig)zkClientConfig$2.get()).getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

