/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00040\u0001\u0001\u0006IA\n\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r5\u0003\u0001\u0015!\u0003G\u0011\u001dq\u0005A1A\u0005\u0002=Ca\u0001\u0016\u0001!\u0002\u0013\u0001\u0006bB+\u0001\u0005\u0004%\tA\u0016\u0005\u0007C\u0002\u0001\u000b\u0011B,\t\u000b\t\u0004A\u0011A2\t\u000bA\u0004A\u0011A2\t\u000bU\u0004A\u0011A2\t\u000b]\u0004A\u0011\u0002=\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u000591m\u001c8gS\u001e\u001cX#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\tIC$\u0001\u0006d_2dWm\u0019;j_:L!a\u000b\u0015\u0003\u0007M+\u0017\u000f\u0005\u0002$[%\u0011a\u0006\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003!Q8n\u00117jK:$X#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u00013\u0012A\u0001>l\u0013\t\u0011uHA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\n1\u0002\\8h\u001b\u0006t\u0017mZ3sgV\ta\tE\u0002(U\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\f\u0002\u00071|w-\u0003\u0002M\u0013\nQAj\\4NC:\fw-\u001a:\u0002\u00191|w-T1oC\u001e,'o\u001d\u0011\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mgV\t\u0001\u000bE\u0002(UE\u0003\"a\t*\n\u0005M#\"\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0001\fm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\:!\u0003=\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014X#A,\u0011\u0005asfBA-]\u001b\u0005Q&BA.\u0017\u0003\u0015)H/\u001b7t\u0013\ti&,A\u0005UKN$X\u000b^5mg&\u0011q\f\u0019\u0002\u0014\u001b>\u001c7.\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u0003;j\u000b\u0001#\u00197uKJL5O]'b]\u0006<WM\u001d\u0011\u0002\u0011Q,\u0017M\u001d3po:$\u0012\u0001\u001a\t\u00037\u0015L!A\u001a\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u000b),h.\u001b;\u000b\u00035\f1a\u001c:h\u0013\ty'NA\u0003BMR,'/A\u0016uKN$\b*[4i/\u0006$XM]7be.\u0004VM]:jgR,gnY3TS:<G.\u001a)beRLG/[8oQ\ty!\u000f\u0005\u0002jg&\u0011AO\u001b\u0002\u0005)\u0016\u001cH/\u0001\u0018uKN$\b*[4i/\u0006$XM]7be.\u0004VM]:jgR,gnY3Nk2$\u0018\u000e\u001d7f!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001\ts\u0003\u0019\t\u0007\u000f]3oIR!A-_A\u0002\u0011\u0015Q\u0018\u00031\u0001|\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f-\u000591\r\\;ti\u0016\u0014\u0018bAA\u0001{\nI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003\u000b\t\u0002\u0019AA\u0004\u0003\u0015\u0019w.\u001e8u!\rY\u0012\u0011B\u0005\u0004\u0003\u0017a\"aA%oi\u00061\u0001n^7G_J$\u0002\"!\u0005\u0002\u0018\u0005\u0005\u0012q\u0007\t\u00047\u0005M\u0011bAA\u000b9\t!Aj\u001c8h\u0011\u001d\tIB\u0005a\u0001\u00037\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002$\u0003;I1!a\b\u0015\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDa\u0001\r\nA\u0002\u0005\r\u0002\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011\u0006\u000f\u000e\u0005\u0005-\"bAA\u00171\u00051AH]8pizJ1!!\r\u001d\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011(!\u000e\u000b\u0007\u0005EB\u0004\u0003\u0004{%\u0001\u0007\u0011q\u0001")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom());
        CleanerConfig x$2 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
        LogConfig x$3 = TestUtils$.MODULE$.createLogManager$default$2();
        MockTime x$4 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, x$2, x$4);
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> new LogDirFailureChannel(config.logDirs().size()), Seq$.MODULE$.canBuildFrom());
    private final TestUtils.MockAlterIsrManager alterIsrManager = TestUtils$.MODULE$.createAlterIsrManager();

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), (AlterIsrManager)this.alterIsrManager(), ReplicaManager$.MODULE$.$lessinit$greater$default$13());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = new TopicPartition(this.topic(), 0);
            Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), (AlterIsrManager)this.alterIsrManager(), ReplicaManager$.MODULE$.$lessinit$greater$default$13());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log topic1Log0 = qual$1.getOrCreateLog(t1p0, (Function0)x$2, x$3, x$4);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            Function0 & Serializable & scala.Serializable x$6 = (Function0 & Serializable & scala.Serializable)() -> LogConfig$.MODULE$.apply();
            boolean x$7 = qual$2.getOrCreateLog$default$3();
            boolean x$8 = qual$2.getOrCreateLog$default$4();
            Log topic2Log0 = qual$2.getOrCreateLog(t2p0, (Function0)x$6, x$7, x$8);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assert.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assert.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void append(Partition partition, int count) {
        void map_bf;
        void map_f;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, count);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> HighwatermarkPersistenceTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)i));
        if (inclusive == null) {
            throw null;
        }
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Log qual$1 = partition.localLogOrException();
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        qual$1.appendAsLeader(records, x$2, x$3, x$4);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

