/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0001\u0004\u0001)A\u0005Q!9\u0011\u0007\u0001a\u0001\n\u0003\u0011\u0004b\u0002\"\u0001\u0001\u0004%\ta\u0011\u0005\u0007\u0013\u0002\u0001\u000b\u0015B\u001a\t\u000b)\u0003A\u0011I&\t\u000bU\u0003A\u0011I&\t\u000bi\u0003A\u0011A&\t\u000b}\u0003A\u0011A&\t\u000b\u0005\u0004A\u0011A&\t\u000b\r\u0004A\u0011A&\t\u000b\u0015\u0004A\u0011A&\t\u000b\u001d\u0004A\u0011\u00025\t\u000b9\u0004A\u0011B8\t\u000bA\u0004A\u0011B9\t\u000bi\u0004A\u0011B>\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\tQ\"I]8lKJ,\u0005o\\2i\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004G\u0001\u0003u.L!!\t\u0010\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\ta#A\u0005ce>\\WM]%ecU\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#FA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\nqa]3sm\u0016\u00148/F\u00014!\r!Dh\u0010\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001\u000f\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013BA\u001e+\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003\u0007M+\u0017O\u0003\u0002<UA\u0011Q\u0005Q\u0005\u0003\u0003Z\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t!u\t\u0005\u0002*\u000b&\u0011aI\u000b\u0002\u0005+:LG\u000fC\u0004I\u000f\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\u0005!\u0005FA\u0005N!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0003kk:LGOC\u0001S\u0003\ry'oZ\u0005\u0003)>\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)9\u0006C\u0001(Y\u0013\tIvJA\u0003BMR,'/\u0001\u0016uKN$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014(I]8lKJ,\u0005o\\2i\u001b\u0006$8\r[3t/&$\bNW6)\u0005-a\u0006C\u0001(^\u0013\tqvJ\u0001\u0003UKN$\u0018a\u000b;fgR\u001cuN\u001c;s_2dWM\u001d\"s_.,'/\u00129pG\"\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6)\u00051a\u0016\u0001\u000b;fgR\u001cuN\u001c;s_2\u0014V-];fgR<\u0016\u000e\u001e5D_J\u0014Xm\u0019;Ce>\\WM]#q_\u000eD\u0007FA\u0007]\u0003\u0019\"Xm\u001d;D_:$(o\u001c7SKF,Xm\u001d;XSRD7\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0003\u001dq\u000ba\u0005^3ti\u000e{g\u000e\u001e:pYJ+\u0017/^3ti^KG\u000f\u001b(fo\u0016\u0014(I]8lKJ,\u0005o\\2iQ\tyA,A\u0011uKN$8i\u001c8ue>d'+Z9vKN$x+\u001b;i\u0005J|7.\u001a:Fa>\u001c\u0007\u000e\u0006\u0002ES\")!\u000e\u0005a\u0001W\u0006\u0011S\r]8dQ&s'+Z9vKN$H)\u001b4g\rJ|WnQ;se\u0016tG/\u00129pG\"\u0004\"!\u000b7\n\u00055T#\u0001\u0002'p]\u001e\fQbZ3u\u0007>tGO]8mY\u0016\u0014X#A \u0002[\rDWmY6D_:$(o\u001c7mKJ\u0014%o\\6fe\u0016\u0003xn\u00195t\u0007\u0006\u001c\u0007.Z'bi\u000eDWm],ji\"T6\u000e\u0006\u0002Ee\")1O\u0005a\u0001i\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005UDX\"\u0001<\u000b\u0005]D\u0012AC2p]R\u0014x\u000e\u001c7fe&\u0011\u0011P\u001e\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018aJ:f]\u0012\fe\u000e\u001a,fe&4\u0017p\u0015;bY\u0016\u0014%o\\6fe\u0016\u0003xn\u00195J]J+7\u000f]8og\u0016$B\u0001\u0012?\u0002\u0004!)Qp\u0005a\u0001}\u0006A2m\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005U|\u0018bAA\u0001m\nA2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\t\u000f\u0005\u00151\u00031\u0001\u0002\b\u00059!-^5mI\u0016\u0014\b\u0007BA\u0005\u0003W\u0001b!a\u0003\u0002\"\u0005\u001db\u0002BA\u0007\u0003;i!!a\u0004\u000b\t\u0005E\u00111C\u0001\te\u0016\fX/Z:ug*!\u0011QCA\f\u0003\u0019\u0019w.\\7p]*\u0019\u0011$!\u0007\u000b\u0007\u0005m\u0011+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003?\ty!\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0013\u0011\t\u0019#!\n\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011qDA\b!\u0011\tI#a\u000b\r\u0001\u0011a\u0011QFA\u0002\u0003\u0003\u0005\tQ!\u0001\u00020\t\u0019q\fJ\u0019\u0012\t\u0005E\u0012q\u0007\t\u0004S\u0005M\u0012bAA\u001bU\t9aj\u001c;iS:<\u0007\u0003BA\u0007\u0003sIA!a\u000f\u0002\u0010\t1\u0012IY:ue\u0006\u001cGoQ8oiJ|GNU3rk\u0016\u001cH/A\u0010tK:$\u0017I\u001c3WKJLg-_*vG\u000e,7o\u001d4vYJ+7\u000f]8og\u0016$R\u0001RA!\u0003\u0007BQ! \u000bA\u0002yDq!!\u0002\u0015\u0001\u0004\t)\u0005\r\u0003\u0002H\u0005-\u0003CBA\u0006\u0003C\tI\u0005\u0005\u0003\u0002*\u0005-C\u0001DA'\u0003\u0007\n\t\u0011!A\u0003\u0002\u0005=\"aA0%e\u0001")
public class BrokerEpochIntegrationTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        .colon.colon configs = new .colon.colon((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), (List)new .colon.colon((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), (List)Nil$.MODULE$));
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaManagerBrokerEpochMatchesWithZk() {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        Assert.assertEquals((long)brokerAndEpochs.size(), (long)this.servers().size());
        brokerAndEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testControllerBrokerEpochCacheMatchesWithZk() {
        KafkaServer controller = this.getController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(controller, e))).get();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.shutdown();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.startup();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
    }

    @Test
    public void testControlRequestWithCorrectBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(0L);
    }

    @Test
    public void testControlRequestWithStaleBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(-1L);
    }

    @Test
    public void testControlRequestWithNewerBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(1L);
    }

    /*
     * WARNING - void declaration
     */
    private void testControlRequestWithBrokerEpoch(long epochInRequestDiffFromCurrentEpoch) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition tp = new TopicPartition("new-topic", 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers());
        int controllerId = 2;
        int controllerEpoch = ((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp();
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, TestUtils$.MODULE$.boundPort$default$2()), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.node(listenerName), scala.collection.Iterable$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokers((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        KafkaServer broker2 = (KafkaServer)this.servers().apply(this.brokerId2());
        long epochInRequest = broker2.kafkaController().brokerEpoch() + epochInRequestDiffFromCurrentEpoch;
        try {
            .colon.colon partitionStates = new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(false), (List)Nil$.MODULE$);
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, epochInRequest, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            if (epochInRequestDiffFromCurrentEpoch < 0L) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)new .colon.colon((Object)broker2, (List)Nil$.MODULE$), tp, 10000L);
            }
            .colon.colon partitionStates2 = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()), (List)Nil$.MODULE$);
            Buffer liveBrokers = ((TraversableOnce)brokerAndEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void orNull_ev;
                Option option;
                .colon.colon endpoints;
                Broker broker;
                if (x0$1 != null) {
                    broker = (Broker)x0$1._1();
                    SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                    ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                    Node node = broker.node(listenerName);
                    endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
                    option = broker.rack();
                    Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
                    if (option == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Option orNull_this = option;
                Object object = orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get();
                UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker = new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)endpoints).asJava()).setRack((String)object);
                return updateMetadataBroker;
            }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
            UpdateMetadataRequest.Builder requestBuilder2 = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), controllerId, controllerEpoch, epochInRequest, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates2).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers).asJava());
            if (epochInRequestDiffFromCurrentEpoch < 0L) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)new .colon.colon((Object)broker2, (List)Nil$.MODULE$), tp.topic(), tp.partition(), 10000L);
                Assert.assertEquals((long)this.brokerId2(), (long)((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker2.metadataCache().getPartitionInfo(tp.topic(), tp.partition()).get()).leader());
            }
            java.util.List topicStates = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StopReplicaRequestData.StopReplicaTopicState().setTopicName(tp.topic()).setPartitionStates((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(tp.partition()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2).setDeletePartition(true), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
            StopReplicaRequest.Builder requestBuilder3 = new StopReplicaRequest.Builder(ApiKeys.STOP_REPLICA.latestVersion(), controllerId, controllerEpoch, epochInRequest, false, topicStates);
            if (epochInRequestDiffFromCurrentEpoch < 0L) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
                Assert.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker2.replicaManager().getPartition(tp));
            }
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    /*
     * WARNING - void declaration
     */
    private void checkControllerBrokerEpochsCacheMatchesWithZk(ControllerContext controllerContext) {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$1(controllerContext, brokerAndEpochs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendAndVerifyStaleBrokerEpochInResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        BooleanRef staleBrokerEpochDetected = BooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable & scala.Serializable)response -> {
            staleBrokerEpochDetected.elem = response.errorCounts().containsKey(Errors.STALE_BROKER_EPOCH);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BrokerEpochIntegrationTest.$anonfun$sendAndVerifyStaleBrokerEpochInResponse$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((String)"Stale broker epoch not detected by the broker", (boolean)staleBrokerEpochDetected.elem);
    }

    /*
     * WARNING - void declaration
     */
    private void sendAndVerifySuccessfulResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        VolatileBooleanRef succeed = VolatileBooleanRef.create((boolean)false);
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable & scala.Serializable)response -> {
            succeed.elem = response.errorCounts().isEmpty() || response.errorCounts().containsKey(Errors.NONE) && response.errorCounts().size() == 1;
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!succeed.elem) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BrokerEpochIntegrationTest.$anonfun$sendAndVerifySuccessfulResponse$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(Broker broker$1, KafkaServer e) {
        return e.config().brokerId() == broker$1.id();
    }

    public static final /* synthetic */ void $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(BrokerEpochIntegrationTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            Broker broker = (Broker)x0$1._1();
            long epoch = x0$1._2$mcJ$sp();
            Option brokerServer = $this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(broker, e)));
            Assert.assertTrue((boolean)brokerServer.isDefined());
            Assert.assertEquals((long)epoch, (long)((KafkaServer)brokerServer.get()).kafkaController().brokerEpoch());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(KafkaServer controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(Map brokerEpochsInControllerContext$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Broker broker = (Broker)x0$1._1();
        long epoch = x0$1._2$mcJ$sp();
        boolean bl = brokerEpochsInControllerContext$1.get((Object)BoxesRunTime.boxToInteger((int)broker.id())).contains((Object)BoxesRunTime.boxToLong((long)epoch));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$1(ControllerContext controllerContext$1, Map brokerAndEpochs$1) {
        Map brokerEpochsInControllerContext = controllerContext$1.liveBrokerIdAndEpochs();
        if (brokerAndEpochs$1.size() != brokerEpochsInControllerContext.size()) {
            return false;
        }
        return brokerAndEpochs$1.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(brokerEpochsInControllerContext, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$3() {
        return "Broker epoch mismatches";
    }

    public static final /* synthetic */ String $anonfun$sendAndVerifyStaleBrokerEpochInResponse$3() {
        return "Broker epoch should be stale";
    }

    public static final /* synthetic */ String $anonfun$sendAndVerifySuccessfulResponse$3() {
        return "Should receive response with no errors";
    }

    public BrokerEpochIntegrationTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

