/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rma\u0001B&M\u0001ECQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0001d\u0011\u0019q\u0007\u0001)A\u0005I\"9q\u000e\u0001b\u0001\n\u0003\u0019\u0007B\u00029\u0001A\u0003%A\rC\u0004r\u0001\t\u0007I\u0011A2\t\rI\u0004\u0001\u0015!\u0003e\u0011\u001d\u0019\bA1A\u0005\u0002QDq!!\u0001\u0001A\u0003%Q\u000f\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001u\u0011\u001d\t)\u0001\u0001Q\u0001\nUD\u0011\"a\u0002\u0001\u0005\u0004%\t!!\u0003\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u0017A\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0011\"!\n\u0001\u0005\u0004%\t!a\n\t\u0011\u0005=\u0002\u0001)A\u0005\u0003SA\u0011\"!\r\u0001\u0005\u0004%\t!a\r\t\u0011\u0005m\u0002\u0001)A\u0005\u0003kA\u0011\"!\u0010\u0001\u0005\u0004%\t!a\u0010\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u00032a!!\u0017\u0001\u0001\u0005m\u0003\u0002DA21\t\u0005\t\u0015!\u0003\u0002f\u0005u\u0004\u0002DA@1\t\u0005\t\u0015!\u0003\u0002\u0002\u00065\u0005\u0002DAH1\t\u0005\t\u0015!\u0003\u0002\u0012\u0006u\u0005B\u00020\u0019\t\u0003\ty\nC\u0004\u0002,b!\t%!,\t\u000f\u0005u\u0006\u0004\"\u0011\u0002@\"I\u0011\u0011\u001d\r\u0012\u0002\u0013\u0005\u00111\u001d\u0005\n\u0003sD\u0012\u0013!C\u0001\u0003wDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\t\r\u0002\u0001\"\u0001\u0003\u0002!9!Q\u0006\u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0019\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005k\u0001A\u0011\u0001B\u0001\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005\u0003AqA!\u0010\u0001\t\u0003\u0011\t\u0001C\u0004\u0003B\u0001!\tA!\u0001\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003\u0002!9!\u0011\n\u0001\u0005\u0002\t\u0005\u0001b\u0002B'\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005#\u0002A\u0011\u0001B\u0001\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005\u0003AqA!\u0017\u0001\t\u0003\u0011\t\u0001C\u0004\u0003^\u0001!\tA!\u0001\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003\u0002!9!Q\r\u0001\u0005\u0002\t\u0005\u0001b\u0002B5\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005[\u0002A\u0011\u0001B\u0001\u0011\u001d\u0011\t\b\u0001C\u0001\u0005\u0003AqA!\u001e\u0001\t\u0003\u0011\t\u0001C\u0004\u0003z\u0001!\tA!\u0001\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0002!9!\u0011\u0011\u0001\u0005\u0002\t\u0005\u0001b\u0002BC\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0013\u0003A\u0011\u0001B\u0001\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u0003AqA!%\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u0016\u0002!\tA!\u0001\t\u000f\te\u0005\u0001\"\u0001\u0003\u0002!9!Q\u0014\u0001\u0005\u0002\t\u0005\u0001b\u0002BQ\u0001\u0011%!1\u0015\u0005\b\u0005O\u0003A\u0011\u0002BU\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005cC\u0011Ba1\u0001#\u0003%IA!2\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Br\u0001\u0011%!Q\u001d\u0005\b\u0005[\u0004A\u0011\u0002Bx\u0011%\u0011I\u0010AI\u0001\n\u0013\u0011Y\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\u0003+1{wm\u00117fC:,'/T1oC\u001e,'\u000fV3ti*\u0011QJT\u0001\u0004Y><'\"A(\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\r\u0005s\u0017PU3g!\tIF,D\u0001[\u0015\tYf*A\u0003vi&d7/\u0003\u0002^5\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001a!\t\t\u0007!D\u0001M\u0003\u0019!X\u000e\u001d#jeV\tA\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006\u0011\u0011n\u001c\u0006\u0002S\u0006!!.\u0019<b\u0013\tYgM\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\bi6\u0004H)\u001b:3\u0003!!X\u000e\u001d#jeJ\u0002\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000f1|w\rR5se\u0005AAn\\4ESJ\u0014\u0004%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003U\u0004\"A\u001e@\u000e\u0003]T!\u0001_=\u0002\r\r|W.\\8o\u0015\ty%P\u0003\u0002|y\u00061\u0011\r]1dQ\u0016T\u0011!`\u0001\u0004_J<\u0017BA@x\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oe\u0005\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t'\u0007I\u0001\tY><\u0007K]8qgV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u00035\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\tyA\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<WCAA\u000f!\r\t\u0017qD\u0005\u0004\u0003Ca%!\u0003'pO\u000e{gNZ5h\u0003)awnZ\"p]\u001aLw\rI\u0001\u0005i&lW-\u0006\u0002\u0002*A\u0019\u0011,a\u000b\n\u0007\u00055\"L\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019ygMZ:fiV\u0011\u0011Q\u0007\t\u0004'\u0006]\u0012bAA\u001d)\n\u0019\u0011J\u001c;\u0002\u000f=4gm]3uA\u0005\u00112\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\t\t\u0005E\u0004\u0002D\u00055S/!\u0015\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\nq!\\;uC\ndWMC\u0002\u0002LQ\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty%!\u0012\u0003\u00075\u000b\u0007\u000fE\u0002T\u0003'J1!!\u0016U\u0005\u0011auN\\4\u0002'\rdW-\u00198fe\u000eCWmY6q_&tGo\u001d\u0011\u0003+1{wm\u00117fC:,'/T1oC\u001e,'/T8dWN\u0019\u0001$!\u0018\u0011\u0007\u0005\fy&C\u0002\u0002b1\u0013\u0011\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u0003\u001dawn\u001a#jeN\u0004R!a\u001a\u0002x\u0011tA!!\u001b\u0002t9!\u00111NA9\u001b\t\tiGC\u0002\u0002pA\u000ba\u0001\u0010:p_Rt\u0014\"A+\n\u0007\u0005UD+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\u0004'\u0016\f(bAA;)&!\u00111MA0\u0003\u0011awnZ:\u0011\re\u000b\u0019)^AD\u0013\r\t)I\u0017\u0002\u0005!>|G\u000eE\u0002b\u0003\u0013K1!a#M\u0005\raunZ\u0005\u0005\u0003\u007f\ny&\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013(\u0002\rM,'O^3s\u0013\u0011\tY*!&\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0013\u0011\ty)a\u0018\u0015\u0011\u0005\u0005\u0016QUAT\u0003S\u00032!a)\u0019\u001b\u0005\u0001\u0001bBA29\u0001\u0007\u0011Q\r\u0005\b\u0003\u007fb\u0002\u0019AAA\u0011\u001d\ty\t\ba\u0001\u0003#\u000bQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u00020B9\u0011\u0011WA]k\u0006Ec\u0002BAZ\u0003k\u00032!a\u001bU\u0013\r\t9\fV\u0001\u0007!J,G-\u001a4\n\t\u0005=\u00131\u0018\u0006\u0004\u0003o#\u0016!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugRA\u0011\u0011YAd\u0003\u0017\fY\u000eE\u0002T\u0003\u0007L1!!2U\u0005\u0011)f.\u001b;\t\r\u0005%g\u00041\u0001e\u0003\u001d!\u0017\r^1ESJD\u0011\"!4\u001f!\u0003\u0005\r!a4\u0002-A\f'\u000f^5uS>tGk\\+qI\u0006$Xm\u0014:BI\u0012\u0004RaUAi\u0003+L1!a5U\u0005\u0019y\u0005\u000f^5p]B11+a6v\u0003#J1!!7U\u0005\u0019!V\u000f\u001d7fe!I\u0011Q\u001c\u0010\u0011\u0002\u0003\u0007\u0011q\\\u0001\u0012a\u0006\u0014H/\u001b;j_:$vNU3n_Z,\u0007\u0003B*\u0002RV\f1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TCAAsU\u0011\ty-a:,\u0005\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a=U\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\fiOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u001aTCAA\u007fU\u0011\ty.a:\u0002\u0011Q,\u0017M\u001d#po:$\"!!1)\u0007\u0005\u0012)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\r\u0011Y\u0001`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u001f\u0011IAA\u0003BMR,'/A\u000etKR,\b/\u00138de\u0016\f7/\u001b8hYf4\u0015\u000e\u001c;is2{wm\u001d\u000b\t\u0003\u0003\u0013)Ba\u0007\u0003 !9!q\u0003\u0012A\u0002\te\u0011A\u00039beRLG/[8ogB)\u0011qMA<k\"9!Q\u0004\u0012A\u0002\u0005U\u0012aD:uCJ$h*^7CCR\u001c\u0007.Z:\t\u000f\t\u0005\"\u00051\u0001\u00026\u0005q!-\u0019;dQ&s7M]3nK:$\u0018\u0001\f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4UQJ|wo]#yG\u0016\u0004H/[8oQ\r\u0019#q\u0005\t\u0005\u0005\u000f\u0011I#\u0003\u0003\u0003,\t%!\u0001\u0002+fgR\f\u0001\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a*fiV\u0014hn\u001d'pO^KG\u000f\u001b#jeRLWm\u001d;SCRLw\u000eK\u0002%\u0005O\t\u0011\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dunZ%h]>\u0014Xm]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004K\t\u001d\u0012\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004M\t\u001d\u0012\u0001\u0016;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:C_RD\u0017J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]N\fe\u000eZ+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004O\t\u001d\u0012!\u000b;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;SKN,G/\u00134MCJ<WM\u001d+iC:,e\u000eZ(gMN,G\u000fK\u0002)\u0005O\tA\u0006^3ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e*fg\u0016$\u0018JZ*nC2dWM\u001d+iC:\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007%\u00129#A\u001auKN$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$H*\u0019:hKJ$\u0006.\u00198BGRLg/Z*fO6,g\u000e\u001e\"bg\u0016|eMZ:fi\"\u001a!Fa\n\u0002aQ,7\u000f\u001e#jeRLxJ\u001a4tKRd\u0015M]4feRC\u0017M\\!di&4XmU3h[\u0016tGOQ1tK>3gm]3uQ\rY#qE\u0001Ei\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf$U\r\\3uK2{wm\u001d\u0015\u0004Y\t\u001d\u0012\u0001\u0013;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fR3mKR,Gj\\4tQ\ri#qE\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bf\u0001\u0018\u0003(\u0005YC/Z:u\u0019><7/\u00168eKJ\u001cE.Z1okBLe.\u001a7jO&\u0014G.\u001a$pe\u000e{W\u000e]1di&|g\u000eK\u00020\u0005O\tq\u0006^3tiV\u0003H-\u0019;f\u0007\",7m\u001b9pS:$8o\u00155pk2$\u0017\t\u001a3PM\u001a\u001cX\r\u001e+p!\u0006\u0014H/\u001b;j_:D3\u0001\rB\u0014\u00039\"Xm\u001d;Va\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN\u001c\u0006n\\;mIJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:$\u0015\r^1)\u0007E\u00129#A\u0017uKN$\b*\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKNCw.\u001e7e%\u0016lwN^3ESJ\fe\u000e\u001a#bi\u0006D3A\rB\u0014\u00035\"Xm\u001d;NCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiNCw.\u001e7e)J,hnY1uK\u0012\u000bG/\u0019\u0015\u0004g\t\u001d\u0012\u0001\u0010;fgR\fE\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:TQ>,H\u000e\u001a*f[>4X\rR1uC&s7K]2ESJ\fe\u000eZ!eI&sg*Z<ESJD3\u0001\u000eB\u0014\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oI2{w\r\u0016:v]\u000e\fG/[8oQ\r)$qE\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3U_BL7\rR3mKRLwN\u001c\u0015\u0004m\t\u001d\u0012A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3feVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\u001aqGa\n\u00027Q,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u0014hj\u001c8fQ\rA$qE\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J$\u0016.\\3)\u0007e\u00129#\u0001\u0011uKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peNCwN\u001d;US6,\u0007f\u0001\u001e\u0003(\u0005AC/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiNtU-\u001a3t\u0007\",7m\u001b9pS:$(+Z:fi\"\u001a1Ha\n\u0002UQ,7\u000f^+oI\u0016\u001c\u0017\u000eZ3e)J\fgn]1di&|g.\u00197ECR\fgj\u001c;DY\u0016\fg.\u00192mK\"\u001aAHa\n\u0002!Q,7\u000f\u001e#p]\u0016\u001cE.Z1oS:<\u0007fA\u001f\u0003(\u0005\u0001B/Z:u\t>tW\rR3mKRLgn\u001a\u0015\u0004}\t\u001d\u0012a\f;fgR\u001c\u0005.Z2la>Lg\u000e^+qI\u0006$X\r\u001a$pe&sg/\u00197jI>3gm]3u\u001d>\u001cE.Z1oS:<\u0007fA \u0003(\u0005\u0001D/Z:u\u0007\",7m\u001b9pS:$X\u000b\u001d3bi\u0016$gi\u001c:J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e(piN+G.Z2uK\u0012D3\u0001\u0011B\u0014\u0003Q\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4feR!\u0011Q\fBS\u0011\u0019i\u0015\t1\u0001\u0002\b\u0006A2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJlunY6\u0015\t\u0005\u0005&1\u0016\u0005\b\u0005[\u0013\u0005\u0019AAA\u0003\u0011\u0001xn\u001c7\u0002\u0013\r\u0014X-\u0019;f\u0019><G\u0003CAD\u0005g\u00139L!1\t\u000f\tU6\t1\u0001\u00026\u0005Y1/Z4nK:$8+\u001b>f\u0011\u001d\u0011Il\u0011a\u0001\u0005w\u000bQb\u00197fC:,\b\u000fU8mS\u000eL\b\u0003BAY\u0005{KAAa0\u0002<\n11\u000b\u001e:j]\u001eDqa]\"\u0011\u0002\u0003\u0007Q/A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003H*\u001aQ/a:\u00027\r\u0014X-\u0019;f\u0019><(+\u001a;f]RLwN\u001c'pO\u000e{gNZ5h)\u0019\tiB!4\u0003P\"9!QW#A\u0002\u0005U\u0002b\u0002B]\u000b\u0002\u0007!1X\u0001\roJLG/\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0003\u0003\u0014)Na6\u0003\\\n}\u0007BB'G\u0001\u0004\t9\tC\u0004\u0003Z\u001a\u0003\r!!\u000e\u0002\u00159,XNQ1uG\",7\u000fC\u0004\u0003^\u001a\u0003\r!!\u000e\u0002\u001fI,7m\u001c:egB+'OQ1uG\"DqA!9G\u0001\u0004\t)$A\tcCR\u001c\u0007.Z:QKJ\u001cVmZ7f]R\fQ\"\u00199qK:$'+Z2pe\u0012\u001cHCBAa\u0005O\u0014I\u000f\u0003\u0004N\u000f\u0002\u0007\u0011q\u0011\u0005\b\u0005W<\u0005\u0019AA\u001b\u0003)qW/\u001c*fG>\u0014Hm]\u0001\b[\u0006\\W\rT8h)\u0019\t9I!=\u0003v\"A!1\u001f%\u0011\u0002\u0003\u0007A-A\u0002eSJDqAa>I\u0001\u0004\ti\"\u0001\u0004d_:4\u0017nZ\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\nTC\u0001B\u007fU\r!\u0017q]\u0001\be\u0016\u001cwN\u001d3t)!\u0019\u0019aa\u0004\u0004\u0014\r]\u0001\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\u0007\r%q/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0007\u001b\u00199AA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0007#Q\u0005\u0019AA\u001b\u0003\rYW-\u001f\u0005\b\u0007+Q\u0005\u0019AA\u001b\u0003\u00151\u0018\r\\;f\u0011\u001d\u0019IB\u0013a\u0001\u0003#\n\u0011\u0002^5nKN$\u0018-\u001c9")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File tmpDir2;
    private final File logDir;
    private final File logDir2;
    private final TopicPartition topicPartition;
    private final TopicPartition topicPartition2;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, Log> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends Log {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, File dir, LogConfig config, TopicPartition tp$1, File tpDir$1) {
                super(dir, config, 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), $outer.topicPartition(), new ProducerStateManager(tp$1, tpDir$1, 3600000), new LogDirFailureChannel(10));
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(this, tpDir, this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact()), tp, tpDir);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get(), ClassTag$.MODULE$.apply(LogCleaningException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        Assert.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assert.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        Assert.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Option option = cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)LogCleanerManagerTest.$anonfun$testUpdateCheckpointsShouldAddOffsetToPartition$1()) : getOrElse_this.get();
        Assert.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)object);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assert.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assert.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).isEmpty());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$4 -> (TopicPartition)x$4._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertFalse((String)"Checkpoint offset should not be reset if valid", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if less than log start offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((Log)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertTrue((String)"Checkpoint offset needs to be reset if greater than log end offset", (boolean)cleanableOffsets.forceUpdateCheckpoint());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assert.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"Log should not be selected for cleaning", (Object)None$.MODULE$, (Object)filthiestLog);
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp).get()));
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((Log)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((String)"Dirtier log should be selected", (Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((String)"Unselected log should have checkpoint offset updated", (long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().get((Object)tp0).get()));
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, Log> pool) {
        return new LogCleanerManagerMock((Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private Log createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(partitionDir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private void writeRecords(Log log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numBatches);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.roll(log.roll$default$1());
    }

    private void appendRecords(Log log, int numRecords) {
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)new RichLong(startOffset).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private Log makeLog(File dir, LogConfig config) {
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(dir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        Log log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ int $anonfun$testUpdateCheckpointsShouldAddOffsetToPartition$1() {
        return 0;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.tmpDir2 = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.topicPartition2 = new TopicPartition("log2", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1$adapted(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, Object i) {
        return LogCleanerManagerTest.$anonfun$writeRecords$1($this, log$2, recordsPerBatch$1, batchesPerSegment$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void assert_assertion;
            boolean bl = partitionToRemove.isEmpty();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (assert_assertion == false) {
                throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)LogCleanerManagerMock.$anonfun$updateCheckpoints$1()).toString());
            }
            if (partitionToUpdateOrAdd == null) {
                throw null;
            }
            if (partitionToUpdateOrAdd.isEmpty()) {
                throw LogCleanerManagerMock.$anonfun$updateCheckpoints$2();
            }
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.get();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public static final /* synthetic */ String $anonfun$updateCheckpoints$1() {
            return "partitionToRemove argument with value not yet handled";
        }

        public static final /* synthetic */ Nothing$ $anonfun$updateCheckpoints$2() {
            throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

