/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004B\u0001\u0001\u0006IA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019y\u0005\u0001)A\u0005\t\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00015\"I1\r\u0001a\u0001\u0002\u0004%\t\u0001\u001a\u0005\nU\u0002\u0001\r\u0011!Q!\nmC\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u0001.\t\u00131\u0004\u0001\u0019!a\u0001\n\u0003i\u0007\"C8\u0001\u0001\u0004\u0005\t\u0015)\u0003\\\u0011%\u0001\b\u00011AA\u0002\u0013\u0005!\fC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"IA\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u0017\u0005\nk\u0002\u0001\r\u00111A\u0005\u0002YD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0001@\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&q\u000fC\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0001bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0001\u0003KA1\"!\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\b!Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0017\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%\t!a\u000e\t\u0017\u0005m\u0002\u00011A\u0001B\u0003&\u0011q\u0006\u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0004C\u0006\u0002H\u0001\u0001\r\u00111A\u0005\u0002\u0005%\u0003bCA'\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003B\u0011\"a\u0014\u0001\u0005\u0004%\t!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005]\u0004\u0001)A\u0005\u0003WB\u0011\"!\u001f\u0001\u0005\u0004%\t!a\u001f\t\u0011\u0005%\u0005\u0001)A\u0005\u0003{B1\"a#\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011AAL\u0011-\tY\n\u0001a\u0001\u0002\u0003\u0006K!a$\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBAm\u0001\u0011\u0005\u0011q\u0014\u0002\u0016\u0003\n\u001cHO]1diB\u000b'\u000f^5uS>tG+Z:u\u0015\tic&A\u0004dYV\u001cH/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005m\u0002Q\"\u0001\u0017\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\u0010\t\u0003g}J!\u0001\u0011\u001b\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001#\u0011\u0005\u0015kU\"\u0001$\u000b\u0005\u001dC\u0015AB2p[6|gN\u0003\u00020\u0013*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h\u0013\tqeI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nA\u0001^5nKV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V]\u0005)Q\u000f^5mg&\u0011q\u000b\u0016\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00051A/\u001c9ESJ,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b!![8\u000b\u0003\u0001\fAA[1wC&\u0011!-\u0018\u0002\u0005\r&dW-\u0001\u0006u[B$\u0015N]0%KF$\"!\u001a5\u0011\u0005M2\u0017BA45\u0005\u0011)f.\u001b;\t\u000f%L\u0011\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0002\u000fQl\u0007\u000fR5sA\u00059An\\4ESJ\f\u0014a\u00037pO\u0012K'/M0%KF$\"!\u001a8\t\u000f%d\u0011\u0011!a\u00017\u0006AAn\\4ESJ\f\u0004%A\u0004m_\u001e$\u0015N\u001d\u001a\u0002\u00171|w\rR5se}#S-\u001d\u000b\u0003KNDq![\b\u0002\u0002\u0003\u00071,\u0001\u0005m_\u001e$\u0015N\u001d\u001a!\u0003)awnZ'b]\u0006<WM]\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!PL\u0001\u0004Y><\u0017B\u0001?z\u0005)aunZ'b]\u0006<WM]\u0001\u000fY><W*\u00198bO\u0016\u0014x\fJ3r)\t)w\u0010C\u0004j%\u0005\u0005\t\u0019A<\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0010C2$XM]%te6\u000bg.Y4feV\u0011\u0011q\u0001\t\u0005\u0003\u0013\tiB\u0004\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\u0001\u0014A\u0002\u001fs_>$h(C\u00010\u0013\t)f&C\u0002\u0002\u001cQ\u000b\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005}\u0011\u0011\u0005\u0002\u0014\u001b>\u001c7.\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u0004\u00037!\u0016aE1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:`I\u0015\fHcA3\u0002(!A\u0011.FA\u0001\u0002\u0004\t9!\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005\t\u0012n\u001d:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0016\u0005\u0005=\u0002\u0003BA\u0005\u0003cIA!a\r\u0002\"\t)Rj\\2l\u0013N\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\u0018!F5te\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0004K\u0006e\u0002\u0002C5\u0019\u0003\u0003\u0005\r!a\f\u0002%%\u001c(o\u00115b]\u001e,G*[:uK:,'\u000fI\u0001\nY><7i\u001c8gS\u001e,\"!!\u0011\u0011\u0007a\f\u0019%C\u0002\u0002Fe\u0014\u0011\u0002T8h\u0007>tg-[4\u0002\u001b1|wmQ8oM&<w\fJ3r)\r)\u00171\n\u0005\tSn\t\t\u00111\u0001\u0002B\u0005QAn\\4D_:4\u0017n\u001a\u0011\u0002\u0015M$\u0018\r^3Ti>\u0014X-\u0006\u0002\u0002TA\u00191(!\u0016\n\u0007\u0005]CFA\nQCJ$\u0018\u000e^5p]N#\u0018\r^3Ti>\u0014X-A\u0006ti\u0006$Xm\u0015;pe\u0016\u0004\u0013!\u00053fY\u0006LX\rZ(qKJ\fG/[8ogV\u0011\u0011q\f\t\u0004w\u0005\u0005\u0014bAA2Y\t\tB)\u001a7bs\u0016$w\n]3sCRLwN\\:\u0002%\u0011,G.Y=fI>\u0003XM]1uS>t7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005-\u0004\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005Ed&\u0001\u0004tKJ4XM]\u0005\u0005\u0003k\nyGA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EygMZ:fi\u000eCWmY6q_&tGo]\u000b\u0003\u0003{\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000by'A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018\u0002BAD\u0003\u0003\u0013\u0011c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;t\u0003IygMZ:fi\u000eCWmY6q_&tGo\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAAH!\rY\u0014\u0011S\u0005\u0004\u0003'c#!\u0003)beRLG/[8o\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR\u0019Q-!'\t\u0011%4\u0013\u0011!a\u0001\u0003\u001f\u000b!\u0002]1si&$\u0018n\u001c8!\u0003\u0015\u0019X\r^;q)\u0005)\u0007f\u0001\u0015\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*.\u000bQA[;oSRLA!!,\u0002(\n1!)\u001a4pe\u0016\f1c\u0019:fCR,Gj\\4Qe>\u0004XM\u001d;jKN$B!a-\u0002@B!\u0011QWA^\u001b\t\t9LC\u0002\u0002:~\u000bA!\u001e;jY&!\u0011QXA\\\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003\u0003L\u0003\u0019AAb\u0003%yg/\u001a:sS\u0012,7\u000f\u0005\u0005\u0002F\u00065\u00171[Aj\u001d\u0011\t9-!3\u0011\u0007\u0005=A'C\u0002\u0002LR\na\u0001\u0015:fI\u00164\u0017\u0002BAh\u0003#\u00141!T1q\u0015\r\tY\r\u000e\t\u0005\u0003\u000b\f).\u0003\u0003\u0002X\u0006E'AB*ue&tw-\u0001\u0005uK\u0006\u0014Hi\\<oQ\rQ\u0013Q\u001c\t\u0005\u0003K\u000by.\u0003\u0003\u0002b\u0006\u001d&!B!gi\u0016\u0014\b")
public class AbstractPartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;
    private TestUtils.MockIsrChangeListener isrChangeListener;
    private LogConfig logConfig;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    public TestUtils.MockIsrChangeListener isrChangeListener() {
        return this.isrChangeListener;
    }

    public void isrChangeListener_$eq(TestUtils.MockIsrChangeListener x$1) {
        this.isrChangeListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.time()));
        this.logManager().startup();
        this.alterIsrManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.isrChangeListener_$eq(TestUtils$.MODULE$.createIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager()));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)this.createLogProperties((Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public AbstractPartitionTest() {
        this.brokerId = 101;
    }
}

