/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.test.ProducerCompressionTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\n\u0015\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\u0006a\u0001!\t!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019Y\u0004\u0001)A\u0005o!9A\b\u0001b\u0001\n\u0013i\u0004BB#\u0001A\u0003%a\bC\u0004G\u0001\t\u0007I\u0011\u0002\u001c\t\r\u001d\u0003\u0001\u0015!\u00038\u0011\u001dA\u0005\u00011A\u0005\n%Cqa\u0014\u0001A\u0002\u0013%\u0001\u000b\u0003\u0004W\u0001\u0001\u0006KA\u0013\u0005\u0006/\u0002!\t\u0005\u0017\u0005\u0006E\u0002!\t\u0005\u0017\u0005\u0006O\u0002!\t\u0001W\u0004\u0006wRA\t\u0001 \u0004\u0006'QA\t! \u0005\u0007aA!\t!a\u0001\t\u000f\u0005\u0015\u0001\u0003\"\u0001\u0002\b\t9\u0002K]8ek\u000e,'oQ8naJ,7o]5p]R+7\u000f\u001e\u0006\u0003+Y\tA\u0001^3ti*\u0011q\u0003G\u0001\u0004CBL'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?a\t!A_6\n\u0005\u0005r\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/A\u0006d_6\u0004(/Z:tS>t\u0007C\u0001\u0013.\u001d\t)3\u0006\u0005\u0002'S5\tqE\u0003\u0002)5\u00051AH]8pizR\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\na\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A&K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\"\u0004CA\u001a\u0001\u001b\u0005!\u0002\"\u0002\u0012\u0003\u0001\u0004\u0019\u0013\u0001\u00032s_.,'/\u00133\u0016\u0003]\u0002\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005)Ao\u001c9jGV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!A\f!\u0002\rQ|\u0007/[2!\u0003)qW/\u001c*fG>\u0014Hm]\u0001\f]Vl'+Z2pe\u0012\u001c\b%\u0001\u0004tKJ4XM]\u000b\u0002\u0015B\u00111*T\u0007\u0002\u0019*\u0011\u0001\nG\u0005\u0003\u001d2\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005E#\u0006C\u0001\u001dS\u0013\t\u0019\u0016F\u0001\u0003V]&$\bbB+\u000b\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0014aB:feZ,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002#\"\u0012AB\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bQA[;oSRT\u0011aX\u0001\u0004_J<\u0017BA1]\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u000eIB\u00111,Z\u0005\u0003Mr\u0013Q!\u00114uKJ\fq\u0002^3ti\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003\u001d%\u0004\"a\u00176\n\u0005-d&\u0001\u0002+fgRDC\u0001A7tiB\u0011a.]\u0007\u0002_*\u0011\u0001\u000fX\u0001\u0007eVtg.\u001a:\n\u0005I|'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002kB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010X\u0001\beVtg.\u001a:t\u0013\tQxOA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0001\u0018!J|G-^2fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgR\u0004\"a\r\t\u0014\u0005Aq\bC\u0001\u001d\u0000\u0013\r\t\t!\u000b\u0002\u0007\u0003:L(+\u001a4\u0015\u0003q\f!\u0002]1sC6,G/\u001a:t+\t\tI\u0001\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004C\u0003\u0011)H/\u001b7\n\t\u0005M\u0011Q\u0002\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003\u0002\u001d\u0002\u0018\rJ1!!\u0007*\u0005\u0015\t%O]1zQ\u001d\u0011\u0012QDA\u001c\u0003s\u0001B!a\b\u000229!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004M\u0005\u001d\u0012\"A0\n\u0005us\u0016B\u0001=]\u0013\r\tyc^\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005M\u0012Q\u0007\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\u0018o\u0006!a.Y7fC\t\tY$A\u000f|S:$W\r_?!G>l\u0007O]3tg&|g\u000eV=qK\u0002j\u0004e\u001f\u0019~\u0001")
public class ProducerCompressionTest
extends ZooKeeperTestHarness {
    private final String compression;
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaServer server;

    @Parameterized.Parameters(name="{index} compressionType = {0}")
    public static Collection<String[]> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$));
        super.tearDown();
    }

    @Test
    public void testCompression() {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", this.compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11());
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            IndexedSeq messageValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, this.numRecords()).map((Function1 & Serializable & scala.Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long now = System.currentTimeMillis();
            ((TraversableLike)((IndexedSeq)messageValues.map((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((TraversableLike)((IterableLike)messageValues.zip(records, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null && (Tuple2)check$ifrefutable$2._1() != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        if (x$1 != null) {
            Future future = (Future)x$1._1();
            Assert.assertEquals((long)x$1._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        if (x$2 != null) {
            Tuple2 tuple2 = (Tuple2)x$2._1();
            int index = x$2._2$mcI$sp();
            if (tuple2 != null) {
                String messageValue = (String)tuple2._1();
                ConsumerRecord record = (ConsumerRecord)tuple2._2();
                Assert.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)now$1, (long)record.timestamp());
                Assert.assertEquals((long)index, (long)record.offset());
                return;
            }
        }
        throw new MatchError((Object)x$2);
    }

    public ProducerCompressionTest(String compression) {
        this.compression = compression;
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
        this.server = null;
    }
}

