/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.api.ConsumerTopicCreationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\n\u0014\u0001aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tM\u0001\u0011\t\u0011)A\u0005=!)q\u0005\u0001C\u0001Q!)A\u0006\u0001C)[!9A\u0007\u0001b\u0001\n\u0003)\u0004BB\u001d\u0001A\u0003%a\u0007C\u0004;\u0001\t\u0007I\u0011A\u001b\t\rm\u0002\u0001\u0015!\u00037\u0011\u001da\u0004A1A\u0005\u0002UBa!\u0010\u0001!\u0002\u00131\u0004b\u0002 \u0001\u0005\u0004%\t!\u000e\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001c\t\u000b\u0001\u0003A\u0011A!\b\u000bu\u001b\u0002\u0012\u00010\u0007\u000bI\u0019\u0002\u0012A0\t\u000b\u001dzA\u0011A2\t\u000b\u0011|A\u0011A3\u00033\r{gn];nKJ$v\u000e]5d\u0007J,\u0017\r^5p]R+7\u000f\u001e\u0006\u0003)U\t1!\u00199j\u0015\u00051\u0012!B6bM.\f7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003MI!\u0001H\n\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fQD\u0019:pW\u0016\u0014\u0018)\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u001d\u0011un\u001c7fC:\fQdY8ogVlWM]!mY><\u0018)\u001e;p\u0007J,\u0017\r^3U_BL7m]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%R3\u0006\u0005\u0002\u001b\u0001!)Qd\u0001a\u0001=!)ae\u0001a\u0001=\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$aA%oi\u00069Ao\u001c9jG~\u000bT#\u0001\u001c\u0011\u0005}9\u0014B\u0001\u001d!\u0005\u0019\u0019FO]5oO\u0006AAo\u001c9jG~\u000b\u0004%A\u0004u_BL7m\u0018\u001a\u0002\u0011Q|\u0007/[2`e\u0001\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u0002+Q,7\u000f^!vi>$v\u000e]5d\u0007J,\u0017\r^5p]R\t!\t\u0005\u00020\u0007&\u0011A\t\r\u0002\u0005+:LG\u000f\u000b\u0002\u000e\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055C%\u0001\u0002+fgRDC\u0001A(V-B\u0011\u0001kU\u0007\u0002#*\u0011!\u000bS\u0001\u0007eVtg.\u001a:\n\u0005Q\u000b&a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!\fS\u0001\beVtg.\u001a:t\u0013\ta\u0016LA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0001\u001a\u0007>t7/^7feR{\u0007/[2De\u0016\fG/[8o)\u0016\u001cH\u000f\u0005\u0002\u001b\u001fM\u0011q\u0002\u0019\t\u0003_\u0005L!A\u0019\u0019\u0003\r\u0005s\u0017PU3g)\u0005q\u0016A\u00039be\u0006lW\r^3sgV\ta\rE\u0002hU2l\u0011\u0001\u001b\u0006\u0003S\n\nA!\u001e;jY&\u00111\u000e\u001b\u0002\u000b\u0007>dG.Z2uS>t\u0007cA\u0018n_&\u0011a\u000e\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003?AL!!\u001d\u0011\u0003\r=\u0013'.Z2uQ\u0019\t2/a\u0002\u0002\nA\u0019A/!\u0001\u000f\u0005UthB\u0001<~\u001d\t9HP\u0004\u0002yw6\t\u0011P\u0003\u0002{/\u00051AH]8pizJ\u0011aS\u0005\u0003\u0013*K!A\u0017%\n\u0005}L\u0016!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002\u0004\u0005\u0015!A\u0003)be\u0006lW\r^3sg*\u0011q0W\u0001\u0005]\u0006lW-\t\u0002\u0002\f\u0005\u0011$M]8lKJ$v\u000e]5d\u0007J,\u0017\r^5p]vZ\b' \u0017!G>t7/^7feR{\u0007/[2De\u0016\fG/[8o{m\fT\u0010")
public class ConsumerTopicCreationTest
extends IntegrationTestHarness {
    private final Boolean brokerAutoTopicCreationEnable;
    private final Boolean consumerAllowAutoCreateTopics;
    private final String topic_1;
    private final String topic_2;
    private final String producerClientId;
    private final String consumerClientId;

    @Parameterized.Parameters(name="brokerTopicCreation={0}, consumerTopicCreation={1}")
    public static Collection<Object[]> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic_1() {
        return this.topic_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTopicCreation() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, (short)1))).all().get();
        producer.send(record).get();
        consumer.subscribe(Arrays.asList((Object[])new String[]{this.topic_1(), this.topic_2()}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerTopicCreationTest.$anonfun$testAutoTopicCreation$1(consumer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ConsumerTopicCreationTest.$anonfun$testAutoTopicCreation$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        KafkaZkClient qual$1 = this.zkClient();
        boolean x$1 = qual$1.getAllTopicsInCluster$default$1();
        boolean topicCreated = qual$1.getAllTopicsInCluster(x$1).contains((Object)this.topic_2());
        if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
            Assert.assertTrue((boolean)topicCreated);
            return;
        }
        Assert.assertFalse((boolean)topicCreated);
    }

    public static final /* synthetic */ boolean $anonfun$testAutoTopicCreation$1(KafkaConsumer consumer$1) {
        return consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
    }

    public static final /* synthetic */ String $anonfun$testAutoTopicCreation$2() {
        return "Timed out waiting to consume";
    }

    public ConsumerTopicCreationTest(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
        this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
    }
}

