/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u0013&\u0001)BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001A\u0002\u0013\u0005A\bC\u0004L\u0001\u0001\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015)\u0003>\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015y\u0006\u0001\"\u0003a\u0011%\t9\u0002AI\u0001\n\u0013\tI\u0002\u0003\u0004`\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0005\u0002n\u0001\t\n\u0011\"\u0003\u0002p!9\u00111\u000f\u0001\u0005\n\u0005U\u0004\"CA>\u0001E\u0005I\u0011BA?\u0011%\t\t\t\u0001b\u0001\n\u0003\t\u0019\tC\u0004\u0002\u0006\u0002\u0001\u000b\u0011\u00028\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0005\u0002CAK\u0001\u0001\u0006I!a#\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005e\u0005\u0002CAN\u0001\u0001\u0006I!!\u0001\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0005\u0002CAS\u0001\u0001\u0006I!!)\t\r\u0005\u001d\u0006\u0001\"\u0001V\u0011\u0019\t\t\f\u0001C\u0001+\"1\u0011Q\u0017\u0001\u0005\u0002UCq!!/\u0001\t\u0013\tY\f\u0003\u0004\u0002T\u0002!\t!\u0016\u0005\u0007\u0003/\u0004A\u0011A+\t\r\u0005m\u0007\u0001\"\u0001V\u0011\u0019\ty\u000e\u0001C\u0001+\"1\u00111\u001d\u0001\u0005\u0002UCa!a:\u0001\t\u0003)\u0006BBAv\u0001\u0011\u0005Q\u000b\u0003\u0004\u0002p\u0002!\t!\u0016\u0005\u0007\u0003g\u0004A\u0011A+\u0003SA\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7i\\7nC:$G+Z:u\u0015\t1s%A\u0003bI6LgNC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\tqs%\u0001\u0002{W&\u0011\u0001'\f\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0013!B;uS2\u001c\u0018B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0013\u0002\u000fM,'O^3sgV\tQ\bE\u0002?\u0007\u0016k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#@\u0005\r\u0019V-\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001e\naa]3sm\u0016\u0014\u0018B\u0001&H\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u001bF\u0003\"AT(\u000e\u0003\u0005K!\u0001U!\u0003\tUs\u0017\u000e\u001e\u0005\b%\u000e\t\t\u00111\u0001>\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001NQ\t)q\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006)!.\u001e8ji*\tA,A\u0002pe\u001eL!AX-\u0003\u000b\u00053G/\u001a:\u00023\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u000b\u0005\u001b\u0006\f9\u0001C\u0003c\r\u0001\u00071-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0011\\gn\u001e\b\u0003K&\u0004\"AZ!\u000e\u0003\u001dT!\u0001[\u0015\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0017)\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u00141!T1q\u0015\tQ\u0017\t\u0005\u0002pk6\t\u0001O\u0003\u0002re\u000611m\\7n_:T!\u0001K:\u000b\u0005Q\\\u0016AB1qC\u000eDW-\u0003\u0002wa\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002=~\u0003\u0003q!!_>\u000f\u0005\u0019T\u0018\"\u0001\"\n\u0005q\f\u0015a\u00029bG.\fw-Z\u0005\u0003}~\u0014A\u0001T5ti*\u0011A0\u0011\t\u0004\u001d\u0006\r\u0011bAA\u0003\u0003\n\u0019\u0011J\u001c;\t\u0013\u0005%a\u0001%AA\u0002\u0005-\u0011AC1vi\"|'/\u001b>feB)a*!\u0004\u0002\u0012%\u0019\u0011qB!\u0003\r=\u0003H/[8o!\r!\u00171C\u0005\u0004\u0003+i'AB*ue&tw-A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m!\u0006BA\u0006\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S\t\u0015AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0006\u001b\u0006E\u0012Q\u0007\u0005\u0007\u0003gA\u0001\u0019A2\u00021A\f'\u000f^5uS>t7/\u00118e\u0003N\u001c\u0018n\u001a8nK:$8\u000fC\u0004\u00028!\u0001\r!!\u000f\u0002\u001b\t\u0014xn[3s\u0007>tg-[4t!\u0011q4)a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!Q\u000f^5m\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u00031\u0011w.\u001e8dKN+'O^3s)\u0015i\u0015qJA*\u0011\u001d\t\t&\u0003a\u0001\u0003\u0003\tA\u0002^1sO\u0016$8+\u001a:wKJDa!!\u0016\n\u0001\u0004q\u0017!\u00039beRLG/[8o\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\u0011\u00111\f\t\u0005\u001d\u00065Q)A\u0006bo\u0006LG\u000fT3bI\u0016\u0014HCBA\u0001\u0003C\n\u0019\u0007C\u0003c\u0017\u0001\u0007a\u000eC\u0005\u0002f-\u0001\n\u00111\u0001\u0002h\u0005IA/[7f_V$Xj\u001d\t\u0004\u001d\u0006%\u0014bAA6\u0003\n!Aj\u001c8h\u0003U\tw/Y5u\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u001d+\t\u0005\u001d\u0014QD\u0001\u0010E>|Go\u001d;sCB\u001cVM\u001d<feR!\u0011\u0011CA<\u0011%\tI(\u0004I\u0001\u0002\u0004\t\t!\u0001\u0004ce>\\WM]\u0001\u001aE>|Go\u001d;sCB\u001cVM\u001d<fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0000)\"\u0011\u0011AA\u000f\u00035!Xm\u001d;QCJ$\u0018\u000e^5p]V\ta.\u0001\buKN$\b+\u0019:uSRLwN\u001c\u0011\u0002/Q,7\u000f\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$XCAAF!\u0019\ti)a%\u0002\u00025\u0011\u0011q\u0012\u0006\u0004\u0003#{\u0014!C5n[V$\u0018M\u00197f\u0013\rq\u0018qR\u0001\u0019i\u0016\u001cH\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0013\u0001\b;fgR\u0004\u0016M\u001d;ji&|g\u000e\u0015:fM\u0016\u0014(/\u001a3MK\u0006$WM]\u000b\u0003\u0003\u0003\tQ\u0004^3tiB\u000b'\u000f^5uS>t\u0007K]3gKJ\u0014X\r\u001a'fC\u0012,'\u000fI\u0001\u001bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8B]\u0012\f5o]5h]6,g\u000e^\u000b\u0003\u0003C\u0003r!!$\u0002$:\fY)C\u0002m\u0003\u001f\u000b1\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3BgNLwM\\7f]R\u0004\u0013\u0001\u0007;fgRlU\u000f\u001c;ja2,'I]8lKJ\u001cx)\u001b<f]\"\u001aq#a+\u0011\u0007a\u000bi+C\u0002\u00020f\u0013A\u0001V3ti\u00061B/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:HSZ,g\u000eK\u0002\u0019\u0003W\u000bQ\u0003^3ti:{\u0007+\u0019:uSRLwN\\:HSZ,g\u000eK\u0002\u001a\u0003W\u000b!\u0002^8Kg>tg)\u001b7f)\u0011\ti,!3\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002D\u0005\u0011\u0011n\\\u0005\u0005\u0003\u000f\f\tM\u0001\u0003GS2,\u0007bBAf5\u0001\u0007\u0011QZ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u00023\u0002P:L1!!5n\u0005\r\u0019V\r^\u0001\u001ci\u0016\u001cHoU5oO2,Go\u001c8QCJ$\u0018\u000e^5p]\u001eKg/\u001a8)\u0007m\tY+A\u000buKN$Hk\u001c9jG\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007q\tY+\u0001\u0013uKN$X*\u001e7uSBdW\rU1si&$\u0018n\u001c8t'\u0006lW-Q:tS\u001etW.\u001a8uQ\ri\u00121V\u0001\u0011i\u0016\u001cHOT8pa\u0016cWm\u0019;j_:D3AHAV\u0003}!Xm\u001d;XSRDwJ\u001a4mS:,\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019\u0015\u0004?\u0005-\u0016a\u0003;fgR$\u0016.\\3pkRD3\u0001IAV\u0003A!Xm\u001d;BkRD'PR1jYV\u0014X\rK\u0002\"\u0003W\u000bA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f'j]8o\t\u0006$\u0018\rK\u0002#\u0003W\u000b\u0011\u0005^3ti\n\u000b7/[2Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:D3aIAV\u0001")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("auto.leader.rebalance.enable", "false"));
        if (authorizer instanceof Some) {
            String className = (String)((Some)authorizer).value();
            brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("authorizer.class.name", className));
        } else if (!None$.MODULE$.equals(authorizer)) {
            throw new MatchError(authorizer);
        }
        this.createTestTopicAndCluster(topicPartition, brokerConfigs);
    }

    /*
     * WARNING - void declaration
     */
    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        partitionsAndAssignments.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$5(this, partitionsAndAssignments)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Shutting down server ").append(targetServer).append(" so a non-preferred replica becomes leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Starting server ").append(targetServer).append(" now that a non-preferred replica is leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$3(this, partition, targetServer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$6(partition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$getController$1(p)));
    }

    /*
     * WARNING - void declaration
     */
    private int awaitLeader(TopicPartition topicPartition, long timeoutMs) {
        void awaitValue_func;
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
            Option option = ((KafkaServer)this.servers().head()).metadataCache().getPartitionInfo(topicPartition.topic(), topicPartition.partition());
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)map_this.get()).leader()));
            return object;
        };
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ awaitValue_this = testUtils$;
        ObjectRef awaitValue_value = ObjectRef.create((Object)None$.MODULE$);
        long awaitValue_waitUntilTrue_pause = awaitValue_this.waitUntilTrue$default$4();
        long awaitValue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$awaitValue$1(awaitValue_value, (Function0)awaitValue_func)) {
            if (System.currentTimeMillis() > awaitValue_waitUntilTrue_startTime + timeoutMs) {
                throw Assertions$.MODULE$.fail(PreferredReplicaLeaderElectionCommandTest.$anonfun$awaitLeader$3(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(timeoutMs, awaitValue_waitUntilTrue_pause));
        }
        return BoxesRunTime.unboxToInt((Object)((Option)awaitValue_value.elem).get());
    }

    private long awaitLeader$default$2() {
        return 15000L;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Server bound to port ").append(port).toString());
        return new StringBuilder(10).append("localhost:").append(port).toString();
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", new StringBuilder(1).append(this.bootstrapServer(1)).append(",").append(this.bootstrapServer(0)).toString()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    @Test
    public void testInvalidBrokerGiven() {
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", "example.com:1234"}), 1000);
            Assert.fail();
            return;
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
            return;
        }
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1())}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(scala.collection.immutable.Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = TestUtils$.MODULE$.stringifyTopicPartitions(partitions);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Using json: ").append(jsonString).toString());
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDoesNotExist() {
        void $minus$greater$extension_$this;
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)nonExistentPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)nonExistentPartitionAssignment);
        scala.collection.immutable.Map nonExistentPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiplePartitionsSameAssignment() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)testPartitionA);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)testPartitionAssignment);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)testPartitionB);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)testPartitionAssignment);
        scala.collection.immutable.Map testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.createTestTopicAndCluster((scala.collection.immutable.Map<TopicPartition, List<Object>>)testPartitionAndAssignment, this.createTestTopicAndCluster$default$2());
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, this.awaitLeader$default$2()));
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, this.awaitLeader$default$2()));
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, this.awaitLeader$default$2()));
    }

    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Throwable suppressed = e.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assert.assertTrue((String)suppressed.getMessage(), (boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}), 2000);
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"Timeout waiting for election results", (Object)e.getMessage());
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), this.awaitLeader$default$2());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"Not authorized to perform leader election", (Object)e.getMessage());
                Assert.assertTrue((boolean)(e.getCause() instanceof ClusterAuthorizationException));
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), this.awaitLeader$default$2()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), (Set)partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicPreferredReplicaElection() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Tuple2[] tuple2Array = new Tuple2[1];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String topic = "test";
        int partition = 0;
        int preferredReplica = 0;
        Tuple2[] tuple2Array2 = new Tuple2[3];
        String string = "rack0";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string2 = "rack1";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "rack2";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map brokerRack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        int x$1 = 3;
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)brokerRack, x$13, x$14, x$15, x$16).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$18 = new Properties();
        boolean x$20 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment(topic, x$18, (Map)expectedReplicaAssignment, x$20);
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)serverConfigs.reverse()).map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        KafkaZkClient x$21 = this.zkClient();
        None$ x$24 = None$.MODULE$;
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, topic, partition, x$25, (Option<Object>)x$24, x$26);
        new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)}))).moveLeaderToPreferredReplica();
        KafkaZkClient x$27 = this.zkClient();
        Some x$30 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$32 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$27, topic, partition, x$31, (Option<Object>)x$30, x$32);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$createTestTopicAndCluster$4(PreferredReplicaLeaderElectionCommandTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            void $minus$greater$extension_$this;
            TopicPartition tp = (TopicPartition)x0$1._1();
            List assignment = (List)x0$1._2();
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
            $this.zkClient().createTopicAssignment(tp.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$7(KafkaServer server$1, Tuple2 partitionAndAssignment) {
        LogManager qual$1 = server$1.getLogManager();
        TopicPartition x$1 = (TopicPartition)partitionAndAssignment._1();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(PreferredReplicaLeaderElectionCommandTest $this, scala.collection.immutable.Map partitionsAndAssignments$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)partitionsAndAssignments$1.forall((Function1 & Serializable & scala.Serializable)partitionAndAssignment -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$7(server, partitionAndAssignment)))));
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$8() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$5(int targetServer$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        return partitionState.isr().contains(BoxesRunTime.boxToInteger((int)targetServer$1));
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$4(TopicPartition partition$1, int targetServer$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState updateMetadataPartitionState;
        Option option = server.metadataCache().getPartitionInfo(partition$1.topic(), partition$1.partition());
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$5(targetServer$1, updateMetadataPartitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)exists_this.get());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$3(PreferredReplicaLeaderElectionCommandTest $this, TopicPartition partition$1, int targetServer$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$4(partition$1, targetServer$1, server)));
    }

    public static final /* synthetic */ String $anonfun$bounceServer$6(TopicPartition partition$1) {
        return new StringBuilder(35).append("Replicas for partition ").append(partition$1).append(" not created").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(KafkaServer p) {
        return p.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$awaitLeader$3(TopicPartition topicPartition$1) {
        return new StringBuilder(44).append("Timed out waiting to find current leader of ").append(topicPartition$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public PreferredReplicaLeaderElectionCommandTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        List<Object> list = this.testPartitionAssignment();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.testPartition());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public static final /* synthetic */ Object $anonfun$bounceServer$5$adapted(int targetServer$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        return BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$5(targetServer$1, partitionState));
    }

    public static final /* synthetic */ Object $anonfun$awaitLeader$2$adapted(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return BoxesRunTime.boxToInteger((int)x$1.leader());
    }
}

