/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Exit$;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r%a\u0001\u0002\"D\u0001!CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001A\u0002\u0013\u0005!\fC\u0004p\u0001\u0001\u0007I\u0011\u00019\t\r]\u0004\u0001\u0015)\u0003\\\u0011\u001dA\bA1A\u0005\neDq!a\u0005\u0001A\u0003%!\u0010C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u0011\u0011\u0006\u0001!\u0002\u0013\tI\u0002C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011\u0011\t\u0001!\u0002\u0013\ty\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011\u0011\u000b\u0001!\u0002\u0013\t9\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u00111\r\u0001!\u0002\u0013\t9\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u00111\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002h!A\u00111\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002|!A\u0011q\u0013\u0001!\u0002\u0013\ti\bC\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0003\u0002\u001c\"A\u00111\u0017\u0001!\u0002\u0013\ti\nC\u0004\u00026\u0002!I!a.\t\u0013\u00055\u0007!%A\u0005\n\u0005=\u0007\"CAs\u0001\t\u0007I\u0011BAt\u0011!\tI\u000f\u0001Q\u0001\n\u0005e\u0006\"CAv\u0001\t\u0007I\u0011BAw\u0011!\t)\u0010\u0001Q\u0001\n\u0005=\bbCA|\u0001\u0001\u0007\t\u0019!C\u0005\u0003sD1Ba\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\n!Y!Q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA~\u0011-\u0011y\u0001\u0001a\u0001\u0002\u0004%IA!\u0005\t\u0017\tM\u0001\u00011AA\u0002\u0013%!Q\u0003\u0005\f\u00053\u0001\u0001\u0019!A!B\u0013\t\t\nC\u0006\u0003\u001c\u0001\u0001\r\u00111A\u0005\n\tE\u0001b\u0003B\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0005?A1Ba\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0012\"9!Q\u0005\u0001\u0005B\t\u001d\u0002b\u0002B\u001c\u0001\u0011\u0005#q\u0005\u0005\b\u0005\u0003\u0002A\u0011\u0001B\u0014\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005OAqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0005\u0003j\u0001\t\n\u0011\"\u0003\u0003l!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0011\u001d\u0011)\n\u0001C\u0001\u0005OAqA!'\u0001\t\u0003\u00119\u0003C\u0004\u0003\u001e\u0002!\tAa\n\t\u000f\t\u0005\u0006\u0001\"\u0003\u0003$\"9!q\u0015\u0001\u0005\u0002\t\u001d\u0002b\u0002BV\u0001\u0011\u0005!q\u0005\u0005\b\u0005_\u0003A\u0011\u0002BY\u0011\u001d\u0011)\f\u0001C\u0001\u0005OAqAa1\u0001\t\u0003\u00119\u0003C\u0004\u0003H\u0002!IA!3\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!Q\u001d\u0001\u0005\n\t\u001d\bb\u0002Bv\u0001\u0011%!Q\u001e\u0002\u000f\u0003\u000ed7i\\7nC:$G+Z:u\u0015\t!U)A\u0003bI6LgNC\u0001G\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A%P!\tQU*D\u0001L\u0015\taU)\u0001\u0002{W&\u0011aj\u0013\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005A\u001bV\"A)\u000b\u0005I+\u0015!B;uS2\u001c\u0018B\u0001+R\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A,\u0011\u0005a\u0003Q\"A\"\u0002\u000fM,'O^3sgV\t1\fE\u0002]M&t!!X2\u000f\u0005y\u000bW\"A0\u000b\u0005\u0001<\u0015A\u0002\u001fs_>$h(C\u0001c\u0003\u0015\u00198-\u00197b\u0013\t!W-A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\tL!a\u001a5\u0003\u0007M+\u0017O\u0003\u0002eKB\u0011!.\\\u0007\u0002W*\u0011A.R\u0001\u0007g\u0016\u0014h/\u001a:\n\u00059\\'aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0011/\u001e\t\u0003eNl\u0011!Z\u0005\u0003i\u0016\u0014A!\u00168ji\"9aoAA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%A\u0005qe&t7-\u001b9bYV\t!\u0010E\u0002|\u0003\u001fi\u0011\u0001 \u0006\u0003{z\fA!Y;uQ*\u0019q0!\u0001\u0002\u0011M,7-\u001e:jifTA!a\u0001\u0002\u0006\u000511m\\7n_:T1ARA\u0004\u0015\u0011\tI!a\u0003\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti!A\u0002pe\u001eL1!!\u0005}\u00059Y\u0015MZ6b!JLgnY5qC2\f!\u0002\u001d:j]\u000eL\u0007/\u00197!\u0003\u0015)6/\u001a:t+\t\tI\u0002E\u0003\u0002\u001c\u0005\u0015\"0\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%IW.\\;uC\ndWMC\u0002\u0002$\u0015\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\b\u0003\u0007M+G/\u0001\u0004Vg\u0016\u00148\u000fI\u0001\u0006\u0011>\u001cHo]\u000b\u0003\u0003_\u0001b!a\u0007\u0002&\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0005Y\u0006twM\u0003\u0002\u0002<\u0005!!.\u0019<b\u0013\u0011\ty$!\u000e\u0003\rM#(/\u001b8h\u0003\u0019Aun\u001d;tA\u0005\u0001\u0012\t\u001c7po\"{7\u000f^\"p[6\fg\u000eZ\u000b\u0003\u0003\u000f\u0002RA]A%\u0003cI1!a\u0013f\u0005\u0015\t%O]1z\u0003E\tE\u000e\\8x\u0011>\u001cHoQ8n[\u0006tG\rI\u0001\u0010\t\u0016t\u0017\u0010S8ti\u000e{W.\\1oI\u0006\u0001B)\u001a8z\u0011>\u001cHoQ8n[\u0006tG\rI\u0001\u0010\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dKV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)!\u0011QLA\u0001\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA1\u00037\u0012qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0011\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\na\u0002V8qS\u000e\u0014Vm]8ve\u000e,7/\u0006\u0002\u0002jA1\u00111DA\u0013\u0003/\nq\u0002V8qS\u000e\u0014Vm]8ve\u000e,7\u000fI\u0001\u000f\u000fJ|W\u000f\u001d*fg>,(oY3t\u0003=9%o\\;q%\u0016\u001cx.\u001e:dKN\u0004\u0013\u0001\u0007+sC:\u001c\u0018m\u0019;j_:\fG.\u00133SKN|WO]2fg\u0006IBK]1og\u0006\u001cG/[8oC2LEMU3t_V\u00148-Z:!\u00039!vn[3o%\u0016\u001cx.\u001e:dKN\fq\u0002V8lK:\u0014Vm]8ve\u000e,7\u000fI\u0001\u0012%\u0016\u001cx.\u001e:dKR{7i\\7nC:$WCAA?!!\tY\"a \u0002\u0004\u0006E\u0015\u0002BAA\u0003;\u00111!T1q!\u0019\t))!$\u0002X9!\u0011qQAE!\tqV-C\u0002\u0002\f\u0016\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003\u001fS1!a#f!\u0015\u0011\u0018\u0011JAJ!\u0011\t))!&\n\t\u0005}\u0012qR\u0001\u0013%\u0016\u001cx.\u001e:dKR{7i\\7nC:$\u0007%\u0001\u000bSKN|WO]2f)>|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003;\u0003\u0002\"a\u0007\u0002\u0000\u0005\r\u0015q\u0014\t\be\u0006\u0005\u0016QUAI\u0013\r\t\u0019+\u001a\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005\u0015\u0015QRAT!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BAW\u0003\u0003\t1!Y2m\u0013\u0011\t\t,a+\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\u0002+I+7o\\;sG\u0016$vn\u00149fe\u0006$\u0018n\u001c8tA\u00051\u0002K]8ek\u000e,'OU3t_V\u00148-\u001a+p\u0003\u000ed7\u000f\u0006\u0003\u0002:\u0006\r\u0007\u0003CA\u000e\u0003\u007f\n\u0019)a/\u0011\r\u0005\u0015\u0015QRA_!\u0011\tI+a0\n\t\u0005\u0005\u00171\u0016\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0005\u0002Fv\u0001\n\u00111\u0001\u0002H\u0006\tRM\\1cY\u0016LE-Z7q_R,gnY3\u0011\u0007I\fI-C\u0002\u0002L\u0016\u0014qAQ8pY\u0016\fg.\u0001\u0011Qe>$WoY3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197tI\u0011,g-Y;mi\u0012\nTCAAiU\u0011\t9-a5,\u0005\u0005U\u0007\u0003BAl\u0003Cl!!!7\u000b\t\u0005m\u0017Q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a8f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\fINA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\facQ8ogVlWM\u001d*fg>,(oY3U_\u0006\u001bGn]\u000b\u0003\u0003s\u000bqcQ8ogVlWM\u001d*fg>,(oY3U_\u0006\u001bGn\u001d\u0011\u0002'\rkG\rV8SKN|WO]2fgR{\u0017i\u00197\u0016\u0005\u0005=\b\u0003CA\u000e\u0003\u007f\n\t*!=\u0011\u0011\u0005\u0015\u00151_AB\u0003wKA!!!\u0002\u0010\u0006!2)\u001c3U_J+7o\\;sG\u0016\u001cHk\\!dY\u0002\n1B\u0019:pW\u0016\u0014\bK]8qgV\u0011\u00111 \t\u0005\u0003{\u0014\u0019!\u0004\u0002\u0002\u0000*!!\u0011AA\u001d\u0003\u0011)H/\u001b7\n\t\t\u0015\u0011q \u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018a\u00042s_.,'\u000f\u0015:paN|F%Z9\u0015\u0007E\u0014Y\u0001\u0003\u0005wI\u0005\u0005\t\u0019AA~\u00031\u0011'o\\6feB\u0013x\u000e]:!\u0003\u0019Q8.\u0011:hgV\u0011\u0011\u0011S\u0001\u000bu.\f%oZ:`I\u0015\fHcA9\u0003\u0018!AaoJA\u0001\u0002\u0004\t\t*A\u0004{W\u0006\u0013xm\u001d\u0011\u0002\u0013\u0005$W.\u001b8Be\u001e\u001c\u0018!D1e[&t\u0017I]4t?\u0012*\u0017\u000fF\u0002r\u0005CA\u0001B\u001e\u0016\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u000bC\u0012l\u0017N\\!sON\u0004\u0013!B:fiV\u0003H#A9)\u00071\u0012Y\u0003\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\u0011\u0011\t$a\u0003\u0002\u000b),h.\u001b;\n\t\tU\"q\u0006\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3!\fB\u001e!\u0011\u0011iC!\u0010\n\t\t}\"q\u0006\u0002\u0006\u0003\u001a$XM]\u0001\u0019i\u0016\u001cH/Q2m\u00072Lw+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014\bf\u0001\u0018\u0003FA!!Q\u0006B$\u0013\u0011\u0011IEa\f\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cH/Q2m\u00072Lw+\u001b;i\u0003\u0012l\u0017N\\!Q\u0013\"\u001aqF!\u0012\u0002\u0019\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:\u0015\u0007E\u0014\u0019\u0006C\u0005\u0003VA\u0002\n\u00111\u0001\u0003X\u0005i1m\\7nC:$7i\u001c8gS\u001e\u0004RA\u001dB-\u0005;J1Aa\u0017f\u0005\u0019y\u0005\u000f^5p]B!!q\fB3\u001b\t\u0011\tG\u0003\u0003\u0003d\u0005e\u0012AA5p\u0013\u0011\u00119G!\u0019\u0003\t\u0019KG.Z\u0001\u0017GJ,\u0017\r^3TKJ4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u000e\u0016\u0005\u0005/\n\u0019.\u0001\u0005dC2dW*Y5o)\u0011\u0011\u0019H!\u001e\u0011\u000fI\f\t+a%\u0002\u0014\"9!q\u000f\u001aA\u0002\u0005E\u0015\u0001B1sON\f!\u0002^3ti\u0006\u001bGn\u00117j)\r\t(Q\u0010\u0005\b\u0005\u007f\u001a\u0004\u0019AAI\u0003\u001d\u0019W\u000eZ!sON\fA#Y:tKJ$x*\u001e;qkR\u001cuN\u001c;bS:\u001cH#C9\u0003\u0006\n%%Q\u0012BI\u0011\u001d\u00119\t\u000ea\u0001\u0003'\u000ba\u0001\u001d:fM&D\bb\u0002BFi\u0001\u0007\u00111Q\u0001\ne\u0016\u001cx.\u001e:dKNDqAa$5\u0001\u0004\t\t*A\u0006sKN|WO]2f\u00076$\u0007b\u0002BJi\u0001\u0007\u00111S\u0001\u0007_V$\b/\u001e;\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u00072Lw+\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014\bfA\u001b\u0003F\u0005\u0019C/Z:u!J|G-^2fe\u000e{gn];nKJ\u001cE.[,ji\"\fE-\\5o\u0003BK\u0005f\u0001\u001c\u0003F\u00051B/Z:u\u0003\u000ed7\t\\5XSRD7\t\\5f]RLE\rK\u00028\u0005\u000b\nq\u0003^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u00148\t\\5\u0015\u0007E\u0014)\u000bC\u0004\u0003\u0000a\u0002\r!!%\u0002SQ,7\u000f^!dYN|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3t/&$\b.Q;uQ>\u0014\u0018N_3sQ\rI$QI\u0001(i\u0016\u001cH/Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-Z:XSRD\u0017\tZ7j]\u0006\u0003\u0016\nK\u0002;\u0005\u000b\n1\u0004^3ti\u0006\u001bGn](o!J,g-\u001b=fIJ+7o\\;sG\u0016\u001cHcA9\u00034\"9!qP\u001eA\u0002\u0005E\u0015!\b;fgRLeN^1mS\u0012\fU\u000f\u001e5pe&TXM\u001d)s_B,'\u000f^=)\u000fq\u0012)E!/\u0003<\u0006AQ\r\u001f9fGR,Gm\t\u0002\u0003>B\u0019ALa0\n\u0007\t\u0005\u0007N\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:\f\u0001\u0003^3tiB\u000bG\u000f^3s]RK\b/Z:)\u0007u\u0012)%\u0001\u0006uKN$(+Z7pm\u0016$r!\u001dBf\u0005\u001b\u0014y\rC\u0004\u0003\u0000y\u0002\r!!%\t\u000f\t-e\b1\u0001\u0002\u0004\"9!q\u0012 A\u0002\u0005E\u0015aD4fi\u0006\u001bG\u000eV8D_6l\u0017M\u001c3\u0015\r\tU'q\u001bBq!\u001d\u0011\u0018\u0011UA^\u0003#CqA!7@\u0001\u0004\u0011Y.\u0001\bqKJl\u0017n]:j_:$\u0016\u0010]3\u0011\t\u0005%&Q\\\u0005\u0005\u0005?\fYKA\tBG2\u0004VM]7jgNLwN\u001c+za\u0016DqAa9@\u0001\u0004\t)+\u0001\u0006pa\u0016\u0014\u0018\r^5p]N\faaZ3u\u00076$G\u0003BAI\u0005SDqA!7A\u0001\u0004\u0011Y.\u0001\bxSRD\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\t=HcA9\u0003r\"9!1_!A\u0002\tU\u0018!\u00014\u0011\rI\u00149Pa?r\u0013\r\u0011I0\u001a\u0002\n\rVt7\r^5p]F\u0002BA!@\u0004\u00065\u0011!q \u0006\u0005\u0007\u0003\u0019\u0019!\u0001\u0006bkRDwN]5{KJT1\u0001\\A\u0003\u0013\u0011\u00199Aa@\u0003\u0015\u0005+H\u000f[8sSj,'\u000f")
public class AclCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final scala.collection.immutable.Set<KafkaPrincipal> Users = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final scala.collection.immutable.Set<String> Hosts = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = (String[])((Object[])new String[]{"--allow-host", "host1", "--allow-host", "host2"});
    private final String[] DenyHostCommand = (String[])((Object[])new String[]{"--deny-host", "host1", "--deny-host", "host2"});
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final scala.collection.immutable.Set<ResourcePattern> TopicResources = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final scala.collection.immutable.Set<ResourcePattern> GroupResources = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final scala.collection.immutable.Set<ResourcePattern> TransactionalIdResources = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final scala.collection.immutable.Set<ResourcePattern> TokenResources = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final Map<scala.collection.immutable.Set<ResourcePattern>, String[]> ResourceToCommand;
    private final Map<scala.collection.immutable.Set<ResourcePattern>, Tuple2<scala.collection.immutable.Set<AclOperation>, String[]>> ResourceToOperations;
    private final Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> ConsumerResourceToAcls;
    private final Map<String[], Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>>> CmdToResourcesToAcl;
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private scala.collection.immutable.Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private scala.collection.immutable.Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private scala.collection.immutable.Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private scala.collection.immutable.Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private scala.collection.immutable.Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private scala.collection.immutable.Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private Map<scala.collection.immutable.Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private Map<scala.collection.immutable.Set<ResourcePattern>, Tuple2<scala.collection.immutable.Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    /*
     * WARNING - void declaration
     */
    private Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[3];
        scala.collection.immutable.Set set = AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts());
        Object object = Predef$.MODULE$.ArrowAssoc(this.TopicResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        scala.collection.immutable.Set set2 = AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts());
        Object object2 = Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Set set3 = AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), this.Hosts());
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()})));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private Map<String[], Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq((String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()}));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclCli(this.adminArgs());
    }

    private void createServer(Option<File> commandConfig) {
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(this.brokerProps()), TestUtils$.MODULE$.createServer$default$2()), (List)Nil$.MODULE$));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        String[] adminArgs = (String[])((Object[])new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)});
        if (commandConfig.isDefined()) {
            adminArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])adminArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        this.adminArgs_$eq(adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AclCommand$.MODULE$.main(args);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            void grabConsoleOutputAndError_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, scala.collection.immutable.Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testProducerConsumerCli(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclCliWithClientId() {
        void find_p;
        File adminClientConfig = TestUtils$.MODULE$.tempFile();
        PrintWriter pw = new PrintWriter(adminClientConfig);
        pw.println("client.id=my-client");
        pw.close();
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        ListBuffer<LoggingEvent> listBuffer = appender.getMessages();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e));
        if (listBuffer == null) {
            throw null;
        }
        Option option = listBuffer.underlying().find((Function1)find_p);
        Assert.assertFalse((String)"There should be no warnings about multiple registration of mbeans", (boolean)option.isDefined());
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$9);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        String[] cmd = (String[])((Object[])new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"});
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)aclAuthorizer);
        }
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAuthorizerProperty() {
        String[] args = (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()});
        new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args)).listAcls();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPatternTypes() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$10) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$10);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PatternType.values()));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                PatternType patternType = (PatternType)foreach_this.apply(foreach_i);
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
            }
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private void testRemove(String[] cmdArgs, scala.collection.immutable.Set<ResourcePattern> resources, String[] resourceCmd) {
        Tuple2<String, String> tuple2 = this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String string = (String)tuple2._1();
        String string2 = (String)tuple2._2();
        String out = string;
        String err = string2;
        Assert.assertEquals((Object)"", (Object)out);
        Assert.assertEquals((Object)"", (Object)err);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<scala.collection.immutable.Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, scala.collection.immutable.Set<AclOperation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable & scala.Serializable)(cmd, user) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{principalCmd, user.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, scala.collection.immutable.Set acls$1, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)acls$1, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, scala.collection.immutable.Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<scala.collection.immutable.Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (scala.collection.immutable.Set<AclOperation>)((scala.collection.immutable.Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set set = (scala.collection.immutable.Set)tuple2._1();
        String[] stringArray = (String[])tuple2._2();
        scala.collection.immutable.Set acls = set;
        String[] cmd = stringArray;
        Tuple2<String, String> tuple22 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String string = (String)tuple22._1();
        String string2 = (String)tuple22._2();
        String addOut = string;
        String addErr = string2;
        $this.assertOutputContains("Adding ACLs", (scala.collection.immutable.Set<ResourcePattern>)resources$1, resourceCmd$1, addOut);
        $this.assertOutputContains("Current ACLs", (scala.collection.immutable.Set<ResourcePattern>)resources$1, resourceCmd$1, addOut);
        Assert.assertEquals((Object)"", (Object)addErr);
        resources$1.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testAclCli$4($this, acls, resource);
            return BoxedUnit.UNIT;
        });
        Tuple2<String, String> tuple23 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$colon$plus((Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String string3 = (String)tuple23._1();
        String string4 = (String)tuple23._2();
        String listOut = string3;
        String listErr = string4;
        $this.assertOutputContains("Current ACLs", (scala.collection.immutable.Set<ResourcePattern>)resources$1, resourceCmd$1, listOut);
        Assert.assertEquals((Object)"", (Object)listErr);
        $this.testRemove(cmdArgs$1, (scala.collection.immutable.Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$4) {
        if (x$4 != null) {
            scala.collection.immutable.Set resources = (scala.collection.immutable.Set)x$4._1();
            String[] resourceCmd = (String[])x$4._2();
            ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable & scala.Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$assertOutputContains$2(String x$5) {
        return !x$5.startsWith("--");
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assert.assertTrue((String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString(), (boolean)output$1.contains(expected));
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        String resourceType = resource.resourceType().toString();
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(resource.equals($this.ClusterResource()) ? (Object[])new String[]{"kafka-cluster"} : (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2)).filterImpl((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$assertOutputContains$2(x$5)), false)));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            String string = (String)foreach_this.apply(foreach_i);
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, string);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, scala.collection.immutable.Set acls$2, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)acls$2, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$8) {
        if (x$8 != null) {
            scala.collection.immutable.Set resources = (scala.collection.immutable.Set)x$8._1();
            scala.collection.immutable.Set acls = (scala.collection.immutable.Set)x$8._2();
            resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$9) {
        if (x$9 != null) {
            String[] cmd = (String[])x$9._1();
            Map resourcesToAcls = (Map)x$9._2();
            String[] resourceCommand = (String[])((TraversableOnce)resourcesToAcls.keys().map($this.ResourceToCommand(), Iterable$.MODULE$.canBuildFrom())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.getCmd(AclPermissionType.ALLOW))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$8);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (scala.collection.immutable.Set<ResourcePattern>)((TraversableOnce)resourcesToAcls.keys().flatten((Function1)Predef$.MODULE$.$conforms())).toSet(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$10) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.callMain(cmd), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("AclCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    /*
     * WARNING - void declaration
     */
    public AclCommandTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_$this15;
        void $minus$greater$extension_y16;
        void $minus$greater$extension_$this16;
        void $minus$greater$extension_y17;
        void $minus$greater$extension_$this17;
        Tuple2[] tuple2Array = new Tuple2[5];
        Object[] objectArray = new String[]{"--topic", "test-1", "--topic", "test-2"};
        Object object = Predef$.MODULE$.ArrowAssoc(this.TopicResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)$minus$greater$extension_y17);
        Object[] objectArray2 = new String[]{"--cluster"};
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()})));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y16);
        Object[] objectArray3 = new String[]{"--group", "testGroup-1", "--group", "testGroup-2"};
        Object object3 = Predef$.MODULE$.ArrowAssoc(this.GroupResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y15);
        Object[] objectArray4 = new String[]{"--transactional-id", "t0", "--transactional-id", "t1"};
        Object object4 = Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y14);
        Object[] objectArray5 = new String[]{"--delegation-token", "token1", "--delegation-token", "token2"};
        Object object5 = Predef$.MODULE$.ArrowAssoc(this.TokenResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        this.ResourceToCommand = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Tuple2[] tuple2Array2 = new Tuple2[5];
        Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"});
        Object object6 = Predef$.MODULE$.ArrowAssoc(this.TopicResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        Tuple2 tuple22 = new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"});
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()})));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        Tuple2 tuple23 = new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"});
        Object object8 = Predef$.MODULE$.ArrowAssoc(this.GroupResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        Tuple2 tuple24 = new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"});
        Object object9 = Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        Tuple2 tuple25 = new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"});
        Object object10 = Predef$.MODULE$.ArrowAssoc(this.TokenResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[4] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        this.ResourceToOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Tuple2[] tuple2Array3 = new Tuple2[2];
        scala.collection.immutable.Set set = AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts());
        Object object11 = Predef$.MODULE$.ArrowAssoc(this.TopicResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        scala.collection.immutable.Set set2 = AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts());
        Object object12 = Predef$.MODULE$.ArrowAssoc(this.GroupResources());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        this.ConsumerResourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3));
        Tuple2[] tuple2Array4 = new Tuple2[5];
        Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> map = this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1());
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"});
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> map2 = this.ProducerResourceToAcls(true);
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"});
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Map<scala.collection.immutable.Set<ResourcePattern>, scala.collection.immutable.Set<AccessControlEntry>> map3 = this.ConsumerResourceToAcls();
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"});
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Object object16 = this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                scala.collection.immutable.Set k = (scala.collection.immutable.Set)x0$1._1();
                scala.collection.immutable.Set v = (scala.collection.immutable.Set)x0$1._2();
                Set set = v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1()).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty()));
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Object object17 = Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"});
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[3] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Object object18 = this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$2 != null) {
                scala.collection.immutable.Set k = (scala.collection.immutable.Set)x0$2._1();
                scala.collection.immutable.Set v = (scala.collection.immutable.Set)x0$2._2();
                Set set = v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty()));
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Object object19 = Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"});
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[4] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.CmdToResourcesToAcl = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4));
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPatternTypes$3$adapted(AclCommandTest $this, PatternType patternType) {
        AclCommandTest.$anonfun$testPatternTypes$3($this, patternType);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(scala.collection.immutable.Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)acls$1, authorizer, resource$1, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$assertOutputContains$3$adapted(String prefix$1, String resourceType$1, String output$1, String name) {
        AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType$1, output$1, name);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(scala.collection.immutable.Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)acls$2, authorizer, resource$2, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$3, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$3, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }
}

