/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u000b\u0017\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019Y\u0004\u0001)A\u0005g!9A\b\u0001b\u0001\n\u0003\u0011\u0004BB\u001f\u0001A\u0003%1\u0007C\u0004?\u0001\t\u0007I\u0011A\u0015\t\r}\u0002\u0001\u0015!\u0003+\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005Ca!\u0018\u0001!\u0002\u0013\u0011\u0005b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007O\u0002\u0001\u000b\u0011\u00021\t\u000b!\u0004A\u0011I5\t\u000bQ\u0004A\u0011I;\t\r\u0005\u0005\u0001\u0001\"\u0011v\u0011\u0019\tY\u0001\u0001C\u0001k\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0005\t\"&/\u00198tC\u000e$\u0018n\u001c8t/&$\b.T1y\u0013:4E.[4ii>sW\rV3ti*\u0011q\u0003G\u0001\u0004CBL'BA\r\u001b\u0003\u0015Y\u0017MZ6b\u0015\u0005Y\u0012aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\u00111$\t\u0006\u00023%\u00111\u0005\t\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\n\t\u0003O\u0001i\u0011AF\u0001\u000b]Vl7+\u001a:wKJ\u001cX#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\u0007%sG/A\u0006ok6\u001cVM\u001d<feN\u0004\u0013A\u0002;pa&\u001c\u0017'F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\fue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:t+\u0005\u0011\u0005cA\"I\u00156\tAI\u0003\u0002F\r\u00069Q.\u001e;bE2,'BA$-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0013\u0012\u0013aAQ;gM\u0016\u0014\b\u0003B&V/^k\u0011\u0001\u0014\u0006\u0003\u001b:\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0003\u001fB\u000bqa\u00197jK:$8O\u0003\u0002\u001a#*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0013\t1FJA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004WaS\u0016BA--\u0005\u0015\t%O]1z!\tY3,\u0003\u0002]Y\t!!)\u001f;f\u0003]!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001c\b%\u0001\fue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:t+\u0005\u0001\u0007cA\"ICB!!-Z,X\u001b\u0005\u0019'B\u00013O\u0003!\u0019wN\\:v[\u0016\u0014\u0018B\u00014d\u00055Y\u0015MZ6b\u0007>t7/^7fe\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t!\u000eE\u0002lY:l\u0011AR\u0005\u0003[\u001a\u00131aU3r!\ty'/D\u0001q\u0015\t\t\u0018%\u0001\u0004tKJ4XM]\u0005\u0003gB\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a;VaR\ta\u000f\u0005\u0002,o&\u0011\u0001\u0010\f\u0002\u0005+:LG\u000f\u000b\u0002\u0010uB\u00111P`\u0007\u0002y*\u0011QpU\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u007fr\u0014aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007A\t)\u0001E\u0002|\u0003\u000fI1!!\u0003}\u0005\u0015\te\r^3s\u0003M\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:TS:<G.\u001a\"s_.,'/T1y\u0013:4E.[4ii>sW\rK\u0002\u0012\u0003\u001f\u00012a_A\t\u0013\r\t\u0019\u0002 \u0002\u0005)\u0016\u001cH/A\u0006tKJ4XM\u001d)s_B\u001cHCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010o\u0005!Q\u000f^5m\u0013\u0011\t\u0019#!\b\u0003\u0015A\u0013x\u000e]3si&,7/A\u000ede\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u000b\u0004C\u0006%\u0002bBA\u0016'\u0001\u0007\u0011QF\u0001\u0006OJ|W\u000f\u001d\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001aY5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0012A\u0002\u001fs_>$h(C\u0002\u0002<1\na\u0001\u0015:fI\u00164\u0017b\u0001\u001e\u0002@)\u0019\u00111\b\u0017\u00027\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3s)\rQ\u0015Q\t\u0005\b\u0003\u000f\"\u0002\u0019AA\u0017\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007")
public class TransactionsWithMaxInFlightOneTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTransactionalProducer("transactional-producer");
        this.createReadCommittedConsumer("transactional-group");
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTransactionalProducerSingleBrokerMaxInFlightOne() {
        Assert.assertEquals((long)1L, (long)this.servers().size());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group) {
        void var2_12;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$5, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return var2_12;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        void var2_9;
        Buffer<KafkaServer> x$2 = this.servers();
        int x$3 = 1;
        int x$4 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        long x$5 = TestUtils$.MODULE$.createTransactionalProducer$default$4();
        long x$6 = TestUtils$.MODULE$.createTransactionalProducer$default$5();
        int x$7 = TestUtils$.MODULE$.createTransactionalProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createTransactionalProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$4, x$5, x$6, x$7, x$8, x$3);
        this.transactionalProducers().$plus$eq(producer);
        return var2_9;
    }

    public TransactionsWithMaxInFlightOneTest() {
        this.numServers = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }
}

