/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyKeyValueStoreFacade;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreFacade;

public class StreamThreadStateStoreProvider {
    private final StreamThread streamThread;

    public StreamThreadStateStoreProvider(StreamThread streamThread) {
        this.streamThread = streamThread;
    }

    public <T> List<T> stores(StoreQueryParameters storeQueryParams) {
        String storeName = storeQueryParams.storeName();
        QueryableStoreType queryableStoreType = storeQueryParams.queryableStoreType();
        if (this.streamThread.state() == StreamThread.State.DEAD) {
            return Collections.emptyList();
        }
        StreamThread.State state = this.streamThread.state();
        if (storeQueryParams.staleStoresEnabled() ? state.isAlive() : state == StreamThread.State.RUNNING) {
            Collection<Task> tasks;
            Collection<Task> collection = tasks = storeQueryParams.staleStoresEnabled() ? this.streamThread.allTasks().values() : this.streamThread.activeTasks();
            if (storeQueryParams.partition() != null) {
                for (Task task : tasks) {
                    if (task.id().partition != storeQueryParams.partition() || task.getStore(storeName) == null || !storeName.equals(task.getStore(storeName).name())) continue;
                    Object typedStore = StreamThreadStateStoreProvider.validateAndCastStores(task.getStore(storeName), queryableStoreType, storeName, task.id());
                    return Collections.singletonList(typedStore);
                }
                return Collections.emptyList();
            }
            ArrayList list = new ArrayList();
            for (Task task : tasks) {
                StateStore store = task.getStore(storeName);
                if (store == null) continue;
                Object typedStore = StreamThreadStateStoreProvider.validateAndCastStores(store, queryableStoreType, storeName, task.id());
                list.add(typedStore);
            }
            return list;
        }
        throw new InvalidStateStoreException("Cannot get state store " + storeName + " because the stream thread is " + state + ", not RUNNING" + (storeQueryParams.staleStoresEnabled() ? " or REBALANCING" : ""));
    }

    private static <T> T validateAndCastStores(StateStore store, QueryableStoreType<T> queryableStoreType, String storeName, TaskId taskId) {
        if (store == null) {
            throw new NullPointerException("Expected store not to be null at this point.");
        }
        if (queryableStoreType.accepts(store)) {
            if (!store.isOpen()) {
                throw new InvalidStateStoreException("Cannot get state store " + storeName + " for task " + taskId + " because the store is not open. The state store may have migrated to another instance.");
            }
            if (store instanceof TimestampedKeyValueStore && queryableStoreType instanceof QueryableStoreTypes.KeyValueStoreType) {
                return (T)new ReadOnlyKeyValueStoreFacade((TimestampedKeyValueStore)store);
            }
            if (store instanceof TimestampedWindowStore && queryableStoreType instanceof QueryableStoreTypes.WindowStoreType) {
                return (T)new ReadOnlyWindowStoreFacade((TimestampedWindowStore)store);
            }
            return (T)store;
        }
        throw new InvalidStateStoreException("Cannot get state store " + storeName + " because the queryable store type [" + queryableStoreType.getClass() + "] does not accept the actual store type [" + store.getClass() + "].");
    }
}

