/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r=c\u0001B#G\u0001-CQA\u0015\u0001\u0005\u0002MCqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004f\u0001\u0001\u0006I\u0001\u0017\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0011\u0019i\u0007\u0001)A\u0005Q\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\u0001\u0007I\u0011A;\t\u000fe\u0004\u0001\u0019!C\u0001u\"9\u0011\u0011\u0001\u0001!B\u00131\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gA\u0011\"a \u0001#\u0003%I!!!\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAu\u0001\u0011%\u00111\u001e\u0005\b\u0005c\u0003A\u0011AA\u0003\u0011\u001d\u0011Y\f\u0001C\u0001\u0003\u000bAqAa0\u0001\t\u0003\t)\u0001C\u0004\u0003D\u0002!\t!!\u0002\t\u000f\t\u001d\u0007\u0001\"\u0001\u0002\u0006!9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bs\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0005S\u0004A\u0011AA\u0003\u0011\u001d\u0011i\u000f\u0001C\u0001\u0003\u000bAqA!=\u0001\t\u0003\t)\u0001C\u0004\u0003v\u0002!\t!!\u0002\t\u000f\te\b\u0001\"\u0001\u0002\u0006!9!Q \u0001\u0005\u0002\u0005\u0015\u0001bBB\u0001\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0007\u000b\u0001A\u0011AA\u0003\u0011\u001d\u0019I\u0001\u0001C\u0001\u0003\u000b1a!a>\u0001\t\u0006e\bBCAVE\tU\r\u0011\"\u0001\u0003\u0014!Q!Q\u0003\u0012\u0003\u0012\u0003\u0006I!!,\t\u0015\u0005\u0015'E!f\u0001\n\u0003\u0011\u0019\u0002\u0003\u0006\u0003\u0018\t\u0012\t\u0012)A\u0005\u0003[C!B!\u0007#\u0005+\u0007I\u0011\u0001B\u000e\u0011)\u0011\u0019C\tB\tB\u0003%!Q\u0004\u0005\u000b\u0005K\u0011#Q3A\u0005\u0002\tm\u0001B\u0003B\u0014E\tE\t\u0015!\u0003\u0003\u001e!1!K\tC\u0001\u0005SAqAa\r#\t\u0003\u0011)\u0004C\u0005\u0003H\t\n\t\u0011\"\u0001\u0003J!I!1\u000b\u0012\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u00053\u0012\u0013\u0013!C\u0001\u0005+B\u0011Ba\u0017##\u0003%\tA!\u0018\t\u0013\t\u0005$%%A\u0005\u0002\tu\u0003\"\u0003B2E\u0005\u0005I\u0011\tB3\u0011!\u00119GIA\u0001\n\u0003)\b\"\u0003B5E\u0005\u0005I\u0011\u0001B6\u0011%\u0011)HIA\u0001\n\u0003\u00129\bC\u0005\u0003\u0006\n\n\t\u0011\"\u0001\u0003\b\"I!\u0011\u0013\u0012\u0002\u0002\u0013\u0005#1\u0013\u0005\n\u0005/\u0013\u0013\u0011!C!\u00053C\u0011Ba'#\u0003\u0003%\tE!(\t\u0013\t}%%!A\u0005B\t\u0005v!CB\u0007\u0001\u0005\u0005\t\u0012BB\b\r%\t9\u0010AA\u0001\u0012\u0013\u0019\t\u0002\u0003\u0004Sy\u0011\u00051\u0011\u0006\u0005\n\u00057c\u0014\u0011!C#\u0005;C\u0011ba\u000b=\u0003\u0003%\ti!\f\t\u0013\r]B(%A\u0005\u0002\tu\u0003\"CB\u001dyE\u0005I\u0011\u0001B/\u0011%\u0019Y\u0004PA\u0001\n\u0003\u001bi\u0004C\u0005\u0004Lq\n\n\u0011\"\u0001\u0003^!I1Q\n\u001f\u0012\u0002\u0013\u0005!Q\f\u0002\u0017\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011q\tS\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003%\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001+\u0011\u0005U\u0003Q\"\u0001$\u0002\tQLW.Z\u000b\u00021B\u0011\u0011lY\u0007\u00025*\u00111\fX\u0001\u0006kRLGn\u001d\u0006\u0003;z\u000baaY8n[>t'BA%`\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011T&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0001\u000e\u0005\u0002jW6\t!N\u0003\u0002g9&\u0011AN\u001b\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013AB2p]\u001aLw-F\u0001q!\t)\u0016/\u0003\u0002s\r\nA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005aa.^7DC2d'-Y2lgV\ta\u000f\u0005\u0002No&\u0011\u0001P\u0014\u0002\u0004\u0013:$\u0018\u0001\u00058v[\u000e\u000bG\u000e\u001c2bG.\u001cx\fJ3r)\tYh\u0010\u0005\u0002Ny&\u0011QP\u0014\u0002\u0005+:LG\u000fC\u0004\u0000\u0013\u0005\u0005\t\u0019\u0001<\u0002\u0007a$\u0013'A\u0007ok6\u001c\u0015\r\u001c7cC\u000e\\7\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t1\u0010K\u0002\f\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\t\u0017!\u00026v]&$\u0018\u0002BA\n\u0003\u001b\u0011Q!\u00114uKJ\f\u0001bY1mY\n\f7m\u001b\u000b\u0004w\u0006e\u0001bBA\u000e\u0019\u0001\u0007\u0011QD\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011qDA\u0016\u001d\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\u0011\u00069a.\u001a;x_J\\\u0017\u0002BA\u0015\u0003G\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0002.\u0005=\"\u0001\u0003*fgB|gn]3\u000b\t\u0005%\u00121E\u0001\rEVLG\u000e\u001a*fcV,7\u000f^\u000b\u0005\u0003k\t\t\u0005\u0006\u0004\u00028\u0005}\u0013\u0011\u000f\t\b\u001b\u0006e\u0012QHA-\u0013\r\tYD\u0014\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005}\u0012\u0011\t\u0007\u0001\t\u001d\t\u0019%\u0004b\u0001\u0003\u000b\u0012\u0011\u0001V\t\u0005\u0003\u000f\ni\u0005E\u0002N\u0003\u0013J1!a\u0013O\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'b\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005]\u0013\u0011\u000b\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3tiB!\u0011qDA.\u0013\u0011\ti&a\f\u0003\u000fI+\u0017/^3ti\"9\u0011\u0011M\u0007A\u0002\u0005\r\u0014a\u00022vS2$WM\u001d\t\u0007\u0003K\nY'!\u0010\u000f\t\u0005=\u0013qM\u0005\u0005\u0003S\n\t&A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\ti'a\u001c\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011\u0011NA)\u0011%\t\u0019(\u0004I\u0001\u0002\u0004\t)(\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002x\u0005mTBAA=\u0015\r\t)\u0003X\u0005\u0005\u0003{\nIH\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\fck&dGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t\u0019)!'\u0016\u0005\u0005\u0015%\u0006BA;\u0003\u000f[#!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003's\u0015AC1o]>$\u0018\r^5p]&!\u0011qSAG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0003\u0007r!\u0019AA#\u0003-i\u0017-\u001f2f%\u0016\u001cwN\u001d3\u0015\u0013Y\fy*!+\u0002D\u0006\u001d\u0007bBAQ\u001f\u0001\u0007\u00111U\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004+\u0006\u0015\u0016bAAT\r\n\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\tYk\u0004a\u0001\u0003[\u000bA!^:feB!\u0011qVA_\u001d\u0011\t\t,!/\u0011\u0007\u0005Mf*\u0004\u0002\u00026*\u0019\u0011q\u0017&\u0002\rq\u0012xn\u001c;?\u0013\r\tYLT\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0016\u0011\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mf\nC\u0004\u0002F>\u0001\r!!,\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!!3\u0010\u0001\u0004\tY-A\u0003wC2,X\rE\u0002N\u0003\u001bL1!a4O\u0005\u0019!u.\u001e2mK\u0006AA\u000f\u001b:piRdW\rF\u0006|\u0003+\f9.!7\u0002\\\u0006}\u0007bBAQ!\u0001\u0007\u00111\u0015\u0005\b\u0003W\u0003\u0002\u0019AAW\u0011\u001d\t)\r\u0005a\u0001\u0003[Ca!!8\u0011\u0001\u00041\u0018A\u0004;ie>$H\u000f\\3US6,Wj\u001d\u0005\b\u0003C\u0004\u0002\u0019AAr\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\r5\u000b)/!\b|\u0013\r\t9O\u0014\u0002\n\rVt7\r^5p]F\n\u0001\u0003^3tiF+x\u000e^1QCJ\u001c\u0018N\\4\u0015\u0017m\fi/a<\u0003&\n%&Q\u0016\u0005\u0006]F\u0001\r\u0001\u001d\u0005\b\u0003c\f\u0002\u0019AAz\u0003\u001d\u0019G.[3oiF\u00022!!>#\u001b\u0005\u0001!AC+tKJ\u001cE.[3oiN1!\u0005TA~\u0005\u0003\u00012!TA\u007f\u0013\r\tyP\u0014\u0002\b!J|G-^2u!\u0011\u0011\u0019A!\u0004\u000f\t\t\u0015!\u0011\u0002\b\u0005\u0003g\u00139!C\u0001P\u0013\r\u0011YAT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yA!\u0005\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\t-a*\u0006\u0002\u0002.\u0006)Qo]3sA\u0005I1\r\\5f]RLE\rI\u0001\u000bG>tg-[4Vg\u0016\u0014XC\u0001B\u000f!\u0015i%qDAW\u0013\r\u0011\tC\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\r|gNZ5h+N,'\u000fI\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0003=\u0019wN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\u0004CCCAz\u0005W\u0011iCa\f\u00032!9\u00111V\u0016A\u0002\u00055\u0006bBAcW\u0001\u0007\u0011Q\u0016\u0005\n\u00053Y\u0003\u0013!a\u0001\u0005;A\u0011B!\n,!\u0003\u0005\rA!\b\u0002/M\fg.\u001b;ju\u0016$7i\u001c8gS\u001e\u001cE.[3oi&#WC\u0001B\u001c!\u0015i%q\u0004B\u001d!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\nA\u0001\\1oO*\u0011!1I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002@\nu\u0012\u0001B2paf$\"\"a=\u0003L\t5#q\nB)\u0011%\tY+\fI\u0001\u0002\u0004\ti\u000bC\u0005\u0002F6\u0002\n\u00111\u0001\u0002.\"I!\u0011D\u0017\u0011\u0002\u0003\u0007!Q\u0004\u0005\n\u0005Ki\u0003\u0013!a\u0001\u0005;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003X)\"\u0011QVAD\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003`)\"!QDAD\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u001d\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u001c\u0003tA\u0019QJa\u001c\n\u0007\tEdJA\u0002B]fDqa \u001b\u0002\u0002\u0003\u0007a/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\b\u0005\u0004\u0003|\t\u0005%QN\u0007\u0003\u0005{R1Aa O\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0007\u0013iH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BE\u0005\u001f\u00032!\u0014BF\u0013\r\u0011iI\u0014\u0002\b\u0005>|G.Z1o\u0011!yh'!AA\u0002\t5\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u000f\u0003\u0016\"9qpNA\u0001\u0002\u00041\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003Y\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005s\ta!Z9vC2\u001cH\u0003\u0002BE\u0005GC\u0001b \u001e\u0002\u0002\u0003\u0007!Q\u000e\u0005\b\u0005O\u000b\u0002\u0019AAz\u0003\u001d\u0019G.[3oiJBqAa+\u0012\u0001\u0004\t\u00190\u0001\u0007sC:$w.\\\"mS\u0016tG\u000fC\u0004\u00030F\u0001\r!a=\u0002'\u0011,g-Y;mi\u000e{gNZ5h\u00072LWM\u001c;\u00021Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\rK\u0002\u0013\u0005k\u0003B!a\u0003\u00038&!!\u0011XA\u0007\u0005\u0011!Vm\u001d;\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r\u0019\"QW\u0001\u001di\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r!\"QW\u0001-i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3!\u0006B[\u0003Q\"Xm\u001d;Vg\u0016\u00148\t\\5f]R\fVo\u001c;b!\u0006\u00148/\u001b8h\u0013\u0012<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004-\tU\u0016AC2iK\u000e\\\u0017+^8uCRi1Pa4\u0003R\nM'Q\u001bBp\u0005CDq!!)\u0018\u0001\u0004\t\u0019\u000bC\u0004\u0002,^\u0001\r!!,\t\u000f\u0005\u0015w\u00031\u0001\u0002.\"9!q[\fA\u0002\te\u0017!D3ya\u0016\u001cG/\u001a3C_VtG\rE\u0002N\u00057L1A!8O\u0005\u0011auN\\4\t\r\u0005%w\u00031\u0001w\u0011\u001d\u0011\u0019o\u0006a\u0001\u0005\u0013\u000ba\"\u001a=qK\u000e$H\u000b\u001b:piRdW-A\u001buKN$x)\u001a;NCb4\u0016\r\\;f\u0013:\fVo\u001c;b/&tGm\\<XSRDgj\u001c8EK\u001a\fW\u000f\u001c;Rk>$\u0018mV5oI><\bf\u0001\r\u00036\u0006\u0001C/Z:u'\u0016$\u0018I\u001c3SK6|g/\u001a#fM\u0006,H\u000e^+tKJ\fVo\u001c;bQ\rI\"QW\u0001\u001ai\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016,6/\u001a:Rk>$\u0018\rK\u0002\u001b\u0005k\u000bq\u0004^3tiN+G/\u00118e%\u0016lwN^3Vg\u0016\u00148\t\\5f]R\fVo\u001c;bQ\rY\"QW\u0001\u001ai\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jOB\u0013XmY3eK:\u001cW\rK\u0002\u001d\u0005k\u000b!\u0003^3tiF+x\u000e^1WS>d\u0017\r^5p]\"\u001aQD!.\u0002GQ,7\u000f\u001e*fcV,7\u000f\u001e)fe\u000e,g\u000e^1hKF+x\u000e^1WS>d\u0017\r^5p]\"\u001aaD!.\u00029Q,7\u000f^#ya&\u0014X\r\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe\"\u001aqD!.\u0002-Q,7\u000f^#ya&\u0014X-U;pi\u0006\u001cVM\\:peND3\u0001\tB[\u0003a!Xm\u001d;DY&,g\u000e^%e\u001d>$8+\u00198ji&TX\r\u001a\u0015\u0004C\tU\u0016AC+tKJ\u001cE.[3oiB\u0019\u0011Q\u001f\u001f\u0014\u000bq\u001a\u0019ba\b\u0011\u001d\rU11DAW\u0003[\u0013iB!\b\u0002t6\u00111q\u0003\u0006\u0004\u00073q\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007;\u00199BA\tBEN$(/Y2u\rVt7\r^5p]R\u0002Ba!\t\u0004(5\u001111\u0005\u0006\u0005\u0007K\u0011\t%\u0001\u0002j_&!!qBB\u0012)\t\u0019y!A\u0003baBd\u0017\u0010\u0006\u0006\u0002t\u000e=2\u0011GB\u001a\u0007kAq!a+@\u0001\u0004\ti\u000bC\u0004\u0002F~\u0002\r!!,\t\u0013\teq\b%AA\u0002\tu\u0001\"\u0003B\u0013\u007fA\u0005\t\u0019\u0001B\u000f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!1qHB$!\u0015i%qDB!!-i51IAW\u0003[\u0013iB!\b\n\u0007\r\u0015cJ\u0001\u0004UkBdW\r\u000e\u0005\n\u0007\u0013\u0012\u0015\u0011!a\u0001\u0003g\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        if (response instanceof RequestChannel.StartThrottlingResponse) {
            return;
        }
        if (response instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            return;
        }
        throw new MatchError((Object)response);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        void var7_7;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var7_7, throttleTimeMs, channelThrottlingCallback);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaBytesPerSecondDefault()).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assert.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(Long.MAX_VALUE, numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds());
        ClientQuotaManager quotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assert.assertEquals((double)Double.MAX_VALUE, (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assert.assertEquals((double)(10 * numFullQuotaWindows), (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples(), ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(quotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(quotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(quotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(quotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(quotaManager, "userE", "client1", 3000L, 2500, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(quotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(quotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(quotaManager, "userF", "client5", 1000L, 800, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(quotaManager, "userG", "client5", 2000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 6000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 8000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(quotaManager, "userA", "client6", 11000L, 8500, false);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            Object var11_10;
            int n = 0;
            int until$extension_end = 10;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$1(this, clientMetrics, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var7_5 = null;
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int sleepTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            Function1 & Serializable throttle_channelThrottlingCallback = (Function1 & Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            };
            Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            RequestChannel.Request throttle_request = (RequestChannel.Request)tuple2._2();
            clientMetrics.throttle((RequestChannel.Request)var11_10, sleepTime, (Function1)throttle_channelThrottlingCallback);
            Object var9_8 = null;
            tuple2 = null;
            var11_10 = null;
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            int until$extension_end2 = 10;
            Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$3(this, clientMetrics, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Object var12_13 = null;
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.time(), "", (Option)None$.MODULE$);
        double upperBound_upperBound = 1.0;
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)new Quota(upperBound_upperBound, true)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Request", ""));
        try {
            Object var12_11;
            int n = 0;
            int until$extension_end = 10;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$1(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var8_6 = null;
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 67.1 * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond());
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            Function1 & Serializable throttle_channelThrottlingCallback = (Function1 & Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            };
            Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            RequestChannel.Request throttle_request = (RequestChannel.Request)tuple2._2();
            quotaManager.throttle((RequestChannel.Request)var12_11, throttleTime, (Function1)throttle_channelThrottlingCallback);
            Object var10_9 = null;
            tuple2 = null;
            var12_11 = null;
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            int until$extension_end2 = 11;
            Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$3(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Object var13_14 = null;
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 500.0 * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond()));
            int n3 = 0;
            int until$extension_end3 = 10;
            Range.Exclusive foreach$mVc$sp_this3 = new Range.Exclusive(n3, until$extension_end3, 1);
            if (!foreach$mVc$sp_this3.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testRequestPercentageQuotaViolation$4(this, quotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
                }
            }
            Object var15_18 = null;
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$1(ClientQuotaManagerTest $this, ClientQuotaManager clientMetrics$1, int x$1) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord(clientMetrics$1, "ANONYMOUS", "unknown", 400.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$3(ClientQuotaManagerTest $this, ClientQuotaManager clientMetrics$1, int x$2) {
        $this.maybeRecord(clientMetrics$1, "ANONYMOUS", "unknown", 400.0);
        $this.time().sleep(1000L);
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$1(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int x$3) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", 4.0 * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond()));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$3(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int x$4) {
        $this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", 4.0 * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond());
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testRequestPercentageQuotaViolation$4(ClientQuotaManagerTest $this, ClientRequestQuotaManager quotaManager$1, int x$5) {
        $this.time().sleep(1000L);
        Assert.assertEquals((long)1000L, (long)$this.maybeRecord((ClientQuotaManager)quotaManager$1, "ANONYMOUS", "test-client", 0.0));
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            Option<String> option = this.configClientId();
            if (option == null) {
                throw null;
            }
            Option<String> map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)UserClient.$anonfun$sanitizedConfigClientId$1((String)map_this.get()));
            return object;
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -889275714, false);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$sanitizedConfigClientId$1(String x) {
            String string = x;
            String string2 = ConfigEntityName$.MODULE$.Default();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ConfigEntityName$.MODULE$.Default();
            }
            return Sanitizer.sanitize((String)x);
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

