/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u0013&\u0001)BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001A\u0002\u0013\u0005A\bC\u0004L\u0001\u0001\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015)\u0003>\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015y\u0006\u0001\"\u0003a\u0011%\t9\u0002AI\u0001\n\u0013\tI\u0002\u0003\u0004`\u0001\u0011%\u0011q\u0006\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0005\u0002n\u0001\t\n\u0011\"\u0003\u0002p!9\u00111\u000f\u0001\u0005\n\u0005U\u0004\"CA>\u0001E\u0005I\u0011BA?\u0011%\t\t\t\u0001b\u0001\n\u0003\t\u0019\tC\u0004\u0002\u0006\u0002\u0001\u000b\u0011\u00028\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0005\u0002CAK\u0001\u0001\u0006I!a#\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005e\u0005\u0002CAN\u0001\u0001\u0006I!!\u0001\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0005\u0002CAS\u0001\u0001\u0006I!!)\t\r\u0005\u001d\u0006\u0001\"\u0001V\u0011\u0019\t\t\f\u0001C\u0001+\"1\u0011Q\u0017\u0001\u0005\u0002UCq!!/\u0001\t\u0013\tY\f\u0003\u0004\u0002T\u0002!\t!\u0016\u0005\u0007\u0003/\u0004A\u0011A+\t\r\u0005m\u0007\u0001\"\u0001V\u0011\u0019\ty\u000e\u0001C\u0001+\"1\u00111\u001d\u0001\u0005\u0002UCa!a:\u0001\t\u0003)\u0006BBAv\u0001\u0011\u0005Q\u000b\u0003\u0004\u0002p\u0002!\t!\u0016\u0005\u0007\u0003g\u0004A\u0011A+\u0003SA\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7i\\7nC:$G+Z:u\u0015\t1s%A\u0003bI6LgNC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\tqs%\u0001\u0002{W&\u0011\u0001'\f\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0013!B;uS2\u001c\u0018B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0013\u0002\u000fM,'O^3sgV\tQ\bE\u0002?\u0007\u0016k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#@\u0005\r\u0019V-\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001e\naa]3sm\u0016\u0014\u0018B\u0001&H\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u001bF\u0003\"AT(\u000e\u0003\u0005K!\u0001U!\u0003\tUs\u0017\u000e\u001e\u0005\b%\u000e\t\t\u00111\u0001>\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001NQ\t)q\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006)!.\u001e8ji*\tA,A\u0002pe\u001eL!AX-\u0003\u000b\u00053G/\u001a:\u00023\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u000b\u0005\u001b\u0006\f9\u0001C\u0003c\r\u0001\u00071-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0011\\gn\u001e\b\u0003K&\u0004\"AZ!\u000e\u0003\u001dT!\u0001[\u0015\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0017)\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u00141!T1q\u0015\tQ\u0017\t\u0005\u0002pk6\t\u0001O\u0003\u0002re\u000611m\\7n_:T!\u0001K:\u000b\u0005Q\\\u0016AB1qC\u000eDW-\u0003\u0002wa\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002=~\u0003\u0003q!!_>\u000f\u0005\u0019T\u0018\"\u0001\"\n\u0005q\f\u0015a\u00029bG.\fw-Z\u0005\u0003}~\u0014A\u0001T5ti*\u0011A0\u0011\t\u0004\u001d\u0006\r\u0011bAA\u0003\u0003\n\u0019\u0011J\u001c;\t\u0013\u0005%a\u0001%AA\u0002\u0005-\u0011AC1vi\"|'/\u001b>feB)a*!\u0004\u0002\u0012%\u0019\u0011qB!\u0003\r=\u0003H/[8o!\r!\u00171C\u0005\u0004\u0003+i'AB*ue&tw-A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m!\u0006BA\u0006\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S\t\u0015AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0006\u001b\u0006E\u0012Q\u0007\u0005\u0007\u0003gA\u0001\u0019A2\u00021A\f'\u000f^5uS>t7/\u00118e\u0003N\u001c\u0018n\u001a8nK:$8\u000fC\u0004\u00028!\u0001\r!!\u000f\u0002\u001b\t\u0014xn[3s\u0007>tg-[4t!\u0011q4)a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!Q\u000f^5m\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u00031\u0011w.\u001e8dKN+'O^3s)\u0015i\u0015qJA*\u0011\u001d\t\t&\u0003a\u0001\u0003\u0003\tA\u0002^1sO\u0016$8+\u001a:wKJDa!!\u0016\n\u0001\u0004q\u0017!\u00039beRLG/[8o\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\u0011\u00111\f\t\u0005\u001d\u00065Q)A\u0006bo\u0006LG\u000fT3bI\u0016\u0014HCBA\u0001\u0003C\n\u0019\u0007C\u0003c\u0017\u0001\u0007a\u000eC\u0005\u0002f-\u0001\n\u00111\u0001\u0002h\u0005IA/[7f_V$Xj\u001d\t\u0004\u001d\u0006%\u0014bAA6\u0003\n!Aj\u001c8h\u0003U\tw/Y5u\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u001d+\t\u0005\u001d\u0014QD\u0001\u0010E>|Go\u001d;sCB\u001cVM\u001d<feR!\u0011\u0011CA<\u0011%\tI(\u0004I\u0001\u0002\u0004\t\t!\u0001\u0004ce>\\WM]\u0001\u001aE>|Go\u001d;sCB\u001cVM\u001d<fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0000)\"\u0011\u0011AA\u000f\u00035!Xm\u001d;QCJ$\u0018\u000e^5p]V\ta.\u0001\buKN$\b+\u0019:uSRLwN\u001c\u0011\u0002/Q,7\u000f\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$XCAAF!\u0019\ti)a%\u0002\u00025\u0011\u0011q\u0012\u0006\u0004\u0003#{\u0014!C5n[V$\u0018M\u00197f\u0013\rq\u0018qR\u0001\u0019i\u0016\u001cH\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0013\u0001\b;fgR\u0004\u0016M\u001d;ji&|g\u000e\u0015:fM\u0016\u0014(/\u001a3MK\u0006$WM]\u000b\u0003\u0003\u0003\tQ\u0004^3tiB\u000b'\u000f^5uS>t\u0007K]3gKJ\u0014X\r\u001a'fC\u0012,'\u000fI\u0001\u001bi\u0016\u001cH\u000fU1si&$\u0018n\u001c8B]\u0012\f5o]5h]6,g\u000e^\u000b\u0003\u0003C\u0003r!!$\u0002$:\fY)C\u0002m\u0003\u001f\u000b1\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3BgNLwM\\7f]R\u0004\u0013\u0001\u0007;fgRlU\u000f\u001c;ja2,'I]8lKJ\u001cx)\u001b<f]\"\u001aq#a+\u0011\u0007a\u000bi+C\u0002\u00020f\u0013A\u0001V3ti\u00061B/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:HSZ,g\u000eK\u0002\u0019\u0003W\u000bQ\u0003^3ti:{\u0007+\u0019:uSRLwN\\:HSZ,g\u000eK\u0002\u001a\u0003W\u000b!\u0002^8Kg>tg)\u001b7f)\u0011\ti,!3\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002D\u0005\u0011\u0011n\\\u0005\u0005\u0003\u000f\f\tM\u0001\u0003GS2,\u0007bBAf5\u0001\u0007\u0011QZ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u00023\u0002P:L1!!5n\u0005\r\u0019V\r^\u0001\u001ci\u0016\u001cHoU5oO2,Go\u001c8QCJ$\u0018\u000e^5p]\u001eKg/\u001a8)\u0007m\tY+A\u000buKN$Hk\u001c9jG\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007q\tY+\u0001\u0013uKN$X*\u001e7uSBdW\rU1si&$\u0018n\u001c8t'\u0006lW-Q:tS\u001etW.\u001a8uQ\ri\u00121V\u0001\u0011i\u0016\u001cHOT8pa\u0016cWm\u0019;j_:D3AHAV\u0003}!Xm\u001d;XSRDwJ\u001a4mS:,\u0007K]3gKJ\u0014X\r\u001a*fa2L7-\u0019\u0015\u0004?\u0005-\u0016a\u0003;fgR$\u0016.\\3pkRD3\u0001IAV\u0003A!Xm\u001d;BkRD'PR1jYV\u0014X\rK\u0002\"\u0003W\u000bA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f'j]8o\t\u0006$\u0018\rK\u0002#\u0003W\u000b\u0011\u0005^3ti\n\u000b7/[2Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:D3aIAV\u0001")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("auto.leader.rebalance.enable", "false"));
        if (authorizer instanceof Some) {
            String className = (String)((Some)authorizer).value();
            brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("authorizer.class.name", className));
        } else if (!None$.MODULE$.equals(authorizer)) {
            throw new MatchError(authorizer);
        }
        this.createTestTopicAndCluster(topicPartition, brokerConfigs);
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), Time.SYSTEM, (Option<String>)None$.MODULE$))));
        partitionsAndAssignments.foreach((Function1 & Serializable)x0$1 -> {
            PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$5(this, partitionsAndAssignments)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Replicas for topic test not created", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Shutting down server ").append(targetServer).append(" so a non-preferred replica becomes leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Starting server ").append(targetServer).append(" now that a non-preferred replica is leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$3(this, partition, targetServer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$6(partition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$getController$1(p)));
    }

    private int awaitLeader(TopicPartition topicPartition, long timeoutMs) {
        Option option;
        long l = 100L;
        long awaitValue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = PreferredReplicaLeaderElectionCommandTest.$anonfun$awaitLeader$1(this, topicPartition)).isDefined()) {
            if (System.currentTimeMillis() > awaitValue_waitUntilTrue_startTime + timeoutMs) {
                throw Assertions$.MODULE$.fail(PreferredReplicaLeaderElectionCommandTest.$anonfun$awaitLeader$3(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(timeoutMs, l));
        }
        return BoxesRunTime.unboxToInt((Object)option.get());
    }

    private long awaitLeader$default$2() {
        return 15000L;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Server bound to port ").append(port).toString());
        return new StringBuilder(10).append("localhost:").append(port).toString();
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", new StringBuilder(1).append(this.bootstrapServer(1)).append(",").append(this.bootstrapServer(0)).toString()}, 30000);
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
    }

    @Test
    public void testInvalidBrokerGiven() {
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234"}, 1000);
            Assert.fail();
            return;
        }
        catch (AdminCommandFailedException adminCommandFailedException) {
            Assert.assertTrue((boolean)(adminCommandFailedException.getCause() instanceof TimeoutException));
            return;
        }
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0)}, 30000);
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(scala.collection.immutable.Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = TestUtils$.MODULE$.stringifyTopicPartitions(partitions);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Using json: ").append(jsonString).toString());
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDoesNotExist() {
        void apply_elems;
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)nonExistentPartition, (Object)nonExistentPartitionAssignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map nonExistentPartitionAndAssignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assert.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiplePartitionsSameAssignment() {
        void apply_elems;
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)testPartitionA, (Object)testPartitionAssignment);
        objectArray[1] = new Tuple2((Object)testPartitionB, (Object)testPartitionAssignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map testPartitionAndAssignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        this.createTestTopicAndCluster((scala.collection.immutable.Map<TopicPartition, List<Object>>)testPartitionAndAssignment, (Option<String>)None$.MODULE$);
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, 15000L));
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionA, 15000L));
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.awaitLeader(testPartitionB, 15000L));
    }

    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
            Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Throwable suppressed = e.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assert.assertTrue((String)suppressed.getMessage(), (boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}, 2000);
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"Timeout waiting for election results", (Object)e.getMessage());
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
                Assert.fail();
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"Not authorized to perform leader election", (Object)e.getMessage());
                Assert.assertTrue((boolean)(e.getCause() instanceof ClusterAuthorizationException));
                Assert.assertEquals((long)leader, (long)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaJsonData() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), (Set)partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicPreferredReplicaElection() {
        None$ none$;
        void apply_elems;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        void apply_elems2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void apply_elems3;
        void $minus$greater$extension_y4;
        void apply_elems4;
        Object object;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        List$ apply_this = List$.MODULE$;
        Object object2 = object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems4);
        Object var27_2 = null;
        arraySeq = null;
        object = null;
        Object object3 = object2;
        Integer $minus$greater$extension_$this = 0;
        Object var19_5 = null;
        object3 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq2 = null;
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        String topic = "test";
        int partition = 0;
        int preferredReplica = 0;
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[3];
        String string = "rack0";
        Integer $minus$greater$extension_$this2 = 0;
        Object var21_12 = null;
        string = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
        String string2 = "rack1";
        Integer $minus$greater$extension_$this3 = 1;
        Object var23_14 = null;
        string2 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this4 = 2;
        Object var25_16 = null;
        string3 = null;
        objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        scala.collection.immutable.Map brokerRack = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2);
        String x$2 = this.zkConnect();
        boolean bl = true;
        None$ none$6 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$8;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 1;
        boolean bl6 = false;
        int n2 = 1;
        short s2 = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, x$2, false, bl, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl2, bl3, bl4, bl5, (Map<Object, String>)brokerRack, n, bl6, n2, s2).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        this.adminZkClient().createTopicWithAssignment(topic, new Properties(), (Map)expectedReplicaAssignment);
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            return TestUtils$.MODULE$.createServer((KafkaConfig)s, createServer_time, (Option<String>)None$.MODULE$);
        })));
        KafkaZkClient x$17 = this.zkClient();
        None$ x$20 = None$.MODULE$;
        long l = 30000L;
        None$ none$9 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$22 = none$9;
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$17, topic, partition, l, (Option<Object>)x$20, (Option<Object>)x$22);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)});
        if (set$ == null) {
            throw null;
        }
        arraySeq4 = null;
        new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).moveLeaderToPreferredReplica();
        KafkaZkClient x$23 = this.zkClient();
        Some x$26 = new Some((Object)currentLeader);
        long l2 = 30000L;
        None$ none$10 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$28 = none$10;
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, topic, partition, l2, (Option<Object>)x$26, (Option<Object>)x$28);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$createTestTopicAndCluster$4(PreferredReplicaLeaderElectionCommandTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            void apply_elems;
            TopicPartition tp = (TopicPartition)x0$1._1();
            List assignment = (List)x0$1._2();
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            objectArray[0] = new Tuple2((Object)tp, (Object)assignment);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            $this.zkClient().createTopicAssignment(tp.topic(), (Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$7(KafkaServer server$1, Tuple2 partitionAndAssignment) {
        LogManager qual$1 = server$1.getLogManager();
        TopicPartition x$1 = (TopicPartition)partitionAndAssignment._1();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(PreferredReplicaLeaderElectionCommandTest $this, scala.collection.immutable.Map partitionsAndAssignments$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)partitionsAndAssignments$1.forall((Function1 & Serializable)partitionAndAssignment -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$7(server, partitionAndAssignment)))));
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$8() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$5(int targetServer$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        return partitionState.isr().contains(targetServer$1);
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$4(TopicPartition partition$1, int targetServer$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState updateMetadataPartitionState;
        Option option = server.metadataCache().getPartitionInfo(partition$1.topic(), partition$1.partition());
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$5(targetServer$1, updateMetadataPartitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)exists_this.get());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$3(PreferredReplicaLeaderElectionCommandTest $this, TopicPartition partition$1, int targetServer$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$4(partition$1, targetServer$1, server)));
    }

    public static final /* synthetic */ String $anonfun$bounceServer$6(TopicPartition partition$1) {
        return new StringBuilder(35).append("Replicas for partition ").append(partition$1).append(" not created").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(KafkaServer p) {
        return p.kafkaController().isActive();
    }

    public static final /* synthetic */ Option $anonfun$awaitLeader$1(PreferredReplicaLeaderElectionCommandTest $this, TopicPartition topicPartition$1) {
        Option option = ((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo(topicPartition$1.topic(), topicPartition$1.partition());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((UpdateMetadataRequestData.UpdateMetadataPartitionState)map_this.get()).leader());
        return object;
    }

    public static final /* synthetic */ String $anonfun$awaitLeader$3(TopicPartition topicPartition$1) {
        return new StringBuilder(44).append("Timed out waiting to find current leader of ").append(topicPartition$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public PreferredReplicaLeaderElectionCommandTest() {
        void apply_elems;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        List<Object> $minus$greater$extension_y = this.testPartitionAssignment();
        TopicPartition $minus$greater$extension_$this = this.testPartition();
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        this.testPartitionAndAssignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
    }

    public static final /* synthetic */ Object $anonfun$bounceServer$5$adapted(int targetServer$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        return BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$5(targetServer$1, partitionState));
    }

    public static final /* synthetic */ Object $anonfun$awaitLeader$2$adapted(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return BoxesRunTime.boxToInteger((int)x$1.leader());
    }
}

