/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BQA\r\u0001\u0005BMBqA\u000f\u0001C\u0002\u0013\u00051\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000e\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u00191\u0005\u0001)A\u0005}!9q\t\u0001b\u0001\n\u0003A\u0005BB,\u0001A\u0003%\u0011\nC\u0004Y\u0001\t\u0007I\u0011A\u001f\t\re\u0003\u0001\u0015!\u0003?\u0011\u001dQ\u0006A1A\u0005\u0002!Caa\u0017\u0001!\u0002\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0010\u0005\u0007;\u0002\u0001\u000b\u0011\u0002 \t\u000fy\u0003!\u0019!C\u0001\u0011\"1q\f\u0001Q\u0001\n%Cq\u0001\u0019\u0001C\u0002\u0013\u0005Q\b\u0003\u0004b\u0001\u0001\u0006IA\u0010\u0005\bE\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0007\u0001)A\u0005\u0013\"9A\r\u0001b\u0001\n\u0003i\u0004BB3\u0001A\u0003%a\bC\u0004g\u0001\t\u0007I\u0011\u0001%\t\r\u001d\u0004\u0001\u0015!\u0003J\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u00151\b\u0001\"\u0001j\u0011\u0015Y\b\u0001\"\u0001j\u0011\u0015i\b\u0001\"\u0001j\u0011\u0015y\b\u0001\"\u0001j\u0011\u0019\t\u0019\u0001\u0001C\u0001S\"1\u0011q\u0001\u0001\u0005\u0002%Dq!a\u0003\u0001\t\u0003\tiAA\tBI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+fgRT!a\t\u0013\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006J\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055R#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005\u0011\u0013a\u00032s_.,'oQ8v]R,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0004\u0013:$\u0018a\u00039beRLG/[8o\u0013\u0012\fA\u0002]1si&$\u0018n\u001c8JI\u0002\na\u0001^8qS\u000e\fT#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\tu_BL7-M!tg&<g.\\3oiV\t\u0011\n\u0005\u0003K\u001fR\nV\"A&\u000b\u00051k\u0015!C5n[V$\u0018M\u00197f\u0015\tqe'\u0001\u0006d_2dWm\u0019;j_:L!\u0001U&\u0003\u00075\u000b\u0007\u000f\u0005\u0002S+6\t1K\u0003\u0002UI\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005Y\u001b&!\u0005*fa2L7-Y!tg&<g.\\3oi\u0006\tBo\u001c9jGF\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[23\u0003\u001d!x\u000e]5de\u0001\n\u0001\u0003^8qS\u000e\u0014\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7mM\u0001\bi>\u0004\u0018nY\u001a!\u0003A!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG/A\tu_BL7mM!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e$\u0014a\u0002;pa&\u001cG\u0007I\u0001\u0011i>\u0004\u0018n\u0019\u001bBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e$\u0014i]:jO:lWM\u001c;!\u0003\u0019!x\u000e]5dk\u00059Ao\u001c9jGV\u0002\u0013\u0001\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dk\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002UB\u0011Qg[\u0005\u0003YZ\u0012A!\u00168ji\"\u0012\u0011D\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fQA[;oSRT\u0011a]\u0001\u0004_J<\u0017BA;q\u0005\u0019\u0011UMZ8sK\u0006)B/Z:u/J|gn\u001a*fa2L7-Y\"pk:$\bF\u0001\u000ey!\ty\u00170\u0003\u0002{a\n!A+Z:u\u0003U!Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]BB#a\u0007=\u0002/Q,7\u000f^%oGJ,W.\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001\u000fy\u0003y!Xm\u001d;NC:,\u0018\r\\!tg&<g.\\3oi>3'+\u001a9mS\u000e\f7\u000f\u000b\u0002\u001eq\u0006qB/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\fE\u000e\\*feZ,'o\u001d\u0015\u0003=a\f!\u0005^3tiJ+\u0007\u000f\\5dCBc\u0017mY3nK:$\b+\u0019:uS\u0006d7+\u001a:wKJ\u001c\bFA\u0010y\u0003e1\u0018\r\\5eCR,G*Z1eKJ\fe\u000e\u001a*fa2L7-Y:\u0015\u0013)\fy!!\u0013\u0002L\u0005=\u0003bBA\tA\u0001\u0007\u00111C\u0001\t[\u0016$\u0018\rZ1uCB!\u0011QCA\"\u001d\u0011\t9\"!\u0010\u000f\t\u0005e\u0011q\u0007\b\u0005\u00037\t\tD\u0004\u0003\u0002\u001e\u00055b\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K1\u0013A\u0002\u001fs_>$h(C\u0001t\u0013\r\tYC]\u0001\u0007CB\f7\r[3\n\u0007\u0015\nyCC\u0002\u0002,ILA!a\r\u00026\u000511m\\7n_:T1!JA\u0018\u0013\u0011\tI$a\u000f\u0002\u0011I,\u0017/^3tiNTA!a\r\u00026%!\u0011qHA!\u0003AiU\r^1eCR\f'+Z:q_:\u001cXM\u0003\u0003\u0002:\u0005m\u0012\u0002BA#\u0003\u000f\u0012Q\u0002V8qS\u000elU\r^1eCR\f'\u0002BA \u0003\u0003BQA\u000f\u0011A\u0002QBa!!\u0014!\u0001\u0004!\u0014\u0001E3ya\u0016\u001cG/\u001a3MK\u0006$WM]%e\u0011\u001d\t\t\u0006\ta\u0001\u0003'\n\u0001#\u001a=qK\u000e$X\r\u001a*fa2L7-Y:\u0011\u000b\u0005U\u0013Q\f\u001b\u000f\t\u0005]\u0013\u0011\f\t\u0004\u0003C1\u0014bAA.m\u00051\u0001K]3eK\u001aLA!a\u0018\u0002b\t\u00191+\u001a;\u000b\u0007\u0005mc\u0007")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment;
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment;
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment;
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment;
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Seq seq = v.replicas();
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            seq = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })));
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
            Seq seq = v.replicas();
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            seq = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })));
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable)x0$3 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            int k = x0$3._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
            Seq seq = v.replicas();
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            seq = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })));
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable)x0$4 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            int k = x0$4._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
            Seq seq = v.replicas();
            Integer $minus$greater$extension_$this = k;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            seq = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWrongReplicaCount() {
        try {
            void apply_elems;
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic1();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[2];
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Integer $minus$greater$extension_$this = 0;
            Object var10_9 = null;
            seqOps = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Integer $minus$greater$extension_$this2 = 1;
            Object var12_11 = null;
            seqOps2 = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            Some x$7 = new Some(MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, 2, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
            return;
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingPartition0() {
        try {
            void apply_elems;
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic5();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[2];
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Integer $minus$greater$extension_$this = 1;
            Object var10_9 = null;
            seqOps = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Integer $minus$greater$extension_$this2 = 2;
            Object var12_11 = null;
            seqOps2 = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            Some x$7 = new Some(MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, 2, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
            return;
        }
        catch (AdminOperationException adminOperationException) {
            Assert.assertTrue((boolean)adminOperationException.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic1();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$12 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$12, x$2);
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, 3, x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})))).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)((MetadataResponse.TopicMetadata)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        if (partitions == null) {
            throw null;
        }
        Assert.assertEquals((long)partitions.length(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testManualAssignmentOfReplicas() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$22 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$22);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Integer $minus$greater$extension_$this = 0;
        Object var18_9 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Integer $minus$greater$extension_$this2 = 1;
        Object var20_11 = null;
        seqOps2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        Integer $minus$greater$extension_$this3 = 2;
        Object var22_13 = null;
        seqOps3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Some x$7 = new Some(MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2));
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, 3, (Option)x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})))).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)response.topicMetadata()).asScala().head();
        Buffer partitionMetadata = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)topicMetadata.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assert.assertEquals((long)2L, (long)replicas.size());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)replicas).asScala().toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaPlacementAllServers() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic3();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic3Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, 7, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()})))).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)response.topicMetadata()).asScala().head();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems7)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems6)));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems5)));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems4)));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems3)));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems2)));
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaPlacementPartialServers() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, 3, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})))).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)response.topicMetadata()).asScala().head();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)metadata.partitionMetadata()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assert.assertTrue((String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString(), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertEquals((String)"Partition leader id should match", Optional.of(expectedLeaderId), (Object)partition.leaderId);
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)partition.replicaIds).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        List replicas = partition.replicaIds;
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assert.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsTest() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_removingReplicas;
        void apply_addingReplicas;
        ReplicaAssignment replicaAssignment;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        ReplicaAssignment replicaAssignment2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_removingReplicas3;
        void apply_addingReplicas3;
        ReplicaAssignment replicaAssignment3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        void apply_removingReplicas4;
        void apply_addingReplicas4;
        ReplicaAssignment replicaAssignment4;
        void apply_elems5;
        void apply_removingReplicas5;
        void apply_addingReplicas5;
        ReplicaAssignment replicaAssignment5;
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ nil$2 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ReplicaAssignment replicaAssignment6 = replicaAssignment5 = new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas5, (Seq)apply_removingReplicas5);
        Object var16_3 = null;
        nil$2 = null;
        nil$ = null;
        replicaAssignment5 = null;
        ReplicaAssignment $minus$greater$extension_y5 = replicaAssignment6;
        Integer $minus$greater$extension_$this = 0;
        Object var1_6 = null;
        Object var2_5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.topic1Assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems5);
        this.topic2 = "new-topic2";
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Nil$ nil$3 = Nil$.MODULE$;
        Nil$ nil$4 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        ReplicaAssignment replicaAssignment7 = replicaAssignment4 = new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas4, (Seq)apply_removingReplicas4);
        Object var20_10 = null;
        nil$4 = null;
        nil$3 = null;
        replicaAssignment4 = null;
        ReplicaAssignment replicaAssignment8 = replicaAssignment7;
        Integer $minus$greater$extension_$this2 = 0;
        Object var3_13 = null;
        replicaAssignment8 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.topic2Assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems4);
        this.topic3 = "new-topic3";
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        Nil$ nil$5 = Nil$.MODULE$;
        Nil$ nil$6 = Nil$.MODULE$;
        Seq apply_replicas3 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}));
        ReplicaAssignment replicaAssignment9 = replicaAssignment3 = new ReplicaAssignment(apply_replicas3, (Seq)apply_addingReplicas3, (Seq)apply_removingReplicas3);
        Object var24_17 = null;
        nil$6 = null;
        nil$5 = null;
        replicaAssignment3 = null;
        ReplicaAssignment replicaAssignment10 = replicaAssignment9;
        Integer $minus$greater$extension_$this3 = 0;
        Object var5_20 = null;
        replicaAssignment10 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.topic3Assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems3);
        this.topic4 = "new-topic4";
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        Nil$ nil$7 = Nil$.MODULE$;
        Nil$ nil$8 = Nil$.MODULE$;
        Seq apply_replicas4 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3}));
        ReplicaAssignment replicaAssignment11 = replicaAssignment2 = new ReplicaAssignment(apply_replicas4, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2);
        Object var28_24 = null;
        nil$8 = null;
        nil$7 = null;
        replicaAssignment2 = null;
        ReplicaAssignment replicaAssignment12 = replicaAssignment11;
        Integer $minus$greater$extension_$this4 = 0;
        Object var7_27 = null;
        replicaAssignment12 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.topic4Assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems2);
        this.topic5 = "new-topic5";
        Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        Nil$ nil$9 = Nil$.MODULE$;
        Nil$ nil$10 = Nil$.MODULE$;
        Seq apply_replicas5 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ReplicaAssignment replicaAssignment13 = replicaAssignment = new ReplicaAssignment(apply_replicas5, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
        Object var32_31 = null;
        nil$10 = null;
        nil$9 = null;
        replicaAssignment = null;
        ReplicaAssignment replicaAssignment14 = replicaAssignment13;
        Integer $minus$greater$extension_$this5 = 1;
        Object var9_34 = null;
        replicaAssignment14 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        this.topic5Assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$5, (scala.collection.immutable.Seq)apply_elems);
    }
}

