/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.tools.MessageInfo;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\u0012%\t%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0001\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007i\u0002\u0001\u000b\u0011\u00022\t\u000fU\u0004!\u0019!C\u0005m\"9\u0011q\u0002\u0001!\u0002\u00139\b\u0002CA\t\u0001\t\u0007I\u0011\u0002<\t\u000f\u0005M\u0001\u0001)A\u0005o\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037Aq!a\n\u0001A\u0003&Q\nC\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u0002\u0018!I\u00111\u0007\u0001A\u0002\u0013%\u0011Q\u0007\u0005\b\u0003s\u0001\u0001\u0015)\u0003N\u0011%\tY\u0004\u0001a\u0001\n\u0013\t9\u0002C\u0005\u0002>\u0001\u0001\r\u0011\"\u0003\u0002@!9\u00111\t\u0001!B\u0013i\u0005\"CA#\u0001\u0001\u0007I\u0011BA$\u0011%\tI\u0005\u0001a\u0001\n\u0013\tY\u0005C\u0004\u0002P\u0001\u0001\u000b\u0015B\u001f\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA-\u0001\u0011\u0005\u00111\u000b\u0005\b\u00037\u0002A\u0011AA,\u0011\u001d\ti\u0006\u0001C\u0005\u0003'Bq!a\u0018\u0001\t\u0013\t\u0019\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011q\u000f\u0001\u0005\u0002\u0005e$!\u0004*fa2L7-\u0019\"vM\u001a,'O\u0003\u0002&M\u0005)Ao\\8mg*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\nQ!\u001e;jYNL!!\u000e\u001a\u0003\u000f1{wmZ5oO\u0006\tS\r\u001f9fGR,GMU3qY&\u001c\u0017m\u001d)feR{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0001hO\u001fI\u001b\u0005I$B\u0001\u001e-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003ye\u00121!T1q!\tqd)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003O\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011qi\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tY\u0013*\u0003\u0002KY\t\u0019\u0011J\u001c;\u0002\u001d%t\u0017\u000e^5bY>3gm]3ugB!\u0001hO\u001fN!\tYc*\u0003\u0002PY\t!Aj\u001c8h\u0003M)\u0007\u0010]3di\u0016$g*^7GKR\u001c\u0007.\u001a:t\u00039\u0011X\r]8si&sG/\u001a:wC2\fa\u0001P5oSRtD#\u0002+W/bK\u0006CA+\u0001\u001b\u0005!\u0003\"\u0002\u001c\u0006\u0001\u00049\u0004\"B&\u0006\u0001\u0004a\u0005\"\u0002)\u0006\u0001\u0004A\u0005\"B)\u0006\u0001\u0004i\u0015A\u00044fi\u000eDwJ\u001a4tKRl\u0015\r]\u000b\u00029B!\u0011'X\u001fN\u0013\tq&G\u0001\u0003Q_>d\u0017a\u00044fi\u000eDwJ\u001a4tKRl\u0015\r\u001d\u0011\u0002\u0019I,7m\u001c:eg\u000e\u000b7\r[3\u0016\u0003\t\u0004B!M/>GB!\u0011'\u0018%e!\r)7N\u001c\b\u0003M&l\u0011a\u001a\u0006\u0003Q~\n\u0001B]3rk\u0016\u001cHo]\u0005\u0003U\u001e\fQBR3uG\"\u0014Vm\u001d9p]N,\u0017B\u00017n\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*\u0011!n\u001a\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c~\naA]3d_J$\u0017BA:q\u00055iU-\\8ssJ+7m\u001c:eg\u0006i!/Z2pe\u0012\u001c8)Y2iK\u0002\naBZ3uG\",'OQ1se&,'/F\u0001x!\u0015A\u00181AA\u0004\u001b\u0005I(B\u0001>|\u0003\u0019\tGo\\7jG*\u0011A0`\u0001\u000bG>t7-\u001e:sK:$(B\u0001@\u0000\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0005\u0011\u0001\u00026bm\u0006L1!!\u0002z\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003BA\u0005\u0003\u0017i\u0011a_\u0005\u0004\u0003\u001bY(AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0010M\u0016$8\r[3s\u0005\u0006\u0014(/[3sA\u0005\u0019b/\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\u0006!b/\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\u0002\na\u0002\\1tiJ+\u0007o\u001c:u)&lW-F\u0001N\u0003Ia\u0017m\u001d;SKB|'\u000f\u001e+j[\u0016|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0004W\u0005}\u0011bAA\u0011Y\t!QK\\5u\u0011!\t)cDA\u0001\u0002\u0004i\u0015a\u0001=%c\u0005yA.Y:u%\u0016\u0004xN\u001d;US6,\u0007\u0005K\u0002\u0011\u0003W\u00012aKA\u0017\u0013\r\ty\u0003\f\u0002\tm>d\u0017\r^5mK\u00061Q.\u0019=MC\u001e\f!\"\\1y\u0019\u0006<w\fJ3r)\u0011\ti\"a\u000e\t\u0011\u0005\u0015\"#!AA\u00025\u000bq!\\1y\u0019\u0006<\u0007%\u0001\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\u0006!rN\u001a4tKR<\u0016\u000e\u001e5NCbd\u0015mZ0%KF$B!!\b\u0002B!A\u0011QE\u000b\u0002\u0002\u0003\u0007Q*A\tpM\u001a\u001cX\r^,ji\"l\u0015\r\u001f'bO\u0002\nq#\\1y\u0019\u0006<Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0016\u0003u\n1$\\1y\u0019\u0006<Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\u000f\u0003\u001bB\u0001\"!\n\u0019\u0003\u0003\u0005\r!P\u0001\u0019[\u0006DH*Y4U_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\u0013aF2sK\u0006$XMT3x\r\u0016$8\r[3s\u0005\u0006\u0014(/[3s)\t\ti\"A\thKR4U\r^2iKJ\u0014\u0015M\u001d:jKJ$\"!a\u0002\u00029\r\u0014X-\u0019;f\u001d\u0016<h+\u001a:jM&\u001c\u0017\r^5p]\n\u000b'O]5fe\u00061r-\u001a;WKJLg-[2bi&|gNQ1se&,'/\u0001\u0006j]&$\u0018.\u00197ju\u0016\f\u0011c]3u\u0013:LG/[1m\u001f\u001a47/\u001a;t\u00039\tG\r\u001a$fi\u000eDW\r\u001a#bi\u0006$\u0002\"!\b\u0002f\u0005%\u0014Q\u000e\u0005\u0007\u0003O\u0002\u0003\u0019A\u001f\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002l\u0001\u0002\r\u0001S\u0001\ne\u0016\u0004H.[2b\u0013\u0012Da!a\u001c!\u0001\u0004!\u0017!\u00049beRLG/[8o\t\u0006$\u0018-A\u0005hKR|eMZ:fiR\u0019Q*!\u001e\t\r\u0005\u001d\u0014\u00051\u0001>\u000391XM]5gs\u000eCWmY6Tk6$B!!\b\u0002|!9\u0011Q\u0010\u0012A\u0002\u0005}\u0014a\u00029sS:$HN\u001c\t\bW\u0005\u0005\u0015QQA\u000f\u0013\r\t\u0019\t\f\u0002\n\rVt7\r^5p]F\u0002B!a\"\u0002\u0016:!\u0011\u0011RAI!\r\tY\tL\u0007\u0003\u0003\u001bS1!a$)\u0003\u0019a$o\\8u}%\u0019\u00111\u0013\u0017\u0002\rA\u0013X\rZ3g\u0013\u0011\t9*!'\u0003\rM#(/\u001b8h\u0015\r\t\u0019\n\f")
public class ReplicaBuffer
implements Logging {
    private final Map<TopicPartition, Object> expectedReplicasPerTopicPartition;
    private final Map<TopicPartition, Object> initialOffsets;
    private final int expectedNumFetchers;
    private final long reportInterval;
    private final Pool<TopicPartition, Object> fetchOffsetMap;
    private final Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache;
    private final AtomicReference<CountDownLatch> fetcherBarrier;
    private final AtomicReference<CountDownLatch> verificationBarrier;
    private volatile long lastReportTime;
    private long maxLag;
    private long offsetWithMaxLag;
    private TopicPartition maxLagTopicAndPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Pool<TopicPartition, Object> fetchOffsetMap() {
        return this.fetchOffsetMap;
    }

    private Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache() {
        return this.recordsCache;
    }

    private AtomicReference<CountDownLatch> fetcherBarrier() {
        return this.fetcherBarrier;
    }

    private AtomicReference<CountDownLatch> verificationBarrier() {
        return this.verificationBarrier;
    }

    private long lastReportTime() {
        return this.lastReportTime;
    }

    private void lastReportTime_$eq(long x$1) {
        this.lastReportTime = x$1;
    }

    private long maxLag() {
        return this.maxLag;
    }

    private void maxLag_$eq(long x$1) {
        this.maxLag = x$1;
    }

    private long offsetWithMaxLag() {
        return this.offsetWithMaxLag;
    }

    private void offsetWithMaxLag_$eq(long x$1) {
        this.offsetWithMaxLag = x$1;
    }

    private TopicPartition maxLagTopicAndPartition() {
        return this.maxLagTopicAndPartition;
    }

    private void maxLagTopicAndPartition_$eq(TopicPartition x$1) {
        this.maxLagTopicAndPartition = x$1;
    }

    public void createNewFetcherBarrier() {
        this.fetcherBarrier().set(new CountDownLatch(this.expectedNumFetchers));
    }

    public CountDownLatch getFetcherBarrier() {
        return this.fetcherBarrier().get();
    }

    public void createNewVerificationBarrier() {
        this.verificationBarrier().set(new CountDownLatch(1));
    }

    public CountDownLatch getVerificationBarrier() {
        return this.verificationBarrier().get();
    }

    private void initialize() {
        this.expectedReplicasPerTopicPartition.keySet().foreach((Function1 & Serializable)topicPartition -> this.recordsCache().put((TopicPartition)topicPartition, new Pool(None$.MODULE$)));
        this.setInitialOffsets();
    }

    private void setInitialOffsets() {
        this.initialOffsets.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)ReplicaBuffer.$anonfun$setInitialOffsets$2(this, x$5)));
    }

    public void addFetchedData(TopicPartition topicAndPartition, int replicaId, FetchResponse.PartitionData<MemoryRecords> partitionData) {
        this.recordsCache().get(topicAndPartition).put(replicaId, partitionData);
    }

    public long getOffset(TopicPartition topicAndPartition) {
        return BoxesRunTime.unboxToLong((Object)this.fetchOffsetMap().get(topicAndPartition));
    }

    public void verifyCheckSum(Function1<String, BoxedUnit> println) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Begin verification");
        this.maxLag_$eq(-1L);
        this.recordsCache().withFilter((Function1<Tuple2<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>>, Object>)(Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$8 -> {
            ReplicaBuffer.$anonfun$verifyCheckSum$3(this, println, x$8);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = Time.SYSTEM.milliseconds();
        if (currentTimeMs - this.lastReportTime() > this.reportInterval) {
            println.apply((Object)new StringBuilder(57).append(ReplicaVerificationTool$.MODULE$.dateFormat().format(new Date(currentTimeMs))).append(": max lag is ").append(this.maxLag()).append(" for partition ").append(this.maxLagTopicAndPartition()).append(" at offset ").append(this.offsetWithMaxLag()).append(" among ").append(this.recordsCache().size()).append(" partitions").toString());
            this.lastReportTime_$eq(currentTimeMs);
        }
    }

    public static final /* synthetic */ long $anonfun$setInitialOffsets$2(ReplicaBuffer $this, Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x$5._1();
        long offset = x$5._2$mcJ$sp();
        long l = BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().put(tp, offset));
        return l;
    }

    public static final /* synthetic */ String $anonfun$verifyCheckSum$5(ReplicaBuffer $this, Pool fetchResponsePerReplica$1, TopicPartition topicPartition$1) {
        return new StringBuilder(46).append("fetched ").append(fetchResponsePerReplica$1.size()).append(" replicas for ").append(topicPartition$1).append(", but expected ").append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition$1)).append(" replicas").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyCheckSum$9(ReplicaBuffer $this, Pool fetchResponsePerReplica$1, BooleanRef isMessageInAllReplicas$1, ObjectRef messageInfoFromFirstReplicaOpt$1, Function1 println$1, TopicPartition topicPartition$1, Tuple2 x$7) {
        if (x$7 == null) throw new MatchError(null);
        int replicaId = x$7._1$mcI$sp();
        Iterator recordBatchIterator = (Iterator)x$7._2();
        try {
            if (recordBatchIterator.hasNext()) {
                MutableRecordBatch batch = (MutableRecordBatch)recordBatchIterator.next();
                if (batch.lastOffset() >= ((FetchResponse.PartitionData)fetchResponsePerReplica$1.get(Integer.valueOf((int)replicaId))).highWatermark) {
                    isMessageInAllReplicas$1.elem = false;
                    return;
                } else {
                    Option option = (Option)messageInfoFromFirstReplicaOpt$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        messageInfoFromFirstReplicaOpt$1.elem = new Some((Object)new MessageInfo(replicaId, batch.lastOffset(), batch.nextOffset(), batch.checksum()));
                        return;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        MessageInfo messageInfoFromFirstReplica = (MessageInfo)((Some)option).value();
                        if (messageInfoFromFirstReplica.offset() != batch.lastOffset()) {
                            println$1.apply((Object)new StringBuilder(65).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(": replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s offset ").append(messageInfoFromFirstReplica.offset()).append(" doesn't match replica ").append(replicaId).append("'s offset ").append(batch.lastOffset()).toString());
                            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
                        }
                        if (messageInfoFromFirstReplica.checksum() == batch.checksum()) return;
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)println$1.apply((Object)new StringBuilder(90).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(" has unmatched checksum at offset ").append(batch.lastOffset()).append("; replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s checksum ").append(messageInfoFromFirstReplica.checksum()).append("; replica ").append(replicaId).append("'s checksum ").append(batch.checksum()).toString());
                        return;
                    }
                }
            }
            isMessageInAllReplicas$1.elem = false;
            return;
        }
        catch (Throwable t) {
            throw new RuntimeException(StringOps$.MODULE$.format$extension("Error in processing replica %d in partition %s at offset %d.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{replicaId, topicPartition$1, $this.fetchOffsetMap().get(topicPartition$1)})), t);
        }
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$3(ReplicaBuffer $this, Function1 println$1, Tuple2 x$8) {
        if (x$8 != null) {
            TopicPartition topicPartition = (TopicPartition)x$8._1();
            Pool fetchResponsePerReplica = (Pool)x$8._2();
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Verifying ").append(topicPartition).toString());
            if (!(fetchResponsePerReplica.size() == BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)))) {
                throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)ReplicaBuffer.$anonfun$verifyCheckSum$5($this, fetchResponsePerReplica, topicPartition)).toString());
            }
            Iterable recordBatchIteratorMap = (Iterable)fetchResponsePerReplica.map((Function1 & Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                Tuple2 tuple2;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int replicaId = x0$1._1$mcI$sp();
                FetchResponse.PartitionData fetchResponse = (FetchResponse.PartitionData)x0$1._2();
                Iterator iterator = ((MemoryRecords)fetchResponse.records).batches().iterator();
                Integer $minus$greater$extension_$this = replicaId;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                Object var4_4 = null;
                iterator = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            });
            long maxHw = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)fetchResponsePerReplica.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.highWatermark))).max((Ordering)Ordering.Long$.MODULE$));
            boolean create_e = true;
            BooleanRef isMessageInAllReplicas = new BooleanRef(create_e);
            while (isMessageInAllReplicas.elem) {
                ObjectRef objectRef;
                None$ create_e2 = None$.MODULE$;
                ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e2);
                Object var13_11 = null;
                objectRef = null;
                ObjectRef messageInfoFromFirstReplicaOpt = objectRef2;
                recordBatchIteratorMap.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$7 -> {
                    ReplicaBuffer.$anonfun$verifyCheckSum$9($this, fetchResponsePerReplica, isMessageInAllReplicas, messageInfoFromFirstReplicaOpt, println$1, topicPartition, x$7);
                    return BoxedUnit.UNIT;
                });
                if (!isMessageInAllReplicas.elem) continue;
                long nextOffset = ((MessageInfo)((Option)messageInfoFromFirstReplicaOpt.elem).get()).nextOffset();
                $this.fetchOffsetMap().put(topicPartition, nextOffset);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(26).append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)).append(" replicas match at offset ").toString()).append(new StringBuilder(5).append(nextOffset).append(" for ").append(topicPartition).toString()).toString());
            }
            if (maxHw - BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)) > $this.maxLag()) {
                $this.offsetWithMaxLag_$eq(BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)));
                $this.maxLag_$eq(maxHw - $this.offsetWithMaxLag());
                $this.maxLagTopicAndPartition_$eq(topicPartition);
            }
            fetchResponsePerReplica.clear();
            return;
        }
        throw new MatchError(null);
    }

    public ReplicaBuffer(Map<TopicPartition, Object> expectedReplicasPerTopicPartition, Map<TopicPartition, Object> initialOffsets, int expectedNumFetchers, long reportInterval) {
        this.expectedReplicasPerTopicPartition = expectedReplicasPerTopicPartition;
        this.initialOffsets = initialOffsets;
        this.expectedNumFetchers = expectedNumFetchers;
        this.reportInterval = reportInterval;
        this.fetchOffsetMap = new Pool(None$.MODULE$);
        this.recordsCache = new Pool(None$.MODULE$);
        this.fetcherBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(expectedNumFetchers));
        this.verificationBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.lastReportTime = Time.SYSTEM.milliseconds();
        this.maxLag = -1L;
        this.offsetWithMaxLag = -1L;
        this.maxLagTopicAndPartition = null;
        this.initialize();
    }
}

