/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015uAB6m\u0011\u0003q\u0007O\u0002\u0004sY\"\u0005an\u001d\u0005\u0006u\u0006!\t\u0001 \u0005\b{\u0006\u0011\r\u0011\"\u0001\u007f\u0011\u001d\ty!\u0001Q\u0001\n}D\u0001\"!\u0005\u0002\u0005\u0004%\tA \u0005\b\u0003'\t\u0001\u0015!\u0003\u0000\u0011!\t)\"\u0001b\u0001\n\u0003q\bbBA\f\u0003\u0001\u0006Ia \u0005\n\u00033\t!\u0019!C\u0001\u00037A\u0001\"a\t\u0002A\u0003%\u0011Q\u0004\u0005\n\u0003K\t\u0011\u0013!C\u0001\u0003O1aA\u001d7\u0001]\u0006u\u0002BCA)\u0019\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u00111\u000b\u0007\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005UCB!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002r1\u0011\t\u0011)A\u0005\u0003;A!\"a\u001d\r\u0005\u0003\u0005\u000b\u0011BA;\u0011)\tY\b\u0004B\u0001B\u0003%\u0011Q\u0010\u0005\u000b\u0003\u0007c!\u0011!Q\u0001\n\u0005\u0015\u0005BCAF\u0019\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0012\u0007\u0003\u0002\u0003\u0006I!a$\t\u0015\u0005eEB!A!\u0002\u0013\tY\n\u0003\u0006\u0002,2\u0011\t\u0011)A\u0005\u0003[C!\"a\u0013\r\u0005\u0003\u0005\u000b\u0011BA]\u0011)\t\u0019\r\u0004B\u0001B\u0003%\u0011Q\u0019\u0005\u000b\u0003\u001fd!\u0011!Q\u0001\n\u0005E\u0007BCAo\u0019\t\u0005\t\u0015!\u0003\u0002`\"Q\u0011Q\u001d\u0007\u0003\u0002\u0003\u0006I!!\b\t\ridA\u0011AAt\u000f\u001d\u0011I\u0001\u0004E\u0005\u0005\u00171qAa\u0004\r\u0011\u0013\u0011\t\u0002\u0003\u0004{?\u0011\u0005!q\u0004\u0005\b\u0005CyB\u0011\u0001B\u0012\u0011%\u0011inHA\u0001\n\u0003\u0013y\u000eC\u0005\u0003l~\t\t\u0011\"!\u0003n\u001a9!q\u0002\u0007AY\n5\u0002B\u0003B&I\tU\r\u0011\"\u0001\u0003N!Q!Q\f\u0013\u0003\u0012\u0003\u0006IAa\u0014\t\u0015\t}CE!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0003b\u0011\u0012\t\u0012)A\u0005\u0003;A!Ba\u0019%\u0005+\u0007I\u0011\u0001B'\u0011)\u0011)\u0007\nB\tB\u0003%!q\n\u0005\u000b\u0005O\"#Q3A\u0005\u0002\u0005m\u0001B\u0003B5I\tE\t\u0015!\u0003\u0002\u001e!Q!1\u000e\u0013\u0003\u0016\u0004%\t!a\u0007\t\u0015\t5DE!E!\u0002\u0013\ti\u0002\u0003\u0004{I\u0011\u0005!q\u000e\u0005\b\u0005w\"C\u0011\tB?\u0011%\u0011y\bJA\u0001\n\u0003\u0011\t\tC\u0005\u0003\u000e\u0012\n\n\u0011\"\u0001\u0003\u0010\"I!1\u0013\u0013\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0005+#\u0013\u0013!C\u0001\u0005\u001fC\u0011Ba&%#\u0003%\t!a\n\t\u0013\teE%%A\u0005\u0002\u0005\u001d\u0002\u0002\u0003BNI\u0005\u0005I\u0011\t@\t\u0013\tuE%!A\u0005\u0002\u0005m\u0001\"\u0003BPI\u0005\u0005I\u0011\u0001BQ\u0011%\u0011i\u000bJA\u0001\n\u0003\u0012y\u000bC\u0005\u0003>\u0012\n\t\u0011\"\u0001\u0003@\"I!\u0011\u001a\u0013\u0002\u0002\u0013\u0005#1\u001a\u0005\n\u0005\u001f$\u0013\u0011!C!\u0005#D\u0011Ba5%\u0003\u0003%\tE!6\t\u0013\tmHB1A\u0005\n\tu\b\u0002CB\u0010\u0019\u0001\u0006IAa@\t\u0013\r\u0005BB1A\u0005\n\r\r\u0002\u0002CB \u0019\u0001\u0006Ia!\n\t\u0013\r\u0005CB1A\u0005\n\r\r\u0003\u0002CB&\u0019\u0001\u0006Ia!\u0012\t\u0015\r5CB1A\u0005\u00029\u001cy\u0005\u0003\u0005\u0004X1\u0001\u000b\u0011BB)\u0011%\u0019I\u0006\u0004b\u0001\n\u0003\u0019Y\u0006\u0003\u0005\u0004j1\u0001\u000b\u0011BB/\u0011%\u0019Y\u0007\u0004b\u0001\n\u0013\u0019i\u0007\u0003\u0005\u0004x1\u0001\u000b\u0011BB8\u0011%\u0019I\b\u0004b\u0001\n\u0013\u0019Y\b\u0003\u0005\u0004\u00042\u0001\u000b\u0011BB?\u0011!\u0019)\t\u0004C\tY\u000e\u001d\u0005\"CBJ\u0019\u0001\u0007I\u0011BA\u000e\u0011%\u0019)\n\u0004a\u0001\n\u0013\u00199\n\u0003\u0005\u0004\"2\u0001\u000b\u0015BA\u000f\u0011\u001d\u0019\u0019\u000b\u0004C!\u0007KC\u0001ba*\r\t\u0003a7\u0011\u0016\u0005\b\u0007scA\u0011BB^\u0011\u001d\u0019)\r\u0004C\u0005\u0007KC\u0001ba2\r\t#a7\u0011\u001a\u0005\b\u00073dA\u0011BBS\u0011\u001d\u0019Y\u000e\u0004C\u0005\u0007KCqa!8\r\t\u0013\u0019)\u000bC\u0004\u0004`2!Ia!9\t\u000f\r\u0015H\u0002\"\u0003\u0004&\"91q\u001d\u0007\u0005\n\r\u0015\u0006bBBu\u0019\u0011%11\u001e\u0005\b\u0007cdA\u0011ABz\u0011\u001d!9\u0002\u0004C\u0005\u0007KCq\u0001\"\u0007\r\t\u0013\u0019)\u000b\u0003\u0005\u0004p2!\t\u0002\u001cC\u000e\u0011!!i\u0003\u0004C\u0001Y\u0012=\u0002b\u0002C\u001a\u0019\u0011%AQ\u0007\u0005\t\toaA\u0011\u00017\u0002\u001c!AA\u0011\b\u0007\u0005\u00021\fY\u0002\u0003\u0005\u0005<1!\t\u0001\u001cC\u001f\u0011\u001d!I\u0005\u0004C\u0005\t\u0017Bq\u0001\"\u001e\r\t\u0013!9\b\u0003\u0005\u0005|1!\t\u0001\u001cC?\u0011\u001d!\t\t\u0004C!\u0007KCq\u0001b!\r\t\u0003\u001a)+A\u0005Qe>\u001cWm]:pe*\u0011QN\\\u0001\b]\u0016$xo\u001c:l\u0015\u0005y\u0017!B6bM.\f\u0007CA9\u0002\u001b\u0005a'!\u0003)s_\u000e,7o]8s'\t\tA\u000f\u0005\u0002vq6\taOC\u0001x\u0003\u0015\u00198-\u00197b\u0013\tIhO\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001/A\u000bJI2,\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003mC:<'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002-%#G.\u001a)fe\u000e,g\u000e^'fiJL7MT1nK\u0002\n\u0011DT3uo>\u00148\u000e\u0015:pG\u0016\u001c8o\u001c:NKR\u0014\u0018n\u0019+bO\u0006Qb*\u001a;x_J\\\u0007K]8dKN\u001cxN]'fiJL7\rV1hA\u0005\tB*[:uK:,'/T3ue&\u001cG+Y4\u0002%1K7\u000f^3oKJlU\r\u001e:jGR\u000bw\rI\u0001\u0014\u0007>tg.Z2uS>t\u0017+^3vKNK'0Z\u000b\u0003\u0003;\u00012!^A\u0010\u0013\r\t\tC\u001e\u0002\u0004\u0013:$\u0018\u0001F\"p]:,7\r^5p]F+X-^3TSj,\u0007%\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u001b\u0016\u0005\u0005%\"\u0006BA\u000f\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003o1\u0018AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0006\u0019\u0005}\u0012Q\t\t\u0004c\u0006\u0005\u0013bAA\"Y\n!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017r\u0017aB7fiJL7m]\u0005\u0005\u0003\u001f\nIEA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\f!!\u001b3\u0002\u0007%$\u0007%\u0001\u0003uS6,\u0007\u0003BA-\u0003[j!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0006kRLGn\u001d\u0006\u0005\u0003C\n\u0019'\u0001\u0004d_6lwN\u001c\u0006\u0004_\u0006\u0015$\u0002BA4\u0003S\na!\u00199bG\",'BAA6\u0003\ry'oZ\u0005\u0005\u0003_\nYF\u0001\u0003US6,\u0017AD7bqJ+\u0017/^3tiNK'0Z\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\r\t\u0018qO\u0005\u0004\u0003sb'A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN\u00042!]A@\u0013\r\t\t\t\u001c\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fAcY8o]\u0016\u001cG/[8og6\u000b\u00070\u00133mK6\u001b\bcA;\u0002\b&\u0019\u0011\u0011\u0012<\u0003\t1{gnZ\u0001\u001cM\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8EK2\f\u00170T:\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005E\u0015QS\u0007\u0003\u0003'S1!\\A0\u0013\u0011\t9*a%\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005CV$\bN\u0003\u0003\u0002&\u0006}\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005%\u0016q\u0014\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\faaY8oM&<\u0007\u0003BAX\u0003kk!!!-\u000b\u0007\u0005Mf.\u0001\u0004tKJ4XM]\u0005\u0005\u0003o\u000b\tLA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0003BA^\u0003\u007fk!!!0\u000b\t\u0005-\u0013qL\u0005\u0005\u0003\u0003\fiLA\u0004NKR\u0014\u0018nY:\u0002%\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u0005\u0003\u000f\fY-\u0004\u0002\u0002J*\u0019\u0011Q\u00158\n\t\u00055\u0017\u0011\u001a\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006nK6|'/\u001f)p_2\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fy&\u0001\u0004nK6|'/_\u0005\u0005\u00037\f)N\u0001\u0006NK6|'/\u001f)p_2\f!\u0002\\8h\u0007>tG/\u001a=u!\u0011\tI&!9\n\t\u0005\r\u00181\f\u0002\u000b\u0019><7i\u001c8uKb$\u0018aE2p]:,7\r^5p]F+X-^3TSj,G\u0003IAu\u0003W\fi/a<\u0002r\u0006M\u0018Q_A|\u0003s\fY0!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0005\u000f\u0001\"!\u001d\u0007\t\u000f\u0005ES\u00041\u0001\u0002\u001e!9\u0011QK\u000fA\u0002\u0005]\u0003bBA9;\u0001\u0007\u0011Q\u0004\u0005\b\u0003gj\u0002\u0019AA;\u0011\u001d\tY(\ba\u0001\u0003{Bq!a!\u001e\u0001\u0004\t)\tC\u0004\u0002\fv\u0001\r!!\b\t\u000f\u00055U\u00041\u0001\u0002\u0010\"9\u0011\u0011T\u000fA\u0002\u0005m\u0005bBAV;\u0001\u0007\u0011Q\u0016\u0005\b\u0003\u0017j\u0002\u0019AA]\u0011\u001d\t\u0019-\ba\u0001\u0003\u000bDq!a4\u001e\u0001\u0004\t\t\u000eC\u0004\u0002^v\u0001\r!a8\t\u0013\u0005\u0015X\u0004%AA\u0002\u0005u\u0011\u0001D\"p]:,7\r^5p]&#\u0007c\u0001B\u0007?5\tAB\u0001\u0007D_:tWm\u0019;j_:LEm\u0005\u0003 i\nM\u0001\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\te\u0011qA\u0001\u0003S>LAA!\b\u0003\u0018\ta1+\u001a:jC2L'0\u00192mKR\u0011!1B\u0001\u000bMJ|Wn\u0015;sS:<G\u0003\u0002B\u0013\u00053\u0004R!\u001eB\u0014\u0005WI1A!\u000bw\u0005\u0019y\u0005\u000f^5p]B\u0019!Q\u0002\u0013\u0014\r\u0011\"(q\u0006B\u001b!\r)(\u0011G\u0005\u0004\u0005g1(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005o\u00119E\u0004\u0003\u0003:\t\rc\u0002\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}20\u0001\u0004=e>|GOP\u0005\u0002o&\u0019!Q\t<\u0002\u000fA\f7m[1hK&!!Q\u0004B%\u0015\r\u0011)E^\u0001\nY>\u001c\u0017\r\u001c%pgR,\"Aa\u0014\u0011\t\tE#\u0011\f\b\u0005\u0005'\u0012)\u0006E\u0002\u0003<YL1Aa\u0016w\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\u0002B.\u0015\r\u00119F^\u0001\u000bY>\u001c\u0017\r\u001c%pgR\u0004\u0013!\u00037pG\u0006d\u0007k\u001c:u\u0003)awnY1m!>\u0014H\u000fI\u0001\u000be\u0016lw\u000e^3I_N$\u0018a\u0003:f[>$X\rS8ti\u0002\n!B]3n_R,\u0007k\u001c:u\u0003-\u0011X-\\8uKB{'\u000f\u001e\u0011\u0002\u000b%tG-\u001a=\u0002\r%tG-\u001a=!)1\u0011YC!\u001d\u0003t\tU$q\u000fB=\u0011\u001d\u0011Ye\fa\u0001\u0005\u001fBqAa\u00180\u0001\u0004\ti\u0002C\u0004\u0003d=\u0002\rAa\u0014\t\u000f\t\u001dt\u00061\u0001\u0002\u001e!9!1N\u0018A\u0002\u0005u\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0013\u0001B2paf$BBa\u000b\u0003\u0004\n\u0015%q\u0011BE\u0005\u0017C\u0011Ba\u00132!\u0003\u0005\rAa\u0014\t\u0013\t}\u0013\u0007%AA\u0002\u0005u\u0001\"\u0003B2cA\u0005\t\u0019\u0001B(\u0011%\u00119'\rI\u0001\u0002\u0004\ti\u0002C\u0005\u0003lE\u0002\n\u00111\u0001\u0002\u001e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BIU\u0011\u0011y%a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BR\u0005S\u00032!\u001eBS\u0013\r\u00119K\u001e\u0002\u0004\u0003:L\b\"\u0003BVs\u0005\u0005\t\u0019AA\u000f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0017\t\u0007\u0005g\u0013ILa)\u000e\u0005\tU&b\u0001B\\m\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm&Q\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003B\n\u001d\u0007cA;\u0003D&\u0019!Q\u0019<\u0003\u000f\t{w\u000e\\3b]\"I!1V\u001e\u0002\u0002\u0003\u0007!1U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002\u0000\u0005\u001bD\u0011Ba+=\u0003\u0003\u0005\r!!\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\b\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tMa6\t\u0013\t-f(!AA\u0002\t\r\u0006b\u0002BnC\u0001\u0007!qJ\u0001\u0002g\u0006)\u0011\r\u001d9msRa!1\u0006Bq\u0005G\u0014)Oa:\u0003j\"9!1\n\u0012A\u0002\t=\u0003b\u0002B0E\u0001\u0007\u0011Q\u0004\u0005\b\u0005G\u0012\u0003\u0019\u0001B(\u0011\u001d\u00119G\ta\u0001\u0003;AqAa\u001b#\u0001\u0004\ti\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=(q\u001f\t\u0006k\n\u001d\"\u0011\u001f\t\u000ek\nM(qJA\u000f\u0005\u001f\ni\"!\b\n\u0007\tUhO\u0001\u0004UkBdW-\u000e\u0005\n\u0005s\u001c\u0013\u0011!a\u0001\u0005W\t1\u0001\u001f\u00131\u00039qWm^\"p]:,7\r^5p]N,\"Aa@\u0011\r\r\u000511BB\b\u001b\t\u0019\u0019A\u0003\u0003\u0004\u0006\r\u001d\u0011AC2p]\u000e,(O]3oi*!1\u0011BA\u0004\u0003\u0011)H/\u001b7\n\t\r511\u0001\u0002\u0013\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0003\u0004\u0012\rmQBAB\n\u0015\u0011\u0019)ba\u0006\u0002\u0011\rD\u0017M\u001c8fYNTAa!\u0007\u0002\b\u0005\u0019a.[8\n\t\ru11\u0003\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002\n\u0011#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3t+\t\u0019)\u0003\u0005\u0005\u0004(\r5\"qJB\u0019\u001b\t\u0019IC\u0003\u0003\u0004,\tU\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0007_\u0019ICA\u0002NCB\u0004Baa\r\u0004:9\u0019\u0011o!\u000e\n\u0007\r]B.\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\rm2Q\b\u0002\t%\u0016\u001c\bo\u001c8tK*\u00191q\u00077\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000fI\u0001\u000ee\u0016\u001c\bo\u001c8tKF+X-^3\u0016\u0005\r\u0015\u0003CBB\u0001\u0007\u000f\u001a\t$\u0003\u0003\u0004J\r\r!a\u0005'j].,GM\u00117pG.Lgn\u001a#fcV,\u0017A\u0004:fgB|gn]3Rk\u0016,X\rI\u0001\u000b[\u0016$(/[2UC\u001e\u001cXCAB)!\u0019\u0019\u0019f!\u0016\u0000\u007f6\u00111qA\u0005\u0005\u0007_\u00199!A\u0006nKR\u0014\u0018n\u0019+bON\u0004\u0013!H3ya&\u0014X\rZ\"p]:,7\r^5p]N\\\u0015\u000e\u001c7fI\u000e{WO\u001c;\u0016\u0005\ru\u0003\u0003BB0\u0007Kj!a!\u0019\u000b\t\r\r\u0014QX\u0001\u0006gR\fGo]\u0005\u0005\u0007O\u001a\tGA\u0007Dk6,H.\u0019;jm\u0016\u001cV/\\\u0001\u001fKb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oi\u0002\nq%\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^'fiJL7MT1nKV\u00111q\u000e\t\u0005\u0007c\u001a\u0019(\u0004\u0002\u0002`%!1QOA0\u0005)iU\r\u001e:jG:\u000bW.Z\u0001)Kb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\tg\u0016dWm\u0019;peV\u00111Q\u0010\t\u0005\u0003#\u001by(\u0003\u0003\u0004\u0002\u0006M%\u0001C*fY\u0016\u001cGo\u001c:\u0002\u0013M,G.Z2u_J\u0004\u0013AD2sK\u0006$XmU3mK\u000e$xN\u001d\u000b\u0005\u0007{\u001aI\tC\u0004\u0004\f6\u0003\ra!$\u0002\u001d\rD\u0017M\u001c8fY\n+\u0018\u000e\u001c3feB!\u0011\u0011SBH\u0013\u0011\u0019\t*a%\u0003\u001d\rC\u0017M\u001c8fY\n+\u0018\u000e\u001c3fe\u0006\u0019b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq\u00069b.\u001a=u\u0007>tg.Z2uS>t\u0017J\u001c3fq~#S-\u001d\u000b\u0005\u00073\u001by\nE\u0002v\u00077K1a!(w\u0005\u0011)f.\u001b;\t\u0013\t-v*!AA\u0002\u0005u\u0011\u0001\u00068fqR\u001cuN\u001c8fGRLwN\\%oI\u0016D\b%A\u0002sk:$\"a!'\u0002!A\u0014xnY3tg\u0016C8-\u001a9uS>tGCBBM\u0007W\u001by\u000bC\u0004\u0004.J\u0003\rAa\u0014\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\t\u000f\rE&\u000b1\u0001\u00044\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005o\u0019),\u0003\u0003\u00048\n%#!\u0003+ie><\u0018M\u00197f\u0003]\u0001(o\\2fgN\u001c\u0005.\u00198oK2,\u0005pY3qi&|g\u000e\u0006\u0005\u0004\u001a\u000eu6\u0011YBb\u0011\u001d\u0019yl\u0015a\u0001\u0005\u001f\n\u0011b\u00195b]:,G.\u00133\t\u000f\r56\u000b1\u0001\u0003P!91\u0011W*A\u0002\rM\u0016a\u00059s_\u000e,7o\u001d(foJ+7\u000f]8og\u0016\u001c\u0018\u0001D:f]\u0012\u0014Vm\u001d9p]N,GCBBM\u0007\u0017\u001cy\rC\u0004\u0004NV\u0003\ra!\r\u0002\u0011I,7\u000f]8og\u0016Dqa!5V\u0001\u0004\u0019\u0019.\u0001\u0007sKN\u0004xN\\:f'\u0016tG\r\u0005\u0003\u0002\u0012\u000eU\u0017\u0002BBl\u0003'\u0013AaU3oI\u0006!\u0001o\u001c7m\u0003a\u0001(o\\2fgN\u001cu.\u001c9mKR,GMU3dK&4Xm]\u0001\u0016aJ|7-Z:t\u0007>l\u0007\u000f\\3uK\u0012\u001cVM\u001c3t\u0003Q)\b\u000fZ1uKJ+\u0017/^3ti6+GO]5dgR!1\u0011TBr\u0011\u001d\u0019i-\u0017a\u0001\u0007c\t1\u0003\u001d:pG\u0016\u001c8\u000fR5tG>tg.Z2uK\u0012\fac\u00197pg\u0016,\u0005pY3tg\u000e{gN\\3di&|gn]\u0001\u0006G2|7/\u001a\u000b\u0005\u00073\u001bi\u000fC\u0004\u0004pr\u0003\rAa\u0014\u0002\u0019\r|gN\\3di&|g.\u00133\u0002\r\u0005\u001c7-\u001a9u)!\u0011\tm!>\u0004z\u000eu\bbBB|;\u0002\u00071qB\u0001\u000eg>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f\rmX\f1\u0001\u0003B\u0006AQ.Y=CY>\u001c7\u000eC\u0004\u0004\u0000v\u0003\r\u0001\"\u0001\u00021\u0005\u001c7-\u001a9u_JLE\r\\3QKJ\u001cWM\u001c;NKR,'\u000f\u0005\u0003\u0005\u0004\u0011MQB\u0001C\u0003\u0015\u0011!9\u0001\"\u0003\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0017\"YA\u0003\u0003\u0005\u000e\u0011=\u0011AB=b[6,'O\u0003\u0002\u0005\u0012\u0005\u00191m\\7\n\t\u0011UAQ\u0001\u0002\u0006\u001b\u0016$XM]\u0001\u0018G>tg-[4ve\u0016tUm^\"p]:,7\r^5p]N\f\u0001b\u00197pg\u0016\fE\u000e\u001c\u000b\u0005\u0005\u001f\"i\u0002C\u0004\u0005 \u0001\u0004\r\u0001\"\t\u0002\rM|7m[3u!\u0011!\u0019\u0003\"\u000b\u000e\u0005\u0011\u0015\"\u0002\u0002C\u0014\u0003\u000f\t1A\\3u\u0013\u0011!Y\u0003\"\n\u0003\rM{7m[3u\u0003=)g.];fk\u0016\u0014Vm\u001d9p]N,G\u0003BBM\tcAqa!4b\u0001\u0004\u0019\t$A\beKF,X-^3SKN\u0004xN\\:f)\t\u0019\t$A\tsKN\u0004xN\\:f#V,W/Z*ju\u0016\fQ#\u001b8gY&<\u0007\u000e\u001e*fgB|gn]3D_VtG/\u0001\u000bpa\u0016twJ]\"m_NLgnZ\"iC:tW\r\u001c\u000b\u0005\t\u007f!9\u0005E\u0003v\u0005O!\t\u0005\u0005\u0003\u0002\u0012\u0012\r\u0013\u0002\u0002C#\u0003'\u0013AbS1gW\u0006\u001c\u0005.\u00198oK2Dqaa<f\u0001\u0004\u0011y%\u0001\fiC:$G.Z\"iC:tW\r\\'vi\u0016,e/\u001a8u)\u0019\u0019I\n\"\u0014\u0005P!91q\u001e4A\u0002\t=\u0003b\u0002C)M\u0002\u0007A1K\u0001\u0006KZ,g\u000e\u001e\t\u0005\t+\"yG\u0004\u0003\u0005X\u0011-d\u0002\u0002C-\tSrA\u0001b\u0017\u0005h9!AQ\fC3\u001d\u0011!y\u0006b\u0019\u000f\t\tmB\u0011M\u0005\u0003\u0003WJA!a\u001a\u0002j%\u0019q.!\u001a\n\t\u0005\u0005\u00141M\u0005\u0004[\u0006}\u0013\u0002\u0002C7\u0003'\u000bAbS1gW\u0006\u001c\u0005.\u00198oK2LA\u0001\"\u001d\u0005t\t\u00012\t[1o]\u0016dW*\u001e;f\u000bZ,g\u000e\u001e\u0006\u0005\t[\n\u0019*\u0001\tuef,f.\\;uK\u000eC\u0017M\u001c8fYR!1\u0011\u0014C=\u0011\u001d\u0019yo\u001aa\u0001\u0005\u001f\nqa\u00195b]:,G\u000e\u0006\u0003\u0005@\u0011}\u0004bBBxQ\u0002\u0007!qJ\u0001\u0007o\u0006\\W-\u001e9\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0007")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int $lessinit$greater$default$15() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            void $plus$eq_elem;
            Tuple2 tuple2;
            this.selector().send(responseSend);
            scala.collection.mutable.Map<String, RequestChannel.Response> map = this.inflightResponses();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)connectionId, (Object)response);
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            if (map == null) {
                throw null;
            }
            map.addOne((Object)$plus$eq_elem);
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = RequestHeader.parse((ByteBuffer)receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> $this.time.nanoseconds())) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics());
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data.clientSoftwareName(), apiVersionsRequest.data.clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                Option option = this.inflightResponses().remove((Object)send.destination());
                if (option == null) {
                    throw null;
                }
                Option getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processCompletedSends$2(send);
                }
                Object var4_2 = null;
                RequestChannel.Response response = (RequestChannel.Response)getOrElse_this.get();
                this.updateRequestMetrics(response);
                Option<Function1<Send, BoxedUnit>> option2 = response.onComplete();
                if (option2 == null) {
                    throw null;
                }
                Option<Function1<Send, BoxedUnit>> foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    ((Function1)foreach_this.get()).apply(send);
                }
                Object var5_4 = null;
                this.handleChannelMuteEvent(send.destination(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destination());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destination(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destination()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        Option<KafkaChannel> option = this.openOrClosingChannel(request.context().connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> fold_this = option;
        long l = fold_this.isEmpty() ? 0L : ((KafkaChannel)fold_this.get()).getAndResetNetworkThreadTimeNanos();
        Object var3_3 = null;
        request.updateRequestMetrics(l, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                Option<ConnectionId> option = this.ConnectionId().fromString((String)connectionId);
                if (option == null) {
                    throw null;
                }
                Option<ConnectionId> getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    throw Processor.$anonfun$processDisconnected$2(connectionId);
                }
                Object var4_2 = null;
                String remoteHost = ((ConnectionId)getOrElse_this.get()).remoteHost();
                Option option2 = this.inflightResponses().remove(connectionId);
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
                    this.updateRequestMetrics(response);
                }
                Object var5_4 = null;
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$close$4(this, connectionId, kafkaChannel);
        }
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        Object[] objectArray = new Tuple2[1];
        String $minus$greater$extension_y = ((Object)this.id()).toString();
        String $minus$greater$extension_$this = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        Option option = Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
        if (option == null) {
            throw null;
        }
        Option orElse_this = option;
        Option option2 = orElse_this.isEmpty() ? Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)) : orElse_this;
        return option2;
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            ((KafkaChannel)foreach_this.get()).handleChannelMuteEvent(event);
        }
    }

    private void tryUnmuteChannel(String connectionId) {
        Option<KafkaChannel> option = this.openOrClosingChannel(connectionId);
        if (option == null) {
            throw null;
        }
        Option<KafkaChannel> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            KafkaChannel kafkaChannel = (KafkaChannel)foreach_this.get();
            Processor.$anonfun$tryUnmuteChannel$1(this, kafkaChannel);
        }
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        Object[] objectArray = new Tuple2[1];
        String $minus$greater$extension_y = ((Object)this.id()).toString();
        String $minus$greater$extension_$this = "networkProcessor";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$2() {
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        Option option = Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags())));
        if (option == null) {
            throw null;
        }
        Option fold_this = option;
        double d = fold_this.isEmpty() ? 0.0 : Processor.$anonfun$new$3((KafkaMetric)fold_this.get());
        return d;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processCompletedSends$2(Send send$1) {
        throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send$1.destination()).append(" completed, but not in `inflightResponses`").toString());
    }

    public static final /* synthetic */ long $anonfun$updateRequestMetrics$1() {
        return 0L;
    }

    public static final /* synthetic */ Nothing$ $anonfun$processDisconnected$2(String connectionId$2) {
        throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append(connectionId$2).toString());
    }

    public static final /* synthetic */ void $anonfun$close$4(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        Option option = $this.inflightResponses().remove((Object)connectionId$3);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            RequestChannel.Response response = (RequestChannel.Response)foreach_this.get();
            $this.updateRequestMetrics(response);
        }
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    /*
     * WARNING - void declaration
     */
    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        super(connectionQuotas);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        Object[] objectArray = new Tuple2[2];
        String string = listenerName.value();
        String $minus$greater$extension_$this = Processor$.MODULE$.ListenerMetricTag();
        Object var17_17 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        String string2 = ((Object)id).toString();
        String $minus$greater$extension_$this2 = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var19_19 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.metricTags = AsJavaExtensions.MutableMapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (scala.collection.mutable.Map)((scala.collection.mutable.Map)MapFactory.apply$((MapFactory)LinkedHashMap$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        Object[] objectArray2 = new Tuple2[1];
        String string3 = ((Object)id).toString();
        String $minus$greater$extension_$this3 = Processor$.MODULE$.NetworkProcessorMetricTag();
        Object var21_21 = null;
        string3 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", "socket-server-metrics", this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext));
        this.nextConnectionIndex = 0;
    }

    public static final /* synthetic */ Object $anonfun$updateRequestMetrics$2$adapted(KafkaChannel x$19) {
        return BoxesRunTime.boxToLong((long)x$19.getAndResetNetworkThreadTimeNanos());
    }

    public static final /* synthetic */ Object $anonfun$close$4$adapted(Processor $this, String connectionId$3, KafkaChannel channel) {
        Processor.$anonfun$close$4($this, connectionId$3, channel);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$handleChannelMuteEvent$1$adapted(KafkaChannel.ChannelMuteEvent event$1, KafkaChannel c) {
        c.handleChannelMuteEvent(event$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryUnmuteChannel$1$adapted(Processor $this, KafkaChannel c) {
        Processor.$anonfun$tryUnmuteChannel$1($this, c);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$new$3$adapted(KafkaMetric m) {
        return BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m));
    }

    public static final /* synthetic */ Object $anonfun$processCompletedSends$3$adapted(Send send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processDisconnected$3$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$close$6$adapted(Processor $this, RequestChannel.Response response) {
        $this.updateRequestMetrics(response);
        return BoxedUnit.UNIT;
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return this.localPort();
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return this.remotePort();
                }
                case 4: {
                    return this.index();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "localHost";
                }
                case 1: {
                    return "localPort";
                }
                case 2: {
                    return "remoteHost";
                }
                case 3: {
                    return "remotePort";
                }
                case 4: {
                    return "index";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.localHost()));
            n = Statics.mix((int)n, (int)this.localPort());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteHost()));
            n = Statics.mix((int)n, (int)this.remotePort());
            n = Statics.mix((int)n, (int)this.index());
            int finalizeHash_length = 5;
            return Statics.avalanche((int)(n ^ finalizeHash_length));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            if (this.localPort() != connectionId.localPort()) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

