/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.AbstractReadOnlyDecorator;
import org.apache.kafka.streams.processor.internals.AbstractReadWriteDecorator;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.ToInternal;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class ProcessorContextImpl
extends AbstractProcessorContext
implements RecordCollector.Supplier {
    private StreamTask streamTask;
    private RecordCollector collector;
    private final ToInternal toInternal = new ToInternal();
    private static final To SEND_TO_ALL = To.all();
    final Map<String, String> storeToChangelogTopic = new HashMap<String, String>();
    final Map<String, ThreadCache.DirtyEntryFlushListener> cacheNameToFlushListener = new HashMap<String, ThreadCache.DirtyEntryFlushListener>();

    public ProcessorContextImpl(TaskId id, StreamsConfig config, ProcessorStateManager stateMgr, StreamsMetricsImpl metrics, ThreadCache cache) {
        super(id, config, metrics, stateMgr, cache);
    }

    @Override
    public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
        if (this.stateManager.taskType() != Task.TaskType.ACTIVE) {
            throw new IllegalStateException("Tried to transition processor context to active but the state manager's type was " + (Object)((Object)this.stateManager.taskType()));
        }
        this.streamTask = streamTask;
        this.collector = recordCollector;
        this.cache = newCache;
        this.addAllFlushListenersToNewCache();
    }

    @Override
    public void transitionToStandby(ThreadCache newCache) {
        if (this.stateManager.taskType() != Task.TaskType.STANDBY) {
            throw new IllegalStateException("Tried to transition processor context to standby but the state manager's type was " + (Object)((Object)this.stateManager.taskType()));
        }
        this.streamTask = null;
        this.collector = null;
        this.cache = newCache;
        this.addAllFlushListenersToNewCache();
    }

    @Override
    public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
        this.cacheNameToFlushListener.put(namespace, listener);
        this.cache.addDirtyEntryFlushListener(namespace, listener);
    }

    private void addAllFlushListenersToNewCache() {
        for (Map.Entry<String, ThreadCache.DirtyEntryFlushListener> cacheEntry : this.cacheNameToFlushListener.entrySet()) {
            this.cache.addDirtyEntryFlushListener(cacheEntry.getKey(), cacheEntry.getValue());
        }
    }

    public ProcessorStateManager stateManager() {
        return (ProcessorStateManager)this.stateManager;
    }

    @Override
    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.storeToChangelogTopic.put(store.name(), ProcessorStateManager.storeChangelogTopic(this.applicationId(), store.name()));
        super.register(store, stateRestoreCallback);
    }

    @Override
    public RecordCollector recordCollector() {
        return this.collector;
    }

    @Override
    public void logChange(String storeName, Bytes key, byte[] value, long timestamp) {
        this.throwUnsupportedOperationExceptionIfStandby("logChange");
        this.collector.send(this.storeToChangelogTopic.get(storeName), key, value, (Headers)null, this.taskId().partition, timestamp, BYTES_KEY_SERIALIZER, BYTEARRAY_VALUE_SERIALIZER);
    }

    @Override
    public StateStore getStateStore(String name) {
        this.throwUnsupportedOperationExceptionIfStandby("getStateStore");
        if (this.currentNode() == null) {
            throw new StreamsException("Accessing from an unknown node");
        }
        StateStore globalStore = this.stateManager.getGlobalStore(name);
        if (globalStore != null) {
            return AbstractReadOnlyDecorator.getReadOnlyStore(globalStore);
        }
        if (!this.currentNode().stateStores.contains(name)) {
            throw new StreamsException("Processor " + this.currentNode().name() + " has no access to StateStore " + name + " as the store is not connected to the processor. If you add stores manually via '.addStateStore()' make sure to connect the added store to the processor by providing the processor name to '.addStateStore()' or connect them via '.connectProcessorAndStateStores()'. DSL users need to provide the store name to '.process()', '.transform()', or '.transformValues()' to connect the store to the corresponding operator, or they can provide a StoreBuilder by implementing the stores() method on the Supplier itself. If you do not add stores manually, please file a bug report at https://issues.apache.org/jira/projects/KAFKA.");
        }
        StateStore store = this.stateManager.getStore(name);
        return AbstractReadWriteDecorator.getReadWriteStore(store);
    }

    @Override
    public <K, V> void forward(K key, V value) {
        this.throwUnsupportedOperationExceptionIfStandby("forward");
        this.forward(key, value, SEND_TO_ALL);
    }

    @Override
    @Deprecated
    public <K, V> void forward(K key, V value, int childIndex) {
        this.throwUnsupportedOperationExceptionIfStandby("forward");
        this.forward(key, value, To.child(this.currentNode().children().get(childIndex).name()));
    }

    @Override
    @Deprecated
    public <K, V> void forward(K key, V value, String childName) {
        this.throwUnsupportedOperationExceptionIfStandby("forward");
        this.forward(key, value, To.child(childName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value, To to) {
        this.throwUnsupportedOperationExceptionIfStandby("forward");
        ProcessorNode<?, ?> previousNode = this.currentNode();
        ProcessorRecordContext previousContext = this.recordContext;
        try {
            String sendTo;
            this.toInternal.update(to);
            if (this.toInternal.hasTimestamp()) {
                this.recordContext = new ProcessorRecordContext(this.toInternal.timestamp(), this.recordContext.offset(), this.recordContext.partition(), this.recordContext.topic(), this.recordContext.headers());
            }
            if ((sendTo = this.toInternal.child()) == null) {
                List<ProcessorNode<?, ?>> children = this.currentNode().children();
                for (ProcessorNode<?, ?> child : children) {
                    this.forward(child, key, value);
                }
            } else {
                ProcessorNode child = this.currentNode().getChild(sendTo);
                if (child == null) {
                    throw new StreamsException("Unknown downstream node: " + sendTo + " either does not exist or is not connected to this processor.");
                }
                this.forward(child, key, value);
            }
        }
        finally {
            this.recordContext = previousContext;
            this.setCurrentNode(previousNode);
        }
    }

    private <K, V> void forward(ProcessorNode<K, V> child, K key, V value) {
        this.setCurrentNode(child);
        child.process(key, value);
        if (child.isTerminalNode()) {
            this.streamTask.maybeRecordE2ELatency(this.timestamp(), this.currentSystemTimeMs(), child.name());
        }
    }

    @Override
    public void commit() {
        this.throwUnsupportedOperationExceptionIfStandby("commit");
        this.streamTask.requestCommit();
    }

    @Override
    @Deprecated
    public Cancellable schedule(long intervalMs, PunctuationType type, Punctuator callback) {
        this.throwUnsupportedOperationExceptionIfStandby("schedule");
        if (intervalMs < 1L) {
            throw new IllegalArgumentException("The minimum supported scheduling interval is 1 millisecond.");
        }
        return this.streamTask.schedule(intervalMs, type, callback);
    }

    @Override
    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        this.throwUnsupportedOperationExceptionIfStandby("schedule");
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(interval, "interval");
        return this.schedule(ApiUtils.validateMillisecondDuration(interval, msgPrefix), type, callback);
    }

    @Override
    public String topic() {
        this.throwUnsupportedOperationExceptionIfStandby("topic");
        return super.topic();
    }

    @Override
    public int partition() {
        this.throwUnsupportedOperationExceptionIfStandby("partition");
        return super.partition();
    }

    @Override
    public long offset() {
        this.throwUnsupportedOperationExceptionIfStandby("offset");
        return super.offset();
    }

    @Override
    public long timestamp() {
        this.throwUnsupportedOperationExceptionIfStandby("timestamp");
        return super.timestamp();
    }

    @Override
    public ProcessorNode<?, ?> currentNode() {
        this.throwUnsupportedOperationExceptionIfStandby("currentNode");
        return super.currentNode();
    }

    @Override
    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.throwUnsupportedOperationExceptionIfStandby("setRecordContext");
        super.setRecordContext(recordContext);
    }

    @Override
    public ProcessorRecordContext recordContext() {
        this.throwUnsupportedOperationExceptionIfStandby("recordContext");
        return super.recordContext();
    }

    private void throwUnsupportedOperationExceptionIfStandby(String operationName) {
        if (this.taskType() == Task.TaskType.STANDBY) {
            throw new UnsupportedOperationException("this should not happen: " + operationName + "() is not supported in standby tasks.");
        }
    }
}

