/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.ThroughputThrottler;
import org.apache.kafka.tools.ToolsUtils;

public class ProducerPerformance {
    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ProducerPerformance.argParser();
        try {
            String payloadDelimiter;
            Namespace res = parser.parseArgs(args);
            String topicName = res.getString("topic");
            long numRecords = res.getLong("numRecords");
            Integer recordSize = res.getInt("recordSize");
            int throughput = res.getInt("throughput");
            List producerProps = res.getList("producerConfig");
            String producerConfig = res.getString("producerConfigFile");
            String payloadFilePath = res.getString("payloadFile");
            String transactionalId = res.getString("transactionalId");
            boolean shouldPrintMetrics = res.getBoolean("printMetrics");
            long transactionDurationMs = res.getLong("transactionDurationMs");
            boolean transactionsEnabled = 0L < transactionDurationMs;
            String string = payloadDelimiter = res.getString("payloadDelimiter").equals("\\n") ? "\n" : res.getString("payloadDelimiter");
            if (producerProps == null && producerConfig == null) {
                throw new ArgumentParserException("Either --producer-props or --producer.config must be specified.", parser);
            }
            ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
            if (payloadFilePath != null) {
                Path path = Paths.get(payloadFilePath, new String[0]);
                System.out.println("Reading payloads from: " + path.toAbsolutePath());
                if (Files.notExists(path, new LinkOption[0]) || Files.size(path) == 0L) {
                    throw new IllegalArgumentException("File does not exist or empty file provided.");
                }
                String[] payloadList = new String(Files.readAllBytes(path), "UTF-8").split(payloadDelimiter);
                System.out.println("Number of messages read: " + payloadList.length);
                for (String payload : payloadList) {
                    payloadByteList.add(payload.getBytes(StandardCharsets.UTF_8));
                }
            }
            Properties props = new Properties();
            if (producerConfig != null) {
                props.putAll((Map<?, ?>)Utils.loadProps((String)producerConfig));
            }
            if (producerProps != null) {
                for (String prop : producerProps) {
                    String[] pieces = prop.split("=");
                    if (pieces.length != 2) {
                        throw new IllegalArgumentException("Invalid property: " + prop);
                    }
                    props.put(pieces[0], pieces[1]);
                }
            }
            props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
            if (transactionsEnabled) {
                props.put("transactional.id", transactionalId);
            }
            KafkaProducer producer = new KafkaProducer(props);
            if (transactionsEnabled) {
                producer.initTransactions();
            }
            byte[] payload = null;
            Random random = new Random(0L);
            if (recordSize != null) {
                payload = new byte[recordSize.intValue()];
                for (int i = 0; i < payload.length; ++i) {
                    payload[i] = (byte)(random.nextInt(26) + 65);
                }
            }
            Stats stats = new Stats(numRecords, 5000);
            long startMs = System.currentTimeMillis();
            ThroughputThrottler throttler = new ThroughputThrottler(throughput, startMs);
            int currentTransactionSize = 0;
            long transactionStartTime = 0L;
            for (long i = 0L; i < numRecords; ++i) {
                if (transactionsEnabled && currentTransactionSize == 0) {
                    producer.beginTransaction();
                    transactionStartTime = System.currentTimeMillis();
                }
                if (payloadFilePath != null) {
                    payload = (byte[])payloadByteList.get(random.nextInt(payloadByteList.size()));
                }
                ProducerRecord record = new ProducerRecord(topicName, (Object)payload);
                long sendStartMs = System.currentTimeMillis();
                Callback cb = stats.nextCompletion(sendStartMs, payload.length, stats);
                producer.send(record, cb);
                ++currentTransactionSize;
                if (transactionsEnabled && transactionDurationMs <= sendStartMs - transactionStartTime) {
                    producer.commitTransaction();
                    currentTransactionSize = 0;
                }
                if (!throttler.shouldThrottle(i, sendStartMs)) continue;
                throttler.throttle();
            }
            if (transactionsEnabled && currentTransactionSize != 0) {
                producer.commitTransaction();
            }
            if (!shouldPrintMetrics) {
                producer.close();
                stats.printTotal();
            } else {
                producer.flush();
                stats.printTotal();
                ToolsUtils.printMetrics(producer.metrics());
                producer.close();
            }
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
    }

    private static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"producer-performance").defaultHelp(true).description("This tool is used to verify the producer performance.");
        MutuallyExclusiveGroup payloadOptions = parser.addMutuallyExclusiveGroup().required(true).description("either --record-size or --payload-file must be specified but not both.");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"TOPIC"}).help("produce messages to this topic");
        parser.addArgument(new String[]{"--num-records"}).action((ArgumentAction)Arguments.store()).required(true).type(Long.class).metavar(new String[]{"NUM-RECORDS"}).dest("numRecords").help("number of messages to produce");
        payloadOptions.addArgument(new String[]{"--record-size"}).action((ArgumentAction)Arguments.store()).required(false).type(Integer.class).metavar(new String[]{"RECORD-SIZE"}).dest("recordSize").help("message size in bytes. Note that you must provide exactly one of --record-size or --payload-file.");
        payloadOptions.addArgument(new String[]{"--payload-file"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"PAYLOAD-FILE"}).dest("payloadFile").help("file to read the message payloads from. This works only for UTF-8 encoded text files. Payloads will be read from this file and a payload will be randomly selected when sending messages. Note that you must provide exactly one of --record-size or --payload-file.");
        parser.addArgument(new String[]{"--payload-delimiter"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"PAYLOAD-DELIMITER"}).dest("payloadDelimiter").setDefault((Object)"\\n").help("provides delimiter to be used when --payload-file is provided. Defaults to new line. Note that this parameter will be ignored if --payload-file is not provided.");
        parser.addArgument(new String[]{"--throughput"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"THROUGHPUT"}).help("throttle maximum message throughput to *approximately* THROUGHPUT messages/sec. Set this to -1 to disable throttling.");
        parser.addArgument(new String[]{"--producer-props"}).nargs("+").required(false).metavar(new String[]{"PROP-NAME=PROP-VALUE"}).type(String.class).dest("producerConfig").help("kafka producer related configuration properties like bootstrap.servers,client.id etc. These configs take precedence over those passed via --producer.config.");
        parser.addArgument(new String[]{"--producer.config"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"CONFIG-FILE"}).dest("producerConfigFile").help("producer config properties file.");
        parser.addArgument(new String[]{"--print-metrics"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).metavar(new String[]{"PRINT-METRICS"}).dest("printMetrics").help("print out metrics at the end of the test.");
        parser.addArgument(new String[]{"--transactional-id"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"TRANSACTIONAL-ID"}).dest("transactionalId").setDefault((Object)"performance-producer-default-transactional-id").help("The transactionalId to use if transaction-duration-ms is > 0. Useful when testing the performance of concurrent transactions.");
        parser.addArgument(new String[]{"--transaction-duration-ms"}).action((ArgumentAction)Arguments.store()).required(false).type(Long.class).metavar(new String[]{"TRANSACTION-DURATION"}).dest("transactionDurationMs").setDefault((Object)0L).help("The max age of each transaction. The commitTransaction will be called after this time has elapsed. Transactions are only enabled if this value is positive.");
        return parser;
    }

    private static final class PerfCallback
    implements Callback {
        private final long start;
        private final int iteration;
        private final int bytes;
        private final Stats stats;

        public PerfCallback(int iter, long start, int bytes, Stats stats) {
            this.start = start;
            this.stats = stats;
            this.iteration = iter;
            this.bytes = bytes;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = System.currentTimeMillis();
            int latency = (int)(now - this.start);
            this.stats.record(this.iteration, latency, this.bytes, now);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    private static class Stats {
        private long start = System.currentTimeMillis();
        private long windowStart = System.currentTimeMillis();
        private int[] latencies;
        private int sampling;
        private int iteration = 0;
        private int index;
        private long count;
        private long bytes;
        private int maxLatency;
        private long totalLatency;
        private long windowCount;
        private int windowMaxLatency;
        private long windowTotalLatency;
        private long windowBytes;
        private long reportingInterval;

        public Stats(long numRecords, int reportingInterval) {
            this.sampling = (int)(numRecords / Math.min(numRecords, 500000L));
            this.latencies = new int[(int)(numRecords / (long)this.sampling) + 1];
            this.index = 0;
            this.maxLatency = 0;
            this.totalLatency = 0L;
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
            this.totalLatency = 0L;
            this.reportingInterval = reportingInterval;
        }

        public void record(int iter, int latency, int bytes, long time) {
            ++this.count;
            this.bytes += (long)bytes;
            this.totalLatency += (long)latency;
            this.maxLatency = Math.max(this.maxLatency, latency);
            ++this.windowCount;
            this.windowBytes += (long)bytes;
            this.windowTotalLatency += (long)latency;
            this.windowMaxLatency = Math.max(this.windowMaxLatency, latency);
            if (iter % this.sampling == 0) {
                this.latencies[this.index] = latency;
                ++this.index;
            }
            if (time - this.windowStart >= this.reportingInterval) {
                this.printWindow();
                this.newWindow();
            }
        }

        public Callback nextCompletion(long start, int bytes, Stats stats) {
            PerfCallback cb = new PerfCallback(this.iteration, start, bytes, stats);
            ++this.iteration;
            return cb;
        }

        public void printWindow() {
            long ellapsed = System.currentTimeMillis() - this.windowStart;
            double recsPerSec = 1000.0 * (double)this.windowCount / (double)ellapsed;
            double mbPerSec = 1000.0 * (double)this.windowBytes / (double)ellapsed / 1048576.0;
            System.out.printf("%d records sent, %.1f records/sec (%.2f MB/sec), %.1f ms avg latency, %.1f ms max latency.%n", this.windowCount, recsPerSec, mbPerSec, (double)this.windowTotalLatency / (double)this.windowCount, (double)this.windowMaxLatency);
        }

        public void newWindow() {
            this.windowStart = System.currentTimeMillis();
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
        }

        public void printTotal() {
            long elapsed = System.currentTimeMillis() - this.start;
            double recsPerSec = 1000.0 * (double)this.count / (double)elapsed;
            double mbPerSec = 1000.0 * (double)this.bytes / (double)elapsed / 1048576.0;
            int[] percs = Stats.percentiles(this.latencies, this.index, 0.5, 0.95, 0.99, 0.999);
            System.out.printf("%d records sent, %f records/sec (%.2f MB/sec), %.2f ms avg latency, %.2f ms max latency, %d ms 50th, %d ms 95th, %d ms 99th, %d ms 99.9th.%n", this.count, recsPerSec, mbPerSec, (double)this.totalLatency / (double)this.count, (double)this.maxLatency, percs[0], percs[1], percs[2], percs[3]);
        }

        private static int[] percentiles(int[] latencies, int count, double ... percentiles) {
            int size = Math.min(count, latencies.length);
            Arrays.sort(latencies, 0, size);
            int[] values = new int[percentiles.length];
            for (int i = 0; i < percentiles.length; ++i) {
                int index = (int)(percentiles[i] * (double)size);
                values[i] = latencies[index];
            }
            return values;
        }
    }
}

