/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\be\u0001\u0011\r\u0011\"\u0003+\u0011\u0019\u0019\u0004\u0001)A\u0005W!9A\u0007\u0001b\u0001\n\u0013Q\u0003BB\u001b\u0001A\u0003%1\u0006C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n]BaA\u0011\u0001!\u0002\u0013A\u0004bB\"\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007\u0017\u0002\u0001\u000b\u0011B#\t\u000b1\u0003A\u0011I'\t\u000bi\u0003A\u0011\u000b\u0016\t\u000bm\u0003A\u0011\u0001/\t\u000b%\u0004A\u0011\u0001/\t\u000b-\u0004A\u0011\u00027\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002\"CA,\u0001E\u0005I\u0011BA-\u0011\u001d\ty\u0007\u0001C\u0005\u0003c2a!a \u0001\t\u0005\u0005\u0005B\u0002\u0014\u0018\t\u0003\ty\t\u0003\u0004\u0002\u0016^!\t\u0005\u0018\u0005\u0007\u0003/;B\u0011\t/\u0003-Q\u0013\u0018M\\:bGRLwN\\:C_Vt7-\u001a+fgRT!!\b\u0010\u0002\u0007\u0005\u0004\u0018NC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r\"S\"\u0001\u000f\n\u0005\u0015b\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0003CA\u0012\u0001\u0003I\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3\u0016\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u00121!\u00138u\u0003M\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3!\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\fac]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005Yq.\u001e;qkR$v\u000e]5d+\u0005A\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011a\u0017M\\4\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019=,H\u000f];u)>\u0004\u0018n\u0019\u0011\u0002\u0015%t\u0007/\u001e;U_BL7-A\u0006j]B,H\u000fV8qS\u000e\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u001e\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005q\u0005cA(S)6\t\u0001K\u0003\u0002R[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005M\u0003&aA*fcB\u0011Q\u000bW\u0007\u0002-*\u0011qKH\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005e3&aC&bM.\f7i\u001c8gS\u001e\f1B\u0019:pW\u0016\u00148i\\;oi\u0006yA/Z:u/&$\bn\u0012:pkBLE\rF\u0001^!\tac,\u0003\u0002`[\t!QK\\5uQ\t\u0001\u0012\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006)!.\u001e8ji*\ta-A\u0002pe\u001eL!\u0001[2\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cHoV5uQ\u001e\u0013x.\u001e9NKR\fG-\u0019;bQ\t\t\u0012-A\tuKN$(I]8lKJ4\u0015-\u001b7ve\u0016$\"!X7\t\u000b9\u0014\u0002\u0019A8\u0002\r\r|W.\\5u!!a\u0003O]A\u0004\u00037i\u0016BA9.\u0005%1UO\\2uS>t7\u0007\u0005\u0003twvlX\"\u0001;\u000b\u0005U4\u0018\u0001\u00039s_\u0012,8-\u001a:\u000b\u0005]D\u0018aB2mS\u0016tGo\u001d\u0006\u0003?eT!A_3\u0002\r\u0005\u0004\u0018m\u00195f\u0013\taHOA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0005Yy\f\t!\u0003\u0002\u0000[\t)\u0011I\u001d:bsB\u0019A&a\u0001\n\u0007\u0005\u0015QF\u0001\u0003CsR,\u0007\u0003BA\u0005\u0003/qA!a\u0003\u0002\u0014A\u0019\u0011QB\u0017\u000e\u0005\u0005=!bAA\tA\u00051AH]8pizJ1!!\u0006.\u0003\u0019\u0001&/\u001a3fM&\u0019q(!\u0007\u000b\u0007\u0005UQ\u0006\u0005\u0004\u0002\u001e\u0005\rR0`\u0007\u0003\u0003?Q1!!\tw\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002BA\u0013\u0003?\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\u0018aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000fF\u0002s\u0003WAq!!\f\u0014\u0001\u0004\t9!A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0003i\u0019'/Z1uK\u000e{gn];nKJ\fe\u000eZ*vEN\u001c'/\u001b2f)!\tY\"a\r\u00028\u00055\u0003bBA\u001b)\u0001\u0007\u0011qA\u0001\bOJ|W\u000f]%e\u0011\u001d\tI\u0004\u0006a\u0001\u0003w\ta\u0001^8qS\u000e\u001c\bCBA\u001f\u0003\u000f\n9A\u0004\u0003\u0002@\u0005\rc\u0002BA\u0007\u0003\u0003J\u0011AL\u0005\u0004\u0003\u000bj\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYE\u0001\u0003MSN$(bAA#[!I\u0011q\n\u000b\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u000ee\u0016\fGmQ8n[&$H/\u001a3\u0011\u00071\n\u0019&C\u0002\u0002V5\u0012qAQ8pY\u0016\fg.\u0001\u0013de\u0016\fG/Z\"p]N,X.\u001a:B]\u0012\u001cVOY:de&\u0014W\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tYF\u000b\u0003\u0002R\u0005u3FAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%T&\u0001\u0006b]:|G/\u0019;j_:LA!!\u001c\u0002d\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0005\u0005M\u0004CBA;\u0003wZ3&\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010)\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA?\u0003o\u00121!T1q\u0005=\u0011u.\u001e8dKN\u001b\u0007.\u001a3vY\u0016\u00148cA\f\u0002\u0004B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nz\tQ!\u001e;jYNLA!!$\u0002\b\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e)\t\t\t\nE\u0002\u0002\u0014^i\u0011\u0001A\u0001\u0007I><vN]6\u0002\u0011MDW\u000f\u001e3po:\u0004")
public class TransactionsBounceTest
extends IntegrationTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), true, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public int brokerCount() {
        return 4;
    }

    @Test
    public void testWithGroupId() {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumerGroup);
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension0(n, testBrokerFailure_numInputRecords).toSet();
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((GenTraversableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
    }

    @Test
    public void testWithGroupMetadata() {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumer.groupMetadata());
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension0(n, testBrokerFailure_numInputRecords).toSet();
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((GenTraversableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
    }

    private void testBrokerFailure(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribe(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribe$default$3());
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("test-txn");
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        try {
            IntRef numMessagesProcessed = IntRef.create((int)0);
            IntRef iteration = IntRef.create((int)0);
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                commit.apply(producer, (Object)consumerGroup, consumer);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            scheduler.shutdown();
        }
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(testBrokerFailure_recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(testBrokerFailure_outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Set expectedValues = RichInt$.MODULE$.until$extension0(n, numInputRecords).toSet();
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.$minus$minus((GenTraversableOnce)recordSet)).toString(), (Object)expectedValues, (Object)recordSet);
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        Properties props = new Properties();
        props.put("acks", "all");
        props.put("batch.size", "512");
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        return this.createProducer(x$2, x$3, props);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribe(String groupId, List<String> topics, boolean readCommitted) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, consumerProps, x$4);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribe$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$7(HashMap recordsByPartition$1, ConsumerRecord record) {
        String string = TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int value = new StringOps(string).toInt();
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
        ((BufferLike)recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer())).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$9(ListBuffer outputRecords$1, ListBuffer x0$1) {
        Assert.assertEquals((String)"Out of order messages detected", (Object)x0$1, (Object)x0$1.sorted((Ordering)Ordering.Int$.MODULE$));
        outputRecords$1.appendAll((TraversableOnce)x0$1);
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupMetadata$1$adapted(KafkaProducer producer, String x$2, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions());
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), foreach_i, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Shutting down server : %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Server %s shut down. Starting it up again.";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            server.startup();
            $this.trace((Function0 & Serializable & scala.Serializable)() -> {
                String string = "Restarted server: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())}));
            });
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

