/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005\u0002ABQ\u0001\u0011\u0001\u0005\u0002\u0005CQ!\u0013\u0001\u0005\u0002\u0005CQA\u0014\u0001\u0005\u0002\u0005CQa\u0015\u0001\u0005\u0002\u0005CQ!\u0016\u0001\u0005\u0002\u0005CQa\u0016\u0001\u0005\naCQ!\u001a\u0001\u0005\u0002\u0005CQa\u001a\u0001\u0005\u0002\u0005CQ!\u001b\u0001\u0005\u0002\u0005CQa\u001b\u0001\u0005\u0002\u0005CQ!\u001c\u0001\u0005\u0002\u0005CQa\u001c\u0001\u0005\u0002\u0005CQ!\u001d\u0001\u0005\u0002\u0005CQa\u001d\u0001\u0005\u0002\u0005CQ!\u001e\u0001\u0005\u0002\u0005CQa\u001e\u0001\u0005\u0002\u0005CQ!\u001f\u0001\u0005\u0002\u0005CQa\u001f\u0001\u0005\u0002\u0005CQ! \u0001\u0005\u0002\u0005CQa \u0001\u0005\u0002\u0005Ca!a\u0001\u0001\t\u0003\t\u0005BBA\u0004\u0001\u0011\u0005\u0011\tC\u0004\u0002\f\u0001!I!!\u0004\t\r\u0005\u001d\u0002\u0001\"\u0001B\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aa!a\u0014\u0001\t\u0003\t\u0005bBA*\u0001\u0011\u0005\u0011Q\u000b\u0002\u001b%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7/\u00168jiR+7\u000f\u001e\u0006\u0003A\u0005\nQ!\u00193nS:T\u0011AI\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003}\tQb\u001a7pE\u0006dG+[7f_V$X#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014!\u0002:vY\u0016\u001c(B\u0001\u001c8\u0003\u0015QWO\\5u\u0015\u0005A\u0014aA8sO&\u0011!h\r\u0002\b)&lWm\\;uQ\t\u0011A\b\u0005\u0002>}5\tQ'\u0003\u0002@k\t!!+\u001e7f\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0005C\u0001\u0014D\u0013\t!uE\u0001\u0003V]&$\bFA\u0002G!\tit)\u0003\u0002Ik\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\t-\u0003\"!\u0010'\n\u00055+$!B!gi\u0016\u0014\u0018A\u0007;fgR\u001cu.\u001c9be\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0003Q!\ti\u0014+\u0003\u0002Sk\t!A+Z:u\u0003\u0005\"Xm\u001d;D_6\u0004\u0018M]3U_BL7\rU1si&$\u0018n\u001c8SKBd\u0017nY1tQ\t1\u0001+A\u0012uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8Ti\u0006$Xm\u001d+p'R\u0014\u0018N\\4)\u0005\u001d\u0001\u0016!C1eIR{\u0007/[2t)\t\u0011\u0015\fC\u0003[\u0011\u0001\u00071,A\u0006bI6Lgn\u00117jK:$\bC\u0001/d\u001b\u0005i&B\u0001\u0011_\u0015\ty\u0006-A\u0004dY&,g\u000e^:\u000b\u0005\t\n'B\u000128\u0003\u0019\t\u0007/Y2iK&\u0011A-\u0018\u0002\u0010\u001b>\u001c7.\u00113nS:\u001cE.[3oi\u0006\u0019C/Z:u\r&tG\rU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u0015;bi\u0016\u001c\bFA\u0005Q\u0003a!Xm\u001d;GS:$Gj\\4ESJluN^3Ti\u0006$Xm\u001d\u0015\u0003\u0015A\u000bQ\u0004^3tiJ+\u0007\u000f\\5dC6{g/Z*uCR,7\u000fV8TiJLgn\u001a\u0015\u0003\u0017A\u000b\u0011\u0004^3ti\u001e+GOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8ug\"\u0012A\u0002U\u0001\u001di\u0016\u001cHoR3u\u0005J|7.\u001a:SC\u000e\\\u0017J\u001c4pe6\fG/[8oQ\ti\u0001+A\u0010uKN$\b+\u0019:tK\u001e+g.\u001a:bi\u0016\f5o]5h]6,g\u000e^!sOND#A\u0004)\u0002aQ,7\u000f^$f]\u0016\u0014\u0018\r^3BgNLwM\\7f]R4\u0015-\u001b7t/&$\bn\\;u\u000b:|Wo\u001a5SKBd\u0017nY1tQ\ty\u0001+A\u0016uKN$x)\u001a8fe\u0006$X-Q:tS\u001etW.\u001a8u/&$\b.\u00138d_:\u001c\u0018n\u001d;f]R\u0014\u0016mY6tQ\t\u0001\u0002+\u0001\u0014uKN$x)\u001a8fe\u0006$X-Q:tS\u001etW.\u001a8u/&$\bNR3xKJ\u0014%o\\6feND#!\u0005)\u0002[Q,7\u000f^\"veJ,g\u000e\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$Hk\\*ue&tw\r\u000b\u0002\u0013!\u0006YA/Z:u\u001b>4X-T1qQ\t\u0019\u0002+\u0001\u0010uKN$\b+\u0019:tK\u0016CXmY;uK\u0006\u001b8/[4o[\u0016tG/\u0011:hg\"\u0012A\u0003U\u0001&i\u0016\u001cH/\u0012=fGV$XmV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7OR1jYND#!\u0006)\u0002GQ,7\u000f^#yK\u000e,H/Z,ji\"LeN^1mS\u0012\u0014%o\\6fe&#g)Y5mg\"\u0012a\u0003U\u0001\u001ai\u0016\u001cH/T8eS\u001aL(I]8lKJ$\u0006N]8ui2,7\u000f\u000b\u0002\u0018!\u0006aB/Z:u\u0007V\u0014(+Z1tg&<g.\\3oiN$vn\u0015;sS:<\u0007F\u0001\rQ\u0003m1XM]5gs\n\u0013xn[3s)\"\u0014x\u000e\u001e;mKJ+7/\u001e7ugR9!)a\u0004\u0002\u001a\u0005\r\u0002bBA\t3\u0001\u0007\u00111C\u0001\u0007G>tg-[4\u0011\u0007q\u000b)\"C\u0002\u0002\u0018u\u0013aaQ8oM&<\u0007bBA\u000e3\u0001\u0007\u0011QD\u0001\u001cKb\u0004Xm\u0019;fI&sG/\u001a:Ce>\\WM\u001d+ie>$H\u000f\\3\u0011\u0007\u0019\ny\"C\u0002\u0002\"\u001d\u0012A\u0001T8oO\"9\u0011QE\rA\u0002\u0005u\u0011aI3ya\u0016\u001cG/\u001a3SKBd\u0017nY1BYR,'\u000fT8h\t&\u00148\u000f\u00165s_R$H.Z\u0001\u0019i\u0016\u001cH/T8eS\u001aLHk\u001c9jGRC'o\u001c;uY\u0016\u001c\bF\u0001\u000eQ\u0003i1XM]5gsR{\u0007/[2UQJ|G\u000f\u001e7f%\u0016\u001cX\u000f\u001c;t)\u001d\u0011\u0015qFA\u0019\u0003\u0017Bq!!\u0005\u001c\u0001\u0004\t\u0019\u0002C\u0004\u00024m\u0001\r!!\u000e\u0002-\u0015D\b/Z2uK\u0012dU-\u00193feRC'o\u001c;uY\u0016\u0004B!a\u000e\u0002F9!\u0011\u0011HA!!\r\tYdJ\u0007\u0003\u0003{Q1!a\u0010$\u0003\u0019a$o\\8u}%\u0019\u00111I\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019e\n\u0005\b\u0003\u001bZ\u0002\u0019AA\u001b\u0003a)\u0007\u0010]3di\u0016$gi\u001c7m_^,'\u000f\u00165s_R$H.Z\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeND#\u0001\b)\u0002!\u0005\u001c8/\u001a:u'R\f'\u000f^:XSRDG#\u0002\"\u0002X\u0005m\u0003bBA-;\u0001\u0007\u0011QG\u0001\u0007aJ,g-\u001b=\t\u000f\u0005uS\u00041\u0001\u00026\u0005\u00191\u000f\u001e:")
public class ReassignPartitionsUnitTest {
    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)60000L);
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsUnitTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCompareTopicPartitions() {
        Assert.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("abc", 0), new TopicPartition("abc", 1)));
        Assert.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("def", 0), new TopicPartition("abc", 1)));
    }

    @Test
    public void testCompareTopicPartitionReplicas() {
        Assert.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("abc", 0, 1)));
        Assert.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("cde", 0, 0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignStatesToString() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[3];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState3 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Status of partition reassignment:", "Reassignment of partition bar-0 is still in progress.", "Reassignment of partition foo-0 is complete.", "Reassignment of partition foo-1 is still in progress."}))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.partitionReassignmentStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    private void addTopics(MockAdminClient adminClient) {
        List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(0), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1), (Node)b.get(2)}), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1)})), new TopicPartitionInfo(1, (Node)b.get(1), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}))}), Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFindPartitionReassignmentStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            void $minus$greater$extension_y5;
            void $minus$greater$extension_$this5;
            void $minus$greater$extension_y6;
            void $minus$greater$extension_$this6;
            void $minus$greater$extension_y7;
            void $minus$greater$extension_$this7;
            void $minus$greater$extension_y8;
            void $minus$greater$extension_$this8;
            this.addTopics(adminClient);
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Throwable v = (Throwable)x0$1._2();
                    Class<?> clazz = v.getClass();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Tuple2[] tuple2Array2 = new Tuple2[1];
            Class<UnknownTopicOrPartitionException> clazz = UnknownTopicOrPartitionException.class;
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)reassignmentResult);
            Tuple2[] tuple2Array3 = new Tuple2[2];
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false);
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true);
            Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            Assert.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))));
            scala.collection.immutable.Map cancelResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.cancelPartitionReassignments((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("quux", 2)}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$2 != null) {
                    TopicPartition k = (TopicPartition)x0$2._1();
                    Throwable v = (Throwable)x0$2._2();
                    Class<?> clazz = v.getClass();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Tuple2[] tuple2Array4 = new Tuple2[1];
            Class<UnknownTopicOrPartitionException> clazz2 = UnknownTopicOrPartitionException.class;
            Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 2));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Object)cancelResult);
            Tuple2[] tuple2Array5 = new Tuple2[2];
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState3 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true);
            Object object7 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState4 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true);
            Object object8 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array5[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFindLogDirMoveStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Arrays.asList((Object[])new List[]{Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", null})})).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            void $minus$greater$extension_y5;
            void $minus$greater$extension_$this5;
            void $minus$greater$extension_y6;
            void $minus$greater$extension_$this6;
            void $minus$greater$extension_y7;
            void $minus$greater$extension_$this7;
            void $minus$greater$extension_y8;
            void $minus$greater$extension_$this8;
            void $minus$greater$extension_y9;
            void $minus$greater$extension_$this9;
            void $minus$greater$extension_y10;
            void $minus$greater$extension_$this10;
            void $minus$greater$extension_y11;
            void $minus$greater$extension_$this11;
            void $minus$greater$extension_y12;
            void $minus$greater$extension_$this12;
            this.addTopics(adminClient);
            List b = adminClient.brokers();
            adminClient.addTopic(false, "quux", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
            Tuple2[] tuple2Array = new Tuple2[2];
            String string = "/tmp/kafka-logs1";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
            String string2 = "/tmp/kafka-logs1";
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
            adminClient.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
            Tuple2[] tuple2Array2 = new Tuple2[5];
            ReassignPartitionsCommand.CompletedMoveState completedMoveState = new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0");
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
            ReassignPartitionsCommand.ActiveMoveState activeMoveState = new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1");
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
            ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1");
            Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
            ReassignPartitionsCommand.MissingLogDirMoveState missingLogDirMoveState = new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1");
            Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
            ReassignPartitionsCommand.MissingReplicaMoveState missingReplicaMoveState = new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs0");
            Object object7 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[4] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
            Tuple2[] tuple2Array3 = new Tuple2[5];
            String string3 = "/tmp/kafka-logs0";
            Object object8 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
            String string4 = "/tmp/kafka-logs1";
            Object object9 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            String string5 = "/tmp/kafka-logs1";
            Object object10 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            String string6 = "/tmp/kafka-logs1";
            Object object11 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[3] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            String string7 = "/tmp/kafka-logs0";
            Object object12 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array3[4] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)ReassignPartitionsCommand$.MODULE$.findLogDirMoveStates((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaMoveStatesToString() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Tuple2[] tuple2Array = new Tuple2[6];
        ReassignPartitionsCommand.CompletedMoveState completedMoveState = new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0");
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        ReassignPartitionsCommand.ActiveMoveState activeMoveState = new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1");
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1");
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ReassignPartitionsCommand.MissingReplicaMoveState missingReplicaMoveState = new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs1");
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ReassignPartitionsCommand.ActiveMoveState activeMoveState2 = new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs2");
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.MissingLogDirMoveState missingLogDirMoveState = new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1");
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 2, 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reassignment of replica bar-0-0 completed successfully.", "Reassignment of replica foo-0-0 is still in progress.", "Partition foo-1 on broker 0 is not being moved from log dir /tmp/kafka-logs0 to /tmp/kafka-logs1.", "Partition quux-0 cannot be found in any live log directory on broker 0.", "Partition quux-1 on broker 1 is being moved to log dir /tmp/kafka-logs2 instead of /tmp/kafka-logs1.", "Partition quux-2 is not found in any live log dir on broker 1. There is likely an offline log directory on the broker."}))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.replicaMoveStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetReplicaAssignments() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            this.addTopics(adminClient);
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForTopics((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))));
            Tuple2[] tuple2Array2 = new Tuple2[2];
            GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0}));
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForPartitions((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}))));
        }
    }

    @Test
    public void testGetBrokerRackInformation() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack1"), new Node(2, "locahost", 9094, null)})).build();){
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)new Some((Object)"rack0")), new BrokerMetadata(1, (Option)new Some((Object)"rack1"))})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), true));
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)None$.MODULE$), new BrokerMetadata(1, (Option)None$.MODULE$)})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), false));
            this.assertStartsWith("Not all brokers have rack information", Assert.assertThrows(AdminOperationException.class, (ThrowingRunnable)new ThrowingRunnable(null, adminClient){
                private final MockAdminClient adminClient$1;

                public void run() {
                    ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)this.adminClient$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), true);
                }
                {
                    this.adminClient$1 = adminClient$1;
                }
            }).getMessage());
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(1, (Option)None$.MODULE$), new BrokerMetadata(2, (Option)None$.MODULE$)})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), false));
        }
    }

    @Test
    public void testParseGenerateAssignmentArgs() {
        this.assertStartsWith("Broker list contains duplicate entries", Assert.assertThrows((String)"Expected to detect duplicate broker list entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "1,1,2");
            }
        }).getMessage());
        this.assertStartsWith("Broker list contains duplicate entries", Assert.assertThrows((String)"Expected to detect duplicate broker list entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4,5");
            }
        }).getMessage());
        Assert.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 2, 3, 4})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"));
        this.assertStartsWith("List of topics to reassign contains duplicate entries", Assert.assertThrows((String)"Expected to detect duplicate topic entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4");
            }
        }).getMessage());
        Assert.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3, 4})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"bar\"}], \"version\":1}", "5,3,4"));
    }

    @Test
    public void testGenerateAssignmentFailsWithoutEnoughReplicas() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Replication factor: 3 larger than available brokers: 2", Assert.assertThrows((String)"Expected generateAssignment to fail", InvalidReplicationFactorException.class, (ThrowingRunnable)new ThrowingRunnable(null, adminClient){
                private final MockAdminClient adminClient$2;

                public void run() {
                    ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)this.adminClient$2, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", "0,1", false);
                }
                {
                    this.adminClient$2 = adminClient$2;
                }
            }).getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithInconsistentRacks() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack0"), new Node(2, "locahost", 9094, null), new Node(3, "locahost", 9095, "rack1"), new Node(4, "locahost", 9096, "rack1"), new Node(5, "locahost", 9097, "rack2")})).build();){
            void var3_3;
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            this.addTopics(adminClient);
            this.assertStartsWith("Not all brokers have rack information.", Assert.assertThrows((String)"Expected generateAssignment to fail", AdminOperationException.class, (ThrowingRunnable)new ThrowingRunnable(null, adminClient){
                private final MockAdminClient adminClient$3;

                public void run() {
                    ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)this.adminClient$3, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", true);
                }
                {
                    this.adminClient$3 = adminClient$3;
                }
            }).getMessage());
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map current = (Map)tuple2._2();
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithFewerBrokers() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void var5_5;
            void var4_4;
            this.addTopics(adminClient);
            scala.collection.immutable.Set goalBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}));
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", goalBrokers.mkString(","), false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map proposed = (Map)tuple2._1();
            Map current = (Map)tuple2._2();
            void proposed2 = var4_4;
            void current2 = var5_5;
            Tuple2[] tuple2Array = new Tuple2[3];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0}));
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)current2);
            proposed2.values().foreach(arg_0 -> ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(goalBrokers, (Map)proposed2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCurrentPartitionReplicaAssignmentToString() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Tuple2[] tuple2Array2 = new Tuple2[4];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        GenTraversable genTraversable5 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8}));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable6 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12}));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition replica assignment", "", "{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", "", "Save this to use as the --reassignment-json-file option during rollback"}))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.currentPartitionReplicaAssignmentToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMoveMap() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_$this15;
        void $minus$greater$extension_y16;
        void $minus$greater$extension_$this16;
        void $minus$greater$extension_y17;
        void $minus$greater$extension_$this17;
        Tuple2[] tuple2Array = new Tuple2[2];
        PartitionReassignment partitionReassignment = new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3)}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)$minus$greater$extension_y17);
        PartitionReassignment partitionReassignment2 = new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y16);
        Tuple2[] tuple2Array2 = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y15);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y14);
        Tuple2[] tuple2Array3 = new Tuple2[4];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        GenTraversable genTraversable5 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[2] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        GenTraversable genTraversable6 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[3] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        scala.collection.mutable.Map moveMap = ReassignPartitionsCommand$.MODULE$.calculateMoveMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)));
        Tuple2[] tuple2Array4 = new Tuple2[2];
        Tuple2[] tuple2Array5 = new Tuple2[2];
        ReassignPartitionsCommand.PartitionMove partitionMove = new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})));
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        ReassignPartitionsCommand.PartitionMove partitionMove2 = new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[1] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        GenMap genMap = Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5));
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)"foo");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Tuple2[] tuple2Array6 = new Tuple2[1];
        ReassignPartitionsCommand.PartitionMove partitionMove3 = new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        GenMap genMap2 = Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6));
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)"bar");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Object)moveMap);
        Tuple2[] tuple2Array7 = new Tuple2[2];
        String string = "0:1,0:2,0:3,1:4,1:5,1:6";
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)"foo");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string2 = "0:2,0:3,0:4";
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)"bar");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7)), (Object)ReassignPartitionsCommand$.MODULE$.calculateLeaderThrottles(moveMap));
        Tuple2[] tuple2Array8 = new Tuple2[2];
        String string3 = "0:5,1:7,1:8";
        Object object16 = Predef$.MODULE$.ArrowAssoc((Object)"foo");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string4 = "0:1";
        Object object17 = Predef$.MODULE$.ArrowAssoc((Object)"bar");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8)), (Object)ReassignPartitionsCommand$.MODULE$.calculateFollowerThrottles(moveMap));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8})), (Object)ReassignPartitionsCommand$.MODULE$.calculateReassigningBrokers(moveMap));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})), (Object)ReassignPartitionsCommand$.MODULE$.calculateMovingBrokers((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("quux", 0, 0), new TopicPartitionReplica("quux", 1, 2)}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testParseExecuteAssignmentArgs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        this.assertStartsWith("Partition reassignment list cannot be empty", Assert.assertThrows((String)"Expected to detect empty partition reassignment list", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[]}");
            }
        }).getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assert.assertThrows((String)"Expected to detect a partition list with duplicate entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}");
            }
        }).getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assert.assertThrows((String)"Expected to detect a partition replica list with duplicate entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}");
            }
        }).getMessage());
        this.assertStartsWith("Partition replica lists may not contain duplicate entries", Assert.assertThrows((String)"Expected to detect a partition replica list with duplicate entries", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null){

            public void run() {
                ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,0],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}");
            }
        }).getMessage());
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Tuple2[] tuple2Array3 = new Tuple2[3];
        String string = "/tmp/a";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string2 = "/tmp/b";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "/tmp/c";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}"));
    }

    @Test
    public void testExecuteWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assert.assertThrows((String)"Expected reassignment with non-existent topic to fail", ExecutionException.class, (ThrowingRunnable)new ThrowingRunnable(null, adminClient){
                private final MockAdminClient adminClient$4;

                public void run() {
                    ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)this.adminClient$4, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"quux\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
                }
                {
                    this.adminClient$4 = adminClient$4;
                }
            }).getCause().getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidBrokerIdFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unknown broker id 4", Assert.assertThrows((String)"Expected reassignment with non-existent broker id to fail", AdminCommandFailedException.class, (ThrowingRunnable)new ThrowingRunnable(null, adminClient){
                private final MockAdminClient adminClient$5;

                public void run() {
                    ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)this.adminClient$5, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
                }
                {
                    this.adminClient$5 = adminClient$5;
                }
            }).getMessage());
        }
    }

    @Test
    public void testModifyBrokerThrottles() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyBrokerThrottles((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 1000L, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 2000L);
            ReassignPartitionsCommand$.MODULE$.modifyBrokerThrottles((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), 100L, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), -1L);
            Seq brokers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyBrokerThrottles$1(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), 100L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), 1000L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), 1000L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), 100L, -1L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCurReassignmentsToString() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            this.addTopics(adminClient);
            Assert.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
            Tuple2[] tuple2Array = new Tuple2[3];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 3}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 4, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Throwable v = (Throwable)x0$1._2();
                    Class<?> clazz = v.getClass();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)reassignmentResult);
            Assert.assertEquals((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition reassignments:", "bar-0: replicas: 2,3,0. removing: 0.", "foo-0: replicas: 0,1,2. adding: 4.", "foo-1: replicas: 1,2,3. adding: 4,5. removing: 1,2."}))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
        }
    }

    private void verifyBrokerThrottleResults(Config config, long expectedInterBrokerThrottle, long expectedReplicaAlterLogDirsThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        if (expectedInterBrokerThrottle >= 0L) {
            Assert.assertEquals((Object)((Object)BoxesRunTime.boxToLong((long)expectedInterBrokerThrottle)).toString(), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
            Assert.assertEquals((Object)((Object)BoxesRunTime.boxToLong((long)expectedInterBrokerThrottle)).toString(), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        }
        if (expectedReplicaAlterLogDirsThrottle >= 0L) {
            Assert.assertEquals((Object)((Object)BoxesRunTime.boxToLong((long)expectedReplicaAlterLogDirsThrottle)).toString(), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testModifyTopicThrottles() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            this.addTopics(adminClient);
            Tuple2[] tuple2Array = new Tuple2[2];
            String string = "leaderFoo";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"foo");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            String string2 = "leaderBar";
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"bar");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            Tuple2[] tuple2Array2 = new Tuple2[1];
            String string3 = "followerBar";
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"bar");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ReassignPartitionsCommand$.MODULE$.modifyTopicThrottles((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
            Seq topics = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "foo"}))).map((Function1 & Serializable & scala.Serializable)id -> new ConfigResource(ConfigResource.Type.TOPIC, id.toString()), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(0)), "leaderBar", "followerBar");
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(1)), "leaderFoo", "");
        }
    }

    private void verifyTopicThrottleResults(Config config, String expectedLeaderThrottle, String expectedFollowerThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        Assert.assertEquals((Object)expectedLeaderThrottle.toString(), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        Assert.assertEquals((Object)expectedFollowerThrottle.toString(), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Collections.nCopies(4, Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}))).build();){
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            this.addTopics(adminClient);
            Tuple2[] tuple2Array = new Tuple2[2];
            String string = "/tmp/kafka-logs1";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            String string2 = "/tmp/kafka-logs1";
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("foo", 0, 0)})), (Object)ReassignPartitionsCommand$.MODULE$.alterReplicaLogDirs((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        }
    }

    public void assertStartsWith(String prefix, String str) {
        String string = "Expected the string to start with %s, but it was %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertTrue((String)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, str})), (boolean)str.startsWith(prefix));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        void orNull_ev;
        Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
        if (message == null) {
            throw null;
        }
        Object object = message.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : message.get();
        throw new IllegalArgumentException((String)object);
    }

    public static final /* synthetic */ void $anonfun$testGenerateAssignmentWithFewerBrokers$1(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq x0$1) {
        if (!x0$1.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> goalBrokers$1.contains((Object)BoxesRunTime.boxToInteger((int)x$3)))) {
            Assert.fail((String)new StringBuilder(57).append("Proposed assignment ").append(proposed$1).append(" puts replicas on brokers ").append("other than ").append(goalBrokers$1).toString());
            return;
        }
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyBrokerThrottles$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)id)).toString());
    }

    public static final /* synthetic */ Object $anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq x0$1) {
        ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1(goalBrokers$1, proposed$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

