/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u001e=\u0001\u0005C\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"I\u0011\f\u0001B\u0001B\u0003%!\f\u0019\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011!i\u0007A!A!\u0002\u0013q\u0007\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005\r\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0011)A\u0005\u0003\u001bAq!!\u0007\u0001\t\u0003\tY\u0002C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026!9\u0011q\u0007\u0001!\u0002\u0013)\u0006\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005u\u0002\"CA#\u0001\t\u0007I\u0011BA$\u0011!\tI\u0005\u0001Q\u0001\n\u0005M\u0001BCA&\u0001\t\u0007I\u0011\u0001\u001f\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005\u0003\u0006\u0002X\u0001\u0011\r\u0011\"\u0001=\u0003\u001bB\u0001\"!\u0017\u0001A\u0003%\u0011q\n\u0005\u000b\u00037\u0002!\u0019!C\u0001y\u00055\u0003\u0002CA/\u0001\u0001\u0006I!a\u0014\t\u0013\u0005}\u0003A1A\u0005\n\u0005\u0005\u0004\u0002CA:\u0001\u0001\u0006I!a\u0019\t\u0013\u0005U\u0004A1A\u0005\n\u0005\u0005\u0004\u0002CA<\u0001\u0001\u0006I!a\u0019\t\u0013\u0005e\u0004A1A\u0005\n\u0005\u0005\u0004\u0002CA>\u0001\u0001\u0006I!a\u0019\t\u0013\u0005u\u0004A1A\u0005\n\u0005\u0005\u0004\u0002CA@\u0001\u0001\u0006I!a\u0019\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005\r\u0005\u0002CAF\u0001\u0001\u0006I!!\"\t\u0013\u00055\u0005A1A\u0005\u0002\u0005=\u0005\u0002CAO\u0001\u0001\u0006I!!%\t\u000f\u0005}\u0005\u0001\"\u0015\u0002\"\"9\u0011\u0011\u0017\u0001\u0005R\u0005M\u0006bBA_\u0001\u0011E\u0013q\u0018\u0005\b\u0003\u0007\u0004A\u0011KAc\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002d\u0002!\t%!:\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!Q\u0004\u0001\u0005R\t}\u0001b\u0002B#\u0001\u0011E#q\t\u0005\b\u0005\u001f\u0002A\u0011\u000bB)\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BqAa\u0019\u0001\t\u0003\u0012)\u0007C\u0004\u0003\u0012\u0002!\tEa%\t\u000f\t\r\u0006\u0001\"\u0015\u0003&\"9!Q\u0016\u0001\u0005B\t=\u0006b\u0002Bc\u0001\u0011\u0005\u00131\u0011\u0005\b\u0005\u000f\u0004A\u0011\u0002Be\u00115\u0011\u0019\u000e\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002BkA\u001eI!q\u001b\u001f\u0002\u0002#\u0005!\u0011\u001c\u0004\twq\n\t\u0011#\u0001\u0003\\\"9\u0011\u0011\u0004\u001d\u0005\u0002\t\r\b\"\u0003BsqE\u0005I\u0011\u0001Bt\u0005Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bI*\u0011QHP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0005B\u00111\tR\u0007\u0002y%\u0011Q\t\u0010\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003\u0011q\u0017-\\3\u0011\u0005!\u000bfBA%P!\tQU*D\u0001L\u0015\ta\u0005)\u0001\u0004=e>|GO\u0010\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+T\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u001b\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\t\u0003-^k\u0011!T\u0005\u000316\u00131!\u00138u\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tYf,D\u0001]\u0015\tif(A\u0004dYV\u001cH/\u001a:\n\u0005}c&A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0005\u00033\u0012\u000bAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"aQ2\n\u0005\u0011d$aC&bM.\f7i\u001c8gS\u001e\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005\r;\u0017B\u00015=\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u0004\"aQ6\n\u00051d$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\b[\u0016$(/[2t!\ty\u00070D\u0001q\u0015\ti\u0017O\u0003\u0002sg\u000611m\\7n_:T!a\u0010;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003sB\u0014q!T3ue&\u001c7/\u0001\u0003uS6,\u0007C\u0001?\u0000\u001b\u0005i(B\u0001@r\u0003\u0015)H/\u001b7t\u0013\r\t\t! \u0002\u0005)&lW-A\u0003rk>$\u0018\rE\u0002D\u0003\u000fI1!!\u0003=\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003iaW-\u00193fe\u0016sG\r]8j]R\u0014En\\2lS:<7+\u001a8e!\u00151\u0016qBA\n\u0013\r\t\t\"\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\r\u000b)\"C\u0002\u0002\u0018q\u0012AB\u00117pG.LgnZ*f]\u0012\fa\u0001P5oSRtDCFA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u0011\u0005\r\u0003\u0001\"\u0002$\f\u0001\u00049\u0005\"\u0002+\f\u0001\u0004)\u0006\"B-\f\u0001\u0004Q\u0006\"B1\f\u0001\u0004\u0011\u0007\"B3\f\u0001\u00041\u0007\"B5\f\u0001\u0004Q\u0007\"B7\f\u0001\u0004q\u0007\"\u0002>\f\u0001\u0004Y\bbBA\u0002\u0017\u0001\u0007\u0011Q\u0001\u0005\n\u0003\u0017Y\u0001\u0013!a\u0001\u0003\u001b\t\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003U\u000b!B]3qY&\u001c\u0017-\u00133!\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003{\u00012\u0001`A \u0013\r\t\t% \u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\na\u0002\\3bI\u0016\u0014XI\u001c3q_&tG/\u0006\u0002\u0002\u0014\u0005yA.Z1eKJ,e\u000e\u001a9pS:$\b%A\ngKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g.\u0006\u0002\u0002PA\u0019a+!\u0015\n\u0007\u0005MSJA\u0003TQ>\u0014H/\u0001\u000bgKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000eI\u0001#_\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8\u0002G=4gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u-\u0016\u00148/[8oA\u0005AB.[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8\u000231L7\u000f^(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000eI\u0001\b[\u0006Dx+Y5u+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005=TBAA4\u0015\u0011\tI'a\u001b\u0002\t1\fgn\u001a\u0006\u0003\u0003[\nAA[1wC&!\u0011\u0011OA4\u0005\u001dIe\u000e^3hKJ\f\u0001\"\\1y/\u0006LG\u000fI\u0001\t[&t')\u001f;fg\u0006IQ.\u001b8CsR,7\u000fI\u0001\t[\u0006D()\u001f;fg\u0006IQ.\u0019=CsR,7\u000fI\u0001\nM\u0016$8\r[*ju\u0016\f!BZ3uG\"\u001c\u0016N_3!\u0003\u0001\u0012'o\\6feN+\b\u000f]8siNdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;\u0016\u0005\u0005\u0015\u0005c\u0001,\u0002\b&\u0019\u0011\u0011R'\u0003\u000f\t{w\u000e\\3b]\u0006\t#M]8lKJ\u001cV\u000f\u001d9peR\u001cH*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uA\u0005\u0019b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7feV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011qS:\u0002\u000f\rd\u0017.\u001a8ug&!\u00111TAK\u0005M1U\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0003Q1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3sA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\t\u0019+!*\u0011\tY\u000by!\u0016\u0005\b\u0003O#\u0003\u0019AAU\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a+\u0002.6\t\u0011/C\u0002\u00020F\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\u0005U\u00161\u0018\t\u0004-\u0006]\u0016bAA]\u001b\n!Aj\u001c8h\u0011\u001d\t9+\na\u0001\u0003S\u000bA\u0002\\8h\u000b:$wJ\u001a4tKR$B!!.\u0002B\"9\u0011q\u0015\u0014A\u0002\u0005%\u0016!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u0011qYAh\u0003#\u0004RAVA\b\u0003\u0013\u00042aQAf\u0013\r\ti\r\u0010\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\t9k\na\u0001\u0003SCa!a5(\u0001\u0004)\u0016!B3q_\u000eD\u0017\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\t))A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u000b\u0003\u0003;\u00042AVAp\u0013\r\t\t/\u0014\u0002\u0005+:LG/\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003O\f)0a>\u0002|B)a+a\u0004\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002pz\n1\u0001\\8h\u0013\u0011\t\u00190!<\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t9K\u000ba\u0001\u0003SCq!!?+\u0001\u0004\t),A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBA\u007fU\u0001\u0007\u0011q`\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t\u0005!1A\u0007\u0002\u0001%\u0019!Q\u0001#\u0003\u0013\u0019+Go\u00195ECR\f\u0017aG7bs\n,w+\u0019:o\u0013\u001a|e/\u001a:tSj,GMU3d_J$7\u000f\u0006\u0004\u0002^\n-!1\u0004\u0005\b\u0005\u001bY\u0003\u0019\u0001B\b\u0003\u001d\u0011XmY8sIN\u0004BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+\t\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0003\u001a\tM!!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002(.\u0002\r!!+\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$BA!\t\u0003.AA!1\u0005B\u0015\u0003S\u000by0\u0004\u0002\u0003&)\u0019!qE'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003,\t\u0015\"aA'ba\"9!q\u0006\u0017A\u0002\tE\u0012\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003\u0002B\u001a\u0005\u007fqAA!\u000e\u0003<5\u0011!q\u0007\u0006\u0004\u0005s\t\u0018\u0001\u0003:fcV,7\u000f^:\n\t\tu\"qG\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005\u0003\u0012\u0019EA\u0004Ck&dG-\u001a:\u000b\t\tu\"qG\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u0011Q\u0017B%\u0005\u0017Bq!a*.\u0001\u0004\tI\u000b\u0003\u0004\u0003N5\u0002\r!V\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003k\u0013\u0019F!\u0016\t\u000f\u0005\u001df\u00061\u0001\u0002*\"1!Q\n\u0018A\u0002U\u000bQCZ3uG\"|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0005\u00026\nm#Q\fB0\u0011\u001d\t9k\fa\u0001\u0003SCaA!\u00140\u0001\u0004)\u0006b\u0002B1_\u0001\u0007\u0011QW\u0001\u0011K\u0006\u0014H.[3ti>\u0013H*\u0019;fgR\f!BY;jY\u00124U\r^2i)\u0011\u00119G!\"\u0011\r\t%$q\u000fB?\u001d\u0011\u0011YGa\u001d\u000f\t\t5$\u0011\u000f\b\u0004\u0015\n=\u0014\"A \n\u0005ur\u0014b\u0001B;y\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002\u0002B=\u0005w\u0012ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c(b\u0001B;yA)a+a\u0004\u0003\u0000A!!\u0011\u000eBA\u0013\u0011\u0011\u0019Ia\u001f\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\t\u001d\u0005\u00071\u0001\u0003\n\u0006a\u0001/\u0019:uSRLwN\\'baBA!1\u0005B\u0015\u0003S\u0013Y\tE\u0002D\u0005\u001bK1Aa$=\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003!!(/\u001e8dCR,GCBAo\u0005+\u0013I\nC\u0004\u0003\u0018F\u0002\r!!+\u0002\u0005Q\u0004\bb\u0002BNc\u0001\u0007!QT\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\r\u0019%qT\u0005\u0004\u0005Cc$!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!8\u0003(\n%\u0006bBATe\u0001\u0007\u0011\u0011\u0016\u0005\b\u0005W\u0013\u0004\u0019AA[\u0003\u0019ygMZ:fi\u0006!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$BA!-\u0003:BA!1\u0005B\u0015\u0003S\u0013\u0019\f\u0005\u0003\u00036\tU\u0016\u0002\u0002B\\\u0005o\u0011a\"\u00129pG\",e\u000eZ(gMN,G\u000fC\u0004\u0003<N\u0002\rA!0\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0005\u0003$\t%\u0012\u0011\u0016B`!\u0011\u0011\tA!1\n\u0007\t\rGIA\u0005Fa>\u001c\u0007\u000eR1uC\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0002-MDw.\u001e7e\r>dGn\\<feRC'o\u001c;uY\u0016$\u0002\"!\"\u0003L\n5'\u0011\u001b\u0005\b\u0003\u0007)\u0004\u0019AA\u0003\u0011\u001d\u0011y-\u000ea\u0001\u0005\u0017\u000b!BZ3uG\"\u001cF/\u0019;f\u0011\u001d\t9+\u000ea\u0001\u0003S\u000b!c];qKJ$3o\\;sG\u0016\u0014%o\\6feV\t!,\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\t\u0003\u0007b\u001a2\u0001\u000fBo!\r1&q\\\u0005\u0004\u0005Cl%AB!osJ+g\r\u0006\u0002\u0003Z\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001BuU\u0011\tiAa;,\u0005\t5\b\u0003\u0002Bx\u0005sl!A!=\u000b\t\tM(Q_\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa>N\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005w\u0014\tPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        Log log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            String string = "Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalStateException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData$1.highWatermark)}));
            });
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Follower has replica log end offset %d after appending %d bytes of messages for partition %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition}));
            });
        }
        long leaderLogStartOffset = partitionData.logStartOffset;
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark);
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LeaderOffsetIncremented$.MODULE$);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        scala.collection.immutable.Map map;
        try {
            FetchResponse fetchResponse = (FetchResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest).responseBody();
            if (this.fetchSessionHandler().handleResponse(fetchResponse)) {
                return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala();
            }
            map = Map$.MODULE$.empty();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return map;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    /*
     * WARNING - void declaration
     */
    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        void $minus$greater$extension_$this;
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)requestPartitionData);
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)((ListOffsetResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody()).responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
        return l;
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitionMap.size(), false);
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
                if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, fetchState, topicPartition)) {
                    try {
                        long logStartOffset = this.logStartOffset(topicPartition);
                        builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(tp).get();
        Log log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        ((Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get()).truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    EpochEndOffset epochEndOffset = new EpochEndOffset(error, -1, -1L);
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
        }
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public static final /* synthetic */ ReplicaFetcherBlockingSend $anonfun$leaderEndpoint$1(ReplicaFetcherThread $this) {
        return new ReplicaFetcherBlockingSend($this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append($this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), $this.logContext());
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append("fetcherId=").append(fetcherId).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        if (leaderEndpointBlockingSend == null) {
            throw null;
        }
        Object object = leaderEndpointBlockingSend.isEmpty() ? ReplicaFetcherThread.$anonfun$leaderEndpoint$1(this) : leaderEndpointBlockingSend.get();
        this.leaderEndpoint = (BlockingSend)object;
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0)));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

