/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.connect.mirror.MirrorCheckpointConnector;
import org.apache.kafka.connect.mirror.MirrorSourceConnector;
import org.apache.kafka.connect.mirror.MirrorTaskConfig;
import org.apache.kafka.connect.mirror.ReplicationPolicy;

class MirrorMetrics
implements AutoCloseable {
    private static final String SOURCE_CONNECTOR_GROUP = MirrorSourceConnector.class.getSimpleName();
    private static final String CHECKPOINT_CONNECTOR_GROUP = MirrorCheckpointConnector.class.getSimpleName();
    private static final Set<String> PARTITION_TAGS = new HashSet<String>(Arrays.asList("target", "topic", "partition"));
    private static final Set<String> GROUP_TAGS = new HashSet<String>(Arrays.asList("source", "target", "group", "topic", "partition"));
    private static final MetricNameTemplate RECORD_COUNT = new MetricNameTemplate("record-count", SOURCE_CONNECTOR_GROUP, "Number of source records replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate RECORD_RATE = new MetricNameTemplate("record-rate", SOURCE_CONNECTOR_GROUP, "Average number of source records replicated to the target cluster per second.", PARTITION_TAGS);
    private static final MetricNameTemplate RECORD_AGE = new MetricNameTemplate("record-age-ms", SOURCE_CONNECTOR_GROUP, "The age of incoming source records when replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate RECORD_AGE_MAX = new MetricNameTemplate("record-age-ms-max", SOURCE_CONNECTOR_GROUP, "The max age of incoming source records when replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate RECORD_AGE_MIN = new MetricNameTemplate("record-age-ms-min", SOURCE_CONNECTOR_GROUP, "The min age of incoming source records when replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate RECORD_AGE_AVG = new MetricNameTemplate("record-age-ms-avg", SOURCE_CONNECTOR_GROUP, "The average age of incoming source records when replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate BYTE_COUNT = new MetricNameTemplate("byte-count", SOURCE_CONNECTOR_GROUP, "Number of bytes replicated to the target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate BYTE_RATE = new MetricNameTemplate("byte-rate", SOURCE_CONNECTOR_GROUP, "Average number of bytes replicated per second.", PARTITION_TAGS);
    private static final MetricNameTemplate REPLICATION_LATENCY = new MetricNameTemplate("replication-latency-ms", SOURCE_CONNECTOR_GROUP, "Time it takes records to replicate from source to target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate REPLICATION_LATENCY_MAX = new MetricNameTemplate("replication-latency-ms-max", SOURCE_CONNECTOR_GROUP, "Max time it takes records to replicate from source to target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate REPLICATION_LATENCY_MIN = new MetricNameTemplate("replication-latency-ms-min", SOURCE_CONNECTOR_GROUP, "Min time it takes records to replicate from source to target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate REPLICATION_LATENCY_AVG = new MetricNameTemplate("replication-latency-ms-avg", SOURCE_CONNECTOR_GROUP, "Average time it takes records to replicate from source to target cluster.", PARTITION_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY = new MetricNameTemplate("checkpoint-latency-ms", CHECKPOINT_CONNECTOR_GROUP, "Time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_MAX = new MetricNameTemplate("checkpoint-latency-ms-max", CHECKPOINT_CONNECTOR_GROUP, "Max time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_MIN = new MetricNameTemplate("checkpoint-latency-ms-min", CHECKPOINT_CONNECTOR_GROUP, "Min time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private static final MetricNameTemplate CHECKPOINT_LATENCY_AVG = new MetricNameTemplate("checkpoint-latency-ms-avg", CHECKPOINT_CONNECTOR_GROUP, "Average time it takes consumer group offsets to replicate from source to target cluster.", GROUP_TAGS);
    private final Metrics metrics;
    private final Map<TopicPartition, PartitionMetrics> partitionMetrics;
    private final Map<String, GroupMetrics> groupMetrics = new HashMap<String, GroupMetrics>();
    private final String source;
    private final String target;

    MirrorMetrics(MirrorTaskConfig taskConfig) {
        this.target = taskConfig.targetClusterAlias();
        this.source = taskConfig.sourceClusterAlias();
        this.metrics = new Metrics();
        this.metrics.sensor("record-count");
        this.metrics.sensor("byte-rate");
        this.metrics.sensor("record-age");
        this.metrics.sensor("replication-latency");
        ReplicationPolicy replicationPolicy = taskConfig.replicationPolicy();
        this.partitionMetrics = taskConfig.taskTopicPartitions().stream().map(x -> new TopicPartition(replicationPolicy.formatRemoteTopic(this.source, x.topic()), x.partition())).collect(Collectors.toMap(x -> x, x -> new PartitionMetrics((TopicPartition)x)));
    }

    @Override
    public void close() {
        this.metrics.close();
    }

    void countRecord(TopicPartition topicPartition) {
        this.partitionMetrics.get(topicPartition).recordSensor.record();
    }

    void recordAge(TopicPartition topicPartition, long ageMillis) {
        this.partitionMetrics.get(topicPartition).recordAgeSensor.record((double)ageMillis);
    }

    void replicationLatency(TopicPartition topicPartition, long millis) {
        this.partitionMetrics.get(topicPartition).replicationLatencySensor.record((double)millis);
    }

    void recordBytes(TopicPartition topicPartition, long bytes) {
        this.partitionMetrics.get(topicPartition).byteSensor.record((double)bytes);
    }

    void checkpointLatency(TopicPartition topicPartition, String group, long millis) {
        this.group(topicPartition, group).checkpointLatencySensor.record((double)millis);
    }

    GroupMetrics group(TopicPartition topicPartition, String group) {
        return this.groupMetrics.computeIfAbsent(String.join((CharSequence)"-", topicPartition.toString(), group), x -> new GroupMetrics(topicPartition, group));
    }

    void addReporter(MetricsReporter reporter) {
        this.metrics.addReporter(reporter);
    }

    private class GroupMetrics {
        private final Sensor checkpointLatencySensor;

        GroupMetrics(TopicPartition topicPartition, String group) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("source", MirrorMetrics.this.source);
            tags.put("target", MirrorMetrics.this.target);
            tags.put("group", group);
            tags.put("topic", topicPartition.topic());
            tags.put("partition", Integer.toString(topicPartition.partition()));
            this.checkpointLatencySensor = MirrorMetrics.this.metrics.sensor("checkpoint-latency");
            this.checkpointLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY, tags), (MeasurableStat)new Value());
            this.checkpointLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_MAX, tags), (MeasurableStat)new Max());
            this.checkpointLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_MIN, tags), (MeasurableStat)new Min());
            this.checkpointLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(CHECKPOINT_LATENCY_AVG, tags), (MeasurableStat)new Avg());
        }
    }

    private class PartitionMetrics {
        private final Sensor recordSensor;
        private final Sensor byteSensor;
        private final Sensor recordAgeSensor;
        private final Sensor replicationLatencySensor;

        PartitionMetrics(TopicPartition topicPartition) {
            String prefix = topicPartition.topic() + "-" + topicPartition.partition() + "-";
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("target", MirrorMetrics.this.target);
            tags.put("topic", topicPartition.topic());
            tags.put("partition", Integer.toString(topicPartition.partition()));
            this.recordSensor = MirrorMetrics.this.metrics.sensor(prefix + "records-sent");
            this.recordSensor.add((CompoundStat)new Meter(MirrorMetrics.this.metrics.metricInstance(RECORD_RATE, tags), MirrorMetrics.this.metrics.metricInstance(RECORD_COUNT, tags)));
            this.byteSensor = MirrorMetrics.this.metrics.sensor(prefix + "bytes-sent");
            this.byteSensor.add((CompoundStat)new Meter(MirrorMetrics.this.metrics.metricInstance(BYTE_RATE, tags), MirrorMetrics.this.metrics.metricInstance(BYTE_COUNT, tags)));
            this.recordAgeSensor = MirrorMetrics.this.metrics.sensor(prefix + "record-age");
            this.recordAgeSensor.add(MirrorMetrics.this.metrics.metricInstance(RECORD_AGE, tags), (MeasurableStat)new Value());
            this.recordAgeSensor.add(MirrorMetrics.this.metrics.metricInstance(RECORD_AGE_MAX, tags), (MeasurableStat)new Max());
            this.recordAgeSensor.add(MirrorMetrics.this.metrics.metricInstance(RECORD_AGE_MIN, tags), (MeasurableStat)new Min());
            this.recordAgeSensor.add(MirrorMetrics.this.metrics.metricInstance(RECORD_AGE_AVG, tags), (MeasurableStat)new Avg());
            this.replicationLatencySensor = MirrorMetrics.this.metrics.sensor(prefix + "replication-latency");
            this.replicationLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(REPLICATION_LATENCY, tags), (MeasurableStat)new Value());
            this.replicationLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(REPLICATION_LATENCY_MAX, tags), (MeasurableStat)new Max());
            this.replicationLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(REPLICATION_LATENCY_MIN, tags), (MeasurableStat)new Min());
            this.replicationLatencySensor.add(MirrorMetrics.this.metrics.metricInstance(REPLICATION_LATENCY_AVG, tags), (MeasurableStat)new Avg());
        }
    }
}

