/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.mirror.Checkpoint;
import org.apache.kafka.connect.mirror.MirrorMetrics;
import org.apache.kafka.connect.mirror.MirrorTaskConfig;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.OffsetSyncStore;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.apache.kafka.connect.mirror.TopicFilter;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorCheckpointTask
extends SourceTask {
    private static final Logger log = LoggerFactory.getLogger(MirrorCheckpointTask.class);
    private AdminClient sourceAdminClient;
    private String sourceClusterAlias;
    private String targetClusterAlias;
    private String checkpointsTopic;
    private Duration interval;
    private Duration pollTimeout;
    private TopicFilter topicFilter;
    private Set<String> consumerGroups;
    private ReplicationPolicy replicationPolicy;
    private OffsetSyncStore offsetSyncStore;
    private boolean stopping;
    private MirrorMetrics metrics;

    public MirrorCheckpointTask() {
    }

    MirrorCheckpointTask(String sourceClusterAlias, String targetClusterAlias, ReplicationPolicy replicationPolicy, OffsetSyncStore offsetSyncStore) {
        this.sourceClusterAlias = sourceClusterAlias;
        this.targetClusterAlias = targetClusterAlias;
        this.replicationPolicy = replicationPolicy;
        this.offsetSyncStore = offsetSyncStore;
    }

    public void start(Map<String, String> props) {
        MirrorTaskConfig config = new MirrorTaskConfig(props);
        this.stopping = false;
        this.sourceClusterAlias = config.sourceClusterAlias();
        this.targetClusterAlias = config.targetClusterAlias();
        this.consumerGroups = config.taskConsumerGroups();
        this.checkpointsTopic = config.checkpointsTopic();
        this.topicFilter = config.topicFilter();
        this.replicationPolicy = config.replicationPolicy();
        this.interval = config.emitCheckpointsInterval();
        this.pollTimeout = config.consumerPollTimeout();
        this.offsetSyncStore = new OffsetSyncStore(config);
        this.sourceAdminClient = AdminClient.create(config.sourceAdminConfig());
        this.metrics = config.metrics();
    }

    public void commit() throws InterruptedException {
    }

    public void stop() {
        long start = System.currentTimeMillis();
        this.stopping = true;
        Utils.closeQuietly((AutoCloseable)this.offsetSyncStore, (String)"offset sync store");
        Utils.closeQuietly((AutoCloseable)this.sourceAdminClient, (String)"source admin client");
        Utils.closeQuietly((AutoCloseable)this.metrics, (String)"metrics");
        log.info("Stopping {} took {} ms.", (Object)Thread.currentThread().getName(), (Object)(System.currentTimeMillis() - start));
    }

    public String version() {
        return "1";
    }

    public List<SourceRecord> poll() throws InterruptedException {
        try {
            long deadline = System.currentTimeMillis() + this.interval.toMillis();
            while (!this.stopping && System.currentTimeMillis() < deadline) {
                this.offsetSyncStore.update(this.pollTimeout);
            }
            ArrayList<SourceRecord> records = new ArrayList<SourceRecord>();
            for (String group : this.consumerGroups) {
                records.addAll(this.checkpointsForGroup(group));
            }
            if (records.isEmpty()) {
                return null;
            }
            return records;
        }
        catch (Throwable e) {
            log.warn("Failure polling consumer state for checkpoints.", e);
            return null;
        }
    }

    private List<SourceRecord> checkpointsForGroup(String group) throws InterruptedException {
        try {
            long timestamp = System.currentTimeMillis();
            return this.listConsumerGroupOffsets(group).entrySet().stream().filter(x -> this.shouldCheckpointTopic(((TopicPartition)x.getKey()).topic())).map(x -> this.checkpoint(group, (TopicPartition)x.getKey(), (OffsetAndMetadata)x.getValue())).filter(x -> x.downstreamOffset() > 0L).map(x -> this.checkpointRecord((Checkpoint)x, timestamp)).collect(Collectors.toList());
        }
        catch (ExecutionException e) {
            log.error("Error querying offsets for consumer group {} on cluster {}.", new Object[]{group, this.sourceClusterAlias, e});
            return Collections.emptyList();
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> listConsumerGroupOffsets(String group) throws InterruptedException, ExecutionException {
        if (this.stopping) {
            return Collections.emptyMap();
        }
        return (Map)this.sourceAdminClient.listConsumerGroupOffsets(group).partitionsToOffsetAndMetadata().get();
    }

    Checkpoint checkpoint(String group, TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        long upstreamOffset = offsetAndMetadata.offset();
        long downstreamOffset = this.offsetSyncStore.translateDownstream(topicPartition, upstreamOffset);
        return new Checkpoint(group, this.renameTopicPartition(topicPartition), upstreamOffset, downstreamOffset, offsetAndMetadata.metadata());
    }

    SourceRecord checkpointRecord(Checkpoint checkpoint, long timestamp) {
        return new SourceRecord(checkpoint.connectPartition(), MirrorUtils.wrapOffset(0L), this.checkpointsTopic, Integer.valueOf(0), Schema.BYTES_SCHEMA, (Object)checkpoint.recordKey(), Schema.BYTES_SCHEMA, (Object)checkpoint.recordValue(), Long.valueOf(timestamp));
    }

    TopicPartition renameTopicPartition(TopicPartition upstreamTopicPartition) {
        if (this.targetClusterAlias.equals(this.replicationPolicy.topicSource(upstreamTopicPartition.topic()))) {
            return new TopicPartition(this.replicationPolicy.originalTopic(upstreamTopicPartition.topic()), upstreamTopicPartition.partition());
        }
        return new TopicPartition(this.replicationPolicy.formatRemoteTopic(this.sourceClusterAlias, upstreamTopicPartition.topic()), upstreamTopicPartition.partition());
    }

    boolean shouldCheckpointTopic(String topic) {
        return this.topicFilter.shouldReplicateTopic(topic);
    }

    public void commitRecord(SourceRecord record, RecordMetadata metadata) {
        this.metrics.checkpointLatency(MirrorUtils.unwrapPartition(record.sourcePartition()), Checkpoint.unwrapGroup((Map)record.sourcePartition()), System.currentTimeMillis() - record.timestamp());
    }
}

