/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.TopicFilter;

public class DefaultTopicFilter
implements TopicFilter {
    public static final String TOPICS_WHITELIST_CONFIG = "topics";
    private static final String TOPICS_WHITELIST_DOC = "List of topics and/or regexes to replicate.";
    public static final String TOPICS_WHITELIST_DEFAULT = ".*";
    public static final String TOPICS_BLACKLIST_CONFIG = "topics.blacklist";
    private static final String TOPICS_BLACKLIST_DOC = "List of topics and/or regexes that should not be replicated.";
    public static final String TOPICS_BLACKLIST_DEFAULT = ".*[\\-\\.]internal, .*\\.replica, __.*";
    private Pattern whitelistPattern;
    private Pattern blacklistPattern;

    @Override
    public void configure(Map<String, ?> props) {
        TopicFilterConfig config = new TopicFilterConfig(props);
        this.whitelistPattern = config.whitelistPattern();
        this.blacklistPattern = config.blacklistPattern();
    }

    @Override
    public void close() {
    }

    private boolean whitelisted(String topic) {
        return this.whitelistPattern != null && this.whitelistPattern.matcher(topic).matches();
    }

    private boolean blacklisted(String topic) {
        return this.blacklistPattern != null && this.blacklistPattern.matcher(topic).matches();
    }

    @Override
    public boolean shouldReplicateTopic(String topic) {
        return this.whitelisted(topic) && !this.blacklisted(topic);
    }

    static class TopicFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("topics", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "List of topics and/or regexes to replicate.").define("topics.blacklist", ConfigDef.Type.LIST, (Object)".*[\\-\\.]internal, .*\\.replica, __.*", ConfigDef.Importance.HIGH, "List of topics and/or regexes that should not be replicated.");

        TopicFilterConfig(Map<?, ?> props) {
            super(DEF, props, false);
        }

        Pattern whitelistPattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultTopicFilter.TOPICS_WHITELIST_CONFIG));
        }

        Pattern blacklistPattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultTopicFilter.TOPICS_BLACKLIST_CONFIG));
        }
    }
}

