/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.GroupFilter;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class DefaultGroupFilter
implements GroupFilter {
    public static final String GROUPS_WHITELIST_CONFIG = "groups";
    private static final String GROUPS_WHITELIST_DOC = "List of consumer group names and/or regexes to replicate.";
    public static final String GROUPS_WHITELIST_DEFAULT = ".*";
    public static final String GROUPS_BLACKLIST_CONFIG = "groups.blacklist";
    private static final String GROUPS_BLACKLIST_DOC = "List of consumer group names and/or regexes that should not be replicated.";
    public static final String GROUPS_BLACKLIST_DEFAULT = "console-consumer-.*, connect-.*, __.*";
    private Pattern whitelistPattern;
    private Pattern blacklistPattern;

    @Override
    public void configure(Map<String, ?> props) {
        GroupFilterConfig config = new GroupFilterConfig(props);
        this.whitelistPattern = config.whitelistPattern();
        this.blacklistPattern = config.blacklistPattern();
    }

    @Override
    public void close() {
    }

    private boolean whitelisted(String group) {
        return this.whitelistPattern != null && this.whitelistPattern.matcher(group).matches();
    }

    private boolean blacklisted(String group) {
        return this.blacklistPattern != null && this.blacklistPattern.matcher(group).matches();
    }

    @Override
    public boolean shouldReplicateGroup(String group) {
        return this.whitelisted(group) && !this.blacklisted(group);
    }

    static class GroupFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("groups", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "List of consumer group names and/or regexes to replicate.").define("groups.blacklist", ConfigDef.Type.LIST, (Object)"console-consumer-.*, connect-.*, __.*", ConfigDef.Importance.HIGH, "List of consumer group names and/or regexes that should not be replicated.");

        GroupFilterConfig(Map<?, ?> props) {
            super(DEF, props, false);
        }

        Pattern whitelistPattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultGroupFilter.GROUPS_WHITELIST_CONFIG));
        }

        Pattern blacklistPattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultGroupFilter.GROUPS_BLACKLIST_CONFIG));
        }
    }
}

