/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.ConfigPropertyFilter;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class DefaultConfigPropertyFilter
implements ConfigPropertyFilter {
    public static final String CONFIG_PROPERTIES_BLACKLIST_CONFIG = "config.properties.blacklist";
    private static final String CONFIG_PROPERTIES_BLACKLIST_DOC = "List of topic configuration properties and/or regexes that should not be replicated.";
    public static final String CONFIG_PROPERTIES_BLACKLIST_DEFAULT = "follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas";
    private Pattern blacklistPattern = MirrorUtils.compilePatternList("follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas");

    @Override
    public void configure(Map<String, ?> props) {
        ConfigPropertyFilterConfig config = new ConfigPropertyFilterConfig(props);
        this.blacklistPattern = config.blacklistPattern();
    }

    @Override
    public void close() {
    }

    private boolean blacklisted(String prop) {
        return this.blacklistPattern != null && this.blacklistPattern.matcher(prop).matches();
    }

    @Override
    public boolean shouldReplicateConfigProperty(String prop) {
        return !this.blacklisted(prop);
    }

    static class ConfigPropertyFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("config.properties.blacklist", ConfigDef.Type.LIST, (Object)"follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas", ConfigDef.Importance.HIGH, "List of topic configuration properties and/or regexes that should not be replicated.");

        ConfigPropertyFilterConfig(Map<?, ?> props) {
            super(DEF, props, false);
        }

        Pattern blacklistPattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultConfigPropertyFilter.CONFIG_PROPERTIES_BLACKLIST_CONFIG));
        }
    }
}

