/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.wordcount;

import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;

public final class WordCountDemo {
    public static final String INPUT_TOPIC = "streams-plaintext-input";
    public static final String OUTPUT_TOPIC = "streams-wordcount-output";

    static Properties getStreamsConfig() {
        Properties props = new Properties();
        props.put("application.id", "streams-wordcount");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("default.key.serde", Serdes.String().getClass().getName());
        props.put("default.value.serde", Serdes.String().getClass().getName());
        props.put("auto.offset.reset", "earliest");
        return props;
    }

    static void createWordCountStream(StreamsBuilder builder) {
        KStream source = builder.stream(INPUT_TOPIC);
        KTable counts = source.flatMapValues(value -> Arrays.asList(value.toLowerCase(Locale.getDefault()).split(" "))).groupBy((key, value) -> value).count();
        counts.toStream().to(OUTPUT_TOPIC, Produced.with((Serde)Serdes.String(), (Serde)Serdes.Long()));
    }

    public static void main(String[] args) {
        Properties props = WordCountDemo.getStreamsConfig();
        StreamsBuilder builder = new StreamsBuilder();
        WordCountDemo.createWordCountStream(builder);
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-wordcount-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

