/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.doc.internal.Console;
import org.apache.juneau.doc.internal.DocStore;
import org.apache.juneau.doc.internal.IOUtils;

public class DocGenerator {
    static List<String> WARNINGS = new ArrayList<String>();
    static final String COPYRIGHT = "\n/***************************************************************************************************************************\n * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *  \n *  http://www.apache.org/licenses/LICENSE-2.0\n *  \n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations under the License.\n ***************************************************************************************************************************/";

    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].equals("build")) {
            DocGenerator.build();
        }
        DocGenerator.printWarnings();
    }

    private static void build() {
        try {
            File f2;
            long startTime = System.currentTimeMillis();
            String template = IOUtils.readFile("docs/overview_template.html");
            DocStore ds = new DocStore(new File("docs/docs.txt"));
            File top = new File("docs/Topics");
            DocGenerator.reorder(top);
            Topics topics = new Topics(top);
            ReleaseNotes releaseNotes = new ReleaseNotes(new File("docs/ReleaseNotes"));
            StringBuilder toc = new StringBuilder("<ol class='toc'>\n");
            StringBuilder contents = new StringBuilder();
            for (PageFile pf1 : topics.pageFiles) {
                toc.append("\t<li><p class='").append(pf1.tags.isEmpty() ? "toc2" : pf1.tags).append("'><a class='doclink' href='{OVERVIEW_URL}#").append(pf1.fullId).append("'>").append(pf1.title).append("</a></p>\n");
                ds.addLink(pf1.fullId, "#" + pf1.fullId, "Overview > " + pf1.title);
                contents.append("\n").append("<!-- ==================================================================================================== -->\n\n").append("<h2 class='topic ").append(pf1.tags).append("' onclick='toggle(this)'><a href='#").append(pf1.fullId).append("' id='").append(pf1.fullId).append("'>").append(pf1.fullNumber).append(" - ").append(pf1.title).append("</a></h2>\n").append("<div class='topic'>").append("<!-- START: ").append(pf1.fullNumber).append(" - ").append(pf1.fullId).append(" -->\n").append(pf1.contents).append("\n");
                if (!pf1.pageFiles.isEmpty()) {
                    toc.append("\t<ol>\n");
                    for (PageFile pf2 : pf1.pageFiles) {
                        toc.append("\t\t<li><p class='").append(pf2.tags).append("'><a class='doclink' href='{OVERVIEW_URL}#").append(pf2.fullId).append("'>").append(pf2.title).append("</a></p>\n");
                        ds.addLink(pf2.fullId, "#" + pf2.fullId, "Overview > " + pf1.title + " > " + pf2.title);
                        contents.append("\n").append("<!-- ==================================================================================================== -->\n\n").append("<h3 class='topic ").append(pf2.tags).append("' onclick='toggle(this)'><a href='#").append(pf2.fullId).append("' id='").append(pf2.fullId).append("'>").append(pf2.fullNumber).append(" - ").append(pf2.title).append("</a></h3>\n").append("<div class='topic'>").append("<!-- START: ").append(pf2.fullNumber).append(" - ").append(pf2.fullId).append(" -->\n").append(pf2.contents).append("\n");
                        if (!pf2.pageFiles.isEmpty()) {
                            toc.append("\t\t<ol>\n");
                            for (PageFile pf3 : pf2.pageFiles) {
                                toc.append("\t\t\t<li><p class='").append(pf3.tags).append("'><a class='doclink' href='{OVERVIEW_URL}#").append(pf3.fullId).append("'>").append(pf3.title).append("</a></p>\n");
                                ds.addLink(pf3.fullId, "#" + pf3.fullId, "Overview > " + pf1.title + " > " + pf2.title + " > " + pf3.title);
                                contents.append("\n").append("<!-- ==================================================================================================== -->\n\n").append("<h4 class='topic ").append(pf3.tags).append("' onclick='toggle(this)'><a href='#").append(pf3.fullId).append("' id='").append(pf3.fullId).append("'>").append(pf3.fullNumber).append(" - ").append(pf3.title).append("</a></h4>\n").append("<div class='topic'>").append("<!-- START: ").append(pf3.fullNumber).append(" - ").append(pf3.fullId).append(" -->\n").append(pf3.contents).append("\n").append("</div>").append("<!-- END: ").append(pf3.fullNumber).append(" - ").append(pf3.fullId).append(" -->\n");
                            }
                            toc.append("\t\t</ol>\n");
                        }
                        contents.append("</div>").append("<!-- END: ").append(pf2.fullNumber).append(" - ").append(pf2.fullId).append(" -->\n");
                    }
                    toc.append("\t</ol>\n");
                }
                contents.append("</div>").append("<!-- END: ").append(pf1.fullNumber).append(" - ").append(pf1.fullId).append(" -->\n");
            }
            StringBuilder tocRn = new StringBuilder("<ul class='toc'>\n");
            StringBuilder rn = new StringBuilder();
            for (ReleaseFile rf : releaseNotes.releaseFiles) {
                tocRn.append("<li><p><a class='doclink' href='#").append(rf.version).append("'>").append(rf.title).append("</a></p>\n");
                rn.append("\n").append("<!-- ==================================================================================================== -->\n\n").append("<h3 class='topic' onclick='toggle(this)'><a href='#").append(rf.version).append("' id='").append(rf.version).append("'>").append(rf.title).append("</a></h3>\n").append("<div class='topic'>").append("<!-- START: ").append(rf.version).append(" -->\n").append(rf.contents).append("\n").append("</div>").append("<!-- END: ").append(rf.version).append(" -->\n");
            }
            toc.append("</ol>\n");
            tocRn.append("</ul>\n");
            template = template.replace("{TOC-CONTENTS}", toc.toString().replace("{OVERVIEW_URL}", "")).replace("{CONTENTS}", contents.toString()).replace("{TOC-RELEASE-NOTES}", tocRn).replace("{RELEASE-NOTES}", rn);
            IOUtils.writeFile("src/main/javadoc/overview.html", template);
            ds.save(new File("src/main/javadoc/resources/docs.txt"));
            Console.info("Generated target/overview.html in {0}ms", System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
            Object object = new File("src/main/javadoc/doc-files").listFiles();
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                f2 = object[n2];
                Files.delete(f2.toPath());
                ++n2;
            }
            object = new File("src/main/javadoc/resources/fragments").listFiles();
            n = ((File[])object).length;
            n2 = 0;
            while (n2 < n) {
                f2 = object[n2];
                Files.delete(f2.toPath());
                ++n2;
            }
            for (File f2 : topics.docFiles) {
                Files.copy(f2.toPath(), Paths.get("src/main/javadoc/doc-files", f2.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
            for (File f2 : releaseNotes.docFiles) {
                Files.copy(f2.toPath(), Paths.get("src/main/javadoc/doc-files", f2.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
            String toc2 = "<!--" + COPYRIGHT + "\n-->\n" + toc;
            IOUtils.writeFile("src/main/javadoc/resources/fragments/toc.html", toc2);
            File[] fileArray = new File("docs/Fragments").listFiles();
            int n3 = fileArray.length;
            n = 0;
            while (n < n3) {
                File f3 = fileArray[n];
                Files.copy(f3.toPath(), Paths.get("src/main/javadoc/resources/fragments", f3.getName()), StandardCopyOption.REPLACE_EXISTING);
                ++n;
            }
            Console.info("Copied doc-files in {0}ms", System.currentTimeMillis() - startTime);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void reorder(File dir) throws IOException {
        Topics t = new Topics(dir);
        int i = 1;
        for (PageFile f : t.pageFiles) {
            f.reorder(i++);
        }
        t = new Topics(dir);
        for (PageFile f : t.pageFiles) {
            if (f.dir == null) continue;
            DocGenerator.reorder(f.dir);
        }
    }

    static void printWarnings() {
        if (WARNINGS.isEmpty()) {
            Console.info("No DocGenerator warnings.", new Object[0]);
        } else {
            Console.warning(String.valueOf(WARNINGS.size()) + " DocGenerator warnings:", new Object[0]);
            int i = 0;
            while (i < WARNINGS.size()) {
                Console.warning("[" + (i + 1) + "] " + WARNINGS.get(i), new Object[0]);
                ++i;
            }
        }
    }

    static class PageFile
    implements Comparable<PageFile> {
        String idWithNum;
        String id;
        String num;
        String fullId;
        String title;
        String contents;
        String fullNumber;
        int pageNumber;
        int dirNumber;
        String tags = "";
        File file;
        File dir;
        Set<PageFile> pageFiles = new TreeSet<PageFile>();

        PageFile(PageFile parent, File f, List<File> docFiles) throws IOException {
            this.file = f;
            try {
                String n = f.getName();
                this.idWithNum = n.substring(0, n.lastIndexOf(46));
                this.num = n.substring(0, n.indexOf(46));
                this.id = this.idWithNum.substring(n.indexOf(46) + 1);
                this.fullId = String.valueOf(parent == null ? "" : String.valueOf(parent.fullId) + ".") + this.id;
                this.pageNumber = Integer.parseInt(n.substring(0, n.indexOf(46)));
                this.fullNumber = String.valueOf(parent == null ? "" : String.valueOf(parent.fullNumber) + ".") + this.pageNumber;
                String s = IOUtils.read(f);
                int i = s.indexOf("-->");
                s = s.substring(i + 4).trim();
                i = s.indexOf("\n");
                this.title = s.substring(0, i);
                if (this.title.startsWith("{")) {
                    this.tags = this.title.substring(1, this.title.indexOf(125));
                    this.title = this.title.substring(this.tags.length() + 2).trim();
                }
                if (s.contains("{@link org.apache.juneau.")) {
                    WARNINGS.add("Found {@link org.apache.juneau...} in file " + f.getAbsolutePath());
                }
                this.contents = s.substring(i).trim().replaceAll("oaj\\.", "org.apache.juneau.").replaceAll("oajr\\.", "org.apache.juneau.rest.").replaceAll("oajrc\\.", "org.apache.juneau.rest.client.");
            }
            catch (Exception e) {
                WARNINGS.add("Problem with file " + f.getAbsolutePath() + ", " + e.getMessage());
                return;
            }
            File[] fileArray = f.getParentFile().listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String n3;
                File d = fileArray[n2];
                if (d.isDirectory() && (n3 = d.getName()).matches("\\d+\\..*")) {
                    int dirNumber = Integer.parseInt(n3.substring(0, n3.indexOf(46)));
                    String dirName = n3.substring(n3.indexOf(46) + 1);
                    if (dirName.equals(this.id)) {
                        this.dirNumber = dirNumber;
                        this.dir = d;
                        File[] fileArray2 = d.listFiles();
                        int n4 = fileArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            File f2 = fileArray2[n5];
                            if (f2.isFile()) {
                                this.pageFiles.add(new PageFile(this, f2, docFiles));
                            } else if (f2.isDirectory() && f2.getName().contains("doc-files")) {
                                docFiles.addAll(Arrays.asList(f2.listFiles()));
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
        }

        public String getPageDirName(File f) {
            String n = f.getName();
            n = n.substring(n.indexOf(46) + 1);
            return n;
        }

        void reorder(int i) {
            File f2;
            if (this.pageNumber != i) {
                f2 = new File(this.file.getParentFile(), String.valueOf(String.format("%0" + this.num.length() + "d", i)) + '.' + this.id + ".html");
                Console.info("Renaming {0} to {1}", this.file.getName(), f2.getName());
                this.file.renameTo(f2);
            }
            if (this.dir != null && this.dirNumber != i) {
                f2 = new File(this.file.getParentFile(), String.valueOf(String.format("%0" + this.num.length() + "d", i)) + '.' + this.id);
                Console.info("Renaming {0} to {1}", this.dir.getName(), f2.getName());
                this.dir.renameTo(f2);
            }
        }

        @Override
        public int compareTo(PageFile o) {
            return this.idWithNum.compareTo(o.idWithNum);
        }
    }

    static class ReleaseFile
    implements Comparable<ReleaseFile> {
        String name;
        String version;
        String title;
        String contents;

        ReleaseFile(File f) throws IOException {
            this.name = f.getName();
            this.name = this.name.substring(0, this.name.lastIndexOf(46));
            this.version = this.name.replaceAll("[0](\\d+)", "$1");
            String s = IOUtils.read(f);
            int i = s.indexOf("-->");
            s = s.substring(i + 4).trim();
            i = s.indexOf("\n");
            this.title = s.substring(0, i);
            this.contents = s.substring(i).trim().replaceAll("oaj\\.", "org.apache.juneau.").replaceAll("oajr\\.", "org.apache.juneau.rest.").replaceAll("oajrc\\.", "org.apache.juneau.rest.client.");
        }

        @Override
        public int compareTo(ReleaseFile o) {
            return this.name.compareTo(o.name);
        }
    }

    static class ReleaseNotes {
        Set<ReleaseFile> releaseFiles = new TreeSet<ReleaseFile>();
        List<File> docFiles = new ArrayList<File>();

        public ReleaseNotes(File releaseNotesDir) throws IOException {
            File[] fileArray = releaseNotesDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile()) {
                    this.releaseFiles.add(new ReleaseFile(f));
                } else if (f.isDirectory() && f.getName().contains("doc-files")) {
                    this.docFiles.addAll(Arrays.asList(f.listFiles()));
                }
                ++n2;
            }
        }
    }

    static class Topics {
        Set<PageFile> pageFiles = new TreeSet<PageFile>();
        List<File> docFiles = new ArrayList<File>();

        public Topics(File topicsDir) throws IOException {
            File[] fileArray = topicsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.getName().startsWith(".")) {
                    if (f.isFile()) {
                        this.pageFiles.add(new PageFile(null, f, this.docFiles));
                    } else if (f.isDirectory() && f.getName().contains("doc-files")) {
                        this.docFiles.addAll(Arrays.asList(f.listFiles()));
                    }
                }
                ++n2;
            }
        }
    }
}

