/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.objecttools.ObjectIntrospector;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.swap.ObjectSwap;

public final class Introspectable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{in:'query',name:'invokeMethod',description:' The Java method name, optionally with arguments if necessary to differentiate between methods.',examples:{example:'toString'}},{in:'query',name:'invokeArgs',description:'The arguments as an array.',examples:{example:'foo,bar'}}";

    @Override
    public Object convert(RestRequest req, Object o) throws InternalServerError {
        String method = req.getQueryParam("invokeMethod").orElse(null);
        String args = req.getQueryParam("invokeArgs").orElse(null);
        if (method == null) {
            return o;
        }
        try {
            BeanSession bs = req.getBeanSession();
            ObjectSwap<Object, ?> swap = bs.getClassMetaForObject(o).getSwap(bs);
            if (swap != null) {
                o = swap.swap(bs, o);
            }
            return ObjectIntrospector.create(o, JsonParser.DEFAULT).invokeMethod(method, args);
        }
        catch (Exception e) {
            return new InternalServerError((Throwable)e, "Error occurred trying to invoke method: {0}", new Object[]{e.getLocalizedMessage()});
        }
    }
}

