/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.HeaderInfo;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="contentType,style,explode,headers,allowReserved,*")
@FluentSetters
public class Encoding
extends OpenApiElement {
    private String contentType;
    private String style;
    private Map<String, HeaderInfo> headers;
    private Boolean explode;
    private Boolean allowReserved;

    public Encoding() {
    }

    public Encoding(Encoding copyFrom) {
        super(copyFrom);
        this.contentType = copyFrom.contentType;
        this.style = copyFrom.style;
        this.explode = copyFrom.explode;
        this.allowReserved = copyFrom.allowReserved;
        if (copyFrom.headers == null) {
            this.headers = null;
        } else {
            this.headers = new LinkedHashMap<String, HeaderInfo>();
            for (Map.Entry<String, HeaderInfo> e : copyFrom.headers.entrySet()) {
                this.headers.put(e.getKey(), e.getValue().copy());
            }
        }
    }

    public Encoding copy() {
        return new Encoding(this);
    }

    @Override
    protected Encoding strict() {
        super.strict();
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Encoding setContentType(String value) {
        this.contentType = value;
        return this;
    }

    public String getStyle() {
        return this.style;
    }

    public Encoding setStyle(String value) {
        this.style = value;
        return this;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public Encoding setHeaders(Map<String, HeaderInfo> value) {
        this.headers = CollectionUtils.copyOf(value);
        return this;
    }

    public Encoding addHeader(String key, HeaderInfo value) {
        this.headers = CollectionUtils.mapBuilder(this.headers).sparse().add(key, value).build();
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Encoding setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Encoding setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "contentType": {
                return ConverterUtils.toType(this.getContentType(), type);
            }
            case "style": {
                return ConverterUtils.toType(this.getStyle(), type);
            }
            case "headers": {
                return ConverterUtils.toType(this.getHeaders(), type);
            }
            case "explode": {
                return ConverterUtils.toType(this.getExplode(), type);
            }
            case "allowReserved": {
                return ConverterUtils.toType(this.getAllowReserved(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Encoding set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "contentType": {
                return this.setContentType(StringUtils.stringify(value));
            }
            case "style": {
                return this.setStyle(StringUtils.stringify(value));
            }
            case "headers": {
                return this.setHeaders(CollectionUtils.mapBuilder(String.class, HeaderInfo.class, new Type[0]).sparse().addAny(value).build());
            }
            case "explode": {
                return this.setExplode(ConverterUtils.toBoolean(value));
            }
            case "allowReserved": {
                return this.setAllowReserved(ConverterUtils.toBoolean(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.contentType != null, "contentType").addIf(this.style != null, "style").addIf(this.headers != null, "headers").addIf(this.explode != null, "explode").addIf(this.allowReserved != null, "allowReserved").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

