/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.swap.Builder;

public class BuilderSwap<T, B> {
    private final Class<T> objectClass;
    private final Class<B> builderClass;
    private final Constructor<T> objectConstructor;
    private final Constructor<B> builderConstructor;
    private final MethodInfo createBuilderMethod;
    private final MethodInfo createObjectMethod;
    private ClassMeta<?> builderClassMeta;

    protected BuilderSwap(Class<T> objectClass, Class<B> builderClass, Constructor<T> objectConstructor, Constructor<B> builderConstructor, MethodInfo createBuilderMethod, MethodInfo createObjectMethod) {
        this.objectClass = objectClass;
        this.builderClass = builderClass;
        this.objectConstructor = objectConstructor;
        this.builderConstructor = builderConstructor;
        this.createBuilderMethod = createBuilderMethod;
        this.createObjectMethod = createObjectMethod;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public Class<B> getBuilderClass() {
        return this.builderClass;
    }

    public ClassMeta<?> getBuilderClassMeta(BeanSession session) {
        if (this.builderClassMeta == null) {
            this.builderClassMeta = session.getClassMeta(this.getBuilderClass());
        }
        return this.builderClassMeta;
    }

    public B create(BeanSession session, ClassMeta<?> hint) throws ExecutableException {
        if (this.createBuilderMethod != null) {
            return (B)this.createBuilderMethod.invoke(null, new Object[0]);
        }
        try {
            return this.builderConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public T build(BeanSession session, B builder, ClassMeta<?> hint) throws ExecutableException {
        if (this.createObjectMethod != null) {
            return this.createObjectMethod.invoke(builder, new Object[0]);
        }
        try {
            return this.objectConstructor.newInstance(builder);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public static BuilderSwap<?, ?> findSwapFromBuilderClass(Class<?> builderClass, Visibility cVis, Visibility mVis) {
        ClassInfo bci = ClassInfo.of(builderClass);
        if (bci.isNotPublic()) {
            return null;
        }
        Class<Object> objectClass = ClassInfo.of(builderClass).getParameterType(0, Builder.class);
        MethodInfo createObjectMethod = BuilderSwap.getBuilderBuildMethod(bci);
        if (createObjectMethod != null) {
            objectClass = createObjectMethod.getReturnType().inner();
        }
        if (objectClass == null) {
            return null;
        }
        ClassInfo pci = ClassInfo.of(objectClass);
        ConstructorInfo objectConstructor = pci.getDeclaredConstructor(x -> x.isVisible(cVis) && x.hasParamTypes(builderClass));
        if (objectConstructor == null) {
            return null;
        }
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis);
        MethodInfo createBuilderMethod = BuilderSwap.getBuilderCreateMethod(pci);
        if (builderConstructor == null && createBuilderMethod == null) {
            return null;
        }
        return new BuilderSwap(objectClass, builderClass, objectConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), createBuilderMethod, createObjectMethod);
    }

    public static BuilderSwap<?, ?> findSwapFromObjectClass(BeanContext bc, Class<?> objectClass, Visibility cVis, Visibility mVis) {
        ConstructorInfo cc;
        Value builderClass = Value.empty();
        ConstructorInfo objectConstructor = null;
        bc.forEachAnnotation(org.apache.juneau.annotation.Builder.class, objectClass, x -> ClassUtils.isNotVoid(x.value()), x -> builderClass.set(x.value()));
        ClassInfo pci = ClassInfo.of(objectClass);
        MethodInfo builderCreateMethod = BuilderSwap.getBuilderCreateMethod(pci);
        if (builderClass.isEmpty() && builderCreateMethod != null) {
            builderClass.set(builderCreateMethod.getReturnType().inner());
        }
        if (builderClass.isEmpty() && (cc = pci.getPublicConstructor(x -> x.isVisible(cVis) && x.hasNumParams(1) && x.getParamType(0).isChildOf(Builder.class))) != null) {
            objectConstructor = cc;
            builderClass.set(cc.getParamType(0).inner());
        }
        if (builderClass.isEmpty()) {
            return null;
        }
        ClassInfo bci = ClassInfo.of((Class)builderClass.get());
        ConstructorInfo builderConstructor = bci.getNoArgConstructor(cVis);
        if (builderConstructor == null && builderCreateMethod == null) {
            return null;
        }
        MethodInfo objectCreateMethod = BuilderSwap.getBuilderBuildMethod(bci);
        Class builderClass2 = (Class)builderClass.get();
        if (objectConstructor == null) {
            objectConstructor = pci.getDeclaredConstructor(x -> x.isVisible(cVis) && x.hasParamTypes(builderClass2));
        }
        if (objectConstructor == null && objectCreateMethod == null) {
            return null;
        }
        return new BuilderSwap(objectClass, (Class)builderClass.get(), objectConstructor == null ? null : objectConstructor.inner(), builderConstructor == null ? null : builderConstructor.inner(), builderCreateMethod, objectCreateMethod);
    }

    private static MethodInfo getBuilderCreateMethod(ClassInfo c) {
        return c.getPublicMethod(x -> x.isStatic() && x.hasName("create") && !x.hasReturnType(c) && BuilderSwap.hasConstructorThatTakesType(c, x.getReturnType()));
    }

    private static boolean hasConstructorThatTakesType(ClassInfo c, ClassInfo argType) {
        return c.getPublicConstructor(x -> x.hasNumParams(1) && x.hasParamTypes(argType)) != null;
    }

    private static MethodInfo getBuilderBuildMethod(ClassInfo c) {
        return c.getDeclaredMethod(x -> x.isNotStatic() && x.hasNoParams() && !x.hasReturnType(Void.TYPE) && x.hasName("build"));
    }
}

