/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.httppart.RequestHttpPart;
import org.apache.juneau.rest.httppart.RequestPathParam;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.svl.VarResolverSession;

public class RequestPathParams
extends ArrayList<RequestPathParam> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private boolean caseSensitive;
    private HttpPartParserSession parser;
    private final VarResolverSession vs;

    public RequestPathParams(RestSession session, RestRequest req, boolean caseSensitive) {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Map parentVars = (Map)req.getAttribute("juneau.pathVars").orElse(Collections.emptyMap());
        for (Map.Entry entry : parentVars.entrySet()) {
            this.add((String)entry.getKey(), entry.getValue());
        }
        UrlPathMatch pm = session.getUrlPathMatch();
        if (pm != null) {
            for (Map.Entry<String, String> entry : pm.getVars().entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
            String string = pm.getRemainder();
            if (string != null) {
                this.add("/**", string);
                this.add("/*", StringUtils.urlDecode((String)string));
            }
        }
    }

    private RequestPathParams(RequestPathParams copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.addAll(copyFrom);
        this.vs = copyFrom.vs;
    }

    private RequestPathParams(RequestPathParams copyFrom, String ... names) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.vs = copyFrom.vs;
        for (String n : names) {
            copyFrom.stream().filter(x -> this.eq(x.getName(), n)).forEach(this::add);
        }
    }

    public RequestPathParams parser(HttpPartParserSession value) {
        this.parser = value;
        this.forEach((? super E x) -> x.parser(this.parser));
        return this;
    }

    public RequestPathParams caseSensitive(boolean value) {
        this.caseSensitive = value;
        return this;
    }

    public RequestPathParams addDefault(List<NameValuePair> pairs) {
        for (NameValuePair p : pairs) {
            String name = p.getName();
            Stream<RequestPathParam> l = this.stream(name);
            boolean hasAllBlanks = l.allMatch(x -> StringUtils.isEmpty((String)x.getValue()));
            if (!hasAllBlanks) continue;
            this.removeAll(this.getAll(name));
            this.add(new RequestPathParam(this.req, name, this.vs.resolve(p.getValue())));
        }
        return this;
    }

    public RequestPathParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(CollectionUtils.alist((Object[])pairs));
    }

    public RequestPathParams addDefault(String name, String value) {
        return this.addDefault(new NameValuePair[]{BasicStringPart.of((String)name, (String)value)});
    }

    public RequestPathParams add(String name, Object value) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.add(new RequestPathParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser));
        return this;
    }

    public RequestPathParams add(NameValuePair ... parameters) {
        ArgUtils.assertArgNotNull((String)"parameters", (Object)parameters);
        for (NameValuePair p : parameters) {
            if (p == null) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestPathParams set(String name, Object value) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.set(new RequestPathParam(this.req, name, StringUtils.stringify((Object)value)).parser(this.parser));
        return this;
    }

    public RequestPathParams set(NameValuePair ... parameters) {
        ArgUtils.assertArgNotNull((String)"headers", (Object)parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestPathParams remove(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public RequestPathParams subset(String ... names) {
        return new RequestPathParams(this, names);
    }

    public boolean contains(String name) {
        ArgUtils.assertArgNotNull((String)"names", (Object)name);
        return this.stream(name).findAny().isPresent();
    }

    public boolean containsAny(String ... names) {
        ArgUtils.assertArgNotNull((String)"names", (Object)names);
        for (String n : names) {
            if (!this.stream(n).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<RequestPathParam> getAll(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        return this.stream(name).collect(Collectors.toList());
    }

    public Stream<RequestPathParam> stream(String name) {
        return this.stream().filter(x -> this.eq(x.getName(), name));
    }

    public Stream<RequestPathParam> getSorted() {
        Comparator<RequestPathParam> x = this.caseSensitive ? Comparator.comparing(RequestHttpPart::getName) : (x1, x2) -> String.CASE_INSENSITIVE_ORDER.compare(x1.getName(), x2.getName());
        return this.stream().sorted(x);
    }

    public List<String> getNames() {
        return this.stream().map(RequestHttpPart::getName).map(x -> this.caseSensitive ? x : x.toLowerCase()).distinct().collect(Collectors.toList());
    }

    public RequestPathParam getFirst(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        return this.stream(name).findFirst().orElseGet(() -> new RequestPathParam(this.req, name, null).parser(this.parser));
    }

    public RequestPathParam getLast(String name) {
        ArgUtils.assertArgNotNull((String)"name", (Object)name);
        Value v = Value.empty();
        this.stream(name).forEach((? super T x) -> v.set(x));
        return (RequestPathParam)v.orElseGet(() -> new RequestPathParam(this.req, name, null).parser(this.parser));
    }

    public RequestPathParam get(String name) {
        List<RequestPathParam> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestPathParam(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        int j = l.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestPathParam(this.req, name, sb.toString()).parser(this.parser);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta cm = this.req.getBeanSession().getClassMeta(type);
        String name = (String)HttpParts.getName((HttpPartType)HttpPartType.PATH, (ClassMeta)cm).orElseThrow(() -> new BasicRuntimeException("@Path(name) not found on class {0}", new Object[]{ClassUtils.className((Object)type)}));
        return this.get(name).as(type);
    }

    public RequestPathParams copy() {
        return new RequestPathParams(this);
    }

    public RequestPathParam getRemainder() {
        return this.get("/*");
    }

    public RequestPathParam getRemainderUndecoded() {
        return this.get("/**");
    }

    private boolean eq(String s1, String s2) {
        if (this.caseSensitive) {
            return StringUtils.eq((String)s1, (String)s2);
        }
        return StringUtils.eqic((String)s1, (String)s2);
    }

    @Override
    public String toString() {
        JsonMap m = new JsonMap();
        for (String n : this.getNames()) {
            m.put(n, this.get(n).asString().orElse(null));
        }
        return m.asJson();
    }
}

