/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.PageArgs;

public final class ObjectPaginator
implements ObjectTool<PageArgs> {
    public static ObjectPaginator create() {
        return new ObjectPaginator();
    }

    public <R> List<R> run(Object input, int pos, int limit) {
        BeanSession bs = BeanContext.DEFAULT_SESSION;
        Object r = this.run(BeanContext.DEFAULT_SESSION, input, PageArgs.create(pos, limit));
        if (r instanceof List) {
            return (List)r;
        }
        return bs.convertToType(r, List.class);
    }

    @Override
    public Object run(BeanSession session, Object input, PageArgs args) {
        if (input == null) {
            return null;
        }
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        if (!type.isCollectionOrArray()) {
            return input;
        }
        int pos = args.getPosition();
        int limit = args.getLimit();
        if (type.isArray()) {
            int size = Array.getLength(input);
            int end = limit + pos >= size ? size : limit + pos;
            pos = Math.min(pos, size);
            ClassMeta<Comparable<Boolean>> et = type.getElementType();
            if (!et.isPrimitive()) {
                return Arrays.copyOfRange((Object[])input, pos, end);
            }
            if (et.is(Boolean.TYPE)) {
                return Arrays.copyOfRange((boolean[])input, pos, end);
            }
            if (et.is(Byte.TYPE)) {
                return Arrays.copyOfRange((byte[])input, pos, end);
            }
            if (et.is(Character.TYPE)) {
                return Arrays.copyOfRange((char[])input, pos, end);
            }
            if (et.is(Double.TYPE)) {
                return Arrays.copyOfRange((double[])input, pos, end);
            }
            if (et.is(Float.TYPE)) {
                return Arrays.copyOfRange((float[])input, pos, end);
            }
            if (et.is(Integer.TYPE)) {
                return Arrays.copyOfRange((int[])input, pos, end);
            }
            if (et.is(Long.TYPE)) {
                return Arrays.copyOfRange((long[])input, pos, end);
            }
            return Arrays.copyOfRange((short[])input, pos, end);
        }
        List l = type.isList() ? (List)input : new ArrayList((Collection)input);
        int end = limit + pos >= l.size() ? l.size() : limit + pos;
        pos = Math.min(pos, l.size());
        return l.subList(pos, end);
    }
}

