/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.ServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.UnsupportedMediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.CharSequenceReader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.util.BoundedServletInputStream;

public class RequestContent {
    private byte[] content;
    private final RestRequest req;
    private EncoderSet encoders;
    private Encoder encoder;
    private ParserSet parsers;
    private long maxInput;
    private int contentLength = 0;
    private MediaType mediaType;
    private Parser parser;
    private HttpPartSchema schema;

    public RequestContent(RestRequest req) {
        this.req = req;
    }

    public RequestContent encoders(EncoderSet value) {
        this.encoders = value;
        return this;
    }

    public RequestContent parsers(ParserSet value) {
        this.parsers = value;
        return this;
    }

    public RequestContent setSchema(HttpPartSchema schema) {
        this.schema = schema;
        return this;
    }

    public RequestContent maxInput(long value) {
        this.maxInput = value;
        return this;
    }

    public RequestContent mediaType(MediaType value) {
        this.mediaType = value;
        return this;
    }

    public RequestContent parser(Parser value) {
        this.parser = value;
        return this;
    }

    public RequestContent content(byte[] value) {
        this.content = value;
        return this;
    }

    boolean isLoaded() {
        return this.content != null;
    }

    public <T> T as(Class<T> type) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type));
    }

    public <T> T as(Type type, Type ... args) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type, args));
    }

    public String asString() throws IOException {
        this.cache();
        return new String(this.content, IOUtils.UTF8);
    }

    public byte[] asBytes() throws IOException {
        this.cache();
        return this.content;
    }

    public String asHex() throws IOException {
        this.cache();
        return StringUtils.toHex((byte[])this.content);
    }

    public String asSpacedHex() throws IOException {
        this.cache();
        return StringUtils.toSpacedHex((byte[])this.content);
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        int len = this.req.getHttpServletRequest().getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (this.content != null) {
            return new CharSequenceReader((CharSequence)new String(this.content, IOUtils.UTF8));
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.req.getCharset());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.content != null) {
            return new BoundedServletInputStream(this.content);
        }
        Encoder enc = this.getEncoder();
        ServletInputStream is = this.req.getHttpServletRequest().getInputStream();
        if (enc == null) {
            return new BoundedServletInputStream((InputStream)is, this.maxInput);
        }
        return new BoundedServletInputStream(enc.getInputStream((InputStream)is), this.maxInput);
    }

    public Optional<ParserMatch> getParserMatch() {
        if (this.mediaType != null && this.parser != null) {
            return CollectionUtils.optional((Object)new ParserMatch(this.mediaType, this.parser));
        }
        MediaType mt = this.getMediaType();
        return CollectionUtils.optional((Object)mt).map(x -> this.parsers.getParserMatch(x));
    }

    private MediaType getMediaType() {
        if (this.mediaType != null) {
            return this.mediaType;
        }
        Optional<ContentType> ct = this.req.getHeader(ContentType.class);
        if (!ct.isPresent() && this.content != null) {
            return MediaType.UON;
        }
        return ct.isPresent() ? (MediaType)ct.get().asMediaType().orElse(null) : null;
    }

    private <T> T getInner(ClassMeta<T> cm) throws BadRequest, UnsupportedMediaType, InternalServerError {
        try {
            return this.parse(cm);
        }
        catch (UnsupportedMediaType e) {
            throw e;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest("Validation failed on request content. " + e.getLocalizedMessage(), new Object[0]);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not convert request content content to class type ''{0}''.", new Object[]{cm});
        }
        catch (IOException e) {
            throw new InternalServerError((Throwable)e, "I/O exception occurred while parsing request content.", new Object[0]);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Exception occurred while parsing request content.", new Object[0]);
        }
    }

    private <T> T parse(ClassMeta<T> cm) throws SchemaValidationException, ParseException, UnsupportedMediaType, IOException {
        if (cm.isReader()) {
            return (T)this.getReader();
        }
        if (cm.isInputStream()) {
            return (T)this.getInputStream();
        }
        Optional<TimeZone> timeZone = this.req.getTimeZone();
        Locale locale = this.req.getLocale();
        ParserMatch pm = this.getParserMatch().orElse(null);
        if (this.schema == null) {
            this.schema = HttpPartSchema.DEFAULT;
        }
        if (pm != null) {
            Parser p = pm.getParser();
            MediaType mediaType = pm.getMediaType();
            ParserSession session = p.createSession().properties(this.req.getAttributes().asMap()).javaMethod(this.req.getOpContext().getJavaMethod()).locale(locale).timeZone((TimeZone)timeZone.orElse(null)).mediaType(mediaType).apply(ReaderParser.Builder.class, x -> x.streamCharset(this.req.getCharset())).schema(this.schema).debug(this.req.isDebug() ? Boolean.valueOf(true) : null).outer(this.req.getContext().getResource()).build();
            try (Reader in = session.isReaderParser() ? this.getUnbufferedReader() : this.getInputStream();){
                Object o = session.parse((Object)in, cm);
                if (this.schema != null) {
                    this.schema.validateOutput(o, cm.getBeanContext());
                }
                Object object = o;
                return (T)object;
            }
        }
        if (cm.hasReaderMutater()) {
            return (T)cm.getReaderMutater().mutate((Object)this.getReader());
        }
        if (cm.hasInputStreamMutater()) {
            return (T)cm.getInputStreamMutater().mutate((Object)this.getInputStream());
        }
        MediaType mt = this.getMediaType();
        if ((StringUtils.isEmpty((String)StringUtils.stringify((Object)mt)) || mt.toString().startsWith("text/plain")) && cm.hasStringMutater()) {
            return (T)cm.getStringMutater().mutate((Object)this.asString());
        }
        Optional<ContentType> ct = this.req.getHeader(ContentType.class);
        throw new UnsupportedMediaType("Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", new Object[]{ct.isPresent() ? ct.get().asMediaType().orElse(null) : "not-specified", Json5.of((Object)this.req.getOpContext().getParsers().getSupportedMediaTypes())});
    }

    private Encoder getEncoder() throws UnsupportedMediaType {
        if (this.encoder == null) {
            String ce = this.req.getHeaderParam("content-encoding").orElse(null);
            if (StringUtils.isNotEmpty((String)ce)) {
                ce = ce.trim();
                this.encoder = this.encoders.getEncoder(ce);
                if (this.encoder == null) {
                    throw new UnsupportedMediaType("Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", new Object[]{this.req.getHeaderParam("content-encoding").orElse(null), Json5.of((Object)this.encoders.getSupportedEncodings())});
                }
            }
            if (this.encoder != null) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? this.req.getHttpServletRequest().getContentLength() : this.contentLength;
    }

    public RequestContent cache() throws IOException {
        if (this.content == null) {
            this.content = IOUtils.readBytes((InputStream)this.getInputStream());
        }
        return this;
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }
}

