/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.internal.CollectionUtils;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = CollectionUtils.mapBuilder(String.class, String.class, (Type[])new Type[0]).add((Object)"get", (Object)"0").add((Object)"put", (Object)"1").add((Object)"post", (Object)"2").add((Object)"delete", (Object)"3").add((Object)"options", (Object)"4").add((Object)"head", (Object)"5").add((Object)"patch", (Object)"6").build();

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(o1);
            String s2 = this.methods.get(o2);
            if (s1 == null) {
                s1 = o1;
            }
            if (s2 == null) {
                s2 = o2;
            }
            return StringUtils.compare((String)s1, (String)s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(StringUtils.emptyIfNull((String)httpMethodName).toLowerCase(), operation);
        return this;
    }
}

