/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequest;
import org.apache.juneau.serializer.Serializer;

@FluentSetters(ignore={"uriScheme"})
public class MockRestRequest
extends RestRequest {
    private Map<String, Object> attributeMap = CollectionUtils.map();
    private Map<String, RequestDispatcher> requestDispatcherMap = CollectionUtils.map();
    private String characterEncoding;
    private String protocol;
    private String scheme;
    private String serverName;
    private String remoteAddr;
    private String remoteHost;
    private String localName;
    private String localAddr;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;
    private String remoteUser;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath;
    private String authType;
    private Integer serverPort;
    private Integer remotePort;
    private Integer localPort;
    private Locale locale;
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private Cookie[] cookies;
    private Principal userPrincipal;
    private HttpSession httpSession;
    private String[] roles;

    protected MockRestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(client, uri, method, hasBody);
    }

    public MockRestRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    public MockRestRequest attributes(Map<String, Object> value) {
        this.attributeMap.clear();
        this.attributeMap.putAll(value);
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public MockRestRequest roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public MockRestRequest role(String role) {
        this.roles = new String[]{role};
        return this;
    }

    public MockRestRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MockRestRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public MockRestRequest uriScheme(String value) {
        super.uriScheme(value);
        this.scheme = value;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public MockRestRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MockRestRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public MockRestRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public MockRestRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public MockRestRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public MockRestRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public MockRestRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public String getLocalName() {
        return this.localName;
    }

    public MockRestRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public MockRestRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public Integer getLocalPort() {
        return this.localPort;
    }

    public MockRestRequest requestDispatcher(String path, RequestDispatcher value) {
        this.requestDispatcherMap.put(path, value);
        return this;
    }

    public Map<String, RequestDispatcher> getRequestDispatcherMap() {
        return this.requestDispatcherMap;
    }

    public MockRestRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public MockRestRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public MockRestRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public String getAuthType() {
        return this.authType;
    }

    public MockRestRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public MockRestRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public MockRestRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public MockRestRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public MockRestRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public MockRestRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public MockRestRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public MockRestRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public MockRestRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public MockRestRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public MockRestRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Override
    public MockRestRequest accept(String value) throws RestCallException {
        super.accept(value);
        return this;
    }

    @Override
    public MockRestRequest acceptCharset(String value) throws RestCallException {
        super.acceptCharset(value);
        return this;
    }

    @Override
    public MockRestRequest cancellable(Cancellable cancellable) {
        super.cancellable(cancellable);
        return this;
    }

    @Override
    public MockRestRequest config(RequestConfig value) {
        super.config(value);
        return this;
    }

    @Override
    public MockRestRequest content(Object value) {
        super.content(value);
        return this;
    }

    @Override
    public MockRestRequest content(Object input, HttpPartSchema schema) {
        super.content(input, schema);
        return this;
    }

    @Override
    public MockRestRequest contentString(Object input) throws RestCallException {
        super.contentString(input);
        return this;
    }

    @Override
    public MockRestRequest contentType(String value) throws RestCallException {
        super.contentType(value);
        return this;
    }

    @Override
    public MockRestRequest context(HttpContext context) {
        super.context(context);
        return this;
    }

    @Override
    public MockRestRequest debug() throws RestCallException {
        super.debug();
        return this;
    }

    @Override
    public MockRestRequest errorCodes(Predicate<Integer> value) {
        super.errorCodes(value);
        return this;
    }

    @Override
    public MockRestRequest formData(NameValuePair ... parts) {
        super.formData(parts);
        return this;
    }

    @Override
    public MockRestRequest formData(String name, Object value) {
        super.formData(name, value);
        return this;
    }

    @Override
    public MockRestRequest formDataBean(Object value) {
        super.formDataBean(value);
        return this;
    }

    @Override
    public MockRestRequest formDataCustom(Object value) {
        super.formDataCustom(value);
        return this;
    }

    @Override
    public MockRestRequest formDataPairs(String ... pairs) throws RestCallException {
        super.formDataPairs(pairs);
        return this;
    }

    @Override
    public MockRestRequest header(Header part) {
        super.header(part);
        return this;
    }

    @Override
    public MockRestRequest header(String name, Object value) {
        super.header(name, value);
        return this;
    }

    @Override
    public MockRestRequest headerPairs(String ... pairs) {
        super.headerPairs(pairs);
        return this;
    }

    @Override
    public MockRestRequest headers(Header ... parts) {
        super.headers(parts);
        return this;
    }

    @Override
    public MockRestRequest headersBean(Object value) {
        super.headersBean(value);
        return this;
    }

    @Override
    public MockRestRequest html() {
        super.html();
        return this;
    }

    @Override
    public MockRestRequest htmlDoc() {
        super.htmlDoc();
        return this;
    }

    @Override
    public MockRestRequest htmlStrippedDoc() {
        super.htmlStrippedDoc();
        return this;
    }

    @Override
    public MockRestRequest ignoreErrors() {
        super.ignoreErrors();
        return this;
    }

    @Override
    public MockRestRequest interceptors(RestCallInterceptor ... interceptors) throws RestCallException {
        super.interceptors(interceptors);
        return this;
    }

    @Override
    public MockRestRequest json() {
        super.json();
        return this;
    }

    @Override
    public MockRestRequest mediaType(String value) throws RestCallException {
        super.mediaType(value);
        return this;
    }

    @Override
    public MockRestRequest msgPack() {
        super.msgPack();
        return this;
    }

    @Override
    public MockRestRequest noTrace() throws RestCallException {
        super.noTrace();
        return this;
    }

    @Override
    public MockRestRequest openApi() {
        super.openApi();
        return this;
    }

    @Override
    public MockRestRequest parser(Class<? extends Parser> parser) {
        super.parser(parser);
        return this;
    }

    @Override
    public MockRestRequest parser(Parser parser) {
        super.parser(parser);
        return this;
    }

    @Override
    public MockRestRequest pathData(NameValuePair ... parts) {
        super.pathData(parts);
        return this;
    }

    @Override
    public MockRestRequest pathData(String name, Object value) {
        super.pathData(name, value);
        return this;
    }

    @Override
    public MockRestRequest pathDataBean(Object value) {
        super.pathDataBean(value);
        return this;
    }

    @Override
    public MockRestRequest pathDataPairs(String ... pairs) {
        super.pathDataPairs(pairs);
        return this;
    }

    @Override
    public MockRestRequest plainText() {
        super.plainText();
        return this;
    }

    @Override
    public MockRestRequest protocolVersion(ProtocolVersion version) {
        super.protocolVersion(version);
        return this;
    }

    @Override
    public MockRestRequest queryCustom(Object value) {
        super.queryCustom(value);
        return this;
    }

    @Override
    public MockRestRequest queryData(NameValuePair ... parts) {
        super.queryData(parts);
        return this;
    }

    @Override
    public MockRestRequest queryData(String name, Object value) {
        super.queryData(name, value);
        return this;
    }

    @Override
    public MockRestRequest queryDataBean(Object value) {
        super.queryDataBean(value);
        return this;
    }

    @Override
    public MockRestRequest queryDataPairs(String ... pairs) throws RestCallException {
        super.queryDataPairs(pairs);
        return this;
    }

    @Override
    public MockRestRequest rethrow(Class<?> ... values) {
        super.rethrow(values);
        return this;
    }

    @Override
    public MockRestRequest serializer(Class<? extends Serializer> serializer) {
        super.serializer(serializer);
        return this;
    }

    @Override
    public MockRestRequest serializer(Serializer serializer) {
        super.serializer(serializer);
        return this;
    }

    @Override
    public MockRestRequest json5() {
        super.json5();
        return this;
    }

    @Override
    public MockRestRequest suppressLogging() {
        super.suppressLogging();
        return this;
    }

    @Override
    public MockRestRequest target(HttpHost target) {
        super.target(target);
        return this;
    }

    @Override
    public MockRestRequest uon() {
        super.uon();
        return this;
    }

    @Override
    public MockRestRequest uri(Object uri) throws RestCallException {
        super.uri(uri);
        return this;
    }

    @Override
    public MockRestRequest uriFragment(String fragment) {
        super.uriFragment(fragment);
        return this;
    }

    @Override
    public MockRestRequest uriHost(String host) {
        super.uriHost(host);
        return this;
    }

    @Override
    public MockRestRequest uriPort(int port) {
        super.uriPort(port);
        return this;
    }

    @Override
    public MockRestRequest uriUserInfo(String userInfo) {
        super.uriUserInfo(userInfo);
        return this;
    }

    @Override
    public MockRestRequest uriUserInfo(String username, String password) {
        super.uriUserInfo(username, password);
        return this;
    }

    @Override
    public MockRestRequest urlEnc() {
        super.urlEnc();
        return this;
    }

    @Override
    public MockRestRequest xml() {
        super.xml();
        return this;
    }
}

